const char jit_dis_arm64_lua[] =
"----------------------------------------------------------------------------\n"
"-- LuaJIT ARM64 disassembler module.\n"
"--\n"
"-- Copyright (C) 2005-2017 Mike Pall. All rights reserved.\n"
"-- Released under the MIT license. See Copyright Notice in luajit.h\n"
"--\n"
"-- Contributed by Djordje Kovacevic and Stefan Pejic from RT-RK.com.\n"
"-- Sponsored by Cisco Systems, Inc.\n"
"----------------------------------------------------------------------------\n"
"-- This is a helper module used by the LuaJIT machine code dumper module.\n"
"--\n"
"-- It disassembles most user-mode AArch64 instructions.\n"
"-- NYI: Advanced SIMD and VFP instructions.\n"
"------------------------------------------------------------------------------\n"
"\n"
"local type = type\n"
"local sub, byte, format = string.sub, string.byte, string.format\n"
"local match, gmatch, gsub = string.match, string.gmatch, string.gsub\n"
"local concat = table.concat\n"
"local bit = require(\"bit\")\n"
"local band, bor, bxor, tohex = bit.band, bit.bor, bit.bxor, bit.tohex\n"
"local lshift, rshift, arshift = bit.lshift, bit.rshift, bit.arshift\n"
"local ror = bit.ror\n"
"\n"
"------------------------------------------------------------------------------\n"
"-- Opcode maps\n"
"------------------------------------------------------------------------------\n"
"\n"
"local map_adr = { -- PC-relative addressing.\n"
"  shift = 31, mask = 1,\n"
"  [0] = \"adrDBx\", \"adrpDBx\"\n"
"}\n"
"\n"
"local map_addsubi = { -- Add/subtract immediate.\n"
"  shift = 29, mask = 3,\n"
"  [0] = \"add|movDNIg\", \"adds|cmnD0NIg\", \"subDNIg\", \"subs|cmpD0NIg\",\n"
"}\n"
"\n"
"local map_logi = { -- Logical immediate.\n"
"  shift = 31, mask = 1,\n"
"  [0] = {\n"
"    shift = 22, mask = 1,\n"
"    [0] = {\n"
"      shift = 29, mask = 3,\n"
"      [0] = \"andDNig\", \"orr|movDN0ig\", \"eorDNig\", \"ands|tstD0Nig\"\n"
"    },\n"
"    false -- unallocated\n"
"  },\n"
"  {\n"
"    shift = 29, mask = 3,\n"
"    [0] = \"andDNig\", \"orr|movDN0ig\", \"eorDNig\", \"ands|tstD0Nig\"\n"
"  }\n"
"}\n"
"\n"
"local map_movwi = { -- Move wide immediate.\n"
"  shift = 31, mask = 1,\n"
"  [0] = {\n"
"    shift = 22, mask = 1,\n"
"    [0] = {\n"
"      shift = 29, mask = 3,\n"
"      [0] = \"movnDWRg\", false, \"movz|movDYRg\", \"movkDWRg\"\n"
"    }, false -- unallocated\n"
"  },\n"
"  {\n"
"    shift = 29, mask = 3,\n"
"    [0] = \"movnDWRg\", false, \"movz|movDYRg\", \"movkDWRg\"\n"
"  },\n"
"}\n"
"\n"
"local map_bitf = { -- Bitfield.\n"
"  shift = 31, mask = 1,\n"
"  [0] = {\n"
"    shift = 22, mask = 1,\n"
"    [0] = {\n"
"      shift = 29, mask = 3,\n"
"      [0] = \"sbfm|sbfiz|sbfx|asr|sxtw|sxth|sxtbDN12w\",\n"
"      \"bfm|bfi|bfxilDN13w\",\n"
"      \"ubfm|ubfiz|ubfx|lsr|lsl|uxth|uxtbDN12w\"\n"
"    }\n"
"  },\n"
"  {\n"
"    shift = 22, mask = 1,\n"
"    {\n"
"      shift = 29, mask = 3,\n"
"      [0] = \"sbfm|sbfiz|sbfx|asr|sxtw|sxth|sxtbDN12x\",\n"
"      \"bfm|bfi|bfxilDN13x\",\n"
"      \"ubfm|ubfiz|ubfx|lsr|lsl|uxth|uxtbDN12x\"\n"
"    }\n"
"  }\n"
"}\n"
"\n"
"local map_datai = { -- Data processing - immediate.\n"
"  shift = 23, mask = 7,\n"
"  [0] = map_adr, map_adr, map_addsubi, false,\n"
"  map_logi, map_movwi, map_bitf,\n"
"  {\n"
"    shift = 15, mask = 0x1c0c1,\n"
"    [0] = \"extr|rorDNM4w\", [0x10080] = \"extr|rorDNM4x\",\n"
"    [0x10081] = \"extr|rorDNM4x\"\n"
"  }\n"
"}\n"
"\n"
"local map_logsr = { -- Logical, shifted register.\n"
"  shift = 31, mask = 1,\n"
"  [0] = {\n"
"    shift = 15, mask = 1,\n"
"    [0] = {\n"
"      shift = 29, mask = 3,\n"
"      [0] = {\n"
"\tshift = 21, mask = 7,\n"
"\t[0] = \"andDNMSg\", \"bicDNMSg\", \"andDNMSg\", \"bicDNMSg\",\n"
"\t\"andDNMSg\", \"bicDNMSg\", \"andDNMg\", \"bicDNMg\"\n"
"      },\n"
"      {\n"
"\tshift = 21, mask = 7,\n"
"\t[0] =\"orr|movDN0MSg\", \"orn|mvnDN0MSg\", \"orr|movDN0MSg\", \"orn|mvnDN0MSg\",\n"
"\t     \"orr|movDN0MSg\", \"orn|mvnDN0MSg\", \"orr|movDN0Mg\", \"orn|mvnDN0Mg\"\n"
"      },\n"
"      {\n"
"\tshift = 21, mask = 7,\n"
"\t[0] = \"eorDNMSg\", \"eonDNMSg\", \"eorDNMSg\", \"eonDNMSg\",\n"
"\t\"eorDNMSg\", \"eonDNMSg\", \"eorDNMg\", \"eonDNMg\"\n"
"      },\n"
"      {\n"
"\tshift = 21, mask = 7,\n"
"\t[0] = \"ands|tstD0NMSg\", \"bicsDNMSg\", \"ands|tstD0NMSg\", \"bicsDNMSg\",\n"
"\t\"ands|tstD0NMSg\", \"bicsDNMSg\", \"ands|tstD0NMg\", \"bicsDNMg\"\n"
"      }\n"
"    },\n"
"    false -- unallocated\n"
"  },\n"
"  {\n"
"    shift = 29, mask = 3,\n"
"    [0] = {\n"
"      shift = 21, mask = 7,\n"
"      [0] = \"andDNMSg\", \"bicDNMSg\", \"andDNMSg\", \"bicDNMSg\",\n"
"      \"andDNMSg\", \"bicDNMSg\", \"andDNMg\", \"bicDNMg\"\n"
"    },\n"
"    {\n"
"      shift = 21, mask = 7,\n"
"      [0] = \"orr|movDN0MSg\", \"orn|mvnDN0MSg\", \"orr|movDN0MSg\", \"orn|mvnDN0MSg\",\n"
"      \"orr|movDN0MSg\", \"orn|mvnDN0MSg\", \"orr|movDN0Mg\", \"orn|mvnDN0Mg\"\n"
"    },\n"
"    {\n"
"      shift = 21, mask = 7,\n"
"      [0] = \"eorDNMSg\", \"eonDNMSg\", \"eorDNMSg\", \"eonDNMSg\",\n"
"      \"eorDNMSg\", \"eonDNMSg\", \"eorDNMg\", \"eonDNMg\"\n"
"    },\n"
"    {\n"
"      shift = 21, mask = 7,\n"
"      [0] = \"ands|tstD0NMSg\", \"bicsDNMSg\", \"ands|tstD0NMSg\", \"bicsDNMSg\",\n"
"      \"ands|tstD0NMSg\", \"bicsDNMSg\", \"ands|tstD0NMg\", \"bicsDNMg\"\n"
"    }\n"
"  }\n"
"}\n"
"\n"
"local map_assh = {\n"
"  shift = 31, mask = 1,\n"
"  [0] = {\n"
"    shift = 15, mask = 1,\n"
"    [0] = {\n"
"      shift = 29, mask = 3,\n"
"      [0] = {\n"
"\tshift = 22, mask = 3,\n"
"\t[0] = \"addDNMSg\", \"addDNMSg\", \"addDNMSg\", \"addDNMg\"\n"
"      },\n"
"      {\n"
"\tshift = 22, mask = 3,\n"
"\t[0] = \"adds|cmnD0NMSg\", \"adds|cmnD0NMSg\",\n"
"\t      \"adds|cmnD0NMSg\", \"adds|cmnD0NMg\"\n"
"      },\n"
"      {\n"
"\tshift = 22, mask = 3,\n"
"\t[0] = \"sub|negDN0MSg\", \"sub|negDN0MSg\", \"sub|negDN0MSg\", \"sub|negDN0Mg\"\n"
"      },\n"
"      {\n"
"\tshift = 22, mask = 3,\n"
"\t[0] = \"subs|cmp|negsD0N0MzSg\", \"subs|cmp|negsD0N0MzSg\",\n"
"\t      \"subs|cmp|negsD0N0MzSg\", \"subs|cmp|negsD0N0Mzg\"\n"
"      },\n"
"    },\n"
"    false -- unallocated\n"
"  },\n"
"  {\n"
"    shift = 29, mask = 3,\n"
"    [0] = {\n"
"      shift = 22, mask = 3,\n"
"      [0] = \"addDNMSg\", \"addDNMSg\", \"addDNMSg\", \"addDNMg\"\n"
"    },\n"
"    {\n"
"      shift = 22, mask = 3,\n"
"      [0] = \"adds|cmnD0NMSg\", \"adds|cmnD0NMSg\", \"adds|cmnD0NMSg\",\n"
"\t    \"adds|cmnD0NMg\"\n"
"    },\n"
"    {\n"
"      shift = 22, mask = 3,\n"
"      [0] = \"sub|negDN0MSg\", \"sub|negDN0MSg\", \"sub|negDN0MSg\", \"sub|negDN0Mg\"\n"
"    },\n"
"    {\n"
"      shift = 22, mask = 3,\n"
"      [0] = \"subs|cmp|negsD0N0MzSg\", \"subs|cmp|negsD0N0MzSg\",\n"
"\t    \"subs|cmp|negsD0N0MzSg\", \"subs|cmp|negsD0N0Mzg\"\n"
"    }\n"
"  }\n"
"}\n"
"\n"
"local map_addsubsh = { -- Add/subtract, shifted register.\n"
"  shift = 22, mask = 3,\n"
"  [0] = map_assh, map_assh, map_assh\n"
"}\n"
"\n"
"local map_addsubex = { -- Add/subtract, extended register.\n"
"  shift = 22, mask = 3,\n"
"  [0] = {\n"
"    shift = 29, mask = 3,\n"
"    [0] = \"addDNMXg\", \"adds|cmnD0NMXg\", \"subDNMXg\", \"subs|cmpD0NMzXg\",\n"
"  }\n"
"}\n"
"\n"
"local map_addsubc = { -- Add/subtract, with carry.\n"
"  shift = 10, mask = 63,\n"
"  [0] = {\n"
"    shift = 29, mask = 3,\n"
"    [0] = \"adcDNMg\", \"adcsDNMg\", \"sbc|ngcDN0Mg\", \"sbcs|ngcsDN0Mg\",\n"
"  }\n"
"}\n"
"\n"
"local map_ccomp = {\n"
"  shift = 4, mask = 1,\n"
"  [0] = {\n"
"    shift = 10, mask = 3,\n"
"    [0] = { -- Conditional compare register.\n"
"      shift = 29, mask = 3,\n"
"      \"ccmnNMVCg\", false, \"ccmpNMVCg\",\n"
"    },\n"
"    [2] = {  -- Conditional compare immediate.\n"
"      shift = 29, mask = 3,\n"
"      \"ccmnN5VCg\", false, \"ccmpN5VCg\",\n"
"    }\n"
"  }\n"
"}\n"
"\n"
"local map_csel = { -- Conditional select.\n"
"  shift = 11, mask = 1,\n"
"  [0] = {\n"
"    shift = 10, mask = 1,\n"
"    [0] = {\n"
"      shift = 29, mask = 3,\n"
"      [0] = \"cselDNMzCg\", false, \"csinv|cinv|csetmDNMcg\", false,\n"
"    },\n"
"    {\n"
"      shift = 29, mask = 3,\n"
"      [0] = \"csinc|cinc|csetDNMcg\", false, \"csneg|cnegDNMcg\", false,\n"
"    }\n"
"  }\n"
"}\n"
"\n"
"local map_data1s = { -- Data processing, 1 source.\n"
"  shift = 29, mask = 1,\n"
"  [0] = {\n"
"    shift = 31, mask = 1,\n"
"    [0] = {\n"
"      shift = 10, mask = 0x7ff,\n"
"      [0] = \"rbitDNg\", \"rev16DNg\", \"revDNw\", false, \"clzDNg\", \"clsDNg\"\n"
"    },\n"
"    {\n"
"      shift = 10, mask = 0x7ff,\n"
"      [0] = \"rbitDNg\", \"rev16DNg\", \"rev32DNx\", \"revDNx\", \"clzDNg\", \"clsDNg\"\n"
"    }\n"
"  }\n"
"}\n"
"\n"
"local map_data2s = { -- Data processing, 2 sources.\n"
"  shift = 29, mask = 1,\n"
"  [0] = {\n"
"    shift = 10, mask = 63,\n"
"    false, \"udivDNMg\", \"sdivDNMg\", false, false, false, false, \"lslDNMg\",\n"
"    \"lsrDNMg\", \"asrDNMg\", \"rorDNMg\"\n"
"  }\n"
"}\n"
"\n"
"local map_data3s = { -- Data processing, 3 sources.\n"
"  shift = 29, mask = 7,\n"
"  [0] = {\n"
"    shift = 21, mask = 7,\n"
"    [0] = {\n"
"      shift = 15, mask = 1,\n"
"      [0] = \"madd|mulDNMA0g\", \"msub|mnegDNMA0g\"\n"
"    }\n"
"  }, false, false, false,\n"
"  {\n"
"    shift = 15, mask = 1,\n"
"    [0] = {\n"
"      shift = 21, mask = 7,\n"
"      [0] = \"madd|mulDNMA0g\", \"smaddl|smullDxNMwA0x\", \"smulhDNMx\", false,\n"
"      false, \"umaddl|umullDxNMwA0x\", \"umulhDNMx\"\n"
"    },\n"
"    {\n"
"      shift = 21, mask = 7,\n"
"      [0] = \"msub|mnegDNMA0g\", \"smsubl|smneglDxNMwA0x\", false, false,\n"
"      false, \"umsubl|umneglDxNMwA0x\"\n"
"    }\n"
"  }\n"
"}\n"
"\n"
"local map_datar = { -- Data processing, register.\n"
"  shift = 28, mask = 1,\n"
"  [0] = {\n"
"    shift = 24, mask = 1,\n"
"    [0] = map_logsr,\n"
"    {\n"
"      shift = 21, mask = 1,\n"
"      [0] = map_addsubsh, map_addsubex\n"
"    }\n"
"  },\n"
"  {\n"
"    shift = 21, mask = 15,\n"
"    [0] = map_addsubc, false, map_ccomp, false, map_csel, false,\n"
"    {\n"
"      shift = 30, mask = 1,\n"
"      [0] = map_data2s, map_data1s\n"
"    },\n"
"    false, map_data3s, map_data3s, map_data3s, map_data3s, map_data3s,\n"
"    map_data3s, map_data3s, map_data3s\n"
"  }\n"
"}\n"
"\n"
"local map_lrl = { -- Load register, literal.\n"
"  shift = 26, mask = 1,\n"
"  [0] = {\n"
"    shift = 30, mask = 3,\n"
"    [0] = \"ldrDwB\", \"ldrDxB\", \"ldrswDxB\"\n"
"  },\n"
"  {\n"
"    shift = 30, mask = 3,\n"
"    [0] = \"ldrDsB\", \"ldrDdB\"\n"
"  }\n"
"}\n"
"\n"
"local map_lsriind = { -- Load/store register, immediate pre/post-indexed.\n"
"  shift = 30, mask = 3,\n"
"  [0] = {\n"
"    shift = 26, mask = 1,\n"
"    [0] = {\n"
"      shift = 22, mask = 3,\n"
"      [0] = \"strbDwzL\", \"ldrbDwzL\", \"ldrsbDxzL\", \"ldrsbDwzL\"\n"
"    }\n"
"  },\n"
"  {\n"
"    shift = 26, mask = 1,\n"
"    [0] = {\n"
"      shift = 22, mask = 3,\n"
"      [0] = \"strhDwzL\", \"ldrhDwzL\", \"ldrshDxzL\", \"ldrshDwzL\"\n"
"    }\n"
"  },\n"
"  {\n"
"    shift = 26, mask = 1,\n"
"    [0] = {\n"
"      shift = 22, mask = 3,\n"
"      [0] = \"strDwzL\", \"ldrDwzL\", \"ldrswDxzL\"\n"
"    },\n"
"    {\n"
"      shift = 22, mask = 3,\n"
"      [0] = \"strDszL\", \"ldrDszL\"\n"
"    }\n"
"  },\n"
"  {\n"
"    shift = 26, mask = 1,\n"
"    [0] = {\n"
"      shift = 22, mask = 3,\n"
"      [0] = \"strDxzL\", \"ldrDxzL\"\n"
"    },\n"
"    {\n"
"      shift = 22, mask = 3,\n"
"      [0] = \"strDdzL\", \"ldrDdzL\"\n"
"    }\n"
"  }\n"
"}\n"
"\n"
"local map_lsriro = {\n"
"  shift = 21, mask = 1,\n"
"  [0] = {  -- Load/store register immediate.\n"
"    shift = 10, mask = 3,\n"
"    [0] = { -- Unscaled immediate.\n"
"      shift = 26, mask = 1,\n"
"      [0] = {\n"
"\tshift = 30, mask = 3,\n"
"\t[0] = {\n"
"\t  shift = 22, mask = 3,\n"
"\t  [0] = \"sturbDwK\", \"ldurbDwK\"\n"
"\t},\n"
"\t{\n"
"\t  shift = 22, mask = 3,\n"
"\t  [0] = \"sturhDwK\", \"ldurhDwK\"\n"
"\t},\n"
"\t{\n"
"\t  shift = 22, mask = 3,\n"
"\t  [0] = \"sturDwK\", \"ldurDwK\"\n"
"\t},\n"
"\t{\n"
"\t  shift = 22, mask = 3,\n"
"\t  [0] = \"sturDxK\", \"ldurDxK\"\n"
"\t}\n"
"      }\n"
"    }, map_lsriind, false, map_lsriind\n"
"  },\n"
"  {  -- Load/store register, register offset.\n"
"    shift = 10, mask = 3,\n"
"    [2] = {\n"
"      shift = 26, mask = 1,\n"
"      [0] = {\n"
"\tshift = 30, mask = 3,\n"
"\t[0] = {\n"
"\t  shift = 22, mask = 3,\n"
"\t  [0] = \"strbDwO\", \"ldrbDwO\", \"ldrsbDxO\", \"ldrsbDwO\"\n"
"\t},\n"
"\t{\n"
"\t  shift = 22, mask = 3,\n"
"\t  [0] = \"strhDwO\", \"ldrhDwO\", \"ldrshDxO\", \"ldrshDwO\"\n"
"\t},\n"
"\t{\n"
"\t  shift = 22, mask = 3,\n"
"\t  [0] = \"strDwO\", \"ldrDwO\", \"ldrswDxO\"\n"
"\t},\n"
"\t{\n"
"\t  shift = 22, mask = 3,\n"
"\t  [0] = \"strDxO\", \"ldrDxO\"\n"
"\t}\n"
"      },\n"
"      {\n"
"\tshift = 30, mask = 3,\n"
"\t[2] = {\n"
"\t  shift = 22, mask = 3,\n"
"\t  [0] = \"strDsO\", \"ldrDsO\"\n"
"\t},\n"
"\t[3] = {\n"
"\t  shift = 22, mask = 3,\n"
"\t  [0] = \"strDdO\", \"ldrDdO\"\n"
"\t}\n"
"      }\n"
"    }\n"
"  }\n"
"}\n"
"\n"
"local map_lsp = { -- Load/store register pair, offset.\n"
"  shift = 22, mask = 1,\n"
"  [0] = {\n"
"    shift = 30, mask = 3,\n"
"    [0] = {\n"
"      shift = 26, mask = 1,\n"
"      [0] = \"stpDzAzwP\", \"stpDzAzsP\",\n"
"    },\n"
"    {\n"
"      shift = 26, mask = 1,\n"
"      \"stpDzAzdP\"\n"
"    },\n"
"    {\n"
"      shift = 26, mask = 1,\n"
"      [0] = \"stpDzAzxP\"\n"
"    }\n"
"  },\n"
"  {\n"
"    shift = 30, mask = 3,\n"
"    [0] = {\n"
"      shift = 26, mask = 1,\n"
"      [0] = \"ldpDzAzwP\", \"ldpDzAzsP\",\n"
"    },\n"
"    {\n"
"      shift = 26, mask = 1,\n"
"      [0] = \"ldpswDAxP\", \"ldpDzAzdP\"\n"
"    },\n"
"    {\n"
"      shift = 26, mask = 1,\n"
"      [0] = \"ldpDzAzxP\"\n"
"    }\n"
"  }\n"
"}\n"
"\n"
"local map_ls = { -- Loads and stores.\n"
"  shift = 24, mask = 0x31,\n"
"  [0x10] = map_lrl, [0x30] = map_lsriro,\n"
"  [0x20] = {\n"
"    shift = 23, mask = 3,\n"
"    map_lsp, map_lsp, map_lsp\n"
"  },\n"
"  [0x21] = {\n"
"    shift = 23, mask = 3,\n"
"    map_lsp, map_lsp, map_lsp\n"
"  },\n"
"  [0x31] = {\n"
"    shift = 26, mask = 1,\n"
"    [0] = {\n"
"      shift = 30, mask = 3,\n"
"      [0] = {\n"
"\tshift = 22, mask = 3,\n"
"\t[0] = \"strbDwzU\", \"ldrbDwzU\"\n"
"      },\n"
"      {\n"
"\tshift = 22, mask = 3,\n"
"\t[0] = \"strhDwzU\", \"ldrhDwzU\"\n"
"      },\n"
"      {\n"
"\tshift = 22, mask = 3,\n"
"\t[0] = \"strDwzU\", \"ldrDwzU\"\n"
"      },\n"
"      {\n"
"\tshift = 22, mask = 3,\n"
"\t[0] = \"strDxzU\", \"ldrDxzU\"\n"
"      }\n"
"    },\n"
"    {\n"
"      shift = 30, mask = 3,\n"
"      [2] = {\n"
"\tshift = 22, mask = 3,\n"
"\t[0] = \"strDszU\", \"ldrDszU\"\n"
"      },\n"
"      [3] = {\n"
"\tshift = 22, mask = 3,\n"
"\t[0] = \"strDdzU\", \"ldrDdzU\"\n"
"      }\n"
"    }\n"
"  },\n"
"}\n"
"\n"
"local map_datafp = { -- Data processing, SIMD and FP.\n"
"  shift = 28, mask = 7,\n"
"  { -- 001\n"
"    shift = 24, mask = 1,\n"
"    [0] = {\n"
"      shift = 21, mask = 1,\n"
"      {\n"
"\tshift = 10, mask = 3,\n"
"\t[0] = {\n"
"\t  shift = 12, mask = 1,\n"
"\t  [0] = {\n"
"\t    shift = 13, mask = 1,\n"
"\t    [0] = {\n"
"\t      shift = 14, mask = 1,\n"
"\t      [0] = {\n"
"\t\tshift = 15, mask = 1,\n"
"\t\t[0] = { -- FP/int conversion.\n"
"\t\t  shift = 31, mask = 1,\n"
"\t\t  [0] = {\n"
"\t\t    shift = 16, mask = 0xff,\n"
"\t\t    [0x20] = \"fcvtnsDwNs\", [0x21] = \"fcvtnuDwNs\",\n"
"\t\t    [0x22] = \"scvtfDsNw\", [0x23] = \"ucvtfDsNw\",\n"
"\t\t    [0x24] = \"fcvtasDwNs\", [0x25] = \"fcvtauDwNs\",\n"
"\t\t    [0x26] = \"fmovDwNs\", [0x27] = \"fmovDsNw\",\n"
"\t\t    [0x28] = \"fcvtpsDwNs\", [0x29] = \"fcvtpuDwNs\",\n"
"\t\t    [0x30] = \"fcvtmsDwNs\", [0x31] = \"fcvtmuDwNs\",\n"
"\t\t    [0x38] = \"fcvtzsDwNs\", [0x39] = \"fcvtzuDwNs\",\n"
"\t\t    [0x60] = \"fcvtnsDwNd\", [0x61] = \"fcvtnuDwNd\",\n"
"\t\t    [0x62] = \"scvtfDdNw\", [0x63] = \"ucvtfDdNw\",\n"
"\t\t    [0x64] = \"fcvtasDwNd\", [0x65] = \"fcvtauDwNd\",\n"
"\t\t    [0x68] = \"fcvtpsDwNd\", [0x69] = \"fcvtpuDwNd\",\n"
"\t\t    [0x70] = \"fcvtmsDwNd\", [0x71] = \"fcvtmuDwNd\",\n"
"\t\t    [0x78] = \"fcvtzsDwNd\", [0x79] = \"fcvtzuDwNd\"\n"
"\t\t  },\n"
"\t\t  {\n"
"\t\t    shift = 16, mask = 0xff,\n"
"\t\t    [0x20] = \"fcvtnsDxNs\", [0x21] = \"fcvtnuDxNs\",\n"
"\t\t    [0x22] = \"scvtfDsNx\", [0x23] = \"ucvtfDsNx\",\n"
"\t\t    [0x24] = \"fcvtasDxNs\", [0x25] = \"fcvtauDxNs\",\n"
"\t\t    [0x28] = \"fcvtpsDxNs\", [0x29] = \"fcvtpuDxNs\",\n"
"\t\t    [0x30] = \"fcvtmsDxNs\", [0x31] = \"fcvtmuDxNs\",\n"
"\t\t    [0x38] = \"fcvtzsDxNs\", [0x39] = \"fcvtzuDxNs\",\n"
"\t\t    [0x60] = \"fcvtnsDxNd\", [0x61] = \"fcvtnuDxNd\",\n"
"\t\t    [0x62] = \"scvtfDdNx\", [0x63] = \"ucvtfDdNx\",\n"
"\t\t    [0x64] = \"fcvtasDxNd\", [0x65] = \"fcvtauDxNd\",\n"
"\t\t    [0x66] = \"fmovDxNd\", [0x67] = \"fmovDdNx\",\n"
"\t\t    [0x68] = \"fcvtpsDxNd\", [0x69] = \"fcvtpuDxNd\",\n"
"\t\t    [0x70] = \"fcvtmsDxNd\", [0x71] = \"fcvtmuDxNd\",\n"
"\t\t    [0x78] = \"fcvtzsDxNd\", [0x79] = \"fcvtzuDxNd\"\n"
"\t\t  }\n"
"\t\t}\n"
"\t      },\n"
"\t      { -- FP data-processing, 1 source.\n"
"\t\tshift = 31, mask = 1,\n"
"\t\t[0] = {\n"
"\t\t  shift = 22, mask = 3,\n"
"\t\t  [0] = {\n"
"\t\t    shift = 15, mask = 63,\n"
"\t\t    [0] = \"fmovDNf\", \"fabsDNf\", \"fnegDNf\",\n"
"\t\t    \"fsqrtDNf\", false, \"fcvtDdNs\", false, false,\n"
"\t\t    \"frintnDNf\", \"frintpDNf\", \"frintmDNf\", \"frintzDNf\",\n"
"\t\t    \"frintaDNf\", false, \"frintxDNf\", \"frintiDNf\",\n"
"\t\t  },\n"
"\t\t  {\n"
"\t\t    shift = 15, mask = 63,\n"
"\t\t    [0] = \"fmovDNf\", \"fabsDNf\", \"fnegDNf\",\n"
"\t\t    \"fsqrtDNf\", \"fcvtDsNd\", false, false, false,\n"
"\t\t    \"frintnDNf\", \"frintpDNf\", \"frintmDNf\", \"frintzDNf\",\n"
"\t\t    \"frintaDNf\", false, \"frintxDNf\", \"frintiDNf\",\n"
"\t\t  }\n"
"\t\t}\n"
"\t      }\n"
"\t    },\n"
"\t    { -- FP compare.\n"
"\t      shift = 31, mask = 1,\n"
"\t      [0] = {\n"
"\t\tshift = 14, mask = 3,\n"
"\t\t[0] = {\n"
"\t\t  shift = 23, mask = 1,\n"
"\t\t  [0] = {\n"
"\t\t    shift = 0, mask = 31,\n"
"\t\t    [0] = \"fcmpNMf\", [8] = \"fcmpNZf\",\n"
"\t\t    [16] = \"fcmpeNMf\", [24] = \"fcmpeNZf\",\n"
"\t\t  }\n"
"\t\t}\n"
"\t      }\n"
"\t    }\n"
"\t  },\n"
"\t  { -- FP immediate.\n"
"\t    shift = 31, mask = 1,\n"
"\t    [0] = {\n"
"\t      shift = 5, mask = 31,\n"
"\t      [0] = {\n"
"\t\tshift = 23, mask = 1,\n"
"\t\t[0] = \"fmovDFf\"\n"
"\t      }\n"
"\t    }\n"
"\t  }\n"
"\t},\n"
"\t{ -- FP conditional compare.\n"
"\t  shift = 31, mask = 1,\n"
"\t  [0] = {\n"
"\t    shift = 23, mask = 1,\n"
"\t    [0] = {\n"
"\t      shift = 4, mask = 1,\n"
"\t      [0] = \"fccmpNMVCf\", \"fccmpeNMVCf\"\n"
"\t    }\n"
"\t  }\n"
"\t},\n"
"\t{ -- FP data-processing, 2 sources.\n"
"\t  shift = 31, mask = 1,\n"
"\t  [0] = {\n"
"\t    shift = 23, mask = 1,\n"
"\t    [0] = {\n"
"\t      shift = 12, mask = 15,\n"
"\t      [0] = \"fmulDNMf\", \"fdivDNMf\", \"faddDNMf\", \"fsubDNMf\",\n"
"\t      \"fmaxDNMf\", \"fminDNMf\", \"fmaxnmDNMf\", \"fminnmDNMf\",\n"
"\t      \"fnmulDNMf\"\n"
"\t    }\n"
"\t  }\n"
"\t},\n"
"\t{ -- FP conditional select.\n"
"\t  shift = 31, mask = 1,\n"
"\t  [0] = {\n"
"\t    shift = 23, mask = 1,\n"
"\t    [0] = \"fcselDNMCf\"\n"
"\t  }\n"
"\t}\n"
"      }\n"
"    },\n"
"    { -- FP data-processing, 3 sources.\n"
"      shift = 31, mask = 1,\n"
"      [0] = {\n"
"\tshift = 15, mask = 1,\n"
"\t[0] = {\n"
"\t  shift = 21, mask = 5,\n"
"\t  [0] = \"fmaddDNMAf\", \"fnmaddDNMAf\"\n"
"\t},\n"
"\t{\n"
"\t  shift = 21, mask = 5,\n"
"\t  [0] = \"fmsubDNMAf\", \"fnmsubDNMAf\"\n"
"\t}\n"
"      }\n"
"    }\n"
"  }\n"
"}\n"
"\n"
"local map_br = { -- Branches, exception generating and system instructions.\n"
"  shift = 29, mask = 7,\n"
"  [0] = \"bB\",\n"
"  { -- Compare & branch, immediate.\n"
"    shift = 24, mask = 3,\n"
"    [0] = \"cbzDBg\", \"cbnzDBg\", \"tbzDTBw\", \"tbnzDTBw\"\n"
"  },\n"
"  { -- Conditional branch, immediate.\n"
"    shift = 24, mask = 3,\n"
"    [0] = {\n"
"      shift = 4, mask = 1,\n"
"      [0] = {\n"
"\tshift = 0, mask = 15,\n"
"\t[0] = \"beqB\", \"bneB\", \"bhsB\", \"bloB\", \"bmiB\", \"bplB\", \"bvsB\", \"bvcB\",\n"
"\t\"bhiB\", \"blsB\", \"bgeB\", \"bltB\", \"bgtB\", \"bleB\", \"balB\"\n"
"      }\n"
"    }\n"
"  }, false, \"blB\",\n"
"  { -- Compare & branch, immediate.\n"
"    shift = 24, mask = 3,\n"
"    [0] = \"cbzDBg\", \"cbnzDBg\", \"tbzDTBx\", \"tbnzDTBx\"\n"
"  },\n"
"  {\n"
"    shift = 24, mask = 3,\n"
"    [0] = { -- Exception generation.\n"
"      shift = 0, mask = 0xe0001f,\n"
"      [0x200000] = \"brkW\"\n"
"    },\n"
"    { -- System instructions.\n"
"      shift = 0, mask = 0x3fffff,\n"
"      [0x03201f] = \"nop\"\n"
"    },\n"
"    { -- Unconditional branch, register.\n"
"      shift = 0, mask = 0xfffc1f,\n"
"      [0x1f0000] = \"brNx\", [0x3f0000] = \"blrNx\",\n"
"      [0x5f0000] = \"retNx\"\n"
"    },\n"
"  }\n"
"}\n"
"\n"
"local map_init = {\n"
"  shift = 25, mask = 15,\n"
"  [0] = false, false, false, false, map_ls, map_datar, map_ls, map_datafp,\n"
"  map_datai, map_datai, map_br, map_br, map_ls, map_datar, map_ls, map_datafp\n"
"}\n"
"\n"
"------------------------------------------------------------------------------\n"
"\n"
"local map_regs = { x = {}, w = {}, d = {}, s = {} }\n"
"\n"
"for i=0,30 do\n"
"  map_regs.x[i] = \"x\"..i\n"
"  map_regs.w[i] = \"w\"..i\n"
"  map_regs.d[i] = \"d\"..i\n"
"  map_regs.s[i] = \"s\"..i\n"
"end\n"
"map_regs.x[31] = \"sp\"\n"
"map_regs.w[31] = \"wsp\"\n"
"map_regs.d[31] = \"d31\"\n"
"map_regs.s[31] = \"s31\"\n"
"\n"
"local map_cond = {\n"
"  [0] = \"eq\", \"ne\", \"cs\", \"cc\", \"mi\", \"pl\", \"vs\", \"vc\",\n"
"  \"hi\", \"ls\", \"ge\", \"lt\", \"gt\", \"le\", \"al\",\n"
"}\n"
"\n"
"local map_shift = { [0] = \"lsl\", \"lsr\", \"asr\", }\n"
"\n"
"local map_extend = {\n"
"  [0] = \"uxtb\", \"uxth\", \"uxtw\", \"uxtx\", \"sxtb\", \"sxth\", \"sxtw\", \"sxtx\",\n"
"}\n"
"\n"
"------------------------------------------------------------------------------\n"
"\n"
"-- Output a nicely formatted line with an opcode and operands.\n"
"local function putop(ctx, text, operands)\n"
"  local pos = ctx.pos\n"
"  local extra = \"\"\n"
"  if ctx.rel then\n"
"    local sym = ctx.symtab[ctx.rel]\n"
"    if sym then\n"
"      extra = \"\\t->\"..sym\n"
"    end\n"
"  end\n"
"  if ctx.hexdump > 0 then\n"
"    ctx.out(format(\"%08x  %s  %-5s %s%s\\n\",\n"
"      ctx.addr+pos, tohex(ctx.op), text, concat(operands, \", \"), extra))\n"
"  else\n"
"    ctx.out(format(\"%08x  %-5s %s%s\\n\",\n"
"      ctx.addr+pos, text, concat(operands, \", \"), extra))\n"
"  end\n"
"  ctx.pos = pos + 4\n"
"end\n"
"\n"
"-- Fallback for unknown opcodes.\n"
"local function unknown(ctx)\n"
"  return putop(ctx, \".long\", { \"0x\"..tohex(ctx.op) })\n"
"end\n"
"\n"
"local function match_reg(p, pat, regnum)\n"
"  return map_regs[match(pat, p..\"%w-([xwds])\")][regnum]\n"
"end\n"
"\n"
"local function fmt_hex32(x)\n"
"  if x < 0 then\n"
"    return tohex(x)\n"
"  else\n"
"    return format(\"%x\", x)\n"
"  end\n"
"end\n"
"\n"
"local imm13_rep = { 0x55555555, 0x11111111, 0x01010101, 0x00010001, 0x00000001 }\n"
"\n"
"local function decode_imm13(op)\n"
"  local imms = band(rshift(op, 10), 63)\n"
"  local immr = band(rshift(op, 16), 63)\n"
"  if band(op, 0x00400000) == 0 then\n"
"    local len = 5\n"
"    if imms >= 56 then\n"
"      if imms >= 60 then len = 1 else len = 2 end\n"
"    elseif imms >= 48 then len = 3 elseif imms >= 32 then len = 4 end\n"
"    local l = lshift(1, len)-1\n"
"    local s = band(imms, l)\n"
"    local r = band(immr, l)\n"
"    local imm = ror(rshift(-1, 31-s), r)\n"
"    if len ~= 5 then imm = band(imm, lshift(1, l)-1) + rshift(imm, 31-l) end\n"
"    imm = imm * imm13_rep[len]\n"
"    local ix = fmt_hex32(imm)\n"
"    if rshift(op, 31) ~= 0 then\n"
"      return ix..tohex(imm)\n"
"    else\n"
"      return ix\n"
"    end\n"
"  else\n"
"    local lo, hi = -1, 0\n"
"    if imms < 32 then lo = rshift(-1, 31-imms) else hi = rshift(-1, 63-imms) end\n"
"    if immr ~= 0 then\n"
"      lo, hi = ror(lo, immr), ror(hi, immr)\n"
"      local x = immr == 32 and 0 or band(bxor(lo, hi), lshift(-1, 32-immr))\n"
"      lo, hi = bxor(lo, x), bxor(hi, x)\n"
"      if immr >= 32 then lo, hi = hi, lo end\n"
"    end\n"
"    if hi ~= 0 then\n"
"      return fmt_hex32(hi)..tohex(lo)\n"
"    else\n"
"      return fmt_hex32(lo)\n"
"    end\n"
"  end\n"
"end\n"
"\n"
"local function parse_immpc(op, name)\n"
"  if name == \"b\" or name == \"bl\" then\n"
"    return arshift(lshift(op, 6), 4)\n"
"  elseif name == \"adr\" or name == \"adrp\" then\n"
"    local immlo = band(rshift(op, 29), 3)\n"
"    local immhi = lshift(arshift(lshift(op, 8), 13), 2)\n"
"    return bor(immhi, immlo)\n"
"  elseif name == \"tbz\" or name == \"tbnz\" then\n"
"    return lshift(arshift(lshift(op, 13), 18), 2)\n"
"  else\n"
"    return lshift(arshift(lshift(op, 8), 13), 2)\n"
"  end\n"
"end\n"
"\n"
"local function parse_fpimm8(op)\n"
"  local sign = band(op, 0x100000) == 0 and 1 or -1\n"
"  local exp = bxor(rshift(arshift(lshift(op, 12), 5), 24), 0x80) - 131\n"
"  local frac = 16+band(rshift(op, 13), 15)\n"
"  return sign * frac * 2^exp\n"
"end\n"
"\n"
"local function prefer_bfx(sf, uns, imms, immr)\n"
"  if imms < immr or imms == 31 or imms == 63 then\n"
"    return false\n"
"  end\n"
"  if immr == 0 then\n"
"    if sf == 0 and (imms == 7 or imms == 15) then\n"
"      return false\n"
"    end\n"
"    if sf ~= 0 and uns == 0 and (imms == 7 or imms == 15 or imms == 31) then\n"
"      return false\n"
"    end\n"
"  end\n"
"  return true\n"
"end\n"
"\n"
"-- Disassemble a single instruction.\n"
"local function disass_ins(ctx)\n"
"  local pos = ctx.pos\n"
"  local b0, b1, b2, b3 = byte(ctx.code, pos+1, pos+4)\n"
"  local op = bor(lshift(b3, 24), lshift(b2, 16), lshift(b1, 8), b0)\n"
"  local operands = {}\n"
"  local suffix = \"\"\n"
"  local last, name, pat\n"
"  local map_reg\n"
"  ctx.op = op\n"
"  ctx.rel = nil\n"
"  last = nil\n"
"  local opat\n"
"  opat = map_init[band(rshift(op, 25), 15)]\n"
"  while type(opat) ~= \"string\" do\n"
"    if not opat then return unknown(ctx) end\n"
"    opat = opat[band(rshift(op, opat.shift), opat.mask)] or opat._\n"
"  end\n"
"  name, pat = match(opat, \"^([a-z0-9]*)(.*)\")\n"
"  local altname, pat2 = match(pat, \"|([a-z0-9_.|]*)(.*)\")\n"
"  if altname then pat = pat2 end\n"
"  if sub(pat, 1, 1) == \".\" then\n"
"    local s2, p2 = match(pat, \"^([a-z0-9.]*)(.*)\")\n"
"    suffix = suffix..s2\n"
"    pat = p2\n"
"  end\n"
"\n"
"  local rt = match(pat, \"[gf]\")\n"
"  if rt then\n"
"    if rt == \"g\" then\n"
"      map_reg = band(op, 0x80000000) ~= 0 and map_regs.x or map_regs.w\n"
"    else\n"
"      map_reg = band(op, 0x400000) ~= 0 and map_regs.d or map_regs.s\n"
"    end\n"
"  end\n"
"\n"
"  local second0, immr\n"
"\n"
"  for p in gmatch(pat, \".\") do\n"
"    local x = nil\n"
"    if p == \"D\" then\n"
"      local regnum = band(op, 31)\n"
"      x = rt and map_reg[regnum] or match_reg(p, pat, regnum)\n"
"    elseif p == \"N\" then\n"
"      local regnum = band(rshift(op, 5), 31)\n"
"      x = rt and map_reg[regnum] or match_reg(p, pat, regnum)\n"
"    elseif p == \"M\" then\n"
"      local regnum = band(rshift(op, 16), 31)\n"
"      x = rt and map_reg[regnum] or match_reg(p, pat, regnum)\n"
"    elseif p == \"A\" then\n"
"      local regnum = band(rshift(op, 10), 31)\n"
"      x = rt and map_reg[regnum] or match_reg(p, pat, regnum)\n"
"    elseif p == \"B\" then\n"
"      local addr = ctx.addr + pos + parse_immpc(op, name)\n"
"      ctx.rel = addr\n"
"      x = \"0x\"..tohex(addr)\n"
"    elseif p == \"T\" then\n"
"      x = bor(band(rshift(op, 26), 32), band(rshift(op, 19), 31))\n"
"    elseif p == \"V\" then\n"
"      x = band(op, 15)\n"
"    elseif p == \"C\" then\n"
"      x = map_cond[band(rshift(op, 12), 15)]\n"
"    elseif p == \"c\" then\n"
"      local rn = band(rshift(op, 5), 31)\n"
"      local rm = band(rshift(op, 16), 31)\n"
"      local cond = band(rshift(op, 12), 15)\n"
"      local invc = bxor(cond, 1)\n"
"      x = map_cond[cond]\n"
"      if altname and cond ~= 14 and cond ~= 15 then\n"
"\tlocal a1, a2 = match(altname, \"([^|]*)|(.*)\")\n"
"\tif rn == rm then\n"
"\t  local n = #operands\n"
"\t  operands[n] = nil\n"
"\t  x = map_cond[invc]\n"
"\t  if rn ~= 31 then\n"
"\t    if a1 then name = a1 else name = altname end\n"
"\t  else\n"
"\t    operands[n-1] = nil\n"
"\t    name = a2\n"
"\t  end\n"
"\tend\n"
"      end\n"
"    elseif p == \"W\" then\n"
"      x = band(rshift(op, 5), 0xffff)\n"
"    elseif p == \"Y\" then\n"
"      x = band(rshift(op, 5), 0xffff)\n"
"      local hw = band(rshift(op, 21), 3)\n"
"      if altname and (hw == 0 or x ~= 0) then\n"
"\tname = altname\n"
"      end\n"
"    elseif p == \"L\" then\n"
"      local rn = map_regs.x[band(rshift(op, 5), 31)]\n"
"      local imm9 = arshift(lshift(op, 11), 23)\n"
"      if band(op, 0x800) ~= 0 then\n"
"\tx = \"[\"..rn..\", #\"..imm9..\"]!\"\n"
"      else\n"
"\tx = \"[\"..rn..\"], #\"..imm9\n"
"      end\n"
"    elseif p == \"U\" then\n"
"      local rn = map_regs.x[band(rshift(op, 5), 31)]\n"
"      local sz = band(rshift(op, 30), 3)\n"
"      local imm12 = lshift(arshift(lshift(op, 10), 20), sz)\n"
"      if imm12 ~= 0 then\n"
"\tx = \"[\"..rn..\", #\"..imm12..\"]\"\n"
"      else\n"
"\tx = \"[\"..rn..\"]\"\n"
"      end\n"
"    elseif p == \"K\" then\n"
"      local rn = map_regs.x[band(rshift(op, 5), 31)]\n"
"      local imm9 = arshift(lshift(op, 11), 23)\n"
"      if imm9 ~= 0 then\n"
"\tx = \"[\"..rn..\", #\"..imm9..\"]\"\n"
"      else\n"
"\tx = \"[\"..rn..\"]\"\n"
"      end\n"
"    elseif p == \"O\" then\n"
"      local rn, rm = map_regs.x[band(rshift(op, 5), 31)]\n"
"      local m = band(rshift(op, 13), 1)\n"
"      if m == 0 then\n"
"\trm = map_regs.w[band(rshift(op, 16), 31)]\n"
"      else\n"
"\trm = map_regs.x[band(rshift(op, 16), 31)]\n"
"      end\n"
"      x = \"[\"..rn..\", \"..rm\n"
"      local opt = band(rshift(op, 13), 7)\n"
"      local s = band(rshift(op, 12), 1)\n"
"      local sz = band(rshift(op, 30), 3)\n"
"      -- extension to be applied\n"
"      if opt == 3 then\n"
"       if s == 0 then x = x..\"]\"\n"
"       else x = x..\", lsl #\"..sz..\"]\" end\n"
"      elseif opt == 2 or opt == 6 or opt == 7 then\n"
"\tif s == 0 then x = x..\", \"..map_extend[opt]..\"]\"\n"
"\telse x = x..\", \"..map_extend[opt]..\" #\"..sz..\"]\" end\n"
"      else\n"
"\tx = x..\"]\"\n"
"      end\n"
"    elseif p == \"P\" then\n"
"      local opcv, sh = rshift(op, 26), 2\n"
"      if opcv >= 0x2a then sh = 4 elseif opcv >= 0x1b then sh = 3 end\n"
"      local imm7 = lshift(arshift(lshift(op, 10), 25), sh)\n"
"      local rn = map_regs.x[band(rshift(op, 5), 31)]\n"
"      local ind = band(rshift(op, 23), 3)\n"
"      if ind == 1 then\n"
"\tx = \"[\"..rn..\"], #\"..imm7\n"
"      elseif ind == 2 then\n"
"\tif imm7 == 0 then\n"
"\t  x = \"[\"..rn..\"]\"\n"
"\telse\n"
"\t  x = \"[\"..rn..\", #\"..imm7..\"]\"\n"
"\tend\n"
"      elseif ind == 3 then\n"
"\tx = \"[\"..rn..\", #\"..imm7..\"]!\"\n"
"      end\n"
"    elseif p == \"I\" then\n"
"      local shf = band(rshift(op, 22), 3)\n"
"      local imm12 = band(rshift(op, 10), 0x0fff)\n"
"      local rn, rd = band(rshift(op, 5), 31), band(op, 31)\n"
"      if altname == \"mov\" and shf == 0 and imm12 == 0 and (rn == 31 or rd == 31) then\n"
"\tname = altname\n"
"\tx = nil\n"
"      elseif shf == 0 then\n"
"\tx = imm12\n"
"      elseif shf == 1 then\n"
"\tx = imm12..\", lsl #12\"\n"
"      end\n"
"    elseif p == \"i\" then\n"
"      x = \"#0x\"..decode_imm13(op)\n"
"    elseif p == \"1\" then\n"
"      immr = band(rshift(op, 16), 63)\n"
"      x = immr\n"
"    elseif p == \"2\" then\n"
"      x = band(rshift(op, 10), 63)\n"
"      if altname then\n"
"\tlocal a1, a2, a3, a4, a5, a6 =\n"
"\t  match(altname, \"([^|]*)|([^|]*)|([^|]*)|([^|]*)|([^|]*)|(.*)\")\n"
"\tlocal sf = band(rshift(op, 26), 32)\n"
"\tlocal uns = band(rshift(op, 30), 1)\n"
"\tif prefer_bfx(sf, uns, x, immr) then\n"
"\t  name = a2\n"
"\t  x = x - immr + 1\n"
"\telseif immr == 0 and x == 7 then\n"
"\t  local n = #operands\n"
"\t  operands[n] = nil\n"
"\t  if sf ~= 0 then\n"
"\t    operands[n-1] = gsub(operands[n-1], \"x\", \"w\")\n"
"\t  end\n"
"\t  last = operands[n-1]\n"
"\t  name = a6\n"
"\t  x = nil\n"
"\telseif immr == 0 and x == 15 then\n"
"\t  local n = #operands\n"
"\t  operands[n] = nil\n"
"\t  if sf ~= 0 then\n"
"\t    operands[n-1] = gsub(operands[n-1], \"x\", \"w\")\n"
"\t  end\n"
"\t  last = operands[n-1]\n"
"\t  name = a5\n"
"\t  x = nil\n"
"\telseif x == 31 or x == 63 then\n"
"\t  if x == 31 and immr == 0 and name == \"sbfm\" then\n"
"\t    name = a4\n"
"\t    local n = #operands\n"
"\t    operands[n] = nil\n"
"\t    if sf ~= 0 then\n"
"\t      operands[n-1] = gsub(operands[n-1], \"x\", \"w\")\n"
"\t    end\n"
"\t    last = operands[n-1]\n"
"\t  else\n"
"\t    name = a3\n"
"\t  end\n"
"\t  x = nil\n"
"\telseif band(x, 31) ~= 31 and immr == x+1 and name == \"ubfm\" then\n"
"\t  name = a4\n"
"\t  last = \"#\"..(sf+32 - immr)\n"
"\t  operands[#operands] = last\n"
"\t  x = nil\n"
"\telseif x < immr then\n"
"\t  name = a1\n"
"\t  last = \"#\"..(sf+32 - immr)\n"
"\t  operands[#operands] = last\n"
"\t  x = x + 1\n"
"\tend\n"
"      end\n"
"    elseif p == \"3\" then\n"
"      x = band(rshift(op, 10), 63)\n"
"      if altname then\n"
"\tlocal a1, a2 = match(altname, \"([^|]*)|(.*)\")\n"
"\tif x < immr then\n"
"\t  name = a1\n"
"\t  local sf = band(rshift(op, 26), 32)\n"
"\t  last = \"#\"..(sf+32 - immr)\n"
"\t  operands[#operands] = last\n"
"\t  x = x + 1\n"
"\telseif x >= immr then\n"
"\t  name = a2\n"
"\t  x = x - immr + 1\n"
"\tend\n"
"      end\n"
"    elseif p == \"4\" then\n"
"      x = band(rshift(op, 10), 63)\n"
"      local rn = band(rshift(op, 5), 31)\n"
"      local rm = band(rshift(op, 16), 31)\n"
"      if altname and rn == rm then\n"
"\tlocal n = #operands\n"
"\toperands[n] = nil\n"
"\tlast = operands[n-1]\n"
"\tname = altname\n"
"      end\n"
"    elseif p == \"5\" then\n"
"      x = band(rshift(op, 16), 31)\n"
"    elseif p == \"S\" then\n"
"      x = band(rshift(op, 10), 63)\n"
"      if x == 0 then x = nil\n"
"      else x = map_shift[band(rshift(op, 22), 3)]..\" #\"..x end\n"
"    elseif p == \"X\" then\n"
"      local opt = band(rshift(op, 13), 7)\n"
"      -- Width specifier <R>.\n"
"      if opt ~= 3 and opt ~= 7 then\n"
"\tlast = map_regs.w[band(rshift(op, 16), 31)]\n"
"\toperands[#operands] = last\n"
"      end\n"
"      x = band(rshift(op, 10), 7)\n"
"      -- Extension.\n"
"      if opt == 2 + band(rshift(op, 31), 1) and\n"
"\t band(rshift(op, second0 and 5 or 0), 31) == 31 then\n"
"\tif x == 0 then x = nil\n"
"\telse x = \"lsl #\"..x end\n"
"      else\n"
"\tif x == 0 then x = map_extend[band(rshift(op, 13), 7)]\n"
"\telse x = map_extend[band(rshift(op, 13), 7)]..\" #\"..x end\n"
"      end\n"
"    elseif p == \"R\" then\n"
"      x = band(rshift(op,21), 3)\n"
"      if x == 0 then x = nil\n"
"      else x = \"lsl #\"..x*16 end\n"
"    elseif p == \"z\" then\n"
"      local n = #operands\n"
"      if operands[n] == \"sp\" then operands[n] = \"xzr\"\n"
"      elseif operands[n] == \"wsp\" then operands[n] = \"wzr\"\n"
"      end\n"
"    elseif p == \"Z\" then\n"
"      x = 0\n"
"    elseif p == \"F\" then\n"
"      x = parse_fpimm8(op)\n"
"    elseif p == \"g\" or p == \"f\" or p == \"x\" or p == \"w\" or\n"
"\t   p == \"d\" or p == \"s\" then\n"
"      -- These are handled in D/N/M/A.\n"
"    elseif p == \"0\" then\n"
"      if last == \"sp\" or last == \"wsp\" then\n"
"\tlocal n = #operands\n"
"\toperands[n] = nil\n"
"\tlast = operands[n-1]\n"
"\tif altname then\n"
"\t  local a1, a2 = match(altname, \"([^|]*)|(.*)\")\n"
"\t  if not a1 then\n"
"\t    name = altname\n"
"\t  elseif second0 then\n"
"\t    name, altname = a2, a1\n"
"\t  else\n"
"\t    name, altname = a1, a2\n"
"\t  end\n"
"\tend\n"
"      end\n"
"      second0 = true\n"
"    else\n"
"      assert(false)\n"
"    end\n"
"    if x then\n"
"      last = x\n"
"      if type(x) == \"number\" then x = \"#\"..x end\n"
"      operands[#operands+1] = x\n"
"    end\n"
"  end\n"
"\n"
"  return putop(ctx, name..suffix, operands)\n"
"end\n"
"\n"
"------------------------------------------------------------------------------\n"
"\n"
"-- Disassemble a block of code.\n"
"local function disass_block(ctx, ofs, len)\n"
"  if not ofs then ofs = 0 end\n"
"  local stop = len and ofs+len or #ctx.code\n"
"  ctx.pos = ofs\n"
"  ctx.rel = nil\n"
"  while ctx.pos < stop do disass_ins(ctx) end\n"
"end\n"
"\n"
"-- Extended API: create a disassembler context. Then call ctx:disass(ofs, len).\n"
"local function create(code, addr, out)\n"
"  local ctx = {}\n"
"  ctx.code = code\n"
"  ctx.addr = addr or 0\n"
"  ctx.out = out or io.write\n"
"  ctx.symtab = {}\n"
"  ctx.disass = disass_block\n"
"  ctx.hexdump = 8\n"
"  return ctx\n"
"end\n"
"\n"
"-- Simple API: disassemble code (a string) at address and output via out.\n"
"local function disass(code, addr, out)\n"
"  create(code, addr, out):disass()\n"
"end\n"
"\n"
"-- Return register name for RID.\n"
"local function regname(r)\n"
"  if r < 32 then return map_regs.x[r] end\n"
"  return map_regs.d[r-32]\n"
"end\n"
"\n"
"-- Public module functions.\n"
"return {\n"
"  create = create,\n"
"  disass = disass,\n"
"  regname = regname\n"
"}\n"
"\n"
""
;
