/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.plan.OpenSearchConstants;
import org.opensearch.sql.expression.function.BuiltinFunctionName;

class DynamicFieldsHelper {
    DynamicFieldsHelper() {
    }

    static boolean isDynamicFieldMap(String field) {
        return "_MAP".equals(field);
    }

    static boolean isDynamicFieldsExists(CalcitePlanContext context) {
        return context.relBuilder.peek().getRowType().getFieldNames().contains("_MAP");
    }

    private static boolean hasDynamicFields(RelNode node) {
        return node.getRowType().getFieldNames().contains("_MAP");
    }

    private static boolean isMetadataField(String fieldName) {
        return OpenSearchConstants.METADATAFIELD_TYPE_MAP.containsKey(fieldName);
    }

    static List<String> getLeftStaticFields(CalcitePlanContext context) {
        return DynamicFieldsHelper.excludeDynamicFields(context.relBuilder.peek(1).getRowType().getFieldNames());
    }

    static List<String> getStaticFields(CalcitePlanContext context) {
        return DynamicFieldsHelper.excludeDynamicFields(context.relBuilder.peek().getRowType().getFieldNames());
    }

    static List<String> getStaticFields(RelNode node) {
        return DynamicFieldsHelper.excludeDynamicFields(node.getRowType().getFieldNames());
    }

    static List<String> getRightStaticFields(CalcitePlanContext context) {
        return DynamicFieldsHelper.getStaticFields(context);
    }

    private static List<String> excludeDynamicFields(Collection<String> fields) {
        return fields.stream().filter(field -> !DynamicFieldsHelper.isDynamicFieldMap(field)).collect(Collectors.toList());
    }

    private static List<String> excludeMetaFields(Collection<String> fields) {
        return fields.stream().filter(field -> !DynamicFieldsHelper.isMetadataField(field)).collect(Collectors.toList());
    }

    private static List<String> excludeSpecialFields(Collection<String> fields) {
        return fields.stream().filter(field -> !DynamicFieldsHelper.isMetadataField(field) && !DynamicFieldsHelper.isDynamicFieldMap(field)).collect(Collectors.toList());
    }

    private static List<String> getRemainingFields(Collection<String> existingFields, Collection<String> excluded) {
        List<String> keys = DynamicFieldsHelper.excludeSpecialFields(existingFields);
        keys.removeAll(excluded);
        Collections.sort(keys);
        return keys;
    }

    static void adjustJoinInputsForDynamicFields(Optional<String> leftAlias, Optional<String> rightAlias, CalcitePlanContext context) {
        if (DynamicFieldsHelper.hasDynamicFields(context.relBuilder.peek()) || DynamicFieldsHelper.hasDynamicFields(context.relBuilder.peek(1))) {
            RelNode right = context.relBuilder.build();
            RelNode left = context.relBuilder.build();
            List<RelNode> inputs = DynamicFieldsHelper.adjustInputsForDynamicFields(List.of(right, left), context);
            right = inputs.get(0);
            left = inputs.get(1);
            context.relBuilder.push(left);
            leftAlias.map(alias -> context.relBuilder.as((String)alias));
            context.relBuilder.push(right);
            rightAlias.map(alias -> context.relBuilder.as((String)alias));
        }
    }

    static RelNode adjustFieldsForDynamicFields(RelNode target, RelNode theOtherInput, CalcitePlanContext context) {
        if (DynamicFieldsHelper.hasDynamicFields(theOtherInput) && !DynamicFieldsHelper.hasDynamicFields(target)) {
            List<String> requiredStaticFields = DynamicFieldsHelper.getStaticFields(theOtherInput);
            return DynamicFieldsHelper.adjustFieldsForDynamicFields(target, requiredStaticFields, context);
        }
        return target;
    }

    static List<RelNode> adjustInputsForDynamicFields(List<RelNode> inputs, CalcitePlanContext context) {
        boolean requireAdjustment = inputs.stream().anyMatch(input -> DynamicFieldsHelper.hasDynamicFields(input));
        if (requireAdjustment) {
            List<String> requiredStaticFields = DynamicFieldsHelper.getRequiredStaticFields(inputs);
            return inputs.stream().map(input -> DynamicFieldsHelper.adjustFieldsForDynamicFields(input, requiredStaticFields, context)).collect(Collectors.toList());
        }
        return inputs;
    }

    static List<String> getRequiredStaticFields(List<RelNode> inputs) {
        HashSet<String> requiredStaticFields = new HashSet<String>();
        for (RelNode input : inputs) {
            if (!DynamicFieldsHelper.hasDynamicFields(input)) continue;
            requiredStaticFields.addAll(DynamicFieldsHelper.getStaticFields(input));
        }
        return DynamicFieldsHelper.toSortedList(requiredStaticFields);
    }

    private static List<String> toSortedList(Collection<String> collection) {
        ArrayList<String> result = new ArrayList<String>(collection);
        Collections.sort(result);
        return result;
    }

    static RelNode adjustFieldsForDynamicFields(RelNode node, List<String> staticFieldNames, CalcitePlanContext context) {
        context.relBuilder.push(node);
        List<String> existingFields = DynamicFieldsHelper.getStaticFields(node);
        ArrayList<Object> project = new ArrayList<Object>();
        for (String existingField : existingFields) {
            if (!staticFieldNames.contains(existingField)) continue;
            project.add(context.rexBuilder.makeInputRef(node, existingFields.indexOf(existingField)));
        }
        if (DynamicFieldsHelper.hasDynamicFields(node)) {
            RexInputRef existingDynamicFieldsMap = context.relBuilder.field("_MAP");
            RexNode additionalFieldsMap = DynamicFieldsHelper.getFieldsAsMap(existingFields, staticFieldNames, context);
            RexNode mapAppend = context.rexBuilder.makeCall(BuiltinFunctionName.MAP_APPEND, new RexNode[]{existingDynamicFieldsMap, additionalFieldsMap});
            project.add(context.relBuilder.alias(mapAppend, "_MAP"));
        } else {
            project.add(context.relBuilder.alias(DynamicFieldsHelper.getFieldsAsMap(existingFields, staticFieldNames, context), "_MAP"));
        }
        return context.relBuilder.project(project).build();
    }

    static List<RexNode> buildRegularFieldProjections(RexNode map, List<String> regularFieldNames, Set<String> existingFields, CalcitePlanContext context) {
        ArrayList<RexNode> fields = new ArrayList<RexNode>();
        for (String fieldName : regularFieldNames) {
            RexNode item = DynamicFieldsHelper.getItemAsString(map, fieldName, context);
            if (existingFields.contains(fieldName)) {
                item = context.rexBuilder.makeCall(BuiltinFunctionName.INTERNAL_APPEND, new RexNode[]{context.relBuilder.field(fieldName), item});
                item = DynamicFieldsHelper.castToString(item, context);
            }
            fields.add(context.relBuilder.alias(item, fieldName));
        }
        return fields;
    }

    static RexNode buildDynamicMapFieldProjection(RexNode map, List<String> sortedRegularFields, Set<String> existingFields, CalcitePlanContext context) {
        RexNode dynamicMapField = DynamicFieldsHelper.createDynamicMapField(map, sortedRegularFields, context);
        List<String> remainingFields = DynamicFieldsHelper.getRemainingFields(existingFields, sortedRegularFields);
        if (!remainingFields.isEmpty()) {
            RexNode existingFieldsMap = DynamicFieldsHelper.getFieldsAsMap(existingFields, sortedRegularFields, context);
            dynamicMapField = context.rexBuilder.makeCall(BuiltinFunctionName.MAP_APPEND, existingFieldsMap, dynamicMapField);
        }
        if (DynamicFieldsHelper.isDynamicFieldsExists(context)) {
            RexInputRef existingMap = context.relBuilder.field("_MAP");
            dynamicMapField = context.rexBuilder.makeCall(BuiltinFunctionName.MAP_APPEND, new RexNode[]{existingMap, dynamicMapField});
        }
        return dynamicMapField;
    }

    private static RexNode getItemAsString(RexNode map, String fieldName, CalcitePlanContext context) {
        RexNode item = context.rexBuilder.itemCall(map, fieldName);
        return context.relBuilder.cast(item, SqlTypeName.VARCHAR);
    }

    private static RexNode castToString(RexNode node, CalcitePlanContext context) {
        return context.relBuilder.cast(node, SqlTypeName.VARCHAR);
    }

    private static RexNode createDynamicMapField(RexNode fullMap, List<String> sortedRegularFields, CalcitePlanContext context) {
        if (sortedRegularFields.isEmpty()) {
            return fullMap;
        }
        List<RexNode> stringLiteralList = DynamicFieldsHelper.getStringLiteralList(sortedRegularFields, context);
        RelDataType stringArrayType = context.rexBuilder.getTypeFactory().createArrayType(context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), -1L);
        RexNode keyArray = context.rexBuilder.makeCall(stringArrayType, (SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, stringLiteralList);
        return context.rexBuilder.makeCall(BuiltinFunctionName.MAP_REMOVE, fullMap, keyArray);
    }

    private static RexNode getFieldsAsMap(Collection<String> existingFields, Collection<String> excluded, CalcitePlanContext context) {
        List<String> keys = DynamicFieldsHelper.excludeMetaFields(existingFields);
        keys.removeAll(excluded);
        Collections.sort(keys);
        RexNode keysArray = DynamicFieldsHelper.getStringLiteralArray(keys, context);
        List<RexNode> values = keys.stream().map(key -> context.relBuilder.field((String)key)).collect(Collectors.toList());
        RexNode valuesArray = DynamicFieldsHelper.makeArray(values, context);
        return context.rexBuilder.makeCall(BuiltinFunctionName.MAP_FROM_ARRAYS, keysArray, valuesArray);
    }

    private static RexNode getStringLiteralArray(Collection<String> keys, CalcitePlanContext context) {
        List<RexNode> stringLiteralList = DynamicFieldsHelper.getStringLiteralList(keys, context);
        return context.rexBuilder.makeCall(DynamicFieldsHelper.getStringArrayType(context), (SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, stringLiteralList);
    }

    private static List<RexNode> getStringLiteralList(Collection<String> strings, CalcitePlanContext context) {
        return strings.stream().sorted().map(name -> context.rexBuilder.makeLiteral((String)name)).collect(Collectors.toList());
    }

    private static RexNode makeArray(List<RexNode> items, CalcitePlanContext context) {
        return context.rexBuilder.makeCall(DynamicFieldsHelper.getStringArrayType(context), (SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, items);
    }

    private static RelDataType getStringArrayType(CalcitePlanContext context) {
        return context.rexBuilder.getTypeFactory().createArrayType(context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), -1L);
    }
}

