// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import { Transform } from 'stream';
import { serializeSignatureInfo } from '@aws-crypto/serialize';
export class SignatureStream extends Transform {
    _signer;
    constructor(getSigner) {
        super();
        const value = getSigner && getSigner();
        Object.defineProperty(this, '_signer', { value, enumerable: true });
    }
    _transform(chunk, _encoding, callback) {
        // If we have a signer, push the data to it
        this._signer && this._signer.update(chunk);
        // forward the data on
        callback(null, chunk);
    }
    _flush(callback) {
        if (this._signer) {
            const signature = this._signer.awsCryptoSign();
            this.push(serializeSignatureInfo(signature));
        }
        callback();
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2lnbmF0dXJlX3N0cmVhbS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9zaWduYXR1cmVfc3RyZWFtLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLG9FQUFvRTtBQUNwRSxzQ0FBc0M7QUFFdEMsT0FBTyxFQUFFLFNBQVMsRUFBRSxNQUFNLFFBQVEsQ0FBQTtBQUVsQyxPQUFPLEVBQUUsc0JBQXNCLEVBQUUsTUFBTSx1QkFBdUIsQ0FBQTtBQUk5RCxNQUFNLE9BQU8sZUFBZ0IsU0FBUSxTQUFTO0lBQ3BDLE9BQU8sQ0FBd0I7SUFDdkMsWUFBWSxTQUFxQjtRQUMvQixLQUFLLEVBQUUsQ0FBQTtRQUNQLE1BQU0sS0FBSyxHQUFHLFNBQVMsSUFBSSxTQUFTLEVBQUUsQ0FBQTtRQUN0QyxNQUFNLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxTQUFTLEVBQUUsRUFBRSxLQUFLLEVBQUUsVUFBVSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUE7SUFDckUsQ0FBQztJQUVELFVBQVUsQ0FDUixLQUFVLEVBQ1YsU0FBaUIsRUFDakIsUUFBeUQ7UUFFekQsMkNBQTJDO1FBQzNDLElBQUksQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUE7UUFDMUMsc0JBQXNCO1FBQ3RCLFFBQVEsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUE7SUFDdkIsQ0FBQztJQUVELE1BQU0sQ0FBQyxRQUErQjtRQUNwQyxJQUFJLElBQUksQ0FBQyxPQUFPLEVBQUU7WUFDaEIsTUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLEVBQUUsQ0FBQTtZQUM5QyxJQUFJLENBQUMsSUFBSSxDQUFDLHNCQUFzQixDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUE7U0FDN0M7UUFDRCxRQUFRLEVBQUUsQ0FBQTtJQUNaLENBQUM7Q0FDRiJ9