/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.query;

import com.google.common.annotations.VisibleForTesting;
import java.util.Comparator;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.opensearch.common.lucene.search.TopDocsAndMaxScore;
import org.opensearch.neuralsearch.search.query.HybridQueryFieldDocComparator;
import org.opensearch.neuralsearch.search.query.HybridQueryScoreDocsMerger;
import org.opensearch.search.collapse.CollapseContext;
import org.opensearch.search.sort.SortAndFormats;

public class TopDocsMerger {
    private HybridQueryScoreDocsMerger docsMerger;
    private SortAndFormats sortAndFormats;
    private CollapseContext collapseContext;
    @VisibleForTesting
    protected static Comparator<ScoreDoc> SCORE_DOC_BY_SCORE_COMPARATOR;
    @VisibleForTesting
    protected static HybridQueryFieldDocComparator FIELD_DOC_BY_SORT_CRITERIA_COMPARATOR;
    private final Comparator<ScoreDoc> MERGING_TIE_BREAKER = (o1, o2) -> {
        int docIdComparison = Integer.compare(o1.doc, o2.doc);
        return docIdComparison;
    };

    TopDocsMerger(SortAndFormats sortAndFormats, CollapseContext collapseContext) {
        this.sortAndFormats = sortAndFormats;
        this.collapseContext = collapseContext;
        if (this.isSortingEnabled()) {
            this.docsMerger = new HybridQueryScoreDocsMerger();
            FIELD_DOC_BY_SORT_CRITERIA_COMPARATOR = new HybridQueryFieldDocComparator(sortAndFormats.sort.getSort(), this.MERGING_TIE_BREAKER);
        } else {
            this.docsMerger = new HybridQueryScoreDocsMerger();
            SCORE_DOC_BY_SCORE_COMPARATOR = Comparator.comparing(scoreDoc -> Float.valueOf(scoreDoc.score));
        }
    }

    public TopDocsAndMaxScore merge(TopDocsAndMaxScore source, TopDocsAndMaxScore newTopDocs) {
        HybridQueryScoreDocsMerger.MergeResult mergeResult;
        if (TopDocsMerger.isEmpty(newTopDocs)) {
            return source;
        }
        if (TopDocsMerger.isEmpty(source)) {
            return newTopDocs;
        }
        TotalHits mergedTotalHits = this.getMergedTotalHits(source, newTopDocs);
        ScoreDoc[] sourceScoreDocs = source.topDocs.scoreDocs;
        ScoreDoc[] newScoreDocs = newTopDocs.topDocs.scoreDocs;
        if (this.isCollapseEnabled()) {
            TopDocs topDocs = source.topDocs;
            if (!(topDocs instanceof CollapseTopFieldDocs)) {
                throw new IllegalStateException("Collapse enabled but source TopDocs is not an instance of CollapseTopFieldDocs");
            }
            CollapseTopFieldDocs sourceCollapseTopFieldDocs = (CollapseTopFieldDocs)topDocs;
            TopDocs topDocs2 = newTopDocs.topDocs;
            if (!(topDocs2 instanceof CollapseTopFieldDocs)) {
                throw new IllegalStateException("Collapse enabled but new TopDocs is not an instance of CollapseTopFieldDocs");
            }
            CollapseTopFieldDocs newCollapseTopFieldDocs = (CollapseTopFieldDocs)topDocs2;
            mergeResult = this.getMergedScoreDocs(sourceScoreDocs, newScoreDocs, sourceCollapseTopFieldDocs.collapseValues, newCollapseTopFieldDocs.collapseValues);
        } else {
            mergeResult = this.getMergedScoreDocs(sourceScoreDocs, newScoreDocs, null, null);
        }
        return new TopDocsAndMaxScore(this.getTopDocs(mergeResult, mergedTotalHits), Math.max(source.maxScore, newTopDocs.maxScore));
    }

    private static boolean isEmpty(TopDocsAndMaxScore topDocsAndMaxScore) {
        return Objects.isNull(topDocsAndMaxScore) || Objects.isNull(topDocsAndMaxScore.topDocs) || topDocsAndMaxScore.topDocs.totalHits.value() == 0L;
    }

    private TotalHits getMergedTotalHits(TopDocsAndMaxScore source, TopDocsAndMaxScore newTopDocs) {
        TotalHits.Relation mergedHitsRelation = source.topDocs.totalHits.relation() == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO || newTopDocs.topDocs.totalHits.relation() == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
        return new TotalHits(source.topDocs.totalHits.value() + newTopDocs.topDocs.totalHits.value(), mergedHitsRelation);
    }

    private TopDocs getTopDocs(HybridQueryScoreDocsMerger.MergeResult mergeResult, TotalHits mergedTotalHits) {
        if (this.isCollapseEnabled()) {
            return new CollapseTopFieldDocs(this.collapseContext.getFieldName(), mergedTotalHits, mergeResult.scoreDocs(), this.getSortFieldsWhenCollapseEnabled(), mergeResult.collapseValues());
        }
        if (this.isSortingEnabled()) {
            return new TopFieldDocs(mergedTotalHits, mergeResult.scoreDocs(), this.sortAndFormats.sort.getSort());
        }
        return new TopDocs(mergedTotalHits, mergeResult.scoreDocs());
    }

    private HybridQueryScoreDocsMerger.MergeResult getMergedScoreDocs(ScoreDoc[] source, ScoreDoc[] newScoreDocs, Object[] sourceCollapseValues, Object[] newCollapseValues) {
        return this.docsMerger.mergeScoreDocsAndCollapseValues(source, newScoreDocs, this.comparator(), sourceCollapseValues, newCollapseValues, this.isSortingEnabled(), this.isCollapseEnabled());
    }

    private Comparator<? extends ScoreDoc> comparator() {
        return this.sortAndFormats != null ? FIELD_DOC_BY_SORT_CRITERIA_COMPARATOR : SCORE_DOC_BY_SCORE_COMPARATOR;
    }

    private boolean isSortingEnabled() {
        return this.sortAndFormats != null;
    }

    private boolean isCollapseEnabled() {
        return this.collapseContext != null;
    }

    private SortField[] getSortFieldsWhenCollapseEnabled() {
        SortField[] sortFieldArray;
        if (this.sortAndFormats != null) {
            sortFieldArray = this.sortAndFormats.sort.getSort();
        } else {
            SortField[] sortFieldArray2 = new SortField[1];
            sortFieldArray = sortFieldArray2;
            sortFieldArray2[0] = new SortField(null, SortField.Type.SCORE);
        }
        return sortFieldArray;
    }

    @Generated
    public TopDocsMerger() {
    }
}

