/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexableField;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.engine.Engine;
import org.opensearch.security.securityconf.FlattenedActionGroups;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.setting.OpensearchDynamicSetting;
import org.opensearch.security.spi.resources.ResourceProvider;
import org.opensearch.security.spi.resources.ResourceSharingExtension;
import org.opensearch.security.spi.resources.client.ResourceSharingClient;

public class ResourcePluginInfo {
    private ResourceSharingClient resourceAccessControlClient;
    private OpensearchDynamicSetting<List<String>> protectedTypesSetting;
    private final Set<ResourceSharingExtension> resourceSharingExtensions = new HashSet<ResourceSharingExtension>();
    private final Map<String, ResourceProvider> typeToProvider = new HashMap<String, ResourceProvider>();
    private final Map<String, LinkedHashSet<String>> typeToAccessLevels = new HashMap<String, LinkedHashSet<String>>();
    private final Map<String, FlattenedActionGroups> typeToFlattened = new HashMap<String, FlattenedActionGroups>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public void setProtectedTypesSetting(OpensearchDynamicSetting<List<String>> protectedTypesSetting) {
        this.protectedTypesSetting = protectedTypesSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceSharingExtensions(Set<ResourceSharingExtension> extensions) {
        this.lock.writeLock().lock();
        try {
            this.resourceSharingExtensions.clear();
            this.typeToProvider.clear();
            HashSet<String> resourceTypes = new HashSet<String>();
            for (ResourceSharingExtension extension : extensions) {
                for (ResourceProvider rp : extension.getResourceProviders()) {
                    if (!resourceTypes.contains(rp.resourceType())) {
                        resourceTypes.add(rp.resourceType());
                        this.typeToProvider.put(rp.resourceType(), rp);
                        continue;
                    }
                    throw new OpenSearchSecurityException(String.format("Resource type [%s] is already registered. Please provide a different unique-name for the resource declared by %s.", rp.resourceType(), extension.getClass().getName()), new Object[0]);
                }
            }
            this.resourceSharingExtensions.addAll(extensions);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProtectedTypes(List<String> protectedTypes) {
        this.lock.writeLock().lock();
        try {
            this.typeToProvider.clear();
            if (protectedTypes == null || protectedTypes.isEmpty()) {
                return;
            }
            for (ResourceSharingExtension extension : this.resourceSharingExtensions) {
                for (ResourceProvider rp : extension.getResourceProviders()) {
                    String type = rp.resourceType();
                    if (!protectedTypes.contains(type)) continue;
                    this.typeToProvider.put(rp.resourceType(), rp);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public static String extractFieldFromIndexOp(String fieldName, Engine.Index indexOp) {
        String fieldValue = null;
        for (IndexableField f : indexOp.parsedDoc().rootDoc().getFields(fieldName)) {
            if (f.stringValue() != null) {
                fieldValue = f.stringValue();
                break;
            }
            if (f.binaryValue() == null) continue;
            fieldValue = f.binaryValue().utf8ToString();
            break;
        }
        return fieldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceTypeForIndexOp(String resourceIndex, Engine.Index indexOp) {
        this.lock.readLock().lock();
        try {
            ResourceProvider provider = this.typeToProvider.values().stream().filter(p -> p.resourceIndexName().equals(resourceIndex)).findFirst().orElse(null);
            if (provider == null) {
                String string = null;
                return string;
            }
            if (provider.typeField() != null) {
                String string = ResourcePluginInfo.extractFieldFromIndexOp(provider.typeField(), indexOp);
                return string;
            }
            String string = provider.resourceType();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<ResourceSharingExtension> getResourceSharingExtensions() {
        return ImmutableSet.copyOf(this.resourceSharingExtensions);
    }

    public void setResourceSharingClient(ResourceSharingClient resourceAccessControlClient) {
        this.resourceAccessControlClient = resourceAccessControlClient;
    }

    public ResourceSharingClient getResourceAccessControlClient() {
        return this.resourceAccessControlClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAccessLevels(String resourceType, SecurityDynamicConfiguration<ActionGroupsV7> accessLevels) {
        if (resourceType == null || accessLevels == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            FlattenedActionGroups flattened = new FlattenedActionGroups(accessLevels);
            this.typeToFlattened.put(resourceType, flattened);
            this.typeToAccessLevels.computeIfAbsent(resourceType, k -> new LinkedHashSet()).addAll(accessLevels.getCEntries().keySet().stream().toList());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public FlattenedActionGroups flattenedForType(String resourceType) {
        this.lock.readLock().lock();
        try {
            FlattenedActionGroups flattenedActionGroups = this.typeToFlattened.getOrDefault(resourceType, FlattenedActionGroups.EMPTY);
            return flattenedActionGroups;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public ResourceProvider getResourceProvider(String type) {
        this.lock.readLock().lock();
        try {
            ResourceProvider resourceProvider = this.typeToProvider.get(type);
            return resourceProvider;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String indexByType(String type) {
        this.lock.readLock().lock();
        try {
            if (!this.typeToProvider.containsKey(type)) {
                String string = null;
                return string;
            }
            String string = this.typeToProvider.get(type).resourceIndexName();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<ResourceDashboardInfo> getResourceTypes() {
        this.lock.readLock().lock();
        try {
            Set set = this.typeToProvider.keySet().stream().map(s -> new ResourceDashboardInfo((String)s, Collections.unmodifiableSet(this.typeToAccessLevels.getOrDefault(s, new LinkedHashSet())))).collect(Collectors.toCollection(LinkedHashSet::new));
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<String> getResourceIndices() {
        this.lock.readLock().lock();
        try {
            Set<String> set = this.typeToProvider.values().stream().map(ResourceProvider::resourceIndexName).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<String> getResourceIndicesForProtectedTypes() {
        List<String> resourceTypes = this.protectedTypesSetting.getDynamicSettingValue();
        if (resourceTypes == null || resourceTypes.isEmpty()) {
            return Collections.emptySet();
        }
        this.lock.readLock().lock();
        try {
            Set<String> set = this.typeToProvider.entrySet().stream().filter(e -> resourceTypes.contains(e.getKey())).map(e -> ((ResourceProvider)e.getValue()).resourceIndexName()).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public record ResourceDashboardInfo(String resourceType, Set<String> accessLevels) implements ToXContentObject
    {
        public XContentBuilder toXContent(XContentBuilder b, ToXContent.Params p) throws IOException {
            b.startObject();
            b.field("type", this.resourceType);
            b.field("access_levels", this.accessLevels == null ? Collections.emptyList() : this.accessLevels);
            return b.endObject();
        }
    }
}

