/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.parser.LengthHandler;
import io.sf.carte.echosvg.parser.ParseException;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public class DefaultLengthHandler
implements LengthHandler {
    @Override
    public void startLength() throws ParseException {
    }

    @Override
    public void lengthValue(float f) throws ParseException {
    }

    @Override
    public void em() throws ParseException {
        this.setUnit((short)20);
    }

    @Override
    public void ex() throws ParseException {
        this.setUnit((short)21);
    }

    @Override
    public void lh() throws ParseException {
        this.setUnit((short)25);
    }

    @Override
    public void in() throws ParseException {
        this.setUnit((short)4);
    }

    @Override
    public void cm() throws ParseException {
        this.setUnit((short)7);
    }

    @Override
    public void mm() throws ParseException {
        this.setUnit((short)8);
    }

    @Override
    public void q() throws ParseException {
        this.setUnit((short)9);
    }

    @Override
    public void pc() throws ParseException {
        this.setUnit((short)5);
    }

    @Override
    public void pt() throws ParseException {
        this.setUnit((short)6);
    }

    @Override
    public void px() throws ParseException {
        this.setUnit((short)3);
    }

    @Override
    public void percentage() throws ParseException {
        this.setUnit((short)2);
    }

    @Override
    public void rem() throws ParseException {
        this.setUnit((short)26);
    }

    @Override
    public void rex() throws ParseException {
        this.setUnit((short)28);
    }

    @Override
    public void rlh() throws ParseException {
        this.setUnit((short)27);
    }

    @Override
    public void vh() throws ParseException {
        this.setUnit((short)41);
    }

    @Override
    public void vw() throws ParseException {
        this.setUnit((short)45);
    }

    @Override
    public void vmax() throws ParseException {
        this.setUnit((short)43);
    }

    @Override
    public void vmin() throws ParseException {
        this.setUnit((short)44);
    }

    @Override
    public void mathExpression(CSSExpressionValue cSSExpressionValue, short s) throws ParseException {
        float f;
        short s2;
        LengthEvaluator lengthEvaluator = new LengthEvaluator(s);
        try {
            CSSTypedValue cSSTypedValue = lengthEvaluator.evaluateExpression(cSSExpressionValue);
            s2 = cSSTypedValue.getUnitType();
            if (s2 != 0) {
                s2 = 3;
            }
            f = cSSTypedValue.getFloatValue(s2);
        }
        catch (RuntimeException runtimeException) {
            throw new ParseException(runtimeException);
        }
        this.lengthValue(f);
        this.setUnit(s2);
    }

    @Override
    public void mathFunction(CSSMathFunctionValue cSSMathFunctionValue, short s) throws ParseException {
        float f;
        short s2;
        LengthEvaluator lengthEvaluator = new LengthEvaluator(s);
        try {
            CSSNumberValue cSSNumberValue = lengthEvaluator.evaluateFunction(cSSMathFunctionValue);
            s2 = cSSNumberValue.getUnitType();
            if (s2 != 0) {
                s2 = 3;
            }
            f = cSSNumberValue.getFloatValue(s2);
        }
        catch (RuntimeException runtimeException) {
            throw new ParseException(runtimeException);
        }
        this.lengthValue(f);
        this.setUnit(s2);
    }

    protected float unitToPixels(short s, float f, short s2) {
        throw new ParseException("Do not know how to convert to " + CSSUnit.dimensionUnitString((short)s), -1, -1);
    }

    protected void setUnit(short s) {
    }

    @Override
    public void endLength() throws ParseException {
    }

    protected class LengthEvaluator
    extends Evaluator {
        private short percentageInterpretation;

        public LengthEvaluator(short s) {
            super((short)3);
            this.percentageInterpretation = s;
        }

        protected CSSTypedValue absoluteTypedValue(CSSTypedValue cSSTypedValue) {
            short s = cSSTypedValue.getUnitType();
            if (CSSUnit.isRelativeLengthUnitType((short)s)) {
                float f = DefaultLengthHandler.this.unitToPixels(s, cSSTypedValue.getFloatValue(s), this.percentageInterpretation);
                return NumberValue.createCSSNumberValue((short)3, (float)f);
            }
            return cSSTypedValue;
        }

        protected float percentage(CSSTypedValue cSSTypedValue, short s) throws DOMException {
            float f = DefaultLengthHandler.this.unitToPixels((short)2, cSSTypedValue.getFloatValue((short)2), this.percentageInterpretation);
            return NumberValue.floatValueConversion((float)f, (short)3, (short)s);
        }

        protected short getPercentageInterpretation() {
            return this.percentageInterpretation;
        }
    }
}

