/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.dialect.type.AbstractPostgreSQLStructJdbcType;
import org.hibernate.procedure.FunctionReturn;
import org.hibernate.procedure.internal.AbstractStandardCallableStatementSupport;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.ProcedureParameterMetadataImplementor;
import org.hibernate.sql.exec.internal.JdbcCallImpl;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;
import org.hibernate.sql.exec.spi.JdbcOperationQueryCall;
import org.hibernate.type.OutputableType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class PostgreSQLCallableStatementSupport
extends AbstractStandardCallableStatementSupport {
    public static final PostgreSQLCallableStatementSupport INSTANCE = new PostgreSQLCallableStatementSupport(true);
    public static final PostgreSQLCallableStatementSupport V10_INSTANCE = new PostgreSQLCallableStatementSupport(false);
    private final boolean supportsProcedures;

    private PostgreSQLCallableStatementSupport(boolean supportsProcedures) {
        this.supportsProcedures = supportsProcedures;
    }

    @Override
    public JdbcOperationQueryCall interpretCall(ProcedureCallImplementor<?> procedureCall) {
        int jdbcParameterOffset;
        int startIndex;
        CallMode callMode;
        String procedureName = procedureCall.getProcedureName();
        FunctionReturn functionReturn = procedureCall.getFunctionReturn();
        ProcedureParameterMetadataImplementor parameterMetadata = procedureCall.getParameterMetadata();
        boolean firstParamIsRefCursor = parameterMetadata.getParameterCount() != 0 && PostgreSQLCallableStatementSupport.isFirstParameterModeRefCursor(parameterMetadata);
        List<ProcedureParameterImplementor<?>> registrations = parameterMetadata.getRegistrationsAsList();
        int paramStringSizeEstimate = functionReturn == null && parameterMetadata.hasNamedParameters() ? registrations.size() * 10 : registrations.size() * 2;
        JdbcCallImpl.Builder builder = new JdbcCallImpl.Builder();
        if (functionReturn != null) {
            if (functionReturn.getJdbcTypeCode() == 2012) {
                if (firstParamIsRefCursor) {
                    if (parameterMetadata.hasNamedParameters()) {
                        throw new HibernateException("Cannot mix named parameters and REF_CURSOR parameter on PostgreSQL");
                    }
                    callMode = CallMode.CALL_RETURN;
                    startIndex = 1;
                    jdbcParameterOffset = 1;
                    builder.addParameterRegistration(registrations.get(0).toJdbcParameterRegistration(1, procedureCall));
                } else {
                    callMode = CallMode.TABLE_FUNCTION;
                    startIndex = 0;
                    jdbcParameterOffset = 1;
                }
            } else {
                callMode = CallMode.FUNCTION;
                startIndex = 0;
                jdbcParameterOffset = 1;
            }
        } else if (this.supportsProcedures) {
            jdbcParameterOffset = 1;
            startIndex = 0;
            callMode = CallMode.NATIVE_CALL;
        } else if (firstParamIsRefCursor) {
            if (parameterMetadata.hasNamedParameters()) {
                throw new HibernateException("Cannot mix named parameters and REF_CURSOR parameter on PostgreSQL");
            }
            jdbcParameterOffset = 1;
            startIndex = 1;
            callMode = CallMode.CALL_RETURN;
            builder.addParameterRegistration(registrations.get(0).toJdbcParameterRegistration(1, procedureCall));
        } else {
            jdbcParameterOffset = 1;
            startIndex = 0;
            callMode = CallMode.CALL;
        }
        StringBuilder buffer = new StringBuilder(callMode.start.length() + callMode.end.length() + procedureName.length() + paramStringSizeEstimate).append(callMode.start);
        buffer.append(procedureName);
        if (startIndex == registrations.size()) {
            buffer.append('(');
        } else {
            int sep = 40;
            for (int i = startIndex; i < registrations.size(); ++i) {
                String castType;
                JdbcType jdbcType;
                ProcedureParameterImplementor<?> parameter = registrations.get(i);
                if (!this.supportsProcedures && parameter.getMode() == ParameterMode.REF_CURSOR) {
                    throw new HibernateException("PostgreSQL supports only one REF_CURSOR parameter, but multiple were registered");
                }
                buffer.append((char)sep);
                JdbcCallParameterRegistration registration = parameter.toJdbcParameterRegistration(i + jdbcParameterOffset, procedureCall);
                OutputableType<?> type = registration.getParameterType();
                if (parameter.getName() != null) {
                    buffer.append(parameter.getName()).append(" => ");
                }
                if (type != null && (jdbcType = type.getJdbcType()) instanceof AbstractPostgreSQLStructJdbcType) {
                    AbstractPostgreSQLStructJdbcType structJdbcType = (AbstractPostgreSQLStructJdbcType)jdbcType;
                    castType = structJdbcType.getStructTypeName();
                    buffer.append("cast(");
                } else {
                    castType = null;
                }
                buffer.append("?");
                if (castType != null) {
                    buffer.append(" as ").append(castType).append(')');
                }
                sep = 44;
                builder.addParameterRegistration(registration);
            }
        }
        buffer.append(callMode.end);
        builder.setCallableName(buffer.toString());
        return builder.buildJdbcCall();
    }

    private static boolean isFirstParameterModeRefCursor(ProcedureParameterMetadataImplementor parameterMetadata) {
        return parameterMetadata.getRegistrationsAsList().get(0).getMode() == ParameterMode.REF_CURSOR;
    }

    static enum CallMode {
        TABLE_FUNCTION("select * from ", ")"),
        FUNCTION("select ", ")"),
        NATIVE_CALL("call ", ")"),
        CALL_RETURN("{?=call ", ")}"),
        CALL("{call ", ")}");

        private final String start;
        private final String end;

        private CallMode(String start, String end) {
            this.start = start;
            this.end = end;
        }
    }
}

