/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

public abstract class AbstractType
implements Type {
    @Override
    public boolean isAssociationType() {
        return false;
    }

    @Override
    public boolean isCollectionType() {
        return false;
    }

    @Override
    public boolean isComponentType() {
        return false;
    }

    @Override
    public boolean isEntityType() {
        return false;
    }

    @Override
    public int compare(Object x, Object y) {
        return ((Comparable)x).compareTo(y);
    }

    @Override
    public Serializable disassemble(Object value, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return value == null ? null : (Serializable)this.deepCopy(value, session.getFactory());
    }

    @Override
    public Serializable disassemble(Object value, SessionFactoryImplementor sessionFactory) throws HibernateException {
        return value == null ? null : (Serializable)this.deepCopy(value, sessionFactory);
    }

    @Override
    public Object assemble(Serializable cached, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return cached == null ? null : this.deepCopy(cached, session.getFactory());
    }

    @Override
    public boolean isDirty(Object old, Object current, SharedSessionContractImplementor session) throws HibernateException {
        return !this.isSame(old, current);
    }

    @Override
    public boolean isAnyType() {
        return false;
    }

    @Override
    public boolean isModified(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        return this.isDirty(old, current, session);
    }

    @Override
    public boolean isSame(Object x, Object y) throws HibernateException {
        return this.isEqual(x, y);
    }

    @Override
    public boolean isEqual(Object x, Object y) {
        return Objects.equals(x, y);
    }

    @Override
    public int getHashCode(Object x) {
        return x.hashCode();
    }

    @Override
    public boolean isEqual(Object x, Object y, SessionFactoryImplementor factory) {
        return this.isEqual(x, y);
    }

    @Override
    public int getHashCode(Object x, SessionFactoryImplementor factory) {
        return this.getHashCode(x);
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache, ForeignKeyDirection foreignKeyDirection) throws HibernateException {
        return this.needsReplacement(foreignKeyDirection) ? this.replace(original, target, session, owner, copyCache) : target;
    }

    private boolean needsReplacement(ForeignKeyDirection foreignKeyDirection) {
        if (this instanceof CollectionType || this instanceof OneToOneType) {
            AssociationType associationType = (AssociationType)((Object)this);
            return associationType.getForeignKeyDirection() == foreignKeyDirection;
        }
        return ForeignKeyDirection.FROM_PARENT == foreignKeyDirection;
    }

    @Override
    public void beforeAssemble(Serializable cached, SharedSessionContractImplementor session) {
    }
}

