/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionConfigModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.provider.Provider;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.utils.RequiredActionHelper;

public interface RequiredActionProvider
extends Provider {
    default public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.NOT_SUPPORTED;
    }

    default public void initiatedActionCanceled(KeycloakSession session, AuthenticationSessionModel authSession) {
    }

    public void evaluateTriggers(RequiredActionContext var1);

    public void requiredActionChallenge(RequiredActionContext var1);

    public void processAction(RequiredActionContext var1);

    @Deprecated(since="26.3.0", forRemoval=true)
    default public int getMaxAuthAge() {
        return 300;
    }

    default public int getMaxAuthAge(KeycloakSession session) {
        int maxAge;
        RequiredActionConfigModel configModel;
        String providerId;
        RequiredActionProviderModel requiredAction;
        if (session == null) {
            return 300;
        }
        KeycloakContext keycloakContext = session.getContext();
        RealmModel realm = keycloakContext.getRealm();
        AuthenticationSessionModel authSession = keycloakContext.getAuthenticationSession();
        if (authSession != null && (requiredAction = RequiredActionHelper.getRequiredActionByProviderId(realm, providerId = authSession.getClientNote("kc_action"))) != null && (configModel = realm.getRequiredActionConfigByAlias(requiredAction.getAlias())) != null && configModel.containsConfigKey("max_auth_age") && (maxAge = RequiredActionFactory.parseMaxAuthAge(configModel)) >= 0) {
            return maxAge;
        }
        return 300;
    }
}

