/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.indices.breaker;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class CircuitBreakerStats
implements Writeable,
ToXContentObject {
    private final String name;
    private final long limit;
    private final long estimated;
    private final long trippedCount;
    private final double overhead;

    public CircuitBreakerStats(String name, long limit, long estimated, double overhead, long trippedCount) {
        this.name = name;
        this.limit = limit;
        this.estimated = estimated;
        this.trippedCount = trippedCount;
        this.overhead = overhead;
    }

    public CircuitBreakerStats(StreamInput in) throws IOException {
        this.limit = in.readLong();
        this.estimated = in.readLong();
        this.overhead = in.readDouble();
        this.trippedCount = in.readLong();
        this.name = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.limit);
        out.writeLong(this.estimated);
        out.writeDouble(this.overhead);
        out.writeLong(this.trippedCount);
        out.writeString(this.name);
    }

    public String getName() {
        return this.name;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getEstimated() {
        return this.estimated;
    }

    public long getTrippedCount() {
        return this.trippedCount;
    }

    public double getOverhead() {
        return this.overhead;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name.toLowerCase(Locale.ROOT));
        builder.field("limit_size_in_bytes", this.limit);
        builder.field("limit_size", new ByteSizeValue(this.limit));
        builder.field("estimated_size_in_bytes", this.estimated);
        builder.field("estimated_size", new ByteSizeValue(this.estimated));
        builder.field("overhead", this.overhead);
        builder.field("tripped", this.trippedCount);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "[" + this.name + ",limit=" + this.limit + "/" + String.valueOf(new ByteSizeValue(this.limit)) + ",estimated=" + this.estimated + "/" + String.valueOf(new ByteSizeValue(this.estimated)) + ",overhead=" + this.overhead + ",tripped=" + this.trippedCount + "]";
    }

    static final class Fields {
        static final String LIMIT = "limit_size_in_bytes";
        static final String LIMIT_HUMAN = "limit_size";
        static final String ESTIMATED = "estimated_size_in_bytes";
        static final String ESTIMATED_HUMAN = "estimated_size";
        static final String OVERHEAD = "overhead";
        static final String TRIPPED_COUNT = "tripped";

        Fields() {
        }
    }
}

