/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.IceGrid.AdminSessionPrx;
import com.zeroc.IceGrid.FileIteratorPrx;
import com.zeroc.IceGrid.FileNotAvailableException;
import com.zeroc.IceGrid.RegistryInfo;
import com.zeroc.IceGrid.RegistryNotExistException;
import com.zeroc.IceGrid.RegistryUnreachableException;
import com.zeroc.IceGridGUI.LiveActions;
import com.zeroc.IceGridGUI.LiveDeployment.Communicator;
import com.zeroc.IceGridGUI.LiveDeployment.Editor;
import com.zeroc.IceGridGUI.LiveDeployment.ShowLogFileDialog;
import com.zeroc.IceGridGUI.LiveDeployment.SlaveEditor;
import com.zeroc.IceGridGUI.LiveDeployment.TreeNode;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.awt.Cursor;
import java.util.concurrent.CompletableFuture;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class Slave
extends Communicator {
    private final RegistryInfo _info;
    private final String _title;
    private final String _instanceName;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static SlaveEditor _editor;
    private static JPopupMenu _popup;

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[25];
        actions[17] = true;
        actions[12] = true;
        actions[13] = true;
        actions[14] = true;
        return actions;
    }

    @Override
    public void shutdownRegistry() {
        String prefix = "Shutting down registry '" + this._id + "'...";
        this.getCoordinator().getStatusBar().setText(prefix);
        try {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this.getCoordinator().getAdmin().shutdownRegistryAsync(this._id).whenComplete((result, ex) -> this.amiComplete(prefix, "Failed to shutdown " + this._id, (Throwable)ex));
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to shutdown " + this._id, e.toString());
        }
        finally {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void retrieveOutput(final boolean stdout) {
        this.getRoot().openShowLogFileDialog(new ShowLogFileDialog.FileIteratorFactory(){

            @Override
            public FileIteratorPrx open(int count) throws FileNotAvailableException, RegistryNotExistException, RegistryUnreachableException {
                AdminSessionPrx session = Slave.this.getCoordinator().getSession();
                FileIteratorPrx result = stdout ? session.openRegistryStdOut(Slave.this._id, count) : session.openRegistryStdErr(Slave.this._id, count);
                return result;
            }

            @Override
            public String getTitle() {
                return "Registry " + Slave.this._title + " " + (stdout ? "stdout" : "stderr");
            }

            @Override
            public String getDefaultFilename() {
                return Slave.this._id + (stdout ? ".out" : ".err");
            }
        });
    }

    @Override
    public JPopupMenu getPopupMenu() {
        LiveActions la = this.getCoordinator().getLiveActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(la.get(12));
            _popup.add(la.get(13));
            _popup.add(la.get(14));
            _popup.addSeparator();
            _popup.add(la.get(17));
        }
        la.setTarget(this);
        return _popup;
    }

    @Override
    public Editor getEditor() {
        if (_editor == null) {
            _editor = new SlaveEditor();
        }
        _editor.show(this);
        return _editor;
    }

    @Override
    protected CompletableFuture<ObjectPrx> getAdminAsync() {
        return this.getRoot().getCoordinator().getAdmin().getRegistryAdminAsync(this._id);
    }

    @Override
    protected String getDisplayName() {
        return "Registry Slave " + this._id;
    }

    @Override
    protected String getDefaultFileName() {
        return "registry-" + this._instanceName + "-" + this._id;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            ImageIcon icon = Utils.getIcon("/icons/16x16/registry.png");
            _cellRenderer.setOpenIcon(icon);
            _cellRenderer.setClosedIcon(icon);
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    RegistryInfo getInfo() {
        return this._info;
    }

    Slave(TreeNode parent, RegistryInfo info, String instanceName) {
        super(parent, info.name, 1);
        this._childrenArray[0] = this._metrics;
        this._info = info;
        this._title = instanceName + " (" + info.name + ")";
        this._instanceName = instanceName;
    }
}

