// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// WebHTTPConfigApplyConfiguration represents a declarative configuration of the WebHTTPConfig type for use
// with apply.
type WebHTTPConfigApplyConfiguration struct {
	HTTP2   *bool                             `json:"http2,omitempty"`
	Headers *WebHTTPHeadersApplyConfiguration `json:"headers,omitempty"`
}

// WebHTTPConfigApplyConfiguration constructs a declarative configuration of the WebHTTPConfig type for use with
// apply.
func WebHTTPConfig() *WebHTTPConfigApplyConfiguration {
	return &WebHTTPConfigApplyConfiguration{}
}

// WithHTTP2 sets the HTTP2 field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HTTP2 field is set to the value of the last call.
func (b *WebHTTPConfigApplyConfiguration) WithHTTP2(value bool) *WebHTTPConfigApplyConfiguration {
	b.HTTP2 = &value
	return b
}

// WithHeaders sets the Headers field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Headers field is set to the value of the last call.
func (b *WebHTTPConfigApplyConfiguration) WithHeaders(value *WebHTTPHeadersApplyConfiguration) *WebHTTPConfigApplyConfiguration {
	b.Headers = value
	return b
}
