{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A type for objects that have an initially floating reference.
-- 
-- All the fields in the @GInitiallyUnowned@ structure are private to the
-- implementation and should never be accessed directly.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Objects.InitiallyUnowned
    ( 

-- * Exported types
    InitiallyUnowned(..)                    ,
    IsInitiallyUnowned                      ,
    toInitiallyUnowned                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveInitiallyUnownedMethod           ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Callbacks as GObject.Callbacks
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags
import {-# SOURCE #-} qualified GI.GObject.Interfaces.TypePlugin as GObject.TypePlugin
import {-# SOURCE #-} qualified GI.GObject.Objects.Binding as GObject.Binding
import {-# SOURCE #-} qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GObject.Structs.InterfaceInfo as GObject.InterfaceInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.Parameter as GObject.Parameter
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInfo as GObject.TypeInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInterface as GObject.TypeInterface
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeValueTable as GObject.TypeValueTable

#else
import {-# SOURCE #-} qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype InitiallyUnowned = InitiallyUnowned (SP.ManagedPtr InitiallyUnowned)
    deriving (Eq)

instance SP.ManagedPtrNewtype InitiallyUnowned where
    toManagedPtr (InitiallyUnowned p) = p

foreign import ccall "g_initially_unowned_get_type"
    c_g_initially_unowned_get_type :: IO B.Types.GType

instance B.Types.TypedObject InitiallyUnowned where
    glibType = c_g_initially_unowned_get_type

instance B.Types.GObject InitiallyUnowned

-- | Type class for types which can be safely cast to t'InitiallyUnowned', for instance with `toInitiallyUnowned`.
class (SP.GObject o, O.IsDescendantOf InitiallyUnowned o) => IsInitiallyUnowned o
instance (SP.GObject o, O.IsDescendantOf InitiallyUnowned o) => IsInitiallyUnowned o

instance O.HasParentTypes InitiallyUnowned
type instance O.ParentTypes InitiallyUnowned = '[GObject.Object.Object]

-- | Cast to t'InitiallyUnowned', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toInitiallyUnowned :: (MIO.MonadIO m, IsInitiallyUnowned o) => o -> m InitiallyUnowned
toInitiallyUnowned = MIO.liftIO . B.ManagedPtr.unsafeCastTo InitiallyUnowned

-- | Convert t'InitiallyUnowned' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe InitiallyUnowned) where
    gvalueGType_ = c_g_initially_unowned_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr InitiallyUnowned)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr InitiallyUnowned)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject InitiallyUnowned ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveInitiallyUnownedMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveInitiallyUnownedMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveInitiallyUnownedMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveInitiallyUnownedMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveInitiallyUnownedMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveInitiallyUnownedMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveInitiallyUnownedMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveInitiallyUnownedMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveInitiallyUnownedMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveInitiallyUnownedMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveInitiallyUnownedMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveInitiallyUnownedMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveInitiallyUnownedMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveInitiallyUnownedMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveInitiallyUnownedMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveInitiallyUnownedMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveInitiallyUnownedMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveInitiallyUnownedMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveInitiallyUnownedMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveInitiallyUnownedMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveInitiallyUnownedMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveInitiallyUnownedMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveInitiallyUnownedMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveInitiallyUnownedMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveInitiallyUnownedMethod t InitiallyUnowned, O.OverloadedMethod info InitiallyUnowned p) => OL.IsLabel t (InitiallyUnowned -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveInitiallyUnownedMethod t InitiallyUnowned, O.OverloadedMethod info InitiallyUnowned p, R.HasField t InitiallyUnowned p) => R.HasField t InitiallyUnowned p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveInitiallyUnownedMethod t InitiallyUnowned, O.OverloadedMethodInfo info InitiallyUnowned) => OL.IsLabel t (O.MethodProxy info InitiallyUnowned) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList InitiallyUnowned
type instance O.AttributeList InitiallyUnowned = InitiallyUnownedAttributeList
type InitiallyUnownedAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList InitiallyUnowned = InitiallyUnownedSignalList
type InitiallyUnownedSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


