{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.HarfBuzz.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "namespace HarfBuzz"
 , ""
 , "# Wrong annotations"
 , "set-attr HarfBuzz/font_set_funcs/@parameters/klass closure -1"
 , "set-attr HarfBuzz/font_set_funcs/@parameters/klass destroy -1"]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.HarfBuzz.Config"
 , "GI.HarfBuzz"
 , "GI.HarfBuzz.Callbacks"
 , "GI.HarfBuzz.Constants"
 , "GI.HarfBuzz.Enums"
 , "GI.HarfBuzz.Flags"
 , "GI.HarfBuzz.Functions"
 , "GI.HarfBuzz.Structs"
 , "GI.HarfBuzz.Structs.AatLayoutFeatureSelectorInfoT"
 , "GI.HarfBuzz.Structs.BlobT"
 , "GI.HarfBuzz.Structs.BufferT"
 , "GI.HarfBuzz.Structs.ColorLineT"
 , "GI.HarfBuzz.Structs.ColorStopT"
 , "GI.HarfBuzz.Structs.DrawFuncsT"
 , "GI.HarfBuzz.Structs.DrawStateT"
 , "GI.HarfBuzz.Structs.FaceT"
 , "GI.HarfBuzz.Structs.FeatureT"
 , "GI.HarfBuzz.Structs.FontExtentsT"
 , "GI.HarfBuzz.Structs.FontFuncsT"
 , "GI.HarfBuzz.Structs.FontT"
 , "GI.HarfBuzz.Structs.GlyphExtentsT"
 , "GI.HarfBuzz.Structs.GlyphInfoT"
 , "GI.HarfBuzz.Structs.GlyphPositionT"
 , "GI.HarfBuzz.Structs.LanguageT"
 , "GI.HarfBuzz.Structs.MapT"
 , "GI.HarfBuzz.Structs.OtColorLayerT"
 , "GI.HarfBuzz.Structs.OtMathGlyphPartT"
 , "GI.HarfBuzz.Structs.OtMathGlyphVariantT"
 , "GI.HarfBuzz.Structs.OtMathKernEntryT"
 , "GI.HarfBuzz.Structs.OtNameEntryT"
 , "GI.HarfBuzz.Structs.OtVarAxisInfoT"
 , "GI.HarfBuzz.Structs.OtVarAxisT"
 , "GI.HarfBuzz.Structs.PaintFuncsT"
 , "GI.HarfBuzz.Structs.SegmentPropertiesT"
 , "GI.HarfBuzz.Structs.SetT"
 , "GI.HarfBuzz.Structs.ShapePlanT"
 , "GI.HarfBuzz.Structs.UnicodeFuncsT"
 , "GI.HarfBuzz.Structs.UserDataKeyT"
 , "GI.HarfBuzz.Structs.VariationT"
 , "GI.HarfBuzz.Unions"
 , "GI.HarfBuzz.Unions.VarIntT"
 , "GI.HarfBuzz.Unions.VarNumT"]
