/* AbstractViewManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AbstractViewManager.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* A ViewManager allows an interface for ViewCollection to monitor a SourceCollection and*/
/* (selectively) add DataViews automatically.*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _ParamSpecViewManager ParamSpecViewManager;

struct _ParamSpecViewManager {
	GParamSpec parent_instance;
};

static gpointer view_manager_parent_class = NULL;

static gboolean view_manager_real_include_in_view (ViewManager* self,
                                            DataSource* source);
static DataView* view_manager_real_create_view (ViewManager* self,
                                         DataSource* source);
static void view_manager_finalize (ViewManager * obj);
static GType view_manager_get_type_once (void);

static gboolean
view_manager_real_include_in_view (ViewManager* self,
                                   DataSource* source)
{
	gboolean result;
	g_return_val_if_fail (source != NULL, FALSE);
	result = TRUE;
	return result;
}

gboolean
view_manager_include_in_view (ViewManager* self,
                              DataSource* source)
{
	ViewManagerClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = VIEW_MANAGER_GET_CLASS (self);
	if (_klass_->include_in_view) {
		return _klass_->include_in_view (self, source);
	}
	return FALSE;
}

static DataView*
view_manager_real_create_view (ViewManager* self,
                               DataSource* source)
{
	g_critical ("Type `%s' does not implement abstract method `view_manager_create_view'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

DataView*
view_manager_create_view (ViewManager* self,
                          DataSource* source)
{
	ViewManagerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VIEW_MANAGER_GET_CLASS (self);
	if (_klass_->create_view) {
		return _klass_->create_view (self, source);
	}
	return NULL;
}

ViewManager*
view_manager_construct (GType object_type)
{
	ViewManager* self = NULL;
	self = (ViewManager*) g_type_create_instance (object_type);
	return self;
}

static void
value_view_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_view_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		view_manager_unref (value->data[0].v_pointer);
	}
}

static void
value_view_manager_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = view_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_view_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_view_manager_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ViewManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = view_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_view_manager_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	ViewManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = view_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_view_manager (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecViewManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIEW_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_view_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_view_manager (GValue* value,
                        gpointer v_object)
{
	ViewManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIEW_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		view_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		view_manager_unref (old);
	}
}

void
value_take_view_manager (GValue* value,
                         gpointer v_object)
{
	ViewManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIEW_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		view_manager_unref (old);
	}
}

static void
view_manager_class_init (ViewManagerClass * klass,
                         gpointer klass_data)
{
	view_manager_parent_class = g_type_class_peek_parent (klass);
	((ViewManagerClass *) klass)->finalize = view_manager_finalize;
	((ViewManagerClass *) klass)->include_in_view = (gboolean (*) (ViewManager*, DataSource*)) view_manager_real_include_in_view;
	((ViewManagerClass *) klass)->create_view = (DataView* (*) (ViewManager*, DataSource*)) view_manager_real_create_view;
}

static void
view_manager_instance_init (ViewManager * self,
                            gpointer klass)
{
	self->ref_count = 1;
}

static void
view_manager_finalize (ViewManager * obj)
{
	ViewManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIEW_MANAGER, ViewManager);
	g_signal_handlers_destroy (self);
}

static GType
view_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_view_manager_init, value_view_manager_free_value, value_view_manager_copy_value, value_view_manager_peek_pointer, "p", value_view_manager_collect_value, "p", value_view_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ViewManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewManager), 0, (GInstanceInitFunc) view_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType view_manager_type_id;
	view_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ViewManager", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return view_manager_type_id;
}

GType
view_manager_get_type (void)
{
	static volatile gsize view_manager_type_id__once = 0;
	if (g_once_init_enter (&view_manager_type_id__once)) {
		GType view_manager_type_id;
		view_manager_type_id = view_manager_get_type_once ();
		g_once_init_leave (&view_manager_type_id__once, view_manager_type_id);
	}
	return view_manager_type_id__once;
}

gpointer
view_manager_ref (gpointer instance)
{
	ViewManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
view_manager_unref (gpointer instance)
{
	ViewManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIEW_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

