/* DataImportSource.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DataImportSource.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include "shotwell-plugin-dev-1.0.h"
#include <stdlib.h>
#include <string.h>
#include "metadata.h"
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE (spit_data_imports_data_import_source_get_type ())
#define SPIT_DATA_IMPORTS_DATA_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE, SpitDataImportsDataImportSource))
#define SPIT_DATA_IMPORTS_DATA_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE, SpitDataImportsDataImportSourceClass))
#define SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE))
#define SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE))
#define SPIT_DATA_IMPORTS_DATA_IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE, SpitDataImportsDataImportSourceClass))

typedef struct _SpitDataImportsDataImportSource SpitDataImportsDataImportSource;
typedef struct _SpitDataImportsDataImportSourceClass SpitDataImportsDataImportSourceClass;
typedef struct _SpitDataImportsDataImportSourcePrivate SpitDataImportsDataImportSourcePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
typedef struct _SpitDataImportsParamSpecDataImportSource SpitDataImportsParamSpecDataImportSource;

struct _SpitDataImportsDataImportSource {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SpitDataImportsDataImportSourcePrivate * priv;
};

struct _SpitDataImportsDataImportSourceClass {
	GTypeClass parent_class;
	void (*finalize) (SpitDataImportsDataImportSource *self);
};

struct _SpitDataImportsDataImportSourcePrivate {
	gboolean backing_file_found;
	SpitDataImportsImportableMediaItem* db_photo;
	gchar* title;
	gchar* preview_md5;
	guint64 file_size;
	GDateTime* modification_time;
	MetadataDateTime* exposure_time;
};

struct _SpitDataImportsParamSpecDataImportSource {
	GParamSpec parent_instance;
};

static gint SpitDataImportsDataImportSource_private_offset;
static gpointer spit_data_imports_data_import_source_parent_class = NULL;

VALA_EXTERN gpointer spit_data_imports_data_import_source_ref (gpointer instance);
VALA_EXTERN void spit_data_imports_data_import_source_unref (gpointer instance);
VALA_EXTERN GParamSpec* spit_data_imports_param_spec_data_import_source (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags);
VALA_EXTERN void spit_data_imports_value_set_data_import_source (GValue* value,
                                                     gpointer v_object);
VALA_EXTERN void spit_data_imports_value_take_data_import_source (GValue* value,
                                                      gpointer v_object);
VALA_EXTERN gpointer spit_data_imports_value_get_data_import_source (const GValue* value);
VALA_EXTERN GType spit_data_imports_data_import_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpitDataImportsDataImportSource, spit_data_imports_data_import_source_unref)
VALA_EXTERN SpitDataImportsDataImportSource* spit_data_imports_data_import_source_new (SpitDataImportsImportableMediaItem* db_photo);
VALA_EXTERN SpitDataImportsDataImportSource* spit_data_imports_data_import_source_construct (GType object_type,
                                                                                 SpitDataImportsImportableMediaItem* db_photo);
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN PhotoMetadata* photo_metadata_new (void);
VALA_EXTERN PhotoMetadata* photo_metadata_construct (GType object_type);
VALA_EXTERN gchar* spit_data_imports_data_import_source_get_filename (SpitDataImportsDataImportSource* self);
VALA_EXTERN MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
VALA_EXTERN gchar* photo_metadata_thumbnail_hash (PhotoMetadata* self);
VALA_EXTERN guint64 query_total_file_size (GFile* file_or_dir,
                               GCancellable* cancellable,
                               GError** error);
VALA_EXTERN GDateTime* query_file_modified (GFile* file,
                                GError** error);
VALA_EXTERN gchar* spit_data_imports_data_import_source_get_fulldir (SpitDataImportsDataImportSource* self);
VALA_EXTERN GFile* spit_data_imports_data_import_source_get_file (SpitDataImportsDataImportSource* self);
VALA_EXTERN gchar* spit_data_imports_data_import_source_get_name (SpitDataImportsDataImportSource* self);
VALA_EXTERN gboolean is_string_empty (const gchar* s);
VALA_EXTERN gchar* spit_data_imports_data_import_source_get_title (SpitDataImportsDataImportSource* self);
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoFileFormat spit_data_imports_data_import_source_get_file_format (SpitDataImportsDataImportSource* self);
VALA_EXTERN PhotoFileFormat photo_file_format_get_by_basename_extension (const gchar* basename);
VALA_EXTERN gchar* spit_data_imports_data_import_source_to_string (SpitDataImportsDataImportSource* self);
VALA_EXTERN GDateTime* spit_data_imports_data_import_source_get_exposure_time (SpitDataImportsDataImportSource* self);
VALA_EXTERN guint64 spit_data_imports_data_import_source_get_filesize (SpitDataImportsDataImportSource* self);
VALA_EXTERN SpitDataImportsImportableMediaItem* spit_data_imports_data_import_source_get_photo (SpitDataImportsDataImportSource* self);
VALA_EXTERN gboolean spit_data_imports_data_import_source_is_already_imported (SpitDataImportsDataImportSource* self);
VALA_EXTERN gboolean library_photo_has_nontrash_duplicate (GFile* file,
                                               const gchar* thumbnail_md5,
                                               const gchar* full_md5,
                                               PhotoFileFormat file_format);
VALA_EXTERN gboolean spit_data_imports_data_import_source_was_backing_file_found (SpitDataImportsDataImportSource* self);
static void spit_data_imports_data_import_source_finalize (SpitDataImportsDataImportSource * obj);
static GType spit_data_imports_data_import_source_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
spit_data_imports_data_import_source_get_instance_private (SpitDataImportsDataImportSource* self)
{
	return G_STRUCT_MEMBER_P (self, SpitDataImportsDataImportSource_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_metadata_date_time_ref0 (gpointer self)
{
	return self ? metadata_date_time_ref (self) : NULL;
}

SpitDataImportsDataImportSource*
spit_data_imports_data_import_source_construct (GType object_type,
                                                SpitDataImportsImportableMediaItem* db_photo)
{
	SpitDataImportsDataImportSource* self = NULL;
	SpitDataImportsImportableMediaItem* _tmp0_;
	gchar* folder_path = NULL;
	gchar* _tmp1_;
	gchar* filename = NULL;
	gchar* _tmp2_;
	GFile* photo = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp14_ = FALSE;
	GFile* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (db_photo, SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_MEDIA_ITEM), NULL);
	self = (SpitDataImportsDataImportSource*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (db_photo);
	_g_object_unref0 (self->priv->db_photo);
	self->priv->db_photo = _tmp0_;
	_tmp1_ = spit_data_imports_importable_media_item_get_folder_path (db_photo);
	folder_path = _tmp1_;
	_tmp2_ = spit_data_imports_importable_media_item_get_filename (db_photo);
	filename = _tmp2_;
	photo = NULL;
	_tmp4_ = folder_path;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = filename;
		_tmp3_ = _tmp5_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		_tmp6_ = spit_data_imports_importable_media_item_get_folder_path (db_photo);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_new_for_path (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = spit_data_imports_importable_media_item_get_filename (db_photo);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_file_get_child (_tmp9_, _tmp11_);
		_g_object_unref0 (photo);
		photo = _tmp12_;
		_g_free0 (_tmp11_);
		_g_object_unref0 (_tmp9_);
		_g_free0 (_tmp7_);
		_tmp13_ = photo;
		self->priv->backing_file_found = g_file_query_exists (_tmp13_, NULL);
	} else {
		self->priv->backing_file_found = FALSE;
	}
	_tmp15_ = photo;
	if (_tmp15_ != NULL) {
		_tmp14_ = self->priv->backing_file_found;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp16_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		GDateTime* date_time = NULL;
		GDateTime* _tmp30_;
		GDateTime* _tmp31_;
		PhotoMetadata* _tmp39_;
		_tmp16_ = photo_metadata_new ();
		metadata = _tmp16_;
		{
			PhotoMetadata* _tmp17_;
			GFile* _tmp18_;
			_tmp17_ = metadata;
			_tmp18_ = photo;
			media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MEDIA_METADATA, MediaMetadata), _tmp18_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_;
			GError* _tmp21_;
			const gchar* _tmp22_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp19_ = spit_data_imports_data_import_source_get_filename (self);
			_tmp20_ = _tmp19_;
			_tmp21_ = e;
			_tmp22_ = _tmp21_->message;
			g_warning ("DataImportSource.vala:48: Could not get file metadata for %s: %s", _tmp20_, _tmp22_);
			_g_free0 (_tmp20_);
			_media_metadata_unref0 (metadata);
			metadata = NULL;
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_media_metadata_unref0 (metadata);
			_g_object_unref0 (photo);
			_g_free0 (filename);
			_g_free0 (folder_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp23_ = spit_data_imports_importable_media_item_get_title (db_photo);
		_g_free0 (self->priv->title);
		self->priv->title = _tmp23_;
		_tmp24_ = self->priv->title;
		if (_tmp24_ == NULL) {
			gchar* _tmp25_ = NULL;
			PhotoMetadata* _tmp26_;
			gchar* _tmp29_;
			_tmp26_ = metadata;
			if (_tmp26_ != NULL) {
				PhotoMetadata* _tmp27_;
				gchar* _tmp28_;
				_tmp27_ = metadata;
				_tmp28_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_MEDIA_METADATA, MediaMetadata));
				_g_free0 (_tmp25_);
				_tmp25_ = _tmp28_;
			} else {
				_g_free0 (_tmp25_);
				_tmp25_ = NULL;
			}
			_tmp29_ = g_strdup (_tmp25_);
			_g_free0 (self->priv->title);
			self->priv->title = _tmp29_;
			_g_free0 (_tmp25_);
		}
		_tmp30_ = spit_data_imports_importable_media_item_get_exposure_time (db_photo);
		date_time = _tmp30_;
		_tmp31_ = date_time;
		if (_tmp31_ != NULL) {
			GDateTime* _tmp32_;
			MetadataDateTime* _tmp33_;
			_tmp32_ = date_time;
			_tmp33_ = metadata_date_time_new (_tmp32_);
			_metadata_date_time_unref0 (self->priv->exposure_time);
			self->priv->exposure_time = _tmp33_;
		} else {
			MetadataDateTime* _tmp34_ = NULL;
			PhotoMetadata* _tmp35_;
			MetadataDateTime* _tmp38_;
			_tmp35_ = metadata;
			if (_tmp35_ != NULL) {
				PhotoMetadata* _tmp36_;
				MetadataDateTime* _tmp37_;
				_tmp36_ = metadata;
				_tmp37_ = photo_metadata_get_exposure_date_time (_tmp36_);
				_metadata_date_time_unref0 (_tmp34_);
				_tmp34_ = _tmp37_;
			} else {
				_metadata_date_time_unref0 (_tmp34_);
				_tmp34_ = NULL;
			}
			_tmp38_ = _metadata_date_time_ref0 (_tmp34_);
			_metadata_date_time_unref0 (self->priv->exposure_time);
			self->priv->exposure_time = _tmp38_;
			_metadata_date_time_unref0 (_tmp34_);
		}
		_tmp39_ = metadata;
		if (_tmp39_ != NULL) {
			PhotoMetadata* _tmp40_;
			gchar* _tmp41_;
			_tmp40_ = metadata;
			_tmp41_ = photo_metadata_thumbnail_hash (_tmp40_);
			_g_free0 (self->priv->preview_md5);
			self->priv->preview_md5 = _tmp41_;
		}
		{
			guint64 _tmp42_ = 0ULL;
			GFile* _tmp43_;
			_tmp43_ = photo;
			_tmp42_ = query_total_file_size (_tmp43_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			self->priv->file_size = _tmp42_;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			gchar* _tmp44_;
			gchar* _tmp45_;
			GError* _tmp46_;
			const gchar* _tmp47_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp44_ = spit_data_imports_data_import_source_get_filename (self);
			_tmp45_ = _tmp44_;
			_tmp46_ = e;
			_tmp47_ = _tmp46_->message;
			g_warning ("DataImportSource.vala:73: Could not get file size for %s: %s", _tmp45_, _tmp47_);
			_g_free0 (_tmp45_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_date_time_unref0 (date_time);
			_media_metadata_unref0 (metadata);
			_g_object_unref0 (photo);
			_g_free0 (filename);
			_g_free0 (folder_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			GDateTime* _tmp48_ = NULL;
			GFile* _tmp49_;
			GDateTime* _tmp50_;
			GDateTime* _tmp51_;
			_tmp49_ = photo;
			_tmp50_ = query_file_modified (_tmp49_, &_inner_error0_);
			_tmp48_ = _tmp50_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp51_ = _tmp48_;
			_tmp48_ = NULL;
			_g_date_time_unref0 (self->priv->modification_time);
			self->priv->modification_time = _tmp51_;
			_g_date_time_unref0 (_tmp48_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			gchar* _tmp52_;
			gchar* _tmp53_;
			GError* _tmp54_;
			const gchar* _tmp55_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp52_ = spit_data_imports_data_import_source_get_filename (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = e;
			_tmp55_ = _tmp54_->message;
			g_warning ("DataImportSource.vala:78: Could not get modification time for %s: %s", _tmp53_, _tmp55_);
			_g_free0 (_tmp53_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_date_time_unref0 (date_time);
			_media_metadata_unref0 (metadata);
			_g_object_unref0 (photo);
			_g_free0 (filename);
			_g_free0 (folder_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_date_time_unref0 (date_time);
		_media_metadata_unref0 (metadata);
	} else {
		GFile* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp56_ = photo;
		_tmp57_ = g_file_get_path (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = g_strdup_printf ("Photo file %s not found", _tmp58_);
		_tmp60_ = _tmp59_;
		g_debug ("DataImportSource.vala:81: %s", _tmp60_);
		_g_free0 (_tmp60_);
		_g_free0 (_tmp58_);
	}
	_g_object_unref0 (photo);
	_g_free0 (filename);
	_g_free0 (folder_path);
	return self;
}

SpitDataImportsDataImportSource*
spit_data_imports_data_import_source_new (SpitDataImportsImportableMediaItem* db_photo)
{
	return spit_data_imports_data_import_source_construct (SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE, db_photo);
}

gchar*
spit_data_imports_data_import_source_get_filename (SpitDataImportsDataImportSource* self)
{
	SpitDataImportsImportableMediaItem* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE (self), NULL);
	_tmp0_ = self->priv->db_photo;
	_tmp1_ = spit_data_imports_importable_media_item_get_filename (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
spit_data_imports_data_import_source_get_fulldir (SpitDataImportsDataImportSource* self)
{
	SpitDataImportsImportableMediaItem* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE (self), NULL);
	_tmp0_ = self->priv->db_photo;
	_tmp1_ = spit_data_imports_importable_media_item_get_folder_path (_tmp0_);
	result = _tmp1_;
	return result;
}

GFile*
spit_data_imports_data_import_source_get_file (SpitDataImportsDataImportSource* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* result;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE (self), NULL);
	_tmp0_ = spit_data_imports_data_import_source_get_fulldir (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = spit_data_imports_data_import_source_get_filename (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_child (_tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp7_;
	return result;
}

gchar*
spit_data_imports_data_import_source_get_name (SpitDataImportsDataImportSource* self)
{
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE (self), NULL);
	_tmp1_ = self->priv->title;
	if (!is_string_empty (_tmp1_)) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->title;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = spit_data_imports_data_import_source_get_filename (self);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

gchar*
spit_data_imports_data_import_source_get_title (SpitDataImportsDataImportSource* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE (self), NULL);
	_tmp0_ = self->priv->title;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

PhotoFileFormat
spit_data_imports_data_import_source_get_file_format (SpitDataImportsDataImportSource* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	PhotoFileFormat _tmp2_;
	PhotoFileFormat result;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE (self), 0);
	_tmp0_ = spit_data_imports_data_import_source_get_filename (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_get_by_basename_extension (_tmp1_);
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
spit_data_imports_data_import_source_to_string (SpitDataImportsDataImportSource* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE (self), NULL);
	_tmp0_ = spit_data_imports_data_import_source_get_name (self);
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

GDateTime*
spit_data_imports_data_import_source_get_exposure_time (SpitDataImportsDataImportSource* self)
{
	GDateTime* _tmp0_ = NULL;
	MetadataDateTime* _tmp1_;
	GDateTime* result;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE (self), NULL);
	_tmp1_ = self->priv->exposure_time;
	if (_tmp1_ != NULL) {
		MetadataDateTime* _tmp2_;
		GDateTime* _tmp3_;
		_tmp2_ = self->priv->exposure_time;
		_tmp3_ = metadata_date_time_get_timestamp (_tmp2_);
		_g_date_time_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		GDateTime* _tmp4_;
		GDateTime* _tmp5_;
		_tmp4_ = self->priv->modification_time;
		_tmp5_ = _g_date_time_ref0 (_tmp4_);
		_g_date_time_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}

guint64
spit_data_imports_data_import_source_get_filesize (SpitDataImportsDataImportSource* self)
{
	guint64 result;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE (self), 0ULL);
	result = self->priv->file_size;
	return result;
}

SpitDataImportsImportableMediaItem*
spit_data_imports_data_import_source_get_photo (SpitDataImportsDataImportSource* self)
{
	SpitDataImportsImportableMediaItem* _tmp0_;
	SpitDataImportsImportableMediaItem* _tmp1_;
	SpitDataImportsImportableMediaItem* result;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE (self), NULL);
	_tmp0_ = self->priv->db_photo;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
spit_data_imports_data_import_source_is_already_imported (SpitDataImportsDataImportSource* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE (self), FALSE);
	_tmp1_ = self->priv->preview_md5;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->preview_md5;
		_tmp0_ = library_photo_has_nontrash_duplicate (NULL, _tmp2_, NULL, spit_data_imports_data_import_source_get_file_format (self));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
spit_data_imports_data_import_source_was_backing_file_found (SpitDataImportsDataImportSource* self)
{
	gboolean result;
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORT_SOURCE (self), FALSE);
	result = self->priv->backing_file_found;
	return result;
}

static void
spit_data_imports_value_data_import_source_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
spit_data_imports_value_data_import_source_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		spit_data_imports_data_import_source_unref (value->data[0].v_pointer);
	}
}

static void
spit_data_imports_value_data_import_source_copy_value (const GValue* src_value,
                                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = spit_data_imports_data_import_source_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
spit_data_imports_value_data_import_source_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
spit_data_imports_value_data_import_source_collect_value (GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SpitDataImportsDataImportSource * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = spit_data_imports_data_import_source_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
spit_data_imports_value_data_import_source_lcopy_value (const GValue* value,
                                                        guint n_collect_values,
                                                        GTypeCValue* collect_values,
                                                        guint collect_flags)
{
	SpitDataImportsDataImportSource ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = spit_data_imports_data_import_source_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
spit_data_imports_param_spec_data_import_source (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags)
{
	SpitDataImportsParamSpecDataImportSource* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
spit_data_imports_value_get_data_import_source (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE), NULL);
	return value->data[0].v_pointer;
}

void
spit_data_imports_value_set_data_import_source (GValue* value,
                                                gpointer v_object)
{
	SpitDataImportsDataImportSource * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		spit_data_imports_data_import_source_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		spit_data_imports_data_import_source_unref (old);
	}
}

void
spit_data_imports_value_take_data_import_source (GValue* value,
                                                 gpointer v_object)
{
	SpitDataImportsDataImportSource * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		spit_data_imports_data_import_source_unref (old);
	}
}

static void
spit_data_imports_data_import_source_class_init (SpitDataImportsDataImportSourceClass * klass,
                                                 gpointer klass_data)
{
	spit_data_imports_data_import_source_parent_class = g_type_class_peek_parent (klass);
	((SpitDataImportsDataImportSourceClass *) klass)->finalize = spit_data_imports_data_import_source_finalize;
	g_type_class_adjust_private_offset (klass, &SpitDataImportsDataImportSource_private_offset);
}

static void
spit_data_imports_data_import_source_instance_init (SpitDataImportsDataImportSource * self,
                                                    gpointer klass)
{
	self->priv = spit_data_imports_data_import_source_get_instance_private (self);
	self->priv->title = NULL;
	self->priv->preview_md5 = NULL;
	self->ref_count = 1;
}

static void
spit_data_imports_data_import_source_finalize (SpitDataImportsDataImportSource * obj)
{
	SpitDataImportsDataImportSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPIT_DATA_IMPORTS_TYPE_DATA_IMPORT_SOURCE, SpitDataImportsDataImportSource);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->db_photo);
	_g_free0 (self->priv->title);
	_g_free0 (self->priv->preview_md5);
	_g_date_time_unref0 (self->priv->modification_time);
	_metadata_date_time_unref0 (self->priv->exposure_time);
}

/**
 * Photo source implementation for alien databases. This class is responsible
 * for extracting meta-data out of a source photo to support the import
 * process.
 *
 * This class does not extend PhotoSource in order to minimise the API to the
 * absolute minimum required to run the import job.
 */
static GType
spit_data_imports_data_import_source_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { spit_data_imports_value_data_import_source_init, spit_data_imports_value_data_import_source_free_value, spit_data_imports_value_data_import_source_copy_value, spit_data_imports_value_data_import_source_peek_pointer, "p", spit_data_imports_value_data_import_source_collect_value, "p", spit_data_imports_value_data_import_source_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsDataImportSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_data_imports_data_import_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpitDataImportsDataImportSource), 0, (GInstanceInitFunc) spit_data_imports_data_import_source_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType spit_data_imports_data_import_source_type_id;
	spit_data_imports_data_import_source_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SpitDataImportsDataImportSource", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SpitDataImportsDataImportSource_private_offset = g_type_add_instance_private (spit_data_imports_data_import_source_type_id, sizeof (SpitDataImportsDataImportSourcePrivate));
	return spit_data_imports_data_import_source_type_id;
}

GType
spit_data_imports_data_import_source_get_type (void)
{
	static volatile gsize spit_data_imports_data_import_source_type_id__once = 0;
	if (g_once_init_enter (&spit_data_imports_data_import_source_type_id__once)) {
		GType spit_data_imports_data_import_source_type_id;
		spit_data_imports_data_import_source_type_id = spit_data_imports_data_import_source_get_type_once ();
		g_once_init_leave (&spit_data_imports_data_import_source_type_id__once, spit_data_imports_data_import_source_type_id);
	}
	return spit_data_imports_data_import_source_type_id__once;
}

gpointer
spit_data_imports_data_import_source_ref (gpointer instance)
{
	SpitDataImportsDataImportSource * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
spit_data_imports_data_import_source_unref (gpointer instance)
{
	SpitDataImportsDataImportSource * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SPIT_DATA_IMPORTS_DATA_IMPORT_SOURCE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

