// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package client

import (
	"encoding/json"
	"errors"
	"github.com/go-acme/jdcloud-sdk-go/core"
	domainservice "github.com/go-acme/jdcloud-sdk-go/services/domainservice/apis"
)

type DomainserviceClient struct {
	core.JDCloudClient
}

func NewDomainserviceClient(credential *core.Credential) *DomainserviceClient {
	if credential == nil {
		return nil
	}

	config := core.NewConfig()
	config.SetEndpoint("domainservice.jdcloud-api.com")

	return &DomainserviceClient{
		core.JDCloudClient{
			Credential:  *credential,
			Config:      *config,
			ServiceName: "domainservice",
			Revision:    "2.0.3",
			Logger:      core.NewDefaultLogger(core.LogInfo),
		}}
}

func (c *DomainserviceClient) SetConfig(config *core.Config) {
	c.Config = *config
}

func (c *DomainserviceClient) SetLogger(logger core.Logger) {
	c.Logger = logger
}

func (c *DomainserviceClient) DisableLogger() {
	c.Logger = core.NewDummyLogger()
}

/* 删除主域名的自定义解析线路的IP段 */
func DeleteUserViewIP(c *DomainserviceClient, request *domainservice.DeleteUserViewIPRequest) (*domainservice.DeleteUserViewIPResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DeleteUserViewIPResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 查看用户在云解析服务下的操作记录 */
func DescribeActionLog(c *DomainserviceClient, request *domainservice.DescribeActionLogRequest) (*domainservice.DescribeActionLogResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DescribeActionLogResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 查看主域名的解析次数 */
func DescribeDomainQueryCount(c *DomainserviceClient, request *domainservice.DescribeDomainQueryCountRequest) (*domainservice.DescribeDomainQueryCountResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DescribeDomainQueryCountResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 查看域名的查询流量 */
func DescribeDomainQueryTraffic(c *DomainserviceClient, request *domainservice.DescribeDomainQueryTrafficRequest) (*domainservice.DescribeDomainQueryTrafficResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DescribeDomainQueryTrafficResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 监控项的操作集合，包括：暂停，启动, 手动恢复, 手动切换 */
func ModifyMonitorStatus(c *DomainserviceClient, request *domainservice.ModifyMonitorStatusRequest) (*domainservice.ModifyMonitorStatusResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.ModifyMonitorStatusResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 添加主域名的解析记录 */
func CreateResourceRecord(c *DomainserviceClient, request *domainservice.CreateResourceRecordRequest) (*domainservice.CreateResourceRecordResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.CreateResourceRecordResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 修改主域名 */
func ModifyDomain(c *DomainserviceClient, request *domainservice.ModifyDomainRequest) (*domainservice.ModifyDomainResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.ModifyDomainResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/*
	同一个主域名下，批量新增或者批量更新导入解析记录。

如果解析记录的ID为0，是新增解析记录，如果不为0，则是更新解析记录。
*/
func BatchSetResourceRecords(c *DomainserviceClient, request *domainservice.BatchSetResourceRecordsRequest) (*domainservice.BatchSetResourceRecordsResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.BatchSetResourceRecordsResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 查询子域名的可用监控对象 */
func DescribeMonitorTarget(c *DomainserviceClient, request *domainservice.DescribeMonitorTargetRequest) (*domainservice.DescribeMonitorTargetResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DescribeMonitorTargetResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 添加子域名的某些特定监控对象为监控项 */
func CreateMonitorTarget(c *DomainserviceClient, request *domainservice.CreateMonitorTargetRequest) (*domainservice.CreateMonitorTargetResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.CreateMonitorTargetResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/*
	添加主域名

如何添加免费域名，详细情况请查阅<a href="https://docs.jdcloud.com/cn/jd-cloud-dns/domainadd">文档</a>
添加收费域名，请查阅<a href="https://docs.jdcloud.com/cn/jd-cloud-dns/purchase-process">文档</a>，
添加收费域名前，请确保用户的京东云账户有足够的资金支付，Openapi接口回返回订单号，可以用此订单号向计费系统查阅详情。
*/
func CreateDomain(c *DomainserviceClient, request *domainservice.CreateDomainRequest) (*domainservice.CreateDomainResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.CreateDomainResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 查询主域名的自定义解析线路的IP段 */
func DescribeUserViewIP(c *DomainserviceClient, request *domainservice.DescribeUserViewIPRequest) (*domainservice.DescribeUserViewIPResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DescribeUserViewIPResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 启用、停用主域名下的解析记录 */
func ModifyResourceRecordStatus(c *DomainserviceClient, request *domainservice.ModifyResourceRecordStatusRequest) (*domainservice.ModifyResourceRecordStatusResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.ModifyResourceRecordStatusResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 修改主域名的某个解析记录 */
func ModifyResourceRecord(c *DomainserviceClient, request *domainservice.ModifyResourceRecordRequest) (*domainservice.ModifyResourceRecordResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.ModifyResourceRecordResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/*
	获取用户所属的主域名列表。

请在调用域名相关的接口之前，调用此接口获取相关的domainId和domainName。
主域名的相关概念，请查阅<a href="https://docs.jdcloud.com/cn/jd-cloud-dns/product-overview">云解析文档</a>
*/
func DescribeDomains(c *DomainserviceClient, request *domainservice.DescribeDomainsRequest) (*domainservice.DescribeDomainsResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DescribeDomainsResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 添加子域名的监控项，默认把子域名的所有监控项都添加上监控 */
func CreateMonitor(c *DomainserviceClient, request *domainservice.CreateMonitorRequest) (*domainservice.CreateMonitorResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.CreateMonitorResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 添加主域名的自定义解析线路的IP段 */
func CreateUserViewIP(c *DomainserviceClient, request *domainservice.CreateUserViewIPRequest) (*domainservice.CreateUserViewIPResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.CreateUserViewIPResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 删除主域名的自定义解析线路 */
func DeleteUserView(c *DomainserviceClient, request *domainservice.DeleteUserViewRequest) (*domainservice.DeleteUserViewResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DeleteUserViewResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 域名的监控项修改 */
func ModifyMonitor(c *DomainserviceClient, request *domainservice.ModifyMonitorRequest) (*domainservice.ModifyMonitorResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.ModifyMonitorResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/*
	查询主域名的解析记录。

在使用解析记录相关的接口之前，请调用此接口获取解析记录的列表。
*/
func DescribeResourceRecord(c *DomainserviceClient, request *domainservice.DescribeResourceRecordRequest) (*domainservice.DescribeResourceRecordResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DescribeResourceRecordResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 查询主域名的自定义解析线路 */
func DescribeUserView(c *DomainserviceClient, request *domainservice.DescribeUserViewRequest) (*domainservice.DescribeUserViewResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DescribeUserViewResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 主域名的监控项的报警信息 */
func DescribeMonitorAlarm(c *DomainserviceClient, request *domainservice.DescribeMonitorAlarmRequest) (*domainservice.DescribeMonitorAlarmResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DescribeMonitorAlarmResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 添加主域名的自定义解析线路 */
func CreateUserView(c *DomainserviceClient, request *domainservice.CreateUserViewRequest) (*domainservice.CreateUserViewResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.CreateUserViewResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/*
	查询云解析所有的基础解析线路。

在使用解析线路的参数之前，请调用此接口获取解析线路的ID。
*/
func DescribeViewTree(c *DomainserviceClient, request *domainservice.DescribeViewTreeRequest) (*domainservice.DescribeViewTreeResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DescribeViewTreeResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 删除主域名下的解析记录 */
func DeleteResourceRecord(c *DomainserviceClient, request *domainservice.DeleteResourceRecordRequest) (*domainservice.DeleteResourceRecordResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DeleteResourceRecordResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 查看主域名的监控项的配置以及状态 */
func DescribeMonitor(c *DomainserviceClient, request *domainservice.DescribeMonitorRequest) (*domainservice.DescribeMonitorResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DescribeMonitorResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 监控项的删除 */
func DeleteMonitor(c *DomainserviceClient, request *domainservice.DeleteMonitorRequest) (*domainservice.DeleteMonitorResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DeleteMonitorResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}

/* 删除主域名 */
func DeleteDomain(c *DomainserviceClient, request *domainservice.DeleteDomainRequest) (*domainservice.DeleteDomainResponse, error) {
	if request == nil {
		return nil, errors.New("Request object is nil. ")
	}
	resp, err := c.Send(request, c.ServiceName)
	if err != nil {
		return nil, err
	}

	jdResp := &domainservice.DeleteDomainResponse{}
	err = json.Unmarshal(resp, jdResp)
	if err != nil {
		c.Logger.Log(core.LogError, "Unmarshal json failed, resp: %s", string(resp))
		return nil, err
	}

	return jdResp, err
}
