/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jws;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.jose.JOSEHeader;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.util.JsonSerialization;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JWSHeader
implements JOSEHeader {
    @JsonProperty(value="alg")
    private Algorithm algorithm;
    @JsonProperty(value="typ")
    private String type;
    @JsonProperty(value="cty")
    private String contentType;
    @JsonProperty(value="kid")
    private String keyId;
    @JsonProperty(value="jwk")
    private JWK key;
    @JsonProperty(value="x5c")
    private List<String> x5c;
    private Map<String, Object> otherClaims = new HashMap<String, Object>();

    public JWSHeader() {
    }

    public JWSHeader(Algorithm algorithm, String type, String contentType) {
        this.algorithm = algorithm;
        this.type = type;
        this.contentType = contentType;
    }

    public JWSHeader(Algorithm algorithm, String type, String keyId, JWK key) {
        this.algorithm = algorithm;
        this.type = type;
        this.keyId = keyId;
        this.key = key;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    @JsonIgnore
    public String getRawAlgorithm() {
        return this.getAlgorithm().name();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public JWK getKey() {
        return this.key;
    }

    public void setKey(JWK key) {
        this.key = key;
    }

    public List<String> getX5c() {
        return this.x5c;
    }

    public void setX5c(List<String> x5c) {
        this.x5c = x5c;
    }

    public void addX5c(String x5c) {
        this.x5c.add(x5c);
    }

    public void addX5c(Certificate x5c) {
        try {
            this.x5c.add(Base64.getEncoder().encodeToString(x5c.getEncoded()));
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonAnyGetter
    public Map<String, Object> getOtherClaims() {
        return this.otherClaims;
    }

    @JsonAnySetter
    public void setOtherClaims(String name, Object value) {
        this.otherClaims.put(name, value);
    }

    public String toString() {
        try {
            return JsonSerialization.writeValueAsString(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

