/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.spies.MultiSpyBase;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Flow;

public class MultiOnSubscribeSpy<T>
extends MultiSpyBase<T> {
    private volatile Flow.Subscription lastSubscription;

    public Flow.Subscription lastSubscription() {
        return this.lastSubscription;
    }

    MultiOnSubscribeSpy(Multi<? extends T> upstream) {
        super(upstream);
    }

    @Override
    public void reset() {
        super.reset();
        this.lastSubscription = null;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.onSubscription().invoke((? super Flow.Subscription subscription) -> {
            this.incrementInvocationCount();
            this.lastSubscription = subscription;
        }).subscribe().withSubscriber(downstream);
    }

    @Override
    public String toString() {
        return "MultiOnSubscribeSpy{lastSubscription=" + String.valueOf(this.lastSubscription) + "} " + super.toString();
    }
}

