/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.NodeFencer;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class RMHAServiceTarget
extends HAServiceTarget {
    private final boolean autoFailoverEnabled;
    private final InetSocketAddress haAdminServiceAddress;

    public RMHAServiceTarget(YarnConfiguration conf) throws IOException {
        this.autoFailoverEnabled = HAUtil.isAutomaticFailoverEnabled(conf);
        this.haAdminServiceAddress = conf.getSocketAddr("yarn.resourcemanager.admin.address", "0.0.0.0:8033", 8033);
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.haAdminServiceAddress;
    }

    @Override
    public InetSocketAddress getZKFCAddress() {
        throw new UnsupportedOperationException("RMHAServiceTarget doesn't have a corresponding ZKFC address");
    }

    @Override
    public NodeFencer getFencer() {
        return null;
    }

    @Override
    public void checkFencingConfigured() throws BadFencingConfigurationException {
        throw new BadFencingConfigurationException("Fencer not configured");
    }

    @Override
    public boolean isAutoFailoverEnabled() {
        return this.autoFailoverEnabled;
    }
}

