---
title: Star Map
---
<% content_for :javascript do %>
<script src="<%= relative_path_to(@items['/map.js']) %>"></script>
<script>
$(document).ready( function() {
    // Create a graphology graph
    const graph = new graphology.Graph();

    // Data generated by ruby
    var ssys = [<%= out = ""
    @items.find_all('/ssys/*.md').each do |s|
        out += "{ name:\"#{s[:name]}\", x:#{s[:x]}, y:#{s[:y]}, s:#{s[:tags].include? "spoiler"} },\n"
    end
    out %>];
    var jumps = [<%= out = ""
    @items.find_all('/ssys/*.md').each do |s|
        s[:jumps].each do |j|
            t = ssys_get( j[:target] )
            spoiler = (s[:tags].include? "spoiler") || (t[:tags].include? "spoiler")
            if s[:name] < j[:target]
                out += "{ a:\"#{s[:name]}\", b:\"#{j[:target]}\", h:#{j[:hidden]}, s:#{spoiler} },\n"
            end
        end
    end
    out %>];

    // Load data into graph, skipping spoilers as necessary
    function make_graph () {
        var spoiled = spoilers();
        var n = ssys.length;
        for (var i=0; i<n; i++) {
            var s = ssys[i];
            if (!s.s || spoiled) {
                graph.addNode( s.name, { label: s.name, x: s.x, y: s.y, size: 5, color: "white", borderColor: "white" } );
            }
        }
        var nj = jumps.length;
        for (var i=0; i<nj; i++) {
            var j = jumps[i];
            if ((!j.s && !j.h) || spoiled) {
                graph.addEdge( j.a, j.b, { size: 2, color: (j.h) ? 'red' :'blue' } );
            }
        }
    }

    // First create the graph
    make_graph();

    // Instantiate sigma.js and render the graph
    const sigmaInstance = new Sigma( graph, document.getElementById("starmap"), {
        labelColor: { color: "white" },
        labelRenderer: starmapLabel,
        hoverRenderer: starmapHover,
        //doubleClickEnabled: false,
        //defaultNodeType: "bordered",
        //nodeProgramClasses: {
        //    bordered: NodeBorderProgram,
        //},
    } );
    sigmaInstance.on('doubleClickNode', function(event) {
        const ssysModal = new bootstrap.Modal('div.modal[data-Name="'+event.node+'"]');
        ssysModal.show();
        event.preventSigmaDefault();
    });

    $('input#spoilers').change( function () {
        graph.clear();
        make_graph();
        sigmaInstance.refresh();
    } );
});
</script>
<% end %>

<div id="starmap" style="width: 100%; height: 600px; background: black"></div>

<div class="alert alert-info d-flex align-items-center" role="alert">
Double-click on a star system to open up an information window.
</div>

<%= modal_addAll() %>
