/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkapersonaldata.h"

#include <qdom.h>
#include <qregexp.h>
#include <qstringlist.h>

#include <klocale.h>

using namespace KKAddressBook;

KKAPersonalData::KKAPersonalData( QObject* parent )
 : QObject( parent )
 , m_prefix( QString::null )
 , m_name( QString::null )
 , m_suffix( QString::null )
{
}

KKAPersonalData::KKAPersonalData( QDomElement e, QObject* parent )
 : QObject( parent )
 , m_prefix( e.attribute( "prefix" ) )
 , m_name( e.attribute( "name" ) )
 , m_suffix( e.attribute( "suffix" ) )
{

}

KKAPersonalData::~KKAPersonalData()
{
}

QDomElement KKAPersonalData::toElement( QDomDocument& doc )
{
	QDomElement elem = doc.createElement( tagName() );
	elem.setAttribute( "prefix", m_prefix );
	elem.setAttribute( "name", m_name );
	elem.setAttribute( "suffix", m_suffix );
	return elem;
}

void KKAPersonalData::setPrefix( const QString& prefix )
{
	if( m_prefix == prefix ) return;
	m_prefix = prefix;
	emit updated();
}

void KKAPersonalData::setName( const QString& name )
{
	if( m_name == name ) return;
	m_name = name;
	emit updated();
}

void KKAPersonalData::setSuffix( const QString& suffix )
{
	if( m_suffix == suffix ) return;
	m_suffix = suffix;
	emit updated();
}

bool KKAPersonalData::isValid() const
{
	return !( m_name.isNull() || m_name.isEmpty() );
}

QString KKAPersonalData::familyName() const
{
	QRegExp sep( QString::fromUtf8( "[ 　]" ) );
	QStringList list = QStringList::split( sep, m_name );
	switch( list.count() )
	{
		case 0:
		case 1:
			return QString::null;
		default:
			return list[0];
	}
	return QString::null;
}

QString KKAPersonalData::givenName() const
{
	QRegExp sep( QString::fromUtf8( "[ 　]" ) );
	QStringList list = QStringList::split( sep, m_name );
	switch( list.count() )
	{
		case 0:
			return QString::null;
		case 1:
			return list[0];
		default:
			list.pop_front();
			return list.join( " " );
	}
	return QString::null;
}
