/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kcmdlineargs.h>
#include <kdebug.h>

#include <ksplashscreen.h>
#include <kstandarddirs.h>
#include <klocale.h>

#include "kkapplication.h"
#include "kreetingkard.h"

KKApplication::KKApplication()
 : KUniqueApplication( "KreetingKard" )
{
	QString splash_png = KGlobal::dirs()->findResource( "data", KGlobal::instance()->instanceName() + "/splash.png" );
	KSplashScreen* splash = new KSplashScreen( splash_png );
	splash->show();
	splash->message( i18n( "Initializing Application" ), AlignBottom | AlignHCenter, blue );
	kapp->processEvents();
	KreetingKard* kk = new KreetingKard();
	setMainWidget( kk );
	kk->show();
	splash->finish( kk );
	delete splash;
}


int KKApplication::newInstance()
{
	if( isRestored() )
	{
		RESTORE(KreetingKard);
	}
	else
	{
		KCmdLineArgs* args = KCmdLineArgs::parsedArgs();
		if( args->count() > 0 )
		{
			QString filename = args->url( args->count() - 1 ).path();
			if( !filename.isNull() )
			{
				KreetingKard* mainWin = (KreetingKard*)mainWidget();
				if( mainWin )
				{
					mainWin->fileOpen( filename );
				}
			}
		}
		args->clear();
	}

	return KUniqueApplication::newInstance();
}


