/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDCATEGORYITEM_H_
#define _KKDCATEGORYITEM_H_

#include <qptrlist.h>
#include <qdom.h>

namespace KKDSubscribeTemplate
{
	class KKDCategoryItem;
	typedef QPtrList<KKDCategoryItem> KKDCategoryItemList;

	class KKDCategoryItem
	{
		public:
			KKDCategoryItem(){}
			KKDCategoryItem( const KKDCategoryItem& ){}
			KKDCategoryItem( QDomElement elem );
			const QString& title(){ return m_title; }
			const QString& path(){ return m_path; }
			KKDCategoryItemList& list(){ return m_list; }

		private:
			QString m_title;
			QString m_path;
			KKDCategoryItemList m_list;
	};
}

#endif /* _KKDCATEGORYITEM_H_ */
