/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKSWIDGET_H_
#define _KKSWIDGET_H_

#include "../kkwidgetbase.h"

class QWidget;
class QListViewItem;
class QDomDocument;

namespace KKDesigner
{
	class KKDDoc;
	class KKDView;
}

namespace KKAddressBook
{
	class KKAContactData;
	class KKADetailView;
}

namespace KKSender
{
	class KKSInputWidget;
	
	class KKSWidget : public KKWidgetBase
	{
		Q_OBJECT
	public:
		KKSWidget( KCommandHistory* cmdHistory, QWidget* parent = 0, const char* name = 0 );
		virtual ~KKSWidget();
		const char* xmlFile(){ return "kksenderui.rc"; }
		bool closable();
		void readConfig( KConfig* conf );
		void saveConfig( KConfig* conf );
		const KKAddressBook::KKAContactData* sender() const { return m_sender; }

	public slots:
		void tabChanged( bool enabled );
		void setDocument( KKDesigner::KKDDoc* doc ) { m_doc = doc; }

	private slots:
		void togglePreview();
	
	private:
		void createData( QDomDocument& doc );

		KKAddressBook::KKAContactData* m_sender;
		
		KKAddressBook::KKADetailView* m_dvw;
		KKDesigner::KKDDoc* m_doc;
		KKDesigner::KKDView* m_pvw;
	};
}

#endif /* _KKSWIDGET_H_ */
