/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kktitem.h"

#include <qdir.h>

#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>

using namespace KKTemplate;

KKTItem::KKTItem( QString path )
	: m_filename( QString::null )
	, m_title( QString::null )
	, m_author( QString::null )
	, m_email( QString::null )
	, m_website( QString::null )
	, m_comment( QString::null )
{
	QDir dir( path );
	QStringList list = dir.entryList( QDir::Files|QDir::Readable, QDir::Name );
	for( QStringList::iterator it = list.begin(); it != list.end(); ++it )
	{
		if( *it == "metadata.xml" )
		{
			readMetaData( path + *it );
		}
		else if( (*it).right( 3 ) == ".kk" )
		{
			m_filename = path + *it;
		}
		else if( (*it).right( 4 ) == ".png" )
		{
			m_preview = QPixmap( path + *it );
		}
	}
}

KKTItem::~KKTItem()
{
}

void KKTItem::readMetaData( const QString& filename )
{
	QFile file( filename );
	if( !file.open( IO_ReadOnly ) )
	{
		KMessageBox::error( (QWidget*)0, i18n( "File open error\n%1" ).arg( filename ) );
		return;
	}

	QDomDocument doc( "kktemplate" );
	if( !doc.setContent( &file ) )
	{
		KMessageBox::error( (QWidget*)0, i18n( "File is not kreetingkard template format" ) );
		file.close();
		return;
	}
	file.close();

	QString lang = KGlobal::locale()->language();

	for( QDomNode node = doc.documentElement().firstChild(); !node.isNull(); node = node.nextSibling() )
	{
		QDomElement elem = node.toElement();
		if( elem.tagName() == "template" )
		{
			if( ( elem.attribute( "lang" ) == "C" && m_title.isNull() ) || elem.attribute( "lang" ) == lang )
			{
				for( QDomNode n = node.firstChild(); !n.isNull(); n = n.nextSibling() )
				{
					QDomElement e = n.toElement();
					if( e.tagName() == "title" )
					{
						m_title = e.text().remove( '\t' );
					}
					else if( e.tagName() == "author" )
					{
						m_author = e.text().remove( '\t' );
					}
					else if( e.tagName() == "email" )
					{
						m_email = e.text().remove( '\t' );
					}
					else if( e.tagName() == "website" )
					{
						m_website = e.text().remove( '\t' );
					}
					else if( e.tagName() == "comment" )
					{
						m_comment = e.text().remove( '\t' );
					}
				}
			}
		}
	}
}
