/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKTWIDGET_H_
#define _KKTWIDGET_H_

#include "../kkwidgetbase.h"

class QWidget;
class QListViewItem;

namespace KKDesigner
{
	class KKDDoc;
	class KKDView;
}

namespace KKTemplate
{
	class KKTCategoryView;
	class KKTThumbnailView;

	class KKTWidget : public KKWidgetBase
	{
		Q_OBJECT
	public:
		KKTWidget( KCommandHistory* cmdHistory, QWidget* parent = 0, const char* name = 0 );
		virtual ~KKTWidget();
		const char* xmlFile(){ return "kktemplateui.rc"; }
		bool closable();
		void readConfig( KConfig* conf );
		void saveConfig( KConfig* conf );

	public slots:
		void tabChanged( bool enabled );
		void open();

	signals:
		void open( const QString& );

	private slots:
		void open( QListViewItem* item );
		void download();
		void preview();
		void preview( QListViewItem* );

	private:
		QSplitter* m_spl;
		KKTCategoryView* m_tvwCategory;
		KKTThumbnailView* m_lvwThumbnail;
		KKDesigner::KKDDoc* m_doc;
		KKDesigner::KKDView* m_pvw;
	};
}

#endif /* _KKDWIDGET_H_ */
