/*
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <glib/gi18n.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "sgtk-stock.h"
#include "st-stock.h"
#include "st-util.h"

/*** constant definitions ****************************************************/

/* keep in sync with the menu names in st_shell_make_menubar() */
static const GtkStockItem items[] = {
  { ST_STOCK_ADD_BOOKMARK, N_("_Add Bookmark"), 0, 0, NULL },
  { ST_STOCK_BROWSE, N_("_Browse"), 0, 0, NULL },
  { ST_STOCK_COPY_LINK_ADDRESS, N_("_Copy Link Address"), 0, 0, NULL },
  { ST_STOCK_DIRECTORY_PREFERENCES, N_("_Directory Preferences"), 0, 0, NULL },
  { ST_STOCK_HIDE_THIS_COLUMN, N_("_Hide This Column"), 0, 0, NULL },
  { ST_STOCK_LEAVE_FULLSCREEN, N_("Leave Fullscreen"), 0, 0, NULL },
  { ST_STOCK_OPEN_LINK, N_("_Open Link"), 0, 0, NULL },
  { ST_STOCK_QUIT_WITHOUT_SAVING, N_("_Quit Without Saving"), 0, 0, NULL },
  { ST_STOCK_RECORD, N_("_Record"), 0, 0, NULL },
  { ST_STOCK_RELOAD, N_("_Reload"), 0, 0, NULL },
  { ST_STOCK_SHOW_ALL_COLUMNS, N_("_Show All Columns"), 0, 0, NULL },
  { ST_STOCK_STREAM_COLUMNS, N_("Stream _Columns"), 0, 0, NULL },
  { ST_STOCK_TUNE_IN, N_("_Tune in"), 0, 0, NULL },
  { ST_STOCK_VISIT_DIRECTORY_HOMEPAGE, N_("_Visit Directory Homepage"), 0, 0, NULL }
};

/*** implementation **********************************************************/

void
st_stock_init (void)
{
  const sGtkStockIcon icons[] = {
    SGTK_STOCK_ICON_FROM_THEME(ST_STOCK_ADD_BOOKMARK, "stock_add-bookmark"),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_APPLICATIONS, ST_PNG("applications")),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_BROWSE, ST_PNG("browse")),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_CATEGORY_OPEN_RUNNING, ST_PNG("category-open-running")),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_CATEGORY_OPEN, ST_PNG("category-open")),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_CATEGORY_RUNNING, ST_PNG("category-running")),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_CATEGORY, ST_PNG("category")),
    SGTK_STOCK_ICON_FROM_STOCK(ST_STOCK_COPY_LINK_ADDRESS, GTK_STOCK_COPY),
    SGTK_STOCK_ICON_FROM_STOCK(ST_STOCK_DIRECTORY_PREFERENCES, GTK_STOCK_PREFERENCES),
    SGTK_STOCK_ICON_FROM_STOCK(ST_STOCK_GENERAL, GTK_STOCK_PREFERENCES),
    SGTK_STOCK_ICON_FROM_THEME(ST_STOCK_HIDE_THIS_COLUMN, "stock_delete-column"),
    SGTK_STOCK_ICON_FROM_STOCK(ST_STOCK_LEAVE_FULLSCREEN, GTK_STOCK_QUIT),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_MAIN_CATEGORY_RUNNING, ST_PNG("main-category-running")),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_MAIN_CATEGORY, ST_PNG("main-category")),
    SGTK_STOCK_ICON_FROM_STOCK(ST_STOCK_NEW_PRESELECTION, GTK_STOCK_NEW),
    SGTK_STOCK_ICON_FROM_STOCK(ST_STOCK_OPEN_LINK, GTK_STOCK_OPEN),
    SGTK_STOCK_ICON_FROM_THEME(ST_STOCK_PLUGIN, "stock_insert-plugin"),
    SGTK_STOCK_ICON_FROM_STOCK(ST_STOCK_QUIT_WITHOUT_SAVING, GTK_STOCK_QUIT),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_RECORD, ST_PNG("record")),
    SGTK_STOCK_ICON_FROM_STOCK(ST_STOCK_RELOAD, GTK_STOCK_REFRESH),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_SEARCH_CATEGORY_RUNNING, ST_PNG("search-category-running")),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_SEARCH_CATEGORY, ST_PNG("search-category")),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_SEARCH, ST_PNG("search")),
    SGTK_STOCK_ICON_FROM_THEME(ST_STOCK_SELECT_ALL, "stock_select-all"),
    SGTK_STOCK_ICON_FROM_THEME(ST_STOCK_SHOW_ALL_COLUMNS, "stock_show-all"),
    SGTK_STOCK_ICON_FROM_THEME(ST_STOCK_STREAM_COLUMNS, "stock_insert-columns"),
    SGTK_STOCK_ICON_FROM_FILE(ST_STOCK_TUNE_IN, ST_PNG("tune-in")),
    SGTK_STOCK_ICON_FROM_STOCK(ST_STOCK_VISIT_DIRECTORY_HOMEPAGE, GTK_STOCK_HOME),

    SGTK_STOCK_ICON_END
  };
      
  sgtk_stock_register_icons(icons);
  gtk_stock_add_static(items, G_N_ELEMENTS(items));
}
