
/*
 *  devicelisting.h
 *
 *  Copyright (C) 2009 David Hubner <hubnerd@ntlworld.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#ifndef __deviceListing__
#define __deviceListing__

//Solid
#include <solid/device.h>
#include <solid/deviceinterface.h>
#include <solid/processor.h>
#include <solid/deviceinterface.h>
#include <solid/networkinterface.h>
#include <solid/devicenotifier.h>

//QT 
#include <QList>
#include <QMap>
#include <QTreeWidget>
#include <QMenu>
#include <QAction>
#include <QContextMenuEvent>
 #include <QTreeWidgetItemIterator>

//Local
#include "infopanel.h"
#include "soldevice.h"
#include "soldevicetypes.h"
#include "devinfo.h"
#include "solidhelper.h"

//Kde
#include <klocale.h>

class InfoPanel;


class DeviceListing : public QTreeWidget
{  
  Q_OBJECT

  private:
    enum show { ALL=0, RELEVENT };

  public:
    DeviceListing(QWidget *, InfoPanel *);
    ~DeviceListing();   

    static QTreeWidgetItem *getTreeWidgetItem(QTreeWidget *widget, QString udi)
    {
        QTreeWidgetItemIterator treeWidget(widget);
	while (*treeWidget) {
	  SolDevice *item = static_cast<SolDevice *>(*treeWidget);
	    if(item->getUdi() == udi) return *treeWidget;
	++treeWidget;
	}
	return NULL;
    }
    
  private:
    void populateListing(show=RELEVENT);
    QTreeWidgetItem *createListItems(Solid::DeviceInterface::Type);
    void contextMenuEvent(QContextMenuEvent *);
    void createMenuActions();
  
    QMap<Solid::DeviceInterface::Type, SolDevice *> deviceMap;
    InfoPanel *iPanel;
    QAction *colAct, *expAct, *allAct, *relAct;
    
  public slots:
    void deviceItemClicked(QTreeWidgetItem *,int);
    void deviceAddedSlot(QString);
    void deviceRemovedSlot(QString);
    void collapseAllDevices();
    void expandAllDevices();
    void showAllDevices();
    void showReleventDevices();
};

#endif //__deviceListing__