
/*
 *  soldevicetypes.h
 *
 *  Copyright (C) 2009 David Hubner <hubnerd@ntlworld.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#ifndef __SOLDEVICETYPES__
#define __SOLDEVICETYPES__

#include "soldevice.h"
#include "infopanel.h"

class SolProcessorDevice : public SolDevice
{
  
  public:
    SolProcessorDevice(Solid::DeviceInterface::Type);
    SolProcessorDevice(QTreeWidgetItem *, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultDeviceText();
    void setDefaultListing(Solid::DeviceInterface::Type); 
};


class SolStorageDevice : public SolDevice
{
  
  public:   
    enum storageChildren { CREATECHILDREN , NOCHILDREN };
    
    SolStorageDevice(Solid::DeviceInterface::Type);
    SolStorageDevice(QTreeWidgetItem *, Solid::Device, storageChildren = CREATECHILDREN);
    
    QVListLayout *getInfoPanelLayout();
      
  private:
    void setDefaultDeviceText();
    void setDefaultListing(Solid::DeviceInterface::Type); 
};

class SolNetworkDevice : public SolDevice 
{

  public:
    SolNetworkDevice(Solid::DeviceInterface::Type);
    SolNetworkDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultDeviceText();
    void setDefaultDeviceIcon();
    void setDefaultListing(Solid::DeviceInterface::Type); 
};

class SolVolumeDevice : public SolDevice 
{

  public:
    SolVolumeDevice(Solid::DeviceInterface::Type);
    SolVolumeDevice(QTreeWidgetItem *parent, Solid::Device);
    
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultListing(Solid::DeviceInterface::Type);
};

class SolAudioDevice : public SolDevice 
{

  public:
    SolAudioDevice(Solid::DeviceInterface::Type);
    SolAudioDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    void addItem(Solid::Device);
    
  private:
    enum SubMenus { ALSA=0, OSS };
    
    void setDefaultListing(Solid::DeviceInterface::Type);
    void listOss();
    void listAlsa();
    void createSubItems(SubMenus);
    
    SolDevice *alsaSubItem;
    SolDevice *ossSubItem;
};

class SolButtonDevice : public SolDevice 
{

  public:
    SolButtonDevice(Solid::DeviceInterface::Type);
    SolButtonDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultDeviceIcon();
    void setDefaultListing(Solid::DeviceInterface::Type);
};

class SolMediaPlayerDevice : public SolDevice 
{

  public:
    SolMediaPlayerDevice(Solid::DeviceInterface::Type);
    SolMediaPlayerDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();

  private:
    void setDefaultListing(Solid::DeviceInterface::Type);
};

class SolCameraDevice : public SolDevice 
{

  public:
    SolCameraDevice(Solid::DeviceInterface::Type);
    SolCameraDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultListing(Solid::DeviceInterface::Type);
};

class SolBatteryDevice : public SolDevice 
{

  public:
    SolBatteryDevice(Solid::DeviceInterface::Type);
    SolBatteryDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultListing(Solid::DeviceInterface::Type);
};

class SolAcAdapterDevice : public SolDevice 
{

  public:
    SolAcAdapterDevice(Solid::DeviceInterface::Type);
    SolAcAdapterDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultListing(Solid::DeviceInterface::Type);
};

class SolDvbDevice : public SolDevice 
{

  public:
    SolDvbDevice(Solid::DeviceInterface::Type);
    SolDvbDevice(QTreeWidgetItem *parent, Solid::Device);
    
  private:
    void setDefaultListing(Solid::DeviceInterface::Type);
};

class SolSerialDevice : public SolDevice 
{

  public:
    SolSerialDevice(Solid::DeviceInterface::Type);
    SolSerialDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();

  private:
    void setDefaultListing(Solid::DeviceInterface::Type);
};

class SolSmartCardDevice : public SolDevice 
{

  public:
    SolSmartCardDevice(Solid::DeviceInterface::Type);
    SolSmartCardDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultListing(Solid::DeviceInterface::Type);
};

class SolVideoDevice : public SolDevice 
{

  public:
    SolVideoDevice(Solid::DeviceInterface::Type);
    SolVideoDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultListing(Solid::DeviceInterface::Type);
};


#endif // __SOLDEVICETYPES__