/*
 * Copyright 2010 Jörg Ehrichs <joerg.ehichs@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "wacomtabletsettings.h"
#include "tabletapplet.h"

//KDE includes
#include <KDE/KConfigDialog>
#include <KDE/KGlobal>
#include <KDE/KStandardDirs>
#include <KDE/KCModuleProxy>
#include <KDE/KCModuleInfo>
#include <KDE/KDebug>

//Qt includes
#include <QtDBus/QDBusInterface>
#include <QtDBus/QDBusReply>
#include <QtGui/QGraphicsSceneContextMenuEvent>

using namespace Wacom;

static const char DEFAULT_ICON_NAME[] = "input-tablet";

K_EXPORT_PLASMA_APPLET(tabletsettings, WacomTabletSettings)

WacomTabletSettings::WacomTabletSettings(QObject *parent, const QVariantList &args)
        : Plasma::PopupApplet(parent, args),
        m_applet(0),
        m_settingsWidget(0),
        m_tabletInterface(0)
{
    KGlobal::locale()->insertCatalog("wacomtablet");

    setBackgroundHints(StandardBackground);
    setAspectRatioMode(Plasma::IgnoreAspectRatio);

    // let's initialize the widget
    setMinimumSize(graphicsWidget()->minimumSize());
}

WacomTabletSettings::~WacomTabletSettings()
{
    delete m_applet;
}

void WacomTabletSettings::init()
{
    setPopupIcon(DEFAULT_ICON_NAME);

    if (!m_applet) {
        m_applet = new TabletApplet(this);
    }

    //DBus init and connection signal/slot stuff
    m_tabletInterface = new QDBusInterface("org.kde.Wacom", "/Tablet", "org.kde.Wacom");

    if (!m_tabletInterface->isValid()) {
        m_applet->showError(i18n("DBus connection to the kded daemon not available!\n\nPlease start the wacom tablet daemon and try again.\nThe daemon is responsible for tablet detection and profile support."));
    } else {
        //DBus signals
        connect(m_tabletInterface, SIGNAL(tabletAdded()), SLOT(onTabletAdded()));
        connect(m_tabletInterface, SIGNAL(tabletRemoved()), SLOT(onTabletRemoved()));
        connect(m_tabletInterface, SIGNAL(profileChanged(const QString)), m_applet, SLOT(setProfile(const QString)));

        QDBusReply<bool> isAvailable = m_tabletInterface->call("tabletAvailable");
        if (!isAvailable) {
            m_applet->showError(i18n("No tablet device was found!\n\nPlease connect the device before you start this module.\nIf the device is already connected refer to the help file for any further information."));
        } else {
            m_applet->connectDBus();
            m_applet->showApplet();
        }
    }

}

QGraphicsWidget *WacomTabletSettings::graphicsWidget()
{
    if (!m_applet) {
        m_applet = new TabletApplet(this);
    }

    return m_applet->dialog();
}

void WacomTabletSettings::createConfigurationInterface(KConfigDialog *parent)
{
    m_settingsWidget = new KCModuleProxy("kcm_wacomtablet");

    parent->addPage(m_settingsWidget, m_settingsWidget->moduleInfo().moduleName(),
                    m_settingsWidget->moduleInfo().icon());

    parent->setButtons(KDialog::Ok | KDialog::Cancel);
    connect(parent, SIGNAL(okClicked()), this, SLOT(configAccepted()));
}

void WacomTabletSettings::configAccepted()
{
    //Save the configurations of the embedded KCMs
    m_settingsWidget->save();
    m_applet->updateProfile();
}

void WacomTabletSettings::onTabletAdded()
{
    setPopupIcon(DEFAULT_ICON_NAME);

    m_applet->showApplet();
}

void WacomTabletSettings::onTabletRemoved()
{
    //@todo change icon when tablet is removed
    KIcon icon("input-tablet");
    setPopupIcon(icon);

    m_applet->showError(i18n("No tablet device was found!\n\nPlease connect the device before you start this module.\nIf the device is already connected refer to the help file for any further information."));
}

