# This is for Fedora 9.
# Use kmenu-gnome-fc8.spec for earlier releases.

%{?!_icondir:%define _icondir   %{_datadir}/icons}

Name:       kmenu-gnome
Version:    0.7.2
Release:    1%{?dist}
Summary:    K Menu with Gnome directory

License:    GPLv2
# GPL/LGPL: Section 3 of LGPL permits changing the license to GPL
Group:      User Interface/Desktops
URL:        http://ariszlo.tripod.com

Source:     http://kde-apps.org/CONTENT/content-files/31025-%{name}-%{version}.tar.gz
Patch:      fedora-administration.patch

BuildArchitectures: noarch
BuildRoot:  %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
K Menu with Gnome folder and extra icons.

%prep
%setup -q
# Remove superfluous System/Administration subdirectory:
%patch -p1 -b .administration
%build

%install
rm -rf %{buildroot}
mkdir -p %{buildroot}%{_sysconfdir}/xdg/menus/applications-merged
cp xdg/%{name}.menu %{buildroot}%{_sysconfdir}/xdg/menus/applications-merged
mkdir -p %{buildroot}%{_datadir}
cp -pr desktop-directories icons %{name} %{buildroot}%{_datadir}

# Remove package_games_kids icons to avoid conflict with kdebase:
rm -f %{buildroot}%{_icondir}/crystalsvg/*/apps/package_games_kids.png

%clean
rm -rf %{buildroot}

# dropped gtk-update-icon-cache from %%post and %preun
# from http://fedoraproject.org/wiki/ScriptletSnippets:
# For KDE, just 'touch'ing the top-level icon directory is enough.
# Also since kmenu-gnome does not affect on gnome menus, its useless to have
# gtk-update-icon-cache.

%post
touch --no-create %{_icondir}/crystalsvg || :
touch --no-create %{_icondir}/hicolor || :

%preun
touch --no-create %{_icondir}/crystalsvg || :
touch --no-create %{_icondir}/hicolor || :

%files
%defattr(-,root,root,-)
%config(noreplace) %{_sysconfdir}/xdg/menus/applications-merged/%{name}.menu
%{_datadir}/%{name}/
%{_datadir}/desktop-directories/*.directory
%{_icondir}/crystalsvg/*/*/*.png
%{_icondir}/hicolor/*/*/*.png
%doc ChangeLog COPYING GPL LGPL README

%Changelog
* Mon Apr 21 2008 Ariszlo <ariszlo@gmail.com> - 0.7.2-1
- release 0.7.2
- Split spec into two: one for Fedora 9 and one one for earlier releases
- Removed fedora-administration.menu from the Fedora 9 package

* Wed Feb 20 2008 Ariszlo <ariszlo@gmail.com> - 0.7.1-1
- release 0.7.1
- updated fedora-administration.patch
- removed package_games_kids icons from crystalsvg

* Fri Feb 01 2008 Chitlesh Goorah <chitlesh@fedoraproject.org>- 0.7-2
- fixed redhat bugzilla #430875

* Sun Jan 20 2008 Ariszlo <ariszlo@gmail.com> - 0.7-1
- release 0.7
- Works with both KDE3 & KDE4

* Wed Nov 21 2007 Chitlesh Goorah <chitlesh@fedoraproject.org>- 0.6.9-2
- new upstream release

* Sat Nov 03 2007 Ariszlo <ariszlo@gmail.com> - 0.6.9-1
- release 0.6.9
- Replaced fc5-hide-bug196275.menu with fedora-administration.menu
- Replaced remove-system-administration.patch with fedora-administration.patch
- Moved GParted, Live Install and all Server Settings into Administration
- Replaced icon-office.png with redhat-office.png
- Removed printer.png -> gnome-dev-printer.png symlinks

* Wed Sep 12 2007 Chitlesh Goorah <chitlesh@fedoraproject.org>- 0.6.8-2
- new upstream release

* Wed Sep 12 2007 Ariszlo <ariszlo@gmail.com> - 0.6.8-1
- release 0.6.8
- Added include categories to fc5-hide-bug196275.menu
- Added remove-system-administration.patch

* Mon Aug 20 2007 Chitlesh Goorah <chitlesh@fedoraproject.org>- 0.6.7-2
- new upstream release

* Sun Aug 19 2007 Ariszlo <ariszlo@gmail.com> - 0.6.7-1
- release 0.6.7

* Wed Jul 11 2007 Chitlesh Goorah <chitlesh@fedoraproject.org>- 0.6.6-2
- new upstream release

* Mon Jul 09 2007 Ariszlo <ariszlo@gmail.com> - 0.6.6-1
- release 0.6.6
- Added printer.png -> gnome-dev-printer.png symlinks

* Sun Jul 08 2007 Chitlesh Goorah <chitlesh@fedoraproject.org>- 0.6.5-3
- fixed %%description #247365

* Tue Jun 12 2007 Chitlesh Goorah <chitlesh@fedoraproject.org>- 0.6.5-2
- new upstream release

* Mon Jun 11 2007 Ariszlo <ariszlo@gmail.com> - 0.6.5-1
- release 0.6.5

* Tue May 22 2007 Chitlesh Goorah <chitlesh@fedoraproject.org>- 0.6.4-1
- new upstream release

* Mon May 21 2007 Ariszlo <ariszlo@gmail.com> - 0.6.4-0.1
- release 0.6.4
- Removed redhat-artwork dependency

* Tue May 01 2007 Chitlesh Goorah <chitlesh@fedoraproject.org>- 0.6.3-1
- New upstream release

* Tue Apr 24 2007 Chitlesh Goorah <chitlesh@fedoraproject.org>- 0.6.2.1-1
- New upstream release

* Mon Apr 23 2007 Ariszlo <ariszlo@gmail.com> - 0.6.2.1-0.1
- Removed package_games_kids icons already added to kdebase
- Preparing release 0.6.3

* Fri Dec 22 2006 Chitlesh Goorah <chitlesh@fedoraproject.org>- 0.6.2-1
- New upstream release for FE

* Wed Nov 01 2006 Chitlesh Goorah <chitlesh@fedoraproject.org>- 0.6.1-2
- New upstream release for FE

* Sat Oct 28 2006 Ariszlo <ariszlo@gmail.com> - 0.6.1-1
- Removed link to accessibility-directory.png
- release 0.6.1

* Sun Oct 15 2006 Chitlesh Goorah <chitlesh@fedoraproject.org> - 0.6.0.1-2
- Removed duplicate gnome-system.png

* Thu Oct 05 2006 Ariszlo <ariszlo@gmail.com> - 0.6.0.1-1
- Removed kde-games-kids.directory link to fix Fedora bug 208788
- Preparing release 0.6.1

* Tue Sep 05 2006 Chitlesh Goorah <chitlesh@fedoraproject.org> - 0.6-4
- Rebuild for FC6-devel

* Sun Aug 13 2006 Chitlesh Goorah <chitlesh@fedoraproject.org> - 0.6-3
- Added redhat-artwork as %%Requires and %%build
- touching Bluecurve and crystalsvg folders
- fixed license GPL/LGPL

* Sun Jul 02 2006 Chitlesh Goorah <chitlesh@fedoraproject.org> - 0.6-2
- fixed Source URL

* Sat Jul 01 2006 Ariszlo <ariszlo@gmail.com> - 0.6-1
- renamed fc5-fix-administration-mergefile.menu fc5-hide-bug196275.menu
- release 0.6

* Thu Jun 29 2006 31025
- Added comment on the exclusion of gtk-update-icon-cache from %%post and %preun

* Thu Jun 29 2006 Chitlesh Goorah <chitlesh@fedoraproject.org> - 0.5.1-2pre3
- dropped gtk-update-icon-cache from %%post and %preun
- corrected the top-level icon directory in %%post and %preun

* Wed Jun 28 2006 Ariszlo <ariszlo@gmail.com> - 0.5.1-1pre3
- added fc5-fix-administration-mergefile.menu
- removed fedora-xdg.patch
- dropped support for FC4
- repacked lost symlinks

* Mon Jun 26 2006 Chitlesh Goorah <chitlesh@fedoraproject.org> - 0.5.1-2pre2
- GTK+ icon cache added in %%post and %%preun
- fixed dangling-relative-symlink
- make use of the macro %%icondir

* Mon Jun 26 2006 Ariszlo <ariszlo@gmail.com> - 0.5.1-1pre2
- removed hicolor directories only needed in Debian and Slackware
- removed GTK+ icon cache

* Mon Jun 26 2006 Chitlesh Goorah <chitlesh@fedoraproject.org> - 0.5.1-1pre1
- fix rpmlint issues - conffile-without-noreplace-flag
- dropped %%build

* Fri Jun 23 2006 Ariszlo <ariszlo@gmail.com> - 0.5.1-0pre2
- moved icon links under %%install

* Thu Jun 22 2006 Ariszlo <ariszlo@gmail.com> - 0.5.1-0pre1
- preparing release 0.5.1
- merged FC4 and FC5 specs
- removed /* from %%files
- added %%config /etc/xdg/menus/applications-merged/kmenu-gnome.menu
- added %%dir %{_datadir}/%{name}
- added %%dir %{_datadir}/%{name}
- added %%{_datadir}/%{name}/*
- added %%{_datadir}/desktop-directories/*.directory
- added %%{_datadir}/icons/*/*/*/*.png

* Wed Jun 21 2006 Chitlesh Goorah <chitlesh@fedoraproject.org> - 0.5-2
- added %%config(noreplace)
- GTK+ icon cache added in %%post and %%preun

* Tue Jun 20 2006 Chitlesh Goorah <chitlesh@fedoraproject.org> - 0.5-1
- Initial package
