#!/bin/sh

testdir="$1"
#sroot=/home/$USER/11srv
sroot=/export/rmeggins/11srv
port=1100
secport=1101
rootdn="cn=directory manager"
rootpw=password
#adminpw=boguspassword
adminpw=admin
#needinstance=1
#needdata=1
#usessl=1
PATH=/usr/lib64/mozldap:/usr/lib/mozldap:$PATH
export PATH

if [ "$needinstance" ] ; then
$sroot/bin/ds_newinst.pl - <<EOF
[General]
FullMachineName=   localhost.localdomain
SuiteSpotUserID=   $USER
ServerRoot=    $sroot/lib/fedora-ds
[slapd]
ServerPort=   $port
ServerIdentifier=   localhost
Suffix=   o=NetscapeRoot
RootDN=   $rootdn
RootDNPwd=  $rootpw
EOF
fi

if [ "$needdata" ] ; then
$sroot/lib/fedora-ds/slapd-localhost/ldif2db.pl -D "$rootdn" -w "$rootpw" -n userRoot -i $testdir/nsroot.ldif
sleep 10
fi

rm -rf testtmp
mkdir testtmp

if [ "$usessl" ] ; then
    ldapurl="ldaps://localhost:$secport/o=NetscapeRoot"
    # grab CA cert
    certutil -L -d $sroot/etc/fedora-ds/slapd-localhost -n "CA certificate" -a > testtmp/cacert.asc
    # pin file
    echo "passwordpassword" > testtmp/pwdfile.txt
    # create sec db
    certutil -N -d testtmp -f testtmp/pwdfile.txt
    # import CA cert
    certutil -A -d testtmp -n "CA certificate" -t "CT,," -a -i testtmp/cacert.asc
else
    ldapurl="ldap://localhost:$port/o=NetscapeRoot"
fi

cat > testtmp/adm.conf <<EOF
ldapurl:    $ldapurl
ldapHost:   localhost.localdomain
ldapPort:   $port
sie:   cn=admin-serv-localhost, cn=Fedora Administration Server, cn=Server Group, cn=localhost.localdomain, ou=localdomain, o=NetscapeRoot
isie:   cn=Fedora Administration Server, cn=Server Group, cn=localhost.localdomain, ou=localdomain, o=NetscapeRoot
port:   32348
ldapStart:   slapd-localhost/start-slapd
EOF

cat > testtmp/admpw <<EOF
admin:{SHA}0DPiKuNIrrVmD8IUCuw1hQxNqZc=
EOF

cat > testtmp/console.conf <<EOF
Listen localhost:54321
CustomLog testtmp/access common
ErrorLog testtmp/error
PidFile  testtmp/pid
User $USER
EOF

dir=`pwd`

# CGI env. vars
#ADMSERV_CONF_DIR=$dir/testtmp
#ADMSERV_CONF_DIR=$sroot/etc/fedora-ds/admin-serv
#export ADMSERV_CONF_DIR
#ADMSERV_LOG_DIR=$dir/testtmp
#export ADMSERV_LOG_DIR
HTTP_ACCEPT_LANGUAGE=en
export HTTP_ACCEPT_LANGUAGE
SERVER_URL=http://localhost
export SERVER_URL

pwpfile=/tmp/pwp.$$
cat > $pwpfile <<EOF
User: admin
Password: $adminpw

UserDN: uid=admin, ou=Administrators, ou=TopologyManagement, o=NetscapeRoot
SIEPWD: $adminpw
EOF

VALGRIND="valgrind --log-file=/var/tmp/vg.out --tool=memcheck --leak-check=yes --suppressions=$HOME/valgrind.supp --num-callers=40 "
GDB="gdb -x .gdbinit "
#DEBUGCMD="$VALGRIND"
#DEBUGCMD="$GDB"

PROGS="mergeConfig admpw security ugdsconfig ReadLog start_config_ds \
	config statpingserv viewdata dsconfig monreplication restartsrv \
	statusping viewlog htmladmin sec-activate stopsrv download help"

SCRIPTS=ds_create

# each prog has a subdir containing the GET/POST args and any other test data
for prog in $PROGS ; do
    getlist=/tmp/gettests.$$
    find $testdir/$prog -name testget.\* -print 2> /dev/null | sort -n > $getlist
    for test in `cat $getlist` ; do
	if [ ! -d results/$prog ] ; then mkdir -p results/$prog ; fi
	basetest=`basename $test`
	echo "Running test $test"
	REQUEST_METHOD=GET ; export REQUEST_METHOD
	QUERY_STRING="`cat $test`" ; export QUERY_STRING
	SCRIPT_NAME=admin-serv/Tasks/Operation/$prog ; export SCRIPT_NAME
	# open pwpfile for reading as file desc 4 - CGIs have to use stdin (0) for POST
	exec 4<$pwpfile
	PASSWORD_PIPE=4 ; export PASSWORD_PIPE
	if [ -n "$DEBUGCMD" -a "$DEBUGCMD" = "$GDB" ] ; then
	    echo "break main" > .gdbinit
	    echo "run > results/$prog/$basetest.html" >> .gdbinit
	    ./libtool --mode execute $GDB ./$prog
	else
	    ./libtool --mode execute $DEBUGCMD ./$prog > results/$prog/$basetest.html
	fi
    done
    rm -f $getlist
    postlist=/tmp/posttests.$$
    find $testdir/$prog -name testpost.\* -print 2> /dev/null | sort -n > $postlist
    for test in `cat $postlist` ; do
	if [ ! -d results/$prog ] ; then mkdir -p results/$prog ; fi
	basetest=`basename $test`
	echo "Running test $test"
	REQUEST_METHOD=POST ; export REQUEST_METHOD
	CONTENT_LENGTH=`wc -c $test | cut -f1 -d' '` ; export CONTENT_LENGTH
	SCRIPT_NAME=admin-serv/Tasks/Operation/$prog ; export SCRIPT_NAME
	# open pwpfile for reading as file desc 4 - CGIs have to use stdin (0) for POST
	exec 4<$pwpfile
	PASSWORD_PIPE=4 ; export PASSWORD_PIPE
	if [ -n "$DEBUGCMD" -a "$DEBUGCMD" = "$GDB" ] ; then
	    echo "break main" > .gdbinit
	    echo "run < $test > results/$prog/$basetest.html" >> .gdbinit
	    ./libtool --mode execute $GDB ./$prog
	else
	    ./libtool --mode execute $DEBUGCMD ./$prog < $test > results/$prog/$basetest.html
	fi
    done
    rm -f $postlist
done

for prog in $SCRIPTS ; do
    getlist=/tmp/gettests.$$
    find $testdir/$prog -name testget.\* -print 2> /dev/null | sort -n > $getlist
    for test in `cat $getlist` ; do
        if [ ! -d results/$prog ] ; then mkdir -p results/$prog ; fi
        basetest=`basename $test`
        echo "Running test $test"
        REQUEST_METHOD=GET ; export REQUEST_METHOD
        QUERY_STRING="`cat $test`" ; export QUERY_STRING
        SCRIPT_NAME=slapd/Tasks/Operation/$prog ; export SCRIPT_NAME
        # open pwpfile for reading as file desc 4 - CGIs have to use stdin (0) for POST
        exec 4<$pwpfile
        PASSWORD_PIPE=4 ; export PASSWORD_PIPE
        if [ -n "$DEBUGCMD" -a "$DEBUGCMD" = "$GDB" ] ; then
            perl -d admserv/cgi-src40/$prog
        else
            perl -w admserv/cgi-src40/$prog
        fi
    done
    rm -f $getlist
done

rm -rf $pwpfile .gdbinit
