/** BEGIN COPYRIGHT BLOCK
 * Copyright (C) 2001 Sun Microsystems, Inc.  Used by permission.
 * Copyright (C) 2005 Red Hat, Inc.
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation version
 * 2.1 of the License.
 *                                                                                  
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *                                                                                  
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * END COPYRIGHT BLOCK **/
/*
 * prodinfo.h
 *
 * $Id: prodinfo.h,v 1.2 2005/12/06 18:38:31 nhosoi Exp $
 */

#ifndef prodinfo_h
#define prodinfo_h

/***********************************************************************
** Includes
***********************************************************************/

#include	<netsite.h>

typedef struct {
  char		*var;	/* name of array */
  int		numEls;	/* how many names in array */
  char		**els;	/* names in array */
} ADM_piList;

typedef struct {
  char		*when;
  int		numVars;	/* numVars is the number of vars and vals */
  char		**vars;
  char		**vals;
  int		numBools;	/* how many boolean variables? */
  char		**boolVars;
  char		*boolVals;
  int		numLists;
  ADM_piList	*lists;
} ADM_piTree;

/***********************************************************************
** GLOBAL FUNCTIONS:
** DESCRIPTION:
** These functions allow one to use data from files which have name value
** pairs, boolean variables, and list variables.  See
** http://poseidon/~flc/prodinfo.html for a description of the file format.
**
** EXAMPLE:
** @+@ Something that really gives the idea of how to use this set of functions
**
** RESTRICTIONS:
** 
**
** RETURN CODE TABLE:
** -1:	list or variable not found
**  0:  boolean variable false or list entry not found
**  1:  boolean variable true or list entry found
***********************************************************************/

NSPR_BEGIN_EXTERN_C

PR_IMPLEMENT(ADM_piTree *)
ADM_pi_init( char *file );

PR_IMPLEMENT(void)
ADM_pi_done( ADM_piTree * );

PR_IMPLEMENT(char *)
ADM_pi_value( ADM_piTree *, char *var );

PR_IMPLEMENT(char *)
ADM_pi_when( ADM_piTree * );

PR_IMPLEMENT(int)
ADM_pi_canDo( ADM_piTree *, char *, char * );

PR_IMPLEMENT(int)
ADM_pi_list( ADM_piTree *, char *name, char ***list );

PR_IMPLEMENT(void)
ADM_pi_setValue (ADM_piTree *tree, char *name, char *value);

PR_IMPLEMENT(void)
ADM_pi_setBoolean (ADM_piTree *tree, char *capability, char *value);

PR_IMPLEMENT(void)
ADM_pi_setCapability (ADM_piTree *tree, char *capability, char *instance);

PR_IMPLEMENT(int)
ADM_pi_write (ADM_piTree *tree, char *fileName);

NSPR_END_EXTERN_C

#endif /* prodinfo_h */
