/***************************************************************************
                          babylon_bgl.cpp  -  description
	This library is based on the work of Raul Fernandes and Karl Grill
	on dictconv

                             -------------------
    begin                : February 2009
    copyright            : (c) 2007 by Roland Suchan
    email                : vmp@arcor.de
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#include <QMessageBox>
#include <KLocale>
#include <QDebug>	//ooo
#include <QUrl>		//ooo
#include <QDir>		//ooo

#include <iostream>	//ooo
#include <stdlib.h>	//ooo
#include <zlib.h>	//ooo
#include <stdio.h>	//ooo

#include "babylon_bgl.h"

//#define DEBUG_1
//#define DEBUG_2
//#define DEBUG_3
//#define DEBUG_3a
//#define DEBUG_3a_
//#define DEBUG_3b
//#define DEBUG_3h
//#define DEBUG_3p
//#define DEBUG_4
//#define DEBUG_5


Babylon_bgl::Babylon_bgl(QString filename, QString strIndexDir)
{
	m_filename = filename.toAscii().data();

	//ba = filename.toStdString().c_str();

	//ba = QByteArray(filename.toAscii().data());
	//ba = filename.toAscii();
	//ba = "/home/gons/.qtrans/index";
	//ba = filename.toUtf8();
	ba = filename.toAscii();
	 //h_filename = filename.toUtf8().toHex().data();
	//h_filename = ba.toHex().data();
	m_qstrIndexDir = strIndexDir;
	m_strIndexDir = strIndexDir.toAscii().data();
}

Babylon_bgl::~Babylon_bgl()
{
}

QString Babylon_bgl::printMessage()
{
	//QMessageBox::about(this, tr("About Diagram Scene"), tr("printMessage(: 1"));
	//QMessageBox::about(i18n("About Menu"), QString("%1").arg("printMessage(: 1"));

	return "Babylon BGL <---> !!!";
}


bool Babylon_bgl::open()
{
	FILE *f;
	unsigned char buf[6];
	int i;

	f = fopen( m_filename.c_str(), "r" );
	if( f == NULL )
		return false;

	i = fread( buf, 1, 6, f );

	/* First four bytes: BGL signature 0x12340001 or 0x12340002 (big-endian) */
	if( i < 6 || memcmp( buf, "\x12\x34\x00", 3 ) || buf[3] == 0 || buf[3] > 2 )
		return false;

	/* Calculate position of gz header */

	i = buf[4] << 8 | buf[5];

	if( i < 6 )
		return false;

	if( fseek( f, i, SEEK_SET ) ) /* can't seek - emulate */
	for(int j=0;j < i - 6;j++) fgetc( f );

	if( ferror( f ) || feof( f ) )
		return false;

	/* we need to flush the file because otherwise some nfs mounts don't seem
	* to properly update the file position for the following reopen */

	fflush( f );

	file = gzdopen( dup( fileno( f ) ), "r" );
	if( file == NULL )
		return false;

	fclose( f );

#ifdef DEBUG_1
	qDebug() << "Babylon_bgl::open()";
#endif

	return true;

/*	QFile file(m_filename);
	if (!file.open(QIODevice::ReadOnly)) {
		return false;
	}

	return true;
*/
}


bool Babylon_bgl::readBlock( bgl_block &block )
{

	#ifdef DEBUG_1
		if ( &block != NULL) {
			qDebug() << ">>> ...........................";
			qDebug() << "Babylon_bgl::readBlock( bgl_block &block )" << " block.length = " << block.length; 
		} else {
			qDebug() << "&block = NULL";
		}
	#endif

	if( gzeof( file ) || file == NULL ) {
		#ifdef DEBUG_1
			qDebug() << "if( gzeof( file ) || file == NULL ) {";
		#endif
		return false;
	}

	block.length = bgl_readnum( 1 );
	block.type = block.length & 0xf;

	#ifdef DEBUG_1
		qDebug() << "block.type = " << "(block.length & 0xf)";
	#endif

	if( block.type == 4 ) {
		#ifdef DEBUG_1
			qDebug() << "block.type == 4";
		#endif
		return false; // end of file marker
	}
	block.length >>= 4;
	block.length = block.length < 4 ? bgl_readnum( block.length + 1 ) : block.length - 4 ;

	if( block.length ) {

		#ifdef DEBUG_1
			qDebug() << "------ if( " << block.length << ") {";
		#endif

		//block.data = (char *)malloc( block.length );
		block.data = (unsigned char *)malloc( block.length );	//ooo
		gzread( file, block.data, block.length );
	}

	#ifdef DEBUG_1
		qDebug() << "........................... <<<";
	#endif

	return true;
}


unsigned int Babylon_bgl::bgl_readnum( int bytes )
{
	unsigned char buf[4];
	unsigned val = 0;

	if ( bytes < 1 || bytes > 4 ) return (0);

	gzread( file, buf, bytes );
	for(int i=0;i<bytes;i++) val= (val << 8) | buf[i];
	return val;
}


bool Babylon_bgl::read()
{
	if( file == NULL ) return false;

	bgl_block block;
	uint pos;
	uint type;
	std::string headword;
	std::string definition;

	m_numEntries = 0;
	while( readBlock( block ) ) {

		#ifdef DEBUG_1
			qDebug() << "            >>> while( readBlock( block ) ) { <<<" << " block.type = " << "(block.length & 0xf)";
		#endif

		headword.clear();
		definition.clear();
		switch( block.type ) {
			case 0:
				switch( block.data[0] ) {
					case 8:
						type = (uint)block.data[2];

						#ifdef DEBUG_2
							qDebug() << " type = " << type;
						#endif

						if( type > 64 ) type -= 65;
						m_defaultCharset = bgl_charset[type];
						break;
					default:
						break;
				}
				break;
			case 1:
			case 10:
				// Only count entries
				m_numEntries++;
				break;
			case 3:
				pos = 2;
				switch( block.data[1] ) {
					case 1:
						headword.reserve( block.length - 2 );
						for(uint a=0;a<block.length-2;a++) headword += block.data[pos++];
						m_title = headword;
						break;
					case 2:
						headword.reserve( block.length - 2 );
						for(uint a=0;a<block.length-2;a++) headword += block.data[pos++];
						m_author = headword;
						break;
					case 3:
						headword.reserve( block.length - 2 );
						for(uint a=0;a<block.length-2;a++) headword += block.data[pos++];
						m_email = headword;
						break;
					case 4:
						headword.reserve( block.length - 2 );
						for(uint a=0;a<block.length-2;a++) headword += block.data[pos++];
						m_copyright = headword;
						break;
					case 7:
						headword = bgl_language[block.data[5]];
						m_sourceLang = headword;
						break;
					case 8:
						headword = bgl_language[block.data[5]];
						m_targetLang = headword;
						break;
					case 9:
						headword.reserve( block.length - 2 );
						for(uint a=0;a<block.length-2;a++) headword += block.data[pos++];
						m_description = headword;
						break;
					case 26:
						type = (uint)block.data[2];
						if( type > 64 ) type -= 65;
						m_sourceCharset = bgl_charset[type];
						break;
					case 27:
						type = (uint)block.data[2];
						if( type > 64 ) type -= 65;
						m_targetCharset = bgl_charset[type];
						break;
					default:
						break;
				}
				break;
			default:
				;
		}

		if( block.length ) free( block.data );

	}
	gzseek( file, 0, SEEK_SET );

	//convertToUtf8( m_title, DEFAULT_CHARSET );
	//convertToUtf8( m_author, DEFAULT_CHARSET );
	//convertToUtf8( m_email, DEFAULT_CHARSET );
	//convertToUtf8( m_copyright, DEFAULT_CHARSET );
	//convertToUtf8( m_description, DEFAULT_CHARSET );

	#ifdef DEBUG_1
		qDebug() << "Babylon_bgl::read()";
	#endif

	return true;
}


bgl_entry Babylon_bgl::readEntry()
{
	bgl_entry entry;

	if( file == NULL )
	{
		entry.headword = L"";
		return entry;
	}

	bgl_block block;
	//uint len, pos;
	unsigned int len, pos;			//ooo
	std::wstring headword;
	std::wstring definition;
	std::wstring definition_stack = L"";	//ooo
	std::wstring definition_origin = L"";	//ooo
	std::wstring temp;
	std::vector<std::wstring> alternates;
	std::wstring alternate;
	//int j = -1;	//ooo

	const std::wstring headword1 = L"Where was Acheulian";
	const std::wstring toFind = L"être"; //L"Acheulian";
	const std::wstring toFind_x2 = L"1,500,000";
	std::wstring transcription = L"";
	//std::wstring filename = L"";
	std::string filename = "";
	std::string filename_2 = "";	//ooo
	std::wstring::size_type n = 0;
	QCryptographicHash hash( QCryptographicHash::Md5 );
	std::string hash_str = "";
	unsigned char const * data;
	size_t size;
	std::vector < unsigned char > compressedData( compressBound( size ) );
	unsigned long compressedSize;
	//char const *indexFile = "myFile";
	//File::Class idx( indexFile, "w" );
	//FILE *fopen( indexFile, "w" );
	FILE *fp;
	QUrl url;
	std::string url_str;
	QDir dir;			//ooo
	QDir hashDir;			//ooo
	bool dirWasCreated = false;	//ooo
	
	hash.reset();					//ooo
	hash.addData( ba );				//ooo
	hash_str = hash.result().toHex().data();	//ooo
	
	//QString str_ = "/home/gons/.qtrans/index/" + hash.result().toHex();	//ooo
	QString strHashDir = m_qstrIndexDir + "/" + hash.result().toHex();	//ooo
	
	//dir = QDir("/home/gons/.qtrans/index/");	//ooo
	dir = QDir(m_qstrIndexDir);	//ooo
	//dir_2 = QDir(str_);				//ooo
	hashDir = QDir(strHashDir);			//ooo
				
	if (!hashDir.exists()) {			//ooo
		dir.mkpath( hash.result().toHex() );
		dirWasCreated = true;
	}


	while( readBlock( block ) )
	{

		#ifdef DEBUG_2
			//qDebug() << "   >>> Babylon_bgl::readEntry() --- " << "block.type = " << block.type;
		#endif

		switch( block.type )
		{
			//case 1:
			case 2:

				pos = 0;

				#ifdef DEBUG_3b
					std::wcout << "\n222\n";
					std::wcout << "block.data[" << pos << "] = " << block.data[pos] << "\n";
				#endif


				len = (unsigned char)block.data[pos++];

				//std::string filename( block.data+pos, len );

				/*for ( unsigned int i = (pos+3); i < (pos+3+length); i++) {
					 transcription += block.data[i];
				}*/
				

				for ( unsigned int i = pos; i < pos + len; i++) {

					#ifdef DEBUG_3b
						std::wcout << "block.data[" << i << "] = " << block.data[i] << "\n";
					#endif

					 filename += block.data[i];
				}

				#ifdef DEBUG_3b
					//std::wcout << "filename = " << filename << "\n";
					std::cout << "filename = " << filename << "\n";
				#endif

				pos += len;

				/*unsigned char const * data = &block.data[pos];
				size_t size = block.length - pos;

				std::vector< unsigned char > compressedData( compressBound( size ) );

				unsigned long compressedSize = compressedData.size();*/

				data = &block.data[pos];
				size = block.length - pos;

				//compressedData.size() = compressBound(size);

				compressedSize = compressedData.size();

				#ifdef DEBUG_3p
					//FILE *fp = fopen(filename.c_str(), "w");
					fp = fopen(filename.c_str(), "w");
					//fwrite(block.data + pos, 1, block.length -pos, fp);
					//fwrite(&compressedData.front(), 1, size, fp);
					fwrite(&block.data[pos], 1, size, fp);
					fclose(fp);
				#endif
				

				if (dirWasCreated) {	//ooo
					//filename_2 = "/home/gons/.qtrans/index/" + hash_str + "/" + filename;
					 filename_2 = std::string(m_qstrIndexDir.toAscii().data()) + "/" + hash_str + "/" + filename;
					//filename_2 = m_strIndexDir + "/" + hash_str + "/" + filename;
					
					/*filename_2 = m_strIndexDir;
					filename_2 += "/";
					filename_2 += hash_str;
					filename_2 += "/";
					filename_2 += filename;
					*/
					fp = fopen(filename_2.c_str(), "w");
					fwrite(&block.data[pos], 1, size, fp);
					fclose(fp);
				}
				
				//filename = L"";
				filename = "";

				/*if (filename == "D437C11D.bmp") {

					#ifdef DEBUG_3b
						std::cout << "***   D437C11D.bmp" << "\n";
					#endif

				}*/

				break;
			case 1:
			case 10:

				#ifdef DEBUG_2
					qDebug() << "   case 10 ";
				#endif

				alternate.clear();
				headword.clear();
				definition.clear();
				temp.clear();
				pos = 0;

				definition_origin = L"";		//ooo ""

				// Headword
				len = 0;
				len = (unsigned char)block.data[pos++];

				headword.reserve( len );
				for(uint a=0;a<len;a++) headword += block.data[pos++];
				//convertToUtf8( headword, SOURCE_CHARSET );


				//j = headword.find("black");

				#ifdef DEBUG_3a
					std::cout << "\n......................\n";
					std::wcout << "block.data[" << pos << "] = " << block.data[pos] << "\n";
					std::wcout << "block.data[" << pos+1 << "] = " << block.data[pos+1] << "\n";
					std::wcout << "block.data[" << pos+2 << "] = " << block.data[pos+2] << "\n";
					//printf("Headword : %s\n", headword.c_str());
					//printf("Definition to ...: %s\n", entry.definition.c_str());
					//printf("Definition to ...: %s\n", "	*****");
				#endif

				// Definition
				len = 0;
				len = (unsigned char)block.data[pos++] << 8;
				//pos++;						//ooo
				//len = (unsigned char)block.data[pos++];		//ooo

				#ifdef DEBUG_3a
					std::wcout << "len = " << len << "\n";
				#endif

				//len <<= 8;					//ooo

				#ifdef DEBUG_3a
					std::wcout << "len = " << len << "\n";
				#endif

				len |= (unsigned char)block.data[pos++];
				definition.reserve( len );

				#ifdef DEBUG_3a
					//std::cout << "\n......................\n";
					std::wcout << "headword = " << headword << "\n";
					std::wcout << "len = " << len << "\n";
				#endif

				for(uint a=0;a<len;a++)
				{
					#ifdef DEBUG_3a_
						std::wcout << "block.data[" << pos << "] = " << block.data[pos] << " a = " << a << "\n";
					#endif

					#ifdef DEBUG_3a
						//qDebug() << "   for(uint a=0;a<len;a++) --- a = " << a;
						//qDebug() << "block.data[" << pos << "] = " << block.data[pos];

						/*if ( headword.compare(L"Afro-Asian $1$") == 0 ) {
							std::wcout << "block.data[" << pos << "] = " << block.data[pos] << "\n";
						}*/

						//std::wcout << "block.data[" << pos << "] = " << block.data[pos] << " a = " << a << "\n";

						definition_origin += block.data[pos];

					#endif

					if ( (unsigned char)block.data[pos] == 0x0a ) {		//LF: LineFeed

						#ifdef DEBUG_2
							qDebug() << "block.data[" << pos << "] == 0x0a = " << block.data[pos];
						#endif

						definition += '\n';
						pos++;

					} else if ( (unsigned char)block.data[pos] == 0x06 ) {

						#ifdef DEBUG_3a
							std::wcout << "block.data[" << pos+1 << "] = " << block.data[pos+1] << "\n";
							std::wcout << "block.data[" << pos+2 << "] = " << block.data[pos+2] << "\n";
						#endif

						pos += 2;
						a++;

					} else if ( (unsigned char)block.data[pos] >= 0x40 && (unsigned char)block.data[pos + 1 ] == 0x18 &&
							len - a >= 2 ) {

						// B344
						unsigned length = (unsigned char)block.data[ pos ] - 0x3F;

						pos += length + 2;
						a += length + 1;

					} else if ( (unsigned char)block.data[pos-1] == 0x14 && (unsigned char)block.data[pos] == 0x18) {

						// definition = def + head

						#ifdef DEBUG_3
							std::cout << "\n>>>>>> (x?)\n";
						#endif

						// length of the explanation string	(Ita->Eng)
						unsigned int length = (unsigned char)block.data[ pos + 1 ];

						headword = L"";

						for ( unsigned int i = (pos+2); i < (pos+2+length); i++) {
							headword += block.data[i];
						}

						#ifdef DEBUG_5
							definition += std::wstring( L"(\?\?)" )
							//definition += L"(??)";
						#endif

						pos += length + 2;
						a += length + 1;

					} else if ( (unsigned char)block.data[pos-4] == 0x02 && (unsigned char)block.data[pos-2] == 0x06 && (unsigned char)block.data[pos] == 0x18 ) {

						//replace headword through headword explanation which is placed at the end of definition
						// Ab$3$ <- Ab...

						#ifdef DEBUG_3a
							std::cout << "\n>>>>>> (xx?)\n";
						#endif

						// length of the explanation string
						unsigned int length = (unsigned char)block.data[ pos + 1 ];

						headword = L"";

						for ( unsigned int i = (pos+2); i < (pos+2+length); i++) {
							headword += block.data[i];
						}

						pos += length + 2;
						a += length + 1;

					} else if ( (unsigned char)block.data[pos-3] == 0x14 && (unsigned char)block.data[pos-2] == 0x06 && (unsigned char)block.data[pos] == 0x18 ) {

						//replace headword through headword explanation which is placed at the begining of definition

						#ifdef DEBUG_3a
							std::cout << "\n>>>>>> (xxx?)\n";
						#endif

						// length of the explanation string
						unsigned int length = (unsigned char)block.data[ pos + 1 ];

						headword = L"";

						for ( unsigned int i = (pos+2); i < (pos+2+length); i++) {
							headword += block.data[i];
						}

						pos += length + 2;
						a += length + 1;

					} else if ( (unsigned char)block.data[pos-3] == 0x14 && (unsigned char)block.data[pos-2] == 0x02 && (unsigned char)block.data[pos] == 0x18 ) {

						//replace headword through headword explanation which is placed at the end of definition

						#ifdef DEBUG_3a
							std::cout << "\n>>>>>> (xxxx?)\n";
						#endif

						// length of the explanation string
						unsigned int length = (unsigned char)block.data[ pos + 1 ];

						headword = L"";

						for ( unsigned int i = (pos+2); i < (pos+2+length); i++) {
							headword += block.data[i];
						}

						pos += length + 2;
						a += length + 1;

					/*} else if ( ((unsigned char)block.data[pos] >= 0x41 && (unsigned char)block.data[pos] <= 0x5A &&
							(unsigned char)block.data[pos+1] == 0x10)
							|| ((unsigned char)block.data[pos] >= 0x41 && (unsigned char)block.data[pos] <= 0x5A &&
							(unsigned char)block.data[pos+1] >= 0x41 && (unsigned char)block.data[pos+1] <= 0x5A &&
							(unsigned char)block.data[pos+2] == 0x10) ) {

						// heb->eng
						pos += len - a;
						//a += len - a;
						break;*/

					} else if ( (unsigned char)block.data[pos] >= 0x41 && (unsigned char)block.data[pos] <= 0x5A &&
							(unsigned char)block.data[pos+1] == 0x10 ) {

						// heb->eng
						pos += len - a;
						a += len - a;
						break;

					} else if ( (unsigned char)block.data[pos] == 0x1A && (unsigned char)block.data[pos] >= 0x03 ) {

						// heb->eng
						pos += len - a;
						a += len - a;
						break;

					} else if ( (unsigned char)block.data[pos] == 0x50 && (unsigned char)block.data[pos + 1 ] == 0x1B &&
							len - a - 1 >= 2 ) {

						#ifdef DEBUG_3a
							std::cout  << "\n*** transcription (1)\n";
						#endif

						unsigned int length = (unsigned char)block.data[pos + 2 ];

						for ( unsigned int i = (pos+3); i < (pos+3+length); i++) {
							 transcription += block.data[i];
						}

						definition = L"[" + std::wstring( L"<span class=\"bgltrn\">" ) + transcription + L"</span>" + L"] " + definition;
						
						/*definition_stack = L"[";
						definition_stack += L"<span class=\"bgltrn\">";
						definition_stack += transcription;
						definition_stack += L"</span>";
						definition_stack += L"]";
						definition.insert(0,definition_stack);
						*/
						
						/*definition.insert(0,L"]");
						definition.insert(0,L"</span>");
						definition.insert(0,transcription);
						definition.insert(0,L"<span class=\"bgltrn\">");
						definition.insert(0,L"[");
						*/
						pos += length + 3;
						a += length + 2;

					} else if ( (unsigned char)block.data[pos] == 0x60 && (unsigned char)block.data[pos + 1 ] == 0x1B &&
							len - a - 1 >= 2 ) {

						#ifdef DEBUG_3a
							std::cout  << "\n*** transcription (2)\n";
						#endif

						unsigned int length = (unsigned char)block.data[pos + 2 ];

						length <<= 8;
						length += (unsigned char)block.data[pos + 3 ];

						for ( unsigned int i = (pos+4); i < (pos+4+length); i++) {
							 transcription += block.data[i];
						}

						definition = L"[" + std::wstring( L"<span class=\"bgltrn\">" ) + transcription + L"</span>" + L"] " + definition;

						/*definition_stack = L"[";
						definition_stack += L"<span class=\"bgltrn\">";
						definition_stack += transcription;
						definition_stack += L"</span>";
						definition_stack += L"]";
						//definition.insert(0,definition_stack);
						
						definition = definition_stack + definition;
						*/
						
						/*definition.insert(0,L"]");
						definition.insert(0,L"</span>");
						definition.insert(0,transcription);
						definition.insert(0,L"<span class=\"bgltrn\">");
						definition.insert(0,L"[");
						*/
						pos += length + 4;
						a += length + 3;

					} else if ( (unsigned char)block.data[pos] == 0x1E ) {

						
						//QCryptographicHash *crypt = new QCryptographicHash(QCryptographicHash::Md5); 

						//QByteArray string = x.toStdString().c_str();
						//crypt->addData(ba);

						//hash.reset();
						//hash.addData( ba );

						//hash_str = hash.result().toHex().data();

						#ifdef DEBUG_3h
							std::cout << "hash_str = " << hash_str << "\n";
						#endif

						/*++pos;

						while ( (unsigned char)block.data[pos] != 0x1F ) {
							filename += block.data[pos++];
						}*/

						url.setScheme( "bres" );
						//url.setHost( QString::fromUtf8( getId().c_str() ) );
						url.setHost( QString::fromUtf8( "/home/gons/.qtrans/index" ) );

						//url.setPath( QString::fromUtf8( filename.c_str() ) );
						//url.setPath( QString::fromUtf8( filename.c_str() ) );

						url_str = url.toEncoded().data();

						//ba = hash(ba, QCryptographicHash::Md5);

						//definition += L"bres:///usr/share/trans/babylon/Concise_Oxford_English_Diction.BGL/";
						//definition += std::wstring( L"bres://" ) + std::wstring(h_filename.begin(), h_filename.end()) + L"/";
						//definition += std::wstring( L"bres://" ) + std::wstring(hash_str.begin(), hash_str.end()) + L"/";
						//definition += std::wstring(url_str.begin(), url_str.end()) + L"/";
						//definition += std::wstring( L"file://" ) + std::wstring( L"/home/gons/.qtrans/index" ) + L"/";
						//definition += std::wstring( L"file://" ) + std::wstring( L"/home/gons/.qtrans/index/" ) + std::wstring(hash_str.begin(), hash_str.end()) + L"/";
						//definition += std::wstring( L"file://" ) + std::wstring((std::string(m_qstrIndexDir.toAscii().data())).begin(), (std::string(m_qstrIndexDir.toAscii().data())).end()) + L"/" + std::wstring(hash_str.begin(), hash_str.end()) + L"/";
						//definition += std::wstring( L"file://" ) + std::wstring(std::string(m_qstrIndexDir)) + L"/" + std::wstring(hash_str.begin(), hash_str.end()) + L"/";
						 //definition += std::wstring( L"file://" ) + std::wstring(m_strIndexDir.begin(), m_strIndexDir.end()) + L"/" + std::wstring(hash_str.begin(), hash_str.end()) + L"/";
						//definition += std::wstring( L"bres://" ) + std::wstring(crypt->result().data().begin(), crypt->result().data().end()) + L"/";
						
						definition += L"file://";
						definition += std::wstring(m_strIndexDir.begin(), m_strIndexDir.end());
						definition += L"/";
						definition += std::wstring(hash_str.begin(), hash_str.end());
						definition += L"/";
						
						++pos;

					} else if ( (unsigned char)block.data[pos] == 0x1F ) {

						//definition += std::wstring( L"\" alt=\"Grafik" );
						//pos += 2;
						++pos;

					} else if ( (unsigned char)block.data[pos] < 0x20 ) {	//SP: Space

						#ifdef DEBUG_2
							qDebug() << "block.data[" << pos << "] < 0x20 = " << block.data[pos];
						#endif

						if ( a <= /*<*/ len - 3 && block.data[pos] == 0x14 && block.data[pos+1] == 0x02 ) {

							#ifdef DEBUG_3a
								std::wcout << "block.data[" << pos+1 << "] = " << block.data[pos+1] << "\n";
								std::wcout << "block.data[" << pos+2 << "] = " << block.data[pos+2] << "\n";
							#endif

							//definition = partOfSpeech[(unsigned char)block.data[pos+2] - 0x30] + " " + definition;
							definition = partOfSpeech[(unsigned char)block.data[pos+2] - 0x30] + L" " + definition;	//ooo

							#ifdef DEBUG_5
								//definition = partOfSpeech[(unsigned char)block.data[pos+2] - 0x30] + L" " + definition + L"(?)";		//ooo
								definition += L"(?)";		//ooo
							#endif
						//}


							pos += 3;	//ooo
							a += 2;		//ooo

						//pos += len - a;
						//break;

						}	//ooo

						else if (block.data[pos] == 0x14) {
							pos++;
						} else {				//ooo
							definition += block.data[pos++];
						}

					} else {

						#ifdef DEBUG_3a

							 //size_t end = current_section.rfind(L']');
							//const std::wstring toFind = L"Acheulian";
							//std::wstring::size_type n = 0;
							 //toFind = L"Acheulian";


							/*while((pos = headword.find(toReplace, pos)) != std::wstring::npos) {
								result.replace(pos, toReplace.length(), replaceWith);
								pos += replaceWith.length();
							}*/

							//std::cout << "pos = " << pos << "\n";
							//std::cout << "headword.find(toFind, pos_) = " << headword.find(toFind, n) << "\n";
							//std::cout << "std::wstring::npos = " << std::wstring::npos << "\n";

							//for(wstring::size_type i = text.find(L'\n'); i != wstring::npos; i = text.find(L'\n', ++i))
							//while ((n = definition.find('Acheulian', n)) != std::wstring::npos) {
							/*for ( n = headword.find(toFind); n != std::wstring::npos; n = headword.find(toFind, ++n)) {

								if (n > 0) {
									std::cout << " n = " << n << "* * * * * *\n";
								}
								std::cout << "n = " << n << "\n* * * * * *\n";
								n++;
							}*/

							//if( std::wstring(your_char_ptr_string) == your_wstring)
							/*if( std::wstring(L"Acheulian") == headword) {
								std::cout << "\n* * * * * *\n";
							}*/

							/*if (headword.find(L"Mitler") < headword.size() ){
								std::cout << "*";
							}*/

							/*if ((block.data[pos] == 0x31)
								&& (block.data[pos+1] == 0x39) && (block.data[pos+2] == 0x33) && (block.data[pos+4] == 0x33)) {
								std::wcout << "bloc.data[" << pos+1 << "]" << "\n";
							}*/
						#endif

						if (block.data[pos] == 0x96 && ( (block.data[pos+1] >= 0x30 && block.data[pos+1] <= 0x39) ||
							(block.data[pos+1] >= 0x41 && block.data[pos+1] <= 0x5A) ||
							(block.data[pos+1] >= 0x61 && block.data[pos+1] <= 0x7A))) {	//ooo but eng->jpn problem

							definition += 0x2D;		// "-"
							pos++;
						} else {

							definition += block.data[pos++];

						}

						//definition += block.data[pos++];

						#ifdef DEBUG_1
							//qDebug() << "definition = " << block.data[pos+1];
							qDebug() << "block.data[pos+1] = " << block.data[pos+1];
						#endif
					}

					//int place = definition.find("black");

					//if (definition.find("black") != -1) {
					//if (place >= 0) {
						#ifdef DEBUG_4
							//printf("Definition to black: \n%s\n", "	###");
							printf("Definition to black: %i\n", place);
							qDebug() << "block.data[" << pos-15 << "] = " << (int)block.data[pos-15] << " chair = " << block.data[pos-15];
						#endif
					//}

				}
				//convertToUtf8( definition, TARGET_CHARSET );

				#ifdef DEBUG_2
					//qDebug() << "alternate = " << QString(" %1 ").arg(alternate.data());
					qDebug() << "block.length = " << block.length;
				#endif

				// Alternate forms
				while ( pos != block.length ) {
					len = (unsigned char)block.data[pos++];
					alternate.reserve( len );
					for(uint a=0;a<len;a++) alternate += block.data[pos++];
					//convertToUtf8( alternate, SOURCE_CHARSET );

					#ifdef DEBUG_2
						qDebug() << "alternate = " << QString(" %1 ").arg(alternate.data());
					#endif

					alternates.push_back( alternate );
					alternate.clear();
				}

				#ifdef DEBUG_3
					if ( (n = headword.find(toFind)) != std::wstring::npos) {
						std::cout  << "\n########################################\n";
						std::wcout << "headword = " << headword << "\n";
						std::wcout << "definition = " << definition << "\n";
						std::cout  << "########################################\n";
					}

					if ( (n = definition.find(toFind_x2)) != std::wstring::npos) {
						std::wcout << "block.data[" << n << "] = " << block.data[n] << "\n";
						std::wcout << "block.data[" << n + 9 << "] = " << block.data[n+9] << "\n";
						std::wcout << "block.data[" << n + 10 << "] = " << block.data[n+10] << "\n";
						std::wcout << "block.data[" << n + 11 << "] = " << block.data[n+11] << "\n";
					}

				#endif

				entry.headword = headword;
				entry.definition = definition;

				/*if (definition_stack != L"") {	//ooo
					entry.definition = definition_stack;
				} else {
					entry.definition = definition;
				}*/

				//if ( (n = headword.find(L"")) != std::wstring::npos) {
				/*if ( (n = definition_stack.find(L"")) != std::wstring::npos) {
					entry.definition = definition;
				} else {
					entry.definition = definition_stack;
				}*/

				#ifdef DEBUG_3
					std::cout << "n = " << definition_origin.find(L"") << "\n";
				#endif

				//if ( (n = definition_stack.find(L"")) == std::wstring::npos) {
				/*if ( definition_stack.empty()) {

					#ifdef DEBUG_3a
						std::wcout << "definition_stack (1) = " << definition_stack << "\n";
					#endif

					entry.definition = definition_stack;
				} else {

					#ifdef DEBUG_3a
						std::wcout << "definition (2) = " << definition << "\n";
					#endif

					entry.definition = definition;
				}*/

				entry.alternates = alternates;

				#ifdef DEBUG_3a
				//if (entry.headword.compare("black") == 0 || entry.headword.compare("Black") == 0) {	//ooo
				//if (entry.headword.find("black") < headword.size() || entry.headword.find("Black") < headword.size()) {	//ooo
					//printf("Definition of ...: %s\n", entry.headword.c_str());
					//printf("Definition of ...: %s\n", entry.definition.c_str());
					//printf("Definition of ...: %s\n", "	*****");

					/*std::copy(entry.headword.begin(), entry.headword.end(), std::back_inserter(temp));	//ooo

					printf("Definition of ...: %s\n", temp.c_str());

					std::copy(entry.definition.begin(), entry.definition.end(), std::back_inserter(temp));	//ooo

					printf("Definition of ...: %s\n", temp.c_str());
					printf("Definition of ...: %s\n", "	*****");*/

					//const std::wstring toFind = L"Acheulian";
					//std::wstring::size_type pos_x0 = 0;

					/*for ( n = headword.find(toFind); n != std::wstring::npos; n = headword.find(toFind, ++n)) {

						if (n > 0) {
							std::cout << " n = " << n << "* * * * * *\n";
						}
						std::cout << " n = " << n << "\n* * * * * *\n";
					}*/

					/*if ( (n = headword.find(toFind)) != std::wstring::npos) {
						std::cout  << "   ########################################\n";
					}*/

					std::wcout << "\ndefinition_origin = " << definition_origin << "\n";
					std::wcout << "entry.headword = " << entry.headword << "\n";
					std::wcout << "entry.definition = " << entry.definition << "\n";
					std::cout  << "   *****\n";

					//qDebug() << "D437C11D = " << QString::fromUtf8("D437C11D");
				//}
				#endif

				return entry;

				break;
			default:
				;
		}

		#ifdef DEBUG_1

			for ( n = headword.find(toFind); n != std::wstring::npos; n = headword.find(toFind, ++n)) {

				if (n > 0) {
					std::cout << " n = " << n << "* * * * * *\n";
				}
				std::cout << " n = " << n << "\n* * * * * *\n";
			}

			qDebug() << "   free( block.data ) ";
		#endif

		if( block.length ) free( block.data );
	}

	entry.headword = L"";

	#ifdef DEBUG_2
		qDebug() << "   Babylon_bgl::readEntry() >>> ";
	#endif

	return entry;
}


#include "babylon_bgl.moc"
