/***************************************************************************
                          babylon_bgl.h  -  description
	This library is based on the work of Raul Fernandes and Karl Grill
	on dictconv

                             -------------------
    begin                : February 2009
    copyright            : (c) 2007 by Roland Suchan
    email                : vmp@arcor.de
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/


#ifndef BABYLON_BGL_H
#define BABYLON_BGL_H

#include <QString>
#include <QFile>		//ooo
#include <QByteArray>		//ooo
#include <QCryptographicHash>	//ooo

#include <zlib.h>

#include <string>
#include <vector>


const std::string bgl_language[] = {
	"English", 
	"French",
	"Italian",
	"Spanish",
	"Dutch",
	"Portuguese",
	"German",
	"Russian",
	"Japanese",
	"Traditional Chinese",
	"Simplified Chinese",
	"Greek",
	"Korean",
	"Turkish",
	"Hebrew",
	"Arabic",
	"Thai",
	"Other",
	"Other Simplified Chinese dialects",
	"Other Traditional Chinese dialects",
	"Other Eastern-European languages",
	"Other Western-European languages",
	"Other Russian languages",
	"Other Japanese languages",
	"Other Baltic languages",
	"Other Greek languages",
	"Other Korean dialects",
	"Other Turkish dialects",
	"Other Thai dialects",
	"Polish",
	"Hungarian",
	"Czech",
	"Lithuanian",
	"Latvian",
	"Catalan",
	"Croatian",
	"Serbian",
	"Slovak",
	"Albanian",
	"Urdu",
	"Slovenian",
	"Estonian",
	"Bulgarian",
	"Danish",
	"Finnish",
	"Icelandic",
	"Norwegian",
	"Romanian",
	"Swedish",
	"Ukrainian",
	"Belarusian",
	"Farsi",
	"Basque",
	"Macedonian",
	"Afrikaans",
	"Faeroese",
	"Latin",
	"Esperanto",
	"Tamazight",
	"Armenian"};



const std::string bgl_charset[] = {
	"ISO-8859-1", /*Default*/
	"ISO-8859-1", /*Latin*/
	"ISO-8859-2", /*Eastern European*/
	"ISO-8859-5", /*Cyriilic*/
	"ISO-8859-14", /*Japanese*/
	"ISO-8859-14", /*Traditional Chinese*/
	"ISO-8859-15", /*Simplified Chinese*/
	"CP1257", /*Baltic*/
	"CP1253", /*Greek*/
	"ISO-8859-15",  /*Korean*/
	"ISO-8859-9", /*Turkish*/
	"ISO-8859-9", /*Hebrew*/
	"CP1256", /*Arabic*/
	"CP874"  /*Thai*/ };

/*
const std::string partOfSpeech[] = {
	"n.",
	"adj.",
	"v.",
	"adv.",
	"interj.",
	"pron.",
	"prep.",
	"conj.",
	"suff.",
	"pref.",
	"art.",
	"?11.",		//ooo
        "init.",	//ooo	12
	"adj./n.",	//ooo	13
	"adj./n.",	//ooo	14
	"?15.",		//ooo
	"nf.",		//ooo	16
	"nmf.",		//ooo	17
	"nm."		//ooo	18
};
*/

const std::wstring partOfSpeech[] = {	//ooo
	L"<i>n.</i>",
	L"<i>adj.</i>",
	L"<i>v.</i>",
	L"<i>adv.</i>",
	L"<i>interj.</i>",
	L"<i>pron.</i>",
	L"<i>prep.</i>",
	L"<i>conj.</i>",
	L"<i>suff.</i>",
	L"<i>pref.</i>",
	L"<i>art.</i>",
	L"?11.",			//ooo
        L"<i>init.</i>",		//ooo	12
	L"<i>adj./n.</i>",	//ooo	13
	L"<i>adj./n.</i>",	//ooo	14
	L"<i>adj./n.</i>",	//ooo	15
	L"<i>nf.</i>",		//ooo	16
	L"<i>nmf.</i>",		//ooo	17
	L"<i>nm.</i>"		//ooo	18
};


typedef struct {
	unsigned type;
	unsigned length;
	//char * data;
	unsigned char * data;	//ooo
} bgl_block;


typedef struct {
	//std::string headword;
	//std::string definition;
	//std::vector<std::string> alternates;
	std::wstring headword;			//ooo
	std::wstring definition;		//ooo
	std::vector<std::wstring> alternates;	//ooo
} bgl_entry;


class Babylon_bgl {
public:
	Babylon_bgl(QString filename, QString strIndexDir);
	~Babylon_bgl();

	QString printMessage();

	bool open();
	bool read();
	bool readBlock( bgl_block& );
	bgl_entry readEntry();

	std::string filename() const { return m_filename; };

	std::string m_filename;
	//QString m_filename;
	QString m_qstrIndexDir;		//ooo
	std::string m_strIndexDir;	//ooo
	std::string h_filename;		//ooo
	QByteArray ba;			//ooo
	gzFile file;

private:
	unsigned int bgl_readnum( int );
	std::string m_title;
	std::string m_author;
	std::string m_email;
	std::string m_description;
	std::string m_copyright;
	std::string m_sourceLang;
	std::string m_targetLang;
	uint m_numEntries;
	std::string m_defaultCharset;
	std::string m_sourceCharset;
	std::string m_targetCharset;

	enum CHARSET { DEFAULT_CHARSET, SOURCE_CHARSET, TARGET_CHARSET };

};


#endif // BABYLON_BGL_H
