/***************************************************************************
                          settings.cpp  -  description
                             -------------------
    begin                : December 2007
    copyright            : (c) 2007 by Roland Suchan
    email                : vmp@arcor.de
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#include <QVBoxLayout>
#include <QHBoxLayout>
#include <KLocale>   //i18n
#include <KWindowSystem>
#include <KShortcut>
#include <KMessageBox>

#include "settings.h"
#include "settings_widg.h"
#include "utils.h"

//#include "variables.h"   //ooo

/* **** If you want to add a new Charset (if supported by KHTML!!)
	add the name here, and the ID in CharsetID array,
	in the SAME position  --*/
const char* CharsetName[] = {
	"Arabic (cp 1256)",
	"Arabic (iso8859-6)",
	"Central European (cp 1250)",
	"Central European (cp 1254)",
	"Central European (ibm852)",
	"Central European (iso8859-2)",
	"Central European (iso8859-3)",
	"Central European (iso8859-4)",
	"Chinese Simplified (big5)",
	"Chinese Traditional (gbk)",
	"Cyrillic (koi8-r)",
	"Cyrillic (koi8-u)",
	"Greek (cp 1253)",
	"Greek (iso8859-7)",
	"Hebrew (cp 1255)",
	"Hebrew (iso8859-8)",
	"Hebrew (iso8859-8-i)",
	"Japanese (eucjp)",
	"Japanese (jis7)",
	"Japanese (sjis)",
	"Korean (euckr)",
	"Thai (tis620)",
	"Turkish (iso8859-9)",
	"Unicode (utf16)",
	"Unicode (utf8)",
	"Western European (cp 1252)",
	"Western European (iso8859-1)",
	"Western European (iso8859-15)",
	"Other (cp 1257)",
	0L
};

const char* StyleName[] = {
	"Default",
	"CDE",
	"Cleanlooks",
	"Macintosh",
	"Motif",
	"Oxygen",
	"Plastique",
	"Windows",
	0L
};

Settings::Settings(QTrans *parent)
    : KPageDialog(parent)
{
	Par = parent;

	setCaption( i18n( "Settings" ) );
	setButtons( Ok | Apply | Cancel);
	setFaceType(KPageDialog::List);
	//setFaceType(KPageDialog::Tabbed);
	//setFaceType(KPageDialog::Tree);
	//setFaceType(KPageDialog::Plain);
	//setFaceType(KPageDialog::Auto);

	setMinimumSize(370, 250);
	//resize(730, 420);
	resize(870, 420);

	QLabel *label = new QLabel( /*"First Test Page"*/ );
	//addPage( label, "Dictionaries" );
	KPageWidgetItem *page = new KPageWidgetItem( label, "Dictionaries" );
	page->setIcon( KIcon( "accessories-dictionary"/*"contents"*/ ) );

	addPage( page );

	QVBoxLayout *topLayout1 = new QVBoxLayout(label);
	Bab = new Settings_widg(label);
	topLayout1->addWidget(Bab);

// ******* Misc Panel *******
	label = new QLabel( /*"Second Test Page"*/ );
	KPageWidgetItem *page2 = new KPageWidgetItem( label, "Misc" );
	//page3->setHeader( "My header string" );
	page2->setIcon( KIcon( /*"misc"*/"applications-accessories" ) );

	addPage( page2 );

	QVBoxLayout *miscLayout = new QVBoxLayout(label);

	AutoPop = new QCheckBox( "AutoPop", label );
	AutoPop->setText(i18n("Enable Auto Pop-Up"));

	DontClose = new QCheckBox( "Dontclose", label );
	DontClose->setText(i18n("Minimize when press Exit button" /*"Minimize when press Close button"*/));

	DockIcon = new QCheckBox( "DockIcon", label );
	DockIcon->setText(i18n("Enable System Tray dock icon"));

	StartMin = new QCheckBox( "StartMin", label );
	StartMin->setText(i18n("Start Minimized"));
	
	hideTask = new QCheckBox( "hideTask", label );
	hideTask->setText(i18n("Hide from taskbar"));

	mouseSelection = new QCheckBox( "mouseSelection", label );	//ooo
	mouseSelection->setText(i18n("Translate mouse selection"));

	StatusBar = new QCheckBox( "StatusBar", label );	//ooo
	StatusBar->setText(i18n("Enable Status Bar"));

	miscLayout->addWidget(AutoPop);
	miscLayout->addWidget(DontClose);
	miscLayout->addWidget(DockIcon);

	QHBoxLayout *h1Layout = new QHBoxLayout(label);
	h1Layout->addSpacing(40);
	h1Layout->addWidget(StartMin);
	miscLayout->addLayout(h1Layout);
	
	QHBoxLayout *h2Layout = new QHBoxLayout(label);
	h2Layout->addSpacing(40);
	h2Layout->addWidget(hideTask);
	miscLayout->addLayout(h2Layout);

	miscLayout->addWidget(mouseSelection);
	miscLayout->addWidget(StatusBar);			//ooo

	//TextLabel3 = new QLabel("TextLabel3", label );
	TextLabel3 = new QLabel("TextLabel3");
	TextLabel3->setText(i18n("Charset :"));
	//Charset = new KComboBox(false, label);
	Charset = new KComboBox(false);
	for (int j=0;CharsetName[j]!=0L;j++) {
		Charset->addItem(CharsetName[j],j);
	}

	//QHBoxLayout *h3Layout = new QHBoxLayout(label);
	QHBoxLayout *h3Layout = new QHBoxLayout();
	h3Layout->addWidget(TextLabel3);
	h3Layout->addWidget(Charset);
	//miscLayout->addLayout(h3Layout);

	TextLabel5 = new QLabel("TextLabel5", label );	//ooo
	TextLabel5->setText(i18n("Widget Style :"));
	widgetStyle = new KComboBox(false, label);
	for (int j=0;StyleName[j]!=0L;j++) {
		widgetStyle->addItem(StyleName[j],j);
	}

	QHBoxLayout *h5Layout = new QHBoxLayout(label);	//ooo
	h5Layout->addWidget(TextLabel5);
	h5Layout->addWidget(widgetStyle);
	miscLayout->addLayout(h5Layout);

// ******* ShortCut Panel *******
	label = new QLabel( /*"Third Test Page"*/ );
	KPageWidgetItem *page3 = new KPageWidgetItem( label, "ShortCut" );
	page3->setIcon(KIcon("configure-shortcuts"/*"key_bindings"*/));

	addPage( page3 );

	//QVBoxLayout *shortCutLayout = new QVBoxLayout(label);

	EnableShortCut = new QCheckBox("Enable_shortCut", label);
	EnableShortCut->setGeometry(QRect(10, 20, 250, 25));
	EnableShortCut->setText(i18n("Enable Hide/Show shortcut"));

	TextLabel4 = new QLabel( "TextLabel4", label );
	TextLabel4->setGeometry( QRect( 10, 70, 110, 25 ) );
	TextLabel4->setText(i18n("Keys : CTRL + "));

	Char = new KComboBox(false, label);
	Char->setGeometry(QRect(130,70,50,25));
	int i = 0;
	for (char a = 'A'; a <= 'Z'; a++)
		Char->addItem(QString(QChar(a)),i++);

	//QHBoxLayout *h4Layout = new QHBoxLayout(label);
	//h4Layout->addWidget(TextLabel4);
	//h4Layout->addWidget(Char);


	//shortCutLayout->addWidget(EnableShortCut);
	//shortCutLayout->addLayout(h4Layout);

// ******* Font Panel *******
	label = new QLabel( /*"Fourth Test Page"*/ );
	KPageWidgetItem *page4 = new KPageWidgetItem( label, "Fonts" );
	page4->setIcon(KIcon("preferences-desktop-font"/*"fonts"*/));

	addPage( page4 );

	QVBoxLayout *topLayout = new QVBoxLayout(label);

	QStringList stringList;
	KFontChooser::getFontList(stringList, KFontChooser::SmoothScalableFonts);
	//KFontChooser *chooseFont = new KFontChooser(0, false, stringList);
	chooseFont = new KFontChooser(0, false, stringList);

	topLayout->addWidget(chooseFont);

// ******* Colors Panel *******
	label = new QLabel( /*"Fifth Test Page"*/ );
	KPageWidgetItem *page5 = new KPageWidgetItem( label, "Colors" );
	page5->setIcon( KIcon( "fill-color" ) );

	addPage( page5 );

/*	QVBoxLayout *mainLayout5 = new QVBoxLayout(label);

	QHBoxLayout *topBox = new QHBoxLayout(label);
	QHBoxLayout *bottomBox = new QHBoxLayout(label);
*/
	//QLabel *textLabel_Background= new QLabel(i18n("Background :"),this);
	QLabel *textLabel_Background= new QLabel("TextLabel5", label);
	textLabel_Background->setGeometry(QRect(20,40,150,20));
	textLabel_Background->setText(i18n("Background :"));
	QLabel *textLabel_ExpressionText= new QLabel("TextLabel6", label);	//ooo
	textLabel_ExpressionText->setGeometry(QRect(20,80,150,20));
	textLabel_ExpressionText->setText(i18n("Expression :"));
	//QLabel *textLabel_Text= new QLabel(i18n("Text :"),this);
	QLabel *textLabel_Text= new QLabel("TextLabel7", label);
	//textLabel_Text->setGeometry(QRect(20,80,110,20));
	textLabel_Text->setGeometry(QRect(20,120,150,20));			//ooo
	//textLabel_Text->setText(i18n("Text :"));
	textLabel_Text->setText(i18n("Definition :"));				//ooo
	QLabel *textLabel_SentencePartText= new QLabel("TextLabel8", label);	//ooo
	textLabel_SentencePartText->setGeometry(QRect(20,160,150,20));		//ooo
	textLabel_SentencePartText->setText(i18n("Part of Language :"));	//ooo


	//colorBtBack = new KColorButton(this);
	colorBtBack = new KColorButton(label);
	colorBtBack->setGeometry(QRect(170,35,280,30));
	colorBtExpressionText = new KColorButton(label);	//ooo
	colorBtExpressionText->setGeometry(QRect(170,75,280,30));
	//colorBtText = new KColorButton(this);
	colorBtText = new KColorButton(label);
	//colorBtText->setGeometry(QRect(140,75,280,30));
	colorBtText->setGeometry(QRect(170,115,280,30));	//ooo
	colorBtSentencePartText = new KColorButton(label);
	colorBtSentencePartText->setGeometry(QRect(170,155,280,30));	//ooo

/*	topBox->addWidget(textLabel_Background);
	topBox->addWidget(colorBtBack);

	bottomBox->addWidget(textLabel_Text);
	bottomBox->addWidget(colorBtText);

	mainLayout5->addLayout(topBox);
	mainLayout5->addLayout(bottomBox);
*/
	connect( this, SIGNAL( okClicked() ), this, SLOT(slot_Ok()));
	connect(this, SIGNAL(applyClicked()),this,SLOT(slot_apply()));
	connect(DockIcon,SIGNAL(clicked()),this,SLOT(slot_DockIcon()));

	Bab->eBasePath->setText(parent->English_Path);

	QList<Dictionary>::const_iterator it;

	for ( it = parent->bab_dict->constBegin(); it != parent->bab_dict->constEnd(); ++it) {
		//Bab->addDictionary( (*it).fileName, (*it).Language, (*it).flagID );
		//Bab->addDictionary( (*it).fileName, (*it).Language, (*it).flagID, (*it).Codec );	//ooo
		//Bab->addDictionary( (*it).fileName, (*it).Language, (*it).flagID, (*it).codecID );	//ooo
		//Bab->addDictionary( (*it).fileName, (*it).Language, (*it).flagID, (*it).codecID, (*it).directionID );	//ooo
		//Bab->addDictionary( (*it).fileName, (*it).Language, (*it).flagID, (*it).codecID, (*it).directionID, (*it).disableID );	//ooo
		//Bab->addDictionary( (*it).fileName, (*it).Language, (*it).flagID, (*it).codecID, (*it).directionID, (*it).disableID, (*it).encodingID );	//ooo
		Bab->addDictionary( (*it).fileName, (*it).Language, (*it).flagID, (*it).encodingDefinitionID, (*it).directionID, (*it).disableID, (*it).encodingExpressionID );	//ooo
	}
	if (Bab->Data->count()==0)
		Bab->bRemoveAll->setEnabled(false);

	QString strGoToLine = "";

	for (int i = 1; i <= Bab->Data->count(); i++) {	//ooo
		Bab->cGoToLine->addItem(strGoToLine.setNum(i));
	}

	//Bab->cGoToLine->setRange(5, 60);	//ooo

	//Bab->cGoToLine->setMaxCount(Bab->Data->count());	//ooo

	//dFont->setFont(parent->fontType);
	chooseFont->setFont(parent->fontType);

	colorBtBack->setColor(QColor(parent->Out->bgColor));
	colorBtText->setColor(QColor(parent->Out->txtColor));
	colorBtExpressionText->setColor(QColor(parent->Out->expressionTxtColor));	//ooo
	colorBtSentencePartText->setColor(QColor(parent->Out->sentencePartTxtColor));	//ooo

	
	//widgetStyle->setItemText(0,parent->widgetStyle);
	//widgetStyle->setItemText(widgetStyle->findText(parent->widgetStyle),parent->widgetStyle);
	//widgetStyle->currentIndex(widgetStyle->findText(parent->widgetStyle));
	widgetStyle->setCurrentIndex(widgetStyle->findText(parent->widgetStyle));	//ooo

/*	if (parent->widgetStyle != "") {	//ooo
		QChar c = parent->ShortKey[5];
		for (int i = 0; i <= 25 ; i++)
			//if (Char->text(i) == c) {
			if (Char->itemText(i) == c) {
				//Char->setCurrentItem(i);
				Char->setCurrentIndex(i);
				break;
			}
	}
*/
	if (parent->AutoPopUp) AutoPop->setChecked(true);
	if (parent->DontClose)
		DontClose->setChecked(true);
	if (parent->DockIcon) {
		DockIcon->setChecked(true);
		StartMin->setEnabled(true);
		hideTask->setEnabled(true);
		if (parent->StartMin) StartMin->setChecked(true);
		if (parent->hideTask) hideTask->setChecked(true);
	} else {
		StartMin->setEnabled(false);
		hideTask->setEnabled(false);
	}
	if (parent->MouseSelected)
		mouseSelection->setChecked(true);
	if (parent->StatusBarSelected)
		StatusBar->setChecked(true);

	if (parent->enableShortCut)
		EnableShortCut->setChecked(true);
	if (parent->ShortKey != "") {
		QChar c = parent->ShortKey[5];
		for (int i = 0; i <= 25 ; i++)
			//if (Char->text(i) == c) {
			if (Char->itemText(i) == c) {
				//Char->setCurrentItem(i);
				Char->setCurrentIndex(i);
				break;
			}
	}
}


Settings::~Settings()
{
}


void Settings::slot_close()
{
	close();
}


void Settings::slot_Ok()
{
	if (slot_apply()==0)
		close();
}


int Settings::slot_apply()
{
	bool hideTask_State = Par->hideTask;   //ooo
	Par->widgetStyle = widgetStyle->currentText();	//ooo

	Par->English_Path = Bab->eBasePath->text();
	Par->bab_dict->clear();
	Par->languageMenu->clear();
	Par->actionsList.clear();

	QList<Dictionary>::const_iterator it;

	for (it = Bab->Data->constBegin(); it != Bab->Data->constEnd(); ++it) {
		Par->bab_dict->append(*it);
		Par->actionsList.append(Par->languageMenu->addAction(QIcon(QPixmap(Bab->flagPath+Flag[(*it).flagID])), (*it).Language));
	}

	Par->fontType = chooseFont->font();
	//Par->Out->setFont(Par->fontType.family(),Par->fontType.pointSize(),Par->Charset);
	Par->Out->setFont(Par->fontType.family(),Par->fontType.pointSize(),Par->fontType.style(),Par->fontType.weight(),Par->Charset);	//ooo
	Par->Out->bgColor = colorBtBack->color().name();
	Par->Out->txtColor = colorBtText->color().name();
	Par->Out->expressionTxtColor = colorBtExpressionText->color().name();		//ooo
	Par->Out->sentencePartTxtColor = colorBtSentencePartText->color().name();	//ooo

	if (AutoPop->isChecked())
		Par->AutoPopUp = true;
	else
		Par->AutoPopUp = false;

	if (DontClose->isChecked())
		Par->DontClose = true;
	else
		Par->DontClose = false;

	if (mouseSelection->isChecked())	//ooo
		Par->MouseSelected = true;
	else
		Par->MouseSelected = false;

	if (StatusBar->isChecked()) {		//ooo
		Par->StatusBarSelected = true;
		Par->QMainWindow::statusBar()->show();
		Par->QMainWindow::statusBar()->showMessage(tr("Ready"));
	} else {
		Par->StatusBarSelected = false;
		Par->QMainWindow::statusBar()->hide();
	}

	if (DockIcon->isChecked()) {
		Par->DockIcon = true;
		Par->Dock->show();               //systemtray.cpp
		//Par->trayIcon->show();
		if (StartMin->isChecked())
			Par->StartMin = true;
		else
			Par->StartMin = false;
		if (hideTask->isChecked()) {
			Par->hideTask = true;
			Par->Dock->hideTask = true;   //ooo
		} else {
			Par->hideTask = false;
			Par->Dock->hideTask = false;   //ooo
		}
	}
	else {
		Par->DockIcon = false;
		Par->Dock->hide();               //systemtray.cpp
		//Par->trayIcon->hide();
		Par->StartMin = false;
		Par->hideTask = false;
		if (!Par->isVisible())
			Par->slot_ShortCut();
	}

	/*-- Seems not to work properly :(
	  the changes are not instantly applied --*/	
/*	if (Par->hideTask)
		KWindowSystem::setState(Par->winId(),NET::SkipTaskbar);
	else
		KWindowSystem::clearState(Par->winId(),NET::SkipTaskbar);
*/

	if (EnableShortCut->isChecked())
		Par->enableShortCut = true;
	else {
		Par->enableShortCut = false;
		Par->closeAct->setGlobalShortcut( KShortcut()
			, KAction::ActiveShortcut   //if on then turn off works
			, KAction::NoAutoloading   //if on then turn off works
		);
	}

	Par->ShortKey = "CTRL+" + Char->currentText();

	if (Par->enableShortCut) {
		Par->closeAct->setGlobalShortcut( KShortcut(Par->ShortKey)
			, KAction::ActiveShortcut | KAction::DefaultShortcut
			, KAction::NoAutoloading //change of ShortKey is possible
		);
	}

	Par->writeConfig();

	if ((hideTask_State != Par->hideTask) /*&& Par->isVisible()*/) {   //ooo
		if (Par->isVisible()) {
			Par->hide();
			Par->show();
		}
		if (Par->hideTask) {
			KWindowSystem::setState(Par->winId(), NET::SkipTaskbar);
			//QMessageBox::about(Par, tr("About Diagram Scene"), tr("slot_apply(: 2a"));
		} else {
			KWindowSystem::clearState(Par->winId(), NET::SkipTaskbar);
			//QMessageBox::about(Par, tr("About Diagram Scene"), tr("slot_apply(: 2b"));
		}
/*		if (Par->isVisible()) {
			Par->hide();
			Par->show();
			if (Par->hideTask) {
				KWindowSystem::setState(Par->winId(),NET::SkipTaskbar);
				QMessageBox::about(Par, tr("About Diagram Scene"), tr("slot_apply(: 2a"));
			} else {
				KWindowSystem::clearState(Par->winId(),NET::SkipTaskbar);
				QMessageBox::about(Par, tr("About Diagram Scene"), tr("slot_apply(: 2b"));
			}
			//Par->show();
		} else {
			if (Par->hideTask) {
				KWindowSystem::setState(Par->winId(),NET::SkipTaskbar);
				//QMessageBox::about(Par, tr("About Diagram Scene"), tr("slot_apply(: 2a"));
			} else {
				KWindowSystem::clearState(Par->winId(),NET::SkipTaskbar);
				//QMessageBox::about(Par, tr("About Diagram Scene"), tr("slot_apply(: 2b"));
			}
		}
*/	}

	return (0);
}


void Settings::slot_DockIcon()
{
	if (DockIcon->isChecked()) {
		StartMin->setEnabled(true);
		hideTask->setEnabled(true);
	} else {
		StartMin->setEnabled(false);
		StartMin->setChecked(false);
		hideTask->setEnabled(false);
		hideTask->setChecked(false);
	}
}

#include "settings.moc"

