/* 
    This program is part of the Project OOoLatexEquation
    It is called by the script OOoLatex to make an emf file 
    from a ps/pdf file generated by latex.
    
    Copyright (C) 2004 - 2005 Geoffroy Piroux gpiroux@mac.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*  Some documentation :
    libEMF SITE: http://libemf.sourceforge.net/
            API: http://msdn.microsoft.com/library/
*/

#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>

#include <emf.h>

using namespace std;

void error(const char*, const char*);
bool isStringDigit( string s);
int  getValue( string &s );

int main ( int argc, char* argv[] ){   

   int bbx1,bby1,bbx2,bby2,scale(10);
   bool isTransp(false);
   char* emffile("");
   char* asciifile("");
   int i;
   
   for ( i = 1; i < argc; i++ ){
        string arg = argv[i];
        if ( arg == "-transp") {
            isTransp = true;
        } else if ( arg == "-bb" ) {
            bbx1 = atoi( argv[++i] );
            bby1 = atoi( argv[++i] );
            bbx2 = atoi( argv[++i] );
            bby2 = atoi( argv[++i] );
        } else { 
            break; 
        } 
   }
   asciifile = argv[i++];
   emffile = argv[i];

   ifstream inStream(asciifile);
   if(!inStream) error("cannot open input file", asciifile);
   
   int sizeX = (bbx2-bbx1)*scale;
   int sizeY = (bby2-bby1)*scale;
   
   RECT size = {0,0, (int)(sizeX*3.125) , (int)(sizeY*3.125) };  
   PCSTR description = "Created by OOoLatex";
   HDC metaDC = CreateEnhMetaFile( 0, emffile, &size, description );
   if(!metaDC) error("cannot create file ", emffile);

   // Define the grid : (scale * size)
   SetMapMode(metaDC, MM_ISOTROPIC);
   SetWindowExtEx(metaDC, scale, scale, NULL);
   
   //Default configuration for the text from PS input
   SetTextAlign( metaDC, TA_BASELINE );
   SetBkMode( metaDC, TRANSPARENT );
   
   //Set the pen, the brush and the default font
   POINT pt = {0,0};
   LOGPEN lpen;
     lpen.lopnStyle = PS_NULL;
     lpen.lopnWidth =  pt;
   LOGBRUSH lbrush;
     lbrush.lbStyle = BS_SOLID;
   LOGFONT lfont;
     lfont.lfWidth = 0;	
     lfont.lfEscapement = 0;
     lfont.lfOrientation = 0;
     lfont.lfWeight = FW_NORMAL; 
     lfont.lfItalic = FALSE;
     lfont.lfUnderline = FALSE;
     lfont.lfStrikeOut = FALSE;
     lfont.lfOutPrecision = OUT_DEFAULT_PRECIS;
     lfont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
     lfont.lfQuality = DEFAULT_QUALITY;
     lfont.lfPitchAndFamily = FIXED_PITCH | FF_DONTCARE;
     lfont.lfCharSet = ANSI_CHARSET;
   
   // Activate the pen
   SelectObject( metaDC, CreatePenIndirect( &lpen ));


/// We start here the loop *********************************
   
   char line[100];
   int x,lx,y,ly,ii,ln,cr,cg,cb;
   string sline,text;
   bool isFirstLoop = true;
   
   // start of the loop...
   while (inStream.getline(line,100))
   {
        sline = line;
        
        // the first line from the file is the background color...
        if ( sline.substr(0,1) == "C" and isFirstLoop ) {
            cr = (int)(getValue( sline ) * .255);
            cg = (int)(getValue( sline ) * .255);
            cb = (int)(getValue( sline ) * .255);
            // set the brush color !
            lbrush.lbColor = RGB(cr,cg,cb);
            SelectObject( metaDC, CreateBrushIndirect( &lbrush ));
            // Insert the background.
            if (!isTransp) Rectangle( metaDC, 0, 0, sizeX , sizeY );
            // we ignor the second line...
            inStream.getline(line,100);
        }
        isFirstLoop = false;
        
        // Insert a rectangle (a line)
        if ( sline.substr(0,1) == "I" or sline.substr(0,1) == "R" ) {
            int old_y = y;
            x = getValue( sline )-(bbx1*scale);
            y = (bby2*scale)-getValue( sline );
            lx = getValue( sline );
            ly = getValue( sline );
                       
            Rectangle( metaDC, x, y-ly , x+lx , y );
        }
        
        // set the text color.
        if ( sline.substr(0,1) == "C" ) {
    
            cr = (int)(getValue( sline ) * .255);
            cg = (int)(getValue( sline ) * .255);
            cb = (int)(getValue( sline ) * .255);
            // set color text
            SetTextColor( metaDC, RGB(cr,cg,cb) );
            // set brush color
            lbrush.lbColor = RGB(cr,cg,cb);
            SelectObject( metaDC, CreateBrushIndirect( &lbrush ));
        }
        // Set font 
        if ( sline.substr(0,1) == "F" ) {
          
            // Name of the font !
            i = sline.find("(");
            ii = sline.rfind(")");
            sline = sline.substr(i+1,ii-i-1);
            ln = sline.length();
            
            // Due to a problem with libEMF, 
            // I get the font size from the name of the font
            string c1 = sline.substr(ln-2,1); // before last char
            string c2 = sline.substr(ln-1,1); // last char
            if ( isStringDigit( c2 ) ) {
                if ( isStringDigit( c1 ) ) {
                    lfont.lfHeight = - atoi( sline.substr(ln-2,2).c_str() )*scale;
                    strcpy(lfont.lfFaceName, sline.c_str() );
                } 
                else {
                    lfont.lfHeight = - atoi( sline.substr(ln-1,1).c_str() )*scale;
                    strcpy(lfont.lfFaceName, sline.c_str() );
                }            
            } else {
                error("cannot get font size for ",sline.c_str());
            }
            
            // spacial case : TeX-cmex7 --> CMEX7
            string fontname(lfont.lfFaceName);
            if ( fontname == "TeX-cmex7" ) { strcpy(lfont.lfFaceName,"CMEX7"); }
            
            // Set the font as the current font !
            SelectObject( metaDC, CreateFontIndirect( &lfont ) ); 
        }
        
        //Insert Text
        if ( sline.substr(0,1) == "S" ) {
                
            x = getValue(sline)-(bbx1*10);
            y = (bby2*10)-getValue(sline); 
            
            i = sline.find("(");
            ii = sline.rfind(")");
            text = sline.substr(i+1,ii-i-1) ;

            i = 0;
            ln = text.length();
            while ( i < ln )
            {   
                // look for "\"
                if ( text.c_str()[i] == 92 )
                    if ( !isdigit(text.c_str()[i+1]) ) {
                        text.replace(i,1,"");
                        ln-=1;
                    } else {
                        char c = 64*atoi(text.substr(i+1,1).c_str()) 
                                + 8*atoi(text.substr(i+2,1).c_str()) 
                                +   atoi(text.substr(i+3,1).c_str());
                        string sc = &c;
                        text.replace(i,4,sc.substr(0,1));
                        ln-=3;
                    }
                i++;
            }
            
            // insert the text !
            TextOut( metaDC, x , y , text.c_str(), text.length() );
        }
   }
   
/// End of the loop *****************************************

   inStream.close();
   // Write the file
   DeleteEnhMetaFile(CloseEnhMetaFile(metaDC));
   return 0;
}


void error(const char* p, const char* p2 = "")
{
    cerr << p << " " << p2 <<  "\n";
    exit(1); 
}

bool isStringDigit( string c )
{
    if (c=="0"||c=="1"||c=="2"||c =="3"||c=="4"||c =="5"||c=="6"||c=="7"||c=="8"||c =="9") return true;
    return false;
}

int getValue( string &s )
{
    int i,ln;
    i = s.find(" ");
    ln = s.length();
    s = s.substr(i+1,i+ln-3);       
    return atoi(s.substr(0,s.find(" ")).c_str());
}

