/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.BooleanResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathResult;

class OrExpr
extends XPathExpression {
    private static String OR = " or ";
    private static String NULL = "null";
    private XPathExpression leftExpr = null;
    private XPathExpression rightExpr = null;

    public OrExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2) {
        if (xPathExpression == null) {
            throw new IllegalArgumentException("Argument leftExpr is null");
        }
        if (xPathExpression2 == null) {
            throw new IllegalArgumentException("Argument rightExpr is null");
        }
        this.leftExpr = xPathExpression;
        this.rightExpr = xPathExpression2;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        XPathResult xPathResult;
        if (this.leftExpr != null && (xPathResult = this.leftExpr.evaluate(xPathContext)).booleanValue()) {
            return BooleanResult.TRUE;
        }
        if (this.rightExpr != null && (xPathResult = this.rightExpr.evaluate(xPathContext)).booleanValue()) {
            return BooleanResult.TRUE;
        }
        return BooleanResult.FALSE;
    }

    public short getExprType() {
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.leftExpr != null) {
            stringBuffer.append(this.leftExpr.toString());
        } else {
            stringBuffer.append(NULL);
        }
        stringBuffer.append(OR);
        if (this.rightExpr != null) {
            stringBuffer.append(this.rightExpr.toString());
        } else {
            stringBuffer.append(NULL);
        }
        return stringBuffer.toString();
    }
}

