/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.exolab.adaptx.net.URIResolver;
import org.exolab.adaptx.net.impl.URIResolverImpl;
import org.exolab.adaptx.util.ErrorObserverAdapter;
import org.exolab.adaptx.util.List;
import org.exolab.adaptx.util.Tokenizer;
import org.exolab.adaptx.xml.Whitespace;
import org.exolab.adaptx.xml.XMLUtil;
import org.exolab.adaptx.xpath.BooleanResult;
import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.StringResult;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathParser;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xslt.ActionIterator;
import org.exolab.adaptx.xslt.ActionTemplate;
import org.exolab.adaptx.xslt.AttributeSet;
import org.exolab.adaptx.xslt.AttributeValueTemplate;
import org.exolab.adaptx.xslt.Conditional;
import org.exolab.adaptx.xslt.CopyOf;
import org.exolab.adaptx.xslt.FunctionResolver;
import org.exolab.adaptx.xslt.NodeSorter;
import org.exolab.adaptx.xslt.Param;
import org.exolab.adaptx.xslt.ProcessorState;
import org.exolab.adaptx.xslt.ResultHandler;
import org.exolab.adaptx.xslt.Selection;
import org.exolab.adaptx.xslt.TemplateRule;
import org.exolab.adaptx.xslt.TreeFragmentResult;
import org.exolab.adaptx.xslt.ValueOf;
import org.exolab.adaptx.xslt.Variable;
import org.exolab.adaptx.xslt.XSLCData;
import org.exolab.adaptx.xslt.XSLException;
import org.exolab.adaptx.xslt.XSLNumber;
import org.exolab.adaptx.xslt.XSLObject;
import org.exolab.adaptx.xslt.XSLSort;
import org.exolab.adaptx.xslt.XSLTStylesheet;
import org.exolab.adaptx.xslt.XSLText;
import org.exolab.adaptx.xslt.dom.XPNBuilder;
import org.exolab.adaptx.xslt.util.MessageObserver;
import org.exolab.adaptx.xslt.util.ResultFormatter;
import org.exolab.adaptx.xslt.util.ScopedVariableSet;
import org.xml.sax.AttributeList;

public class RuleProcessor
extends ErrorObserverAdapter {
    public static final String XSL_VERSION = "version";
    public static final String XSL_VENDOR = "vendor";
    public static final String XSL_VENDOR_URL = "vendor-url";
    private static final String RULE_CONFLICT = "There is a rule conflict between the following two template match expressions: ";
    private static final String ENDLESS_LOOP_WARNING = "A possible endless loop has been encountered during processing of template: ";
    private static final String NS_DEFAULT_DECL = "xmlns";
    private static final String NS_DECL_PREFIX = "xmlns:";
    private static final String NAMESPACE_ATTR = "namespace";
    private final String NS_SEP = ":";
    private XSLTStylesheet stylesheet = null;
    private TemplateRule[] allRules = null;
    private TemplateRule defaultRule = null;
    private Selection selectChildren = null;
    private Properties xslSysProps = null;
    private Properties params = null;
    List msgObservers = null;
    List fnResolvers = null;
    private URIResolver _uriResolver = null;
    private XPathParser _parser = new XPathParser();

    public RuleProcessor(XSLTStylesheet xSLTStylesheet) {
        this.stylesheet = xSLTStylesheet;
        this.msgObservers = new List(3);
        this.fnResolvers = new List(3);
        this.defaultRule = new TemplateRule();
        this.selectChildren = new Selection(1);
        this.defaultRule.appendAction(this.selectChildren);
        this.defaultRule.setParent(xSLTStylesheet);
        this.xslSysProps = new Properties();
        ((Hashtable)this.xslSysProps).put(XSL_VERSION, "0.9.4.3+");
        ((Hashtable)this.xslSysProps).put(XSL_VENDOR, "The Exolab Group");
        ((Hashtable)this.xslSysProps).put(XSL_VENDOR_URL, "http://www.clc-marketing.com/xslp");
        this.params = new Properties();
        this.allRules = xSLTStylesheet.getTemplates();
        this._parser.setUseErrorExpr(true);
    }

    public void addFunctionResolver(FunctionResolver functionResolver) {
        if (functionResolver != null) {
            this.fnResolvers.add(functionResolver);
        }
    }

    public void addMessageObserver(MessageObserver messageObserver) {
        this.msgObservers.add(messageObserver);
    }

    protected void bindVariable(Variable variable, ProcessorState processorState) {
        ScopedVariableSet scopedVariableSet;
        ScopedVariableSet scopedVariableSet2 = processorState.getVariables();
        XPathResult xPathResult = null;
        if (variable.getType() == 26 && (scopedVariableSet = processorState.getParameters()) != null) {
            xPathResult = scopedVariableSet.getVariable(variable.getName());
        }
        if (xPathResult == null) {
            xPathResult = this.processVariable(variable, processorState);
        }
        if (xPathResult != null) {
            scopedVariableSet2.setVariable(variable.getName(), xPathResult);
        }
    }

    private void copy(XPathNode xPathNode, XSLObject xSLObject, ProcessorState processorState) {
        if (xPathNode.getNodeType() == 1) {
            String string;
            Object object;
            ResultFormatter resultFormatter = processorState.getResultFormatter();
            String string2 = xPathNode.getLocalName();
            String string3 = xPathNode.getNamespaceURI();
            if (!resultFormatter.isNamespaceDeclared(string3)) {
                object = xPathNode.getNamespacePrefix(string3);
                resultFormatter.declareNamespace((String)object, string3);
            }
            resultFormatter.startElement(string2, string3);
            object = xPathNode.getFirstNamespace();
            while (object != null) {
                string = ((XPathNode)object).getLocalName();
                String string4 = ((XPathNode)object).getStringValue();
                resultFormatter.declareNamespace(string, string4);
                object = ((XPathNode)object).getNext();
            }
            string = xSLObject.getAttribute("use-attribute-sets");
            if (string != null && string.length() > 0) {
                this.processAttributeSets(string, processorState);
            }
            processorState.pushNodeSet(new NodeSet(xPathNode));
            this.processTemplate(xSLObject.getActions(), processorState);
            processorState.popNodeSet();
            resultFormatter.endElement(string2, string3);
        } else {
            this.copyOf(xPathNode, processorState);
        }
    }

    private void copyOf(XPathNode xPathNode, ProcessorState processorState) {
        ResultFormatter resultFormatter = processorState.getResultFormatter();
        switch (xPathNode.getNodeType()) {
            case 2: {
                resultFormatter.attribute(xPathNode.getLocalName(), xPathNode.getStringValue(), xPathNode.getNamespaceURI());
                break;
            }
            case 8: {
                resultFormatter.comment(xPathNode.getStringValue());
                break;
            }
            case 1: {
                Object object;
                String string = xPathNode.getLocalName();
                String string2 = xPathNode.getNamespaceURI();
                if (!resultFormatter.isNamespaceDeclared(string2)) {
                    object = xPathNode.getNamespacePrefix(string2);
                    resultFormatter.declareNamespace((String)object, string2);
                }
                resultFormatter.startElement(string, string2);
                object = xPathNode.getFirstNamespace();
                while (object != null) {
                    resultFormatter.declareNamespace(((XPathNode)object).getLocalName(), ((XPathNode)object).getStringValue());
                    object = ((XPathNode)object).getNext();
                }
                XPathNode xPathNode2 = xPathNode.getFirstAttribute();
                while (xPathNode2 != null) {
                    resultFormatter.attribute(xPathNode2.getLocalName(), xPathNode2.getStringValue(), xPathNode2.getNamespaceURI());
                    xPathNode2 = xPathNode2.getNext();
                }
                XPathNode xPathNode3 = xPathNode.getFirstChild();
                while (xPathNode3 != null) {
                    this.copyOf(xPathNode3, processorState);
                    xPathNode3 = xPathNode3.getNext();
                }
                resultFormatter.endElement(string, string2);
                break;
            }
            case 3: {
                resultFormatter.characters(xPathNode.getStringValue());
                break;
            }
            case 7: {
                resultFormatter.processingInstruction(xPathNode.getLocalName(), xPathNode.getStringValue());
                break;
            }
        }
    }

    private void createNode(XSLObject xSLObject, ProcessorState processorState) throws XSLException {
        Object object;
        Object object2;
        String string = null;
        String string2 = null;
        XPathNode xPathNode = null;
        AttributeValueTemplate attributeValueTemplate = null;
        String string3 = xSLObject.getAttribute("name");
        try {
            attributeValueTemplate = processorState.getAttributeValueTemplate(string3);
        }
        catch (XPathException xPathException) {
            throw new XSLException(xPathException);
        }
        string = attributeValueTemplate != null ? attributeValueTemplate.evaluate(processorState) : "";
        short s = xSLObject.getType();
        switch (s) {
            default: {
                object2 = new XPNBuilder();
                processorState.pushHandler((ResultHandler)object2);
                object = processorState.getResultFormatter();
                ((ResultFormatter)object).startElement(xSLObject.getTypeName(), null);
                this.processTemplate(xSLObject.getActions(), processorState);
                ((ResultFormatter)object).flush();
                xPathNode = ((XPNBuilder)object2).getCurrentNode();
                ((ResultFormatter)object).endElement(xSLObject.getTypeName(), null);
                processorState.popHandler();
                string2 = xPathNode.getStringValue();
            }
            case 10: 
            case 12: 
            case 38: 
        }
        object2 = processorState.getResultFormatter();
        switch (s) {
            case 3: {
                object = null;
                if (string.equals(NS_DEFAULT_DECL)) {
                    String string4 = "Illegal attribute name: xmlns";
                    string4 = String.valueOf(string4) + "; 'xmlns' is a reserved word";
                    throw new XSLException(string4);
                }
                int n = string.indexOf(58);
                if (n >= 0) {
                    String string5 = string.substring(0, n);
                    if (string5.equals(NS_DEFAULT_DECL)) {
                        String string6 = "Illegal attribute name: " + string;
                        string6 = String.valueOf(string6) + "; The 'xmlns' prefix is reserved.";
                        throw new XSLException(string6);
                    }
                    object = xSLObject.getAttribute(NAMESPACE_ATTR);
                    if (object == null) {
                        object = processorState.getNamespaceURI(string5);
                    }
                }
                string2 = Whitespace.stripSpace(string2);
                ((ResultFormatter)object2).attribute(string, string2, (String)object);
                break;
            }
            case 8: {
                ((ResultFormatter)object2).comment(string2);
                break;
            }
            case 10: {
                this.copy(processorState.getNode(), xSLObject, processorState);
                break;
            }
            case 12: {
                String string7;
                object = "";
                int n = string.indexOf(58);
                if (n >= 0) {
                    object = string.substring(0, n);
                    string = string.substring(n + 1);
                }
                if ((string7 = xSLObject.getAttribute(NAMESPACE_ATTR)) == null) {
                    string7 = processorState.getNamespaceURI((String)object);
                }
                if (!((ResultFormatter)object2).isNamespaceDeclared(string7)) {
                    ((ResultFormatter)object2).declareNamespace((String)object, string7);
                }
                ((ResultFormatter)object2).startElement(string, string7);
                String string8 = xSLObject.getAttribute("use-attribute-sets");
                this.processAttributeSets(string8, processorState);
                this.processTemplate(xSLObject.getActions(), processorState);
                ((ResultFormatter)object2).endElement(string, string7);
                break;
            }
            case 38: {
                ((ResultFormatter)object2).entityReference(string);
                break;
            }
            case 27: {
                ((ResultFormatter)object2).processingInstruction(string, string2);
                break;
            }
        }
    }

    private void duplicateIdError(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("warning: multiple elements with the same id value: ");
        stringBuffer.append(string);
        stringBuffer.append("\n -- processing will continue with first occurance only.");
        this.receiveError(stringBuffer.toString());
    }

    protected TemplateRule findTemplate(TemplateRule[] templateRuleArray, XPathNode xPathNode, String string, ProcessorState processorState) throws XSLException {
        if (xPathNode == null) {
            return null;
        }
        TemplateRule templateRule = null;
        float f = 0.0f;
        if (xPathNode.getNodeType() == 9) {
            templateRule = this.defaultRule;
            f = 0.5f;
        }
        int n = 0;
        while (n < templateRuleArray.length) {
            TemplateRule templateRule2 = templateRuleArray[n];
            String string2 = templateRule2.getMode();
            if (!(string2 == null && string != null || string2 != null && string == null || string2 != null && string != null && !string2.equals(string) || !templateRule2.matches(xPathNode, processorState))) {
                if (templateRule == null) {
                    templateRule = templateRule2;
                    f = templateRule2.calculatePriority(xPathNode, processorState);
                } else {
                    float f2 = templateRule2.calculatePriority(xPathNode, processorState);
                    if (f < f2) {
                        templateRule = templateRule2;
                        f = f2;
                    } else if (f == f2) {
                        if (this.defaultRule != templateRule && templateRule.getStylesheet() == templateRule2.getStylesheet()) {
                            StringBuffer stringBuffer = new StringBuffer(RULE_CONFLICT);
                            stringBuffer.append("\n 1." + templateRule.getPattern());
                            stringBuffer.append(" mode='" + templateRule.getMode() + "' {");
                            stringBuffer.append(templateRule.getStylesheet().getHref());
                            stringBuffer.append("}\n 2." + templateRule2.getPattern());
                            stringBuffer.append(" mode='" + templateRule2.getMode() + "' {");
                            stringBuffer.append(templateRule2.getStylesheet().getHref());
                            stringBuffer.append("}\n");
                            throw new XSLException(stringBuffer.toString());
                        }
                        templateRule = templateRule2;
                        f = f2;
                    }
                }
            }
            ++n;
        }
        return templateRule;
    }

    public String getParameter(String string) {
        if (string == null) {
            return null;
        }
        return this.params.getProperty(string);
    }

    public String getProperty(String string) {
        return this.xslSysProps.getProperty(string, "");
    }

    private String getResolvedName(String string) {
        int n = 0;
        n = string.indexOf(":");
        if (n > 0) {
            String string2 = this.stylesheet.getQuotedNamespace(string.substring(0, n));
            return String.valueOf(string2) + string.substring(n);
        }
        return string;
    }

    public URIResolver getURIResolver() {
        if (this._uriResolver == null) {
            this._uriResolver = new URIResolverImpl();
        }
        return this._uriResolver;
    }

    private boolean isStripSpaceAllowed(XPathNode xPathNode, ProcessorState processorState) {
        if (xPathNode == null) {
            return true;
        }
        if (processorState.getXMLSpaceModes().peek().equals("preserve")) {
            return false;
        }
        XPathNode xPathNode2 = xPathNode;
        switch (xPathNode.getNodeType()) {
            case 9: {
                return true;
            }
            default: {
                xPathNode2 = xPathNode.getParentNode();
                if (xPathNode2 == null) {
                    return false;
                }
                if (xPathNode2.getNodeType() == 1) break;
                return true;
            }
            case 1: 
        }
        return this.stylesheet.isStripSpaceAllowed(xPathNode2.getLocalName());
    }

    public void process(XPathNode xPathNode, ResultHandler resultHandler) {
        Object object;
        XSLObject xSLObject;
        if (xPathNode == null) {
            this.receiveError("null source node, nothing to do.");
            return;
        }
        if (resultHandler == null) {
            this.receiveError("null ResultHandler, it's pointless to proceed.");
            return;
        }
        ProcessorState processorState = new ProcessorState(this, xPathNode, this.stylesheet, resultHandler);
        processorState.setFunctionResolvers(this.fnResolvers);
        ResultFormatter resultFormatter = processorState.getResultFormatter();
        Enumeration enumeration = null;
        ScopedVariableSet scopedVariableSet = processorState.getVariables();
        enumeration = this.stylesheet.getParameters();
        while (enumeration.hasMoreElements()) {
            xSLObject = (Param)enumeration.nextElement();
            object = this.getParameter(((Variable)xSLObject).getName());
            if (object != null) {
                scopedVariableSet.setVariable(((Variable)xSLObject).getName(), new StringResult((String)object));
                continue;
            }
            XPathResult xPathResult = this.processVariable((Variable)xSLObject, processorState);
            if (xPathResult == null) continue;
            scopedVariableSet.setVariable(((Variable)xSLObject).getName(), xPathResult);
        }
        enumeration = this.stylesheet.getVariables();
        while (enumeration.hasMoreElements()) {
            xSLObject = (Variable)enumeration.nextElement();
            object = this.processVariable((Variable)xSLObject, processorState);
            if (object == null) continue;
            scopedVariableSet.setVariable(((Variable)xSLObject).getName(), (XPathResult)object);
        }
        xSLObject = null;
        try {
            xSLObject = this.findTemplate(this.allRules, xPathNode, null, processorState);
        }
        catch (Exception exception) {
            this.receiveError(exception);
        }
        try {
            if (xSLObject != null) {
                this.processTemplate(xSLObject.getActions(), processorState);
            } else {
                this.processTemplate(this.defaultRule.getActions(), processorState);
            }
            resultFormatter.flush();
        }
        catch (Exception exception) {
            this.receiveError(exception);
        }
    }

    private void processAction(XSLObject xSLObject, ProcessorState processorState) {
        XPathNode xPathNode = processorState.getNode();
        XPathNode xPathNode2 = null;
        String string = null;
        String string2 = null;
        TemplateRule[] templateRuleArray = this.allRules;
        NodeSet nodeSet = null;
        processorState.pushAction(xSLObject);
        block7 : switch (xSLObject.getType()) {
            case 0: {
                templateRuleArray = xSLObject.getStylesheet().getTemplates();
            }
            case 1: {
                XSLSort[] xSLSortArray;
                Selection selection = (Selection)xSLObject;
                try {
                    nodeSet = selection.selectNodes(processorState);
                }
                catch (XPathException xPathException) {
                    this.receiveError(xPathException);
                    break;
                }
                if (nodeSet.size() == 0) break;
                if (nodeSet.size() > 1 && selection.hasSortKeys() && (xSLSortArray = selection.getSortKeys()).length > 0) {
                    nodeSet = NodeSorter.sort(nodeSet, xSLSortArray, processorState);
                }
                xSLSortArray = selection.getAttribute("mode");
                processorState.newParameterScope();
                this.processParameters(xSLObject, processorState);
                processorState.pushNodeSet(nodeSet);
                int n = 0;
                while (n < nodeSet.size()) {
                    processorState.setPosition(n);
                    xPathNode2 = nodeSet.item(n);
                    ActionTemplate actionTemplate = null;
                    TemplateRule templateRule = null;
                    try {
                        templateRule = this.findTemplate(templateRuleArray, xPathNode2, (String)xSLSortArray, processorState);
                    }
                    catch (Exception exception) {
                        this.receiveError(exception);
                    }
                    if (templateRule != null) {
                        actionTemplate = templateRule.getActions();
                    }
                    if (xPathNode2 != xPathNode) {
                        this.processTemplate(actionTemplate, processorState);
                    } else {
                        XSLObject xSLObject2 = selection.getNearestAncestor((short)13);
                        if (xSLObject2 == null) {
                            xSLObject2 = selection.getNearestAncestor((short)32);
                        }
                        if (templateRule == xSLObject2) {
                            String string3 = ENDLESS_LOOP_WARNING + templateRule.getPattern().toString();
                            this.receiveError(string3, 2);
                        }
                        this.processTemplate(actionTemplate, processorState);
                    }
                    ++n;
                }
                processorState.popNodeSet();
                processorState.freeParameterScope();
                break;
            }
            case 5: {
                processorState.newParameterScope();
                this.processParameters(xSLObject, processorState);
                string = xSLObject.getAttribute("name");
                TemplateRule templateRule = this.stylesheet.getNamedTemplate(string);
                if (templateRule != null) {
                    this.processTemplate(templateRule.getActions(), processorState);
                } else {
                    this.receiveError("No named template found: " + string);
                }
                processorState.freeParameterScope();
                break;
            }
            case 13: {
                XSLSort[] xSLSortArray;
                Selection selection = (Selection)xSLObject;
                try {
                    nodeSet = selection.selectNodes(processorState);
                }
                catch (XPathException xPathException) {
                    this.receiveError(xPathException);
                    break;
                }
                if (nodeSet.size() == 0) break;
                if (nodeSet.size() > 1 && selection.hasSortKeys() && (xSLSortArray = selection.getSortKeys()).length > 0) {
                    nodeSet = NodeSorter.sort(nodeSet, xSLSortArray, processorState);
                }
                processorState.pushNodeSet(nodeSet);
                int n = 0;
                while (n < nodeSet.size()) {
                    processorState.setPosition(n);
                    xPathNode2 = nodeSet.item(n);
                    if (xPathNode2 != xPathNode) {
                        this.processTemplate(selection.getActions(), processorState);
                    }
                    ++n;
                }
                processorState.popNodeSet();
                break;
            }
            case 16: {
                Conditional conditional = (Conditional)((Object)xSLObject);
                BooleanResult booleanResult = null;
                try {
                    booleanResult = conditional.evaluate(processorState);
                }
                catch (XPathException xPathException) {
                    this.receiveError(xPathException);
                    break;
                }
                if (!booleanResult.booleanValue()) break;
                this.processTemplate(xSLObject.getActions(), processorState);
                break;
            }
            case 7: {
                ActionIterator actionIterator = xSLObject.getActions().actions();
                BooleanResult booleanResult = null;
                while (actionIterator.hasNext()) {
                    XSLObject xSLObject3 = actionIterator.next();
                    Conditional conditional = (Conditional)((Object)xSLObject3);
                    try {
                        booleanResult = conditional.evaluate(processorState);
                    }
                    catch (XPathException xPathException) {
                        this.receiveError(xPathException);
                        break block7;
                    }
                    catch (NullPointerException nullPointerException) {
                        nullPointerException.printStackTrace();
                    }
                    if (!booleanResult.booleanValue()) continue;
                    this.processTemplate(xSLObject3.getActions(), processorState);
                    break block7;
                }
                break;
            }
            case 22: {
                XPNBuilder xPNBuilder = new XPNBuilder();
                processorState.pushHandler(xPNBuilder);
                XPathNode xPathNode3 = xPNBuilder.startFragment();
                this.processTemplate(xSLObject.getActions(), processorState);
                processorState.popHandler();
                string2 = xPathNode3.getStringValue();
                int n = 0;
                while (n < this.msgObservers.size()) {
                    ((MessageObserver)this.msgObservers.get(n)).receiveMessage(string2);
                    ++n;
                }
                break;
            }
            case 23: {
                this.processXSLNumber(xPathNode, (XSLNumber)xSLObject, processorState);
                break;
            }
            case 34: {
                string2 = ((ValueOf)xSLObject).getValue(processorState);
                if (string2 == null) break;
                char[] cArray = string2.toCharArray();
                int n = cArray.length;
                if (this.isStripSpaceAllowed(xPathNode, processorState)) {
                    n = Whitespace.stripSpace(cArray, true, true);
                }
                if (n > 0) {
                    processorState.getResultFormatter().characters(cArray, 0, n);
                }
                string2 = null;
                break;
            }
            case 26: 
            case 35: {
                this.bindVariable((Variable)xSLObject, processorState);
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 12: 
            case 27: 
            case 38: {
                try {
                    this.createNode(xSLObject, processorState);
                }
                catch (XSLException xSLException) {
                    this.receiveError(xSLException);
                }
                break;
            }
            case 11: {
                CopyOf copyOf = (CopyOf)xSLObject;
                try {
                    NodeSet nodeSet2 = copyOf.selectNodes(processorState);
                    int n = 0;
                    while (n < nodeSet2.size()) {
                        this.copyOf(nodeSet2.item(n), processorState);
                        ++n;
                    }
                }
                catch (XPathException xPathException) {
                    this.receiveError(xPathException);
                }
                break;
            }
            case 33: {
                XSLText xSLText = (XSLText)xSLObject;
                ResultFormatter resultFormatter = processorState.getResultFormatter();
                char[] cArray = xSLText.getCharArray();
                if (xSLText.disableOutputEscaping()) {
                    resultFormatter.unescapedCharacters(cArray, 0, cArray.length);
                    break;
                }
                resultFormatter.characters(cArray, 0, cArray.length);
                break;
            }
            case 6: {
                String string4 = ((XSLCData)xSLObject).getText();
                processorState.getResultFormatter().cdata(string4);
                break;
            }
            case 20: {
                String string5;
                ResultFormatter resultFormatter = processorState.getResultFormatter();
                string = this.getResolvedName(xSLObject.getTypeName());
                String string6 = "";
                int n = string.indexOf(58);
                if (n >= 0) {
                    string6 = string.substring(0, n);
                    string = string.substring(n + 1);
                }
                if (!resultFormatter.isNamespaceDeclared(string5 = processorState.getNamespaceURI(string6))) {
                    resultFormatter.declareNamespace(string6, string5);
                }
                resultFormatter.startElement(string, string5);
                this.processAttributes(xSLObject, processorState, true);
                ActionTemplate actionTemplate = xSLObject.getActions();
                if (actionTemplate.size() > 0) {
                    ActionIterator actionIterator = actionTemplate.actions();
                    processorState.newVariableScope();
                    while (actionIterator.hasNext()) {
                        this.processAction(actionIterator.next(), processorState);
                    }
                    processorState.freeVariableScope();
                }
                resultFormatter.endElement(string, string5);
                break;
            }
        }
        processorState.popAction();
    }

    private void processAttributeSets(String string, ProcessorState processorState) {
        if (string == null || string.length() == 0) {
            return;
        }
        Tokenizer tokenizer = new Tokenizer(string);
        while (tokenizer.hasMoreTokens()) {
            String string2;
            String string3 = tokenizer.nextToken();
            AttributeSet attributeSet = this.stylesheet.getAttributeSet(string3);
            if (attributeSet == null) continue;
            String string4 = "use-attribute-sets";
            String string5 = attributeSet.getAttribute(string4);
            if (string5 == null && (string2 = this.stylesheet.getXSLNSPrefix()) != null && string2.length() > 0) {
                string4 = String.valueOf(string2) + ':' + string4;
                string5 = attributeSet.getAttribute(string4);
            }
            if (string5 != null) {
                this.processAttributeSets(string5, processorState);
            }
            if (attributeSet == null) continue;
            this.processTemplate(attributeSet.getActions(), processorState);
        }
    }

    private void processAttributes(XSLObject xSLObject, ProcessorState processorState, boolean bl) {
        AttributeList attributeList = xSLObject.getAttributes();
        AttributeValueTemplate attributeValueTemplate = null;
        ResultFormatter resultFormatter = processorState.getResultFormatter();
        int n = 0;
        while (n < attributeList.getLength()) {
            String string;
            String string2 = attributeList.getName(n);
            String string3 = attributeList.getValue(n);
            String string4 = XMLUtil.getNameSpacePrefix(string2);
            String string5 = null;
            if (string4.length() > 0) {
                string5 = processorState.getNamespaceURI(string4);
            }
            if (processorState.isXSLTNamespace(string4)) {
                if (bl && "use-attribute-sets".equals(string = XMLUtil.getLocalPart(string2))) {
                    this.processAttributeSets(string3, processorState);
                }
            } else if (string3.indexOf(123) < 0) {
                resultFormatter.attribute(string2, string3, string5);
            } else {
                try {
                    string = attributeList.getValue(n);
                    attributeValueTemplate = processorState.getAttributeValueTemplate(string);
                }
                catch (XPathException xPathException) {
                    attributeValueTemplate = null;
                }
                if (attributeValueTemplate != null) {
                    try {
                        string3 = attributeValueTemplate.evaluate(processorState);
                    }
                    catch (XSLException xSLException) {
                        this.receiveError(xSLException);
                    }
                    string3 = Whitespace.stripSpace(string3, true, true);
                } else {
                    string3 = "";
                }
                resultFormatter.attribute(string2, string3, string5);
            }
            ++n;
        }
    }

    private void processParameters(XSLObject xSLObject, ProcessorState processorState) {
        ScopedVariableSet scopedVariableSet = processorState.getParameters();
        ActionTemplate actionTemplate = xSLObject.getActions();
        if (actionTemplate.size() > 0) {
            ActionIterator actionIterator = actionTemplate.actions();
            while (actionIterator.hasNext()) {
                XSLObject xSLObject2 = actionIterator.next();
                if (xSLObject2.getType() != 37) break;
                Variable variable = (Variable)xSLObject2;
                XPathResult xPathResult = this.processVariable(variable, processorState);
                scopedVariableSet.setVariable(variable.getName(), xPathResult);
            }
        }
    }

    private void processTemplate(ActionTemplate actionTemplate, ProcessorState processorState) {
        Object object;
        XPathNode xPathNode = processorState.getNode();
        boolean bl = false;
        if (xPathNode != null && xPathNode.getNodeType() == 1 && (object = xPathNode.getAttribute(null, "xml:space")) != null && ((String)object).length() > 0) {
            processorState.getXMLSpaceModes().push(object);
            bl = true;
        }
        if (actionTemplate != null) {
            if (actionTemplate.size() > 0) {
                processorState.newVariableScope();
                object = actionTemplate.actions();
                while (object.hasNext()) {
                    this.processAction(object.next(), processorState);
                }
                processorState.freeVariableScope();
            }
        } else {
            if (xPathNode == null) {
                return;
            }
            object = processorState.getResultFormatter();
            switch (xPathNode.getNodeType()) {
                case 1: 
                case 9: {
                    this.processAction(this.selectChildren, processorState);
                    break;
                }
                case 2: {
                    ((ResultFormatter)object).characters(xPathNode.getStringValue());
                    break;
                }
                case 3: {
                    if (this.isStripSpaceAllowed(xPathNode, processorState)) {
                        this.stripSpace(xPathNode, (ResultFormatter)object);
                        break;
                    }
                    ((ResultFormatter)object).characters(xPathNode.getStringValue());
                    break;
                }
            }
        }
        if (bl) {
            processorState.getXMLSpaceModes().pop();
        }
    }

    XPathResult processVariable(Variable variable, ProcessorState processorState) {
        String string = variable.getAttribute("select");
        XPathResult xPathResult = null;
        if (string != null && string.length() > 0) {
            try {
                XPathExpression xPathExpression = this._parser.createExpression(string);
                xPathResult = xPathExpression.evaluate(processorState);
            }
            catch (XPathException xPathException) {
                String string2 = "variable binding error: '" + variable.getName();
                string2 = String.valueOf(string2) + "'";
                this.receiveError((Exception)xPathException, string2);
            }
        } else {
            XPNBuilder xPNBuilder = new XPNBuilder();
            processorState.pushHandler(xPNBuilder);
            XPathNode xPathNode = xPNBuilder.startFragment();
            this.processTemplate(variable.getActions(), processorState);
            XPathNode xPathNode2 = xPathNode.getFirstChild();
            if (xPathNode2 == null) {
                xPathResult = new TreeFragmentResult();
            } else if (xPathNode2.getNext() == null) {
                xPathResult = new TreeFragmentResult(xPathNode2);
            } else {
                NodeSet nodeSet = new NodeSet(xPathNode2);
                while ((xPathNode2 = xPathNode2.getNext()) != null) {
                    nodeSet.add(xPathNode2);
                }
                xPathResult = new TreeFragmentResult(nodeSet);
            }
            processorState.popHandler();
        }
        return xPathResult;
    }

    private void processXSLNumber(XPathNode xPathNode, XSLNumber xSLNumber, ProcessorState processorState) {
        String string = xSLNumber.getFormattedNumber(xPathNode, processorState);
        processorState.getResultFormatter().characters(string);
    }

    public MessageObserver removeMessageObserver(MessageObserver messageObserver) {
        if (this.msgObservers.remove(messageObserver)) {
            return messageObserver;
        }
        return null;
    }

    public void setParameter(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        if (string.length() > 0) {
            ((Hashtable)this.params).put(string, string2);
        }
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this._uriResolver = uRIResolver != null ? uRIResolver : new URIResolverImpl();
    }

    private void stripSpace(XPathNode xPathNode, ResultFormatter resultFormatter) {
        if (xPathNode.getNodeType() != 3) {
            return;
        }
        boolean bl = xPathNode.getPrevious() == null;
        boolean bl2 = xPathNode.getNext() == null;
        String string = xPathNode.getStringValue();
        if (string != null && string.length() > 0) {
            char[] cArray = string.toCharArray();
            int n = Whitespace.stripSpace(cArray, bl, bl2);
            resultFormatter.characters(cArray, 0, n);
        }
    }
}

