/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.xerces.parsers.SAXParser;
import org.exolab.adaptx.xml.parser.DOMParser;
import org.xml.sax.Parser;

public class Configuration {
    public static final String DEFAULT_PARSER = "org.exolab.adaptx.xml.parser.XercesParser";
    public static final String DEFAULT_PARSER_NAME = "DefaultParser";
    public static final String DOM_PARSER = "parser.dom";
    public static final String SAX_PARSER = "parser.sax";
    public static final String PROPERTIES_FILE = "adaptx.properties";
    private static final String PROPERTIES_PATH = "org/exolab/adaptx";
    private static boolean loaded = false;
    private static Properties props = null;
    private static DOMParser _DOMParser = null;
    static /* synthetic */ Class class$org$exolab$adaptx$xslt$util$Configuration;

    private Configuration() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static void createDefaultProperties() {
        props = new Properties();
        ((Hashtable)props).put(DOM_PARSER, DEFAULT_PARSER);
    }

    public static DOMParser getDOMParser() {
        String string;
        if (_DOMParser != null) {
            return _DOMParser.copyInstance();
        }
        if (!loaded) {
            Configuration.loadProperties();
        }
        if ((string = Configuration.getProperty(DOM_PARSER)) == null) {
            ((Hashtable)props).put(DOM_PARSER, DEFAULT_PARSER);
        }
        try {
            Class<?> clazz = Class.forName(string);
            _DOMParser = (DOMParser)clazz.newInstance();
        }
        catch (Exception exception) {
            String string2 = "unable to load DOM parser: " + string;
            string2 = String.valueOf(string2) + " (" + string + ")\n -- ";
            string2 = String.valueOf(string2) + exception.getMessage();
            string2 = String.valueOf(string2) + "\n -- please reconfigure the properties file '";
            string2 = String.valueOf(string2) + "adaptx.properties' and try again.";
            throw new RuntimeException(string2);
        }
        return _DOMParser;
    }

    public static String getProperty(String string) {
        if (string == null) {
            return null;
        }
        if (!loaded) {
            Configuration.loadProperties();
        }
        String string2 = null;
        String string3 = props.getProperty(string);
        while (string3 != null) {
            string2 = string3;
            string3 = props.getProperty(string3);
        }
        return string2;
    }

    private static InputStream getResourceAsStream(String string) {
        return (class$org$exolab$adaptx$xslt$util$Configuration != null ? class$org$exolab$adaptx$xslt$util$Configuration : (class$org$exolab$adaptx$xslt$util$Configuration = Configuration.class$("org.exolab.adaptx.xslt.util.Configuration"))).getResourceAsStream(string);
    }

    public static Parser getSAXParser() {
        Object object = null;
        object = new SAXParser();
        if (object != null) {
            return object;
        }
        String string = Configuration.getProperty(SAX_PARSER);
        try {
            if (string != null && string.length() > 0) {
                Class<?> clazz = Class.forName(string);
                object = (Parser)clazz.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        return object;
    }

    private static void loadProperties() {
        props = new Properties();
        try {
            InputStream inputStream = null;
            File file = new File(PROPERTIES_FILE);
            inputStream = file.exists() ? new FileInputStream(file) : ((file = new File(PROPERTIES_PATH, PROPERTIES_FILE)).exists() ? new FileInputStream(file) : Configuration.getResourceAsStream("/org/exolab/adaptxadaptx.properties"));
            if (inputStream != null) {
                props.load(inputStream);
            } else {
                Configuration.createDefaultProperties();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            Configuration.createDefaultProperties();
        }
        loaded = true;
    }

    public static void setDOMParser(DOMParser dOMParser) {
        _DOMParser = dOMParser;
    }

    public static void setProperty(String string, String string2) {
        ((Hashtable)props).put(string, string2);
        if (DOM_PARSER.equals(string)) {
            _DOMParser = null;
        }
    }
}

