#ifndef __DBUS_PROXY_DBUS_EXAMPLE_CALCULATOR_H
#define __DBUS_PROXY_DBUS_EXAMPLE_CALCULATOR_H

#include <dbus-cxx.h>

#include "calculator.h"


namespace DBus {
  namespace Example {

    class CalculatorProxy : public ::DBus::ObjectProxy
    {
      protected:
        CalculatorProxy( ::DBus::Connection::pointer conn, const std::string& dest="dbuscxx.example.calculator.server", const std::string& path="/dbuscxx/example/Calculator"):
          ::DBus::ObjectProxy(conn, dest, path)
        {
          ::DBus::Path child_path;

          m_method_add_ddd = this->create_method< double,double,double >( "Calculator.Basic", "add" );
          m_method_sub_ddd = this->create_method< double,double,double >( "Calculator.Basic", "sub" );
          m_method_mul_ddd = this->create_method< double,double,double >( "Calculator.Basic", "mul" );
          m_method_div_ddd = this->create_method< double,double,double >( "Calculator.Basic", "div" );
          m_method_pi_d = this->create_method< double >( "Calculator.Basic", "pi" );
          m_method_print_pi_v = this->create_method< void >( "Calculator.Basic", "print_pi" );
          m_signal_calculation = this->create_signal<void,std::string,std::string,double,double,double>( "Calculator.Basic", "calculation" );
          m_method_factorial_ty = this->create_method< uint64_t,uint8_t >( "Calculator.Computed", "factorial" );
          m_method_fibonacci_ty = this->create_method< uint64_t,uint8_t >( "Calculator.Computed", "fibonacci" );
          m_method_thue_morse_ty = this->create_method< uint64_t,uint8_t >( "Calculator.Computed", "thue_morse" );
          m_signal_computation = this->create_signal<void,std::string,uint64_t,uint8_t>( "Calculator.Computed", "computation" );
        }

      public:

        typedef DBusCxxPointer<CalculatorProxy> pointer;

        static pointer create( ::DBus::Connection::pointer conn,
                               const std::string& dest="dbuscxx.example.calculator.server",
                               const std::string& path="/dbuscxx/example/Calculator"
                             )
        { return pointer( new CalculatorProxy(conn, dest, path)); }


        double add( double a, double b ) { return (*m_method_add_ddd)( a, b); }

        double subtract( double a, double b ) { return (*m_method_sub_ddd)( a, b); }

        double multiply( double a, double b ) { return (*m_method_mul_ddd)( a, b); }

        double divide( double a, double b ) { return (*m_method_div_ddd)( a, b); }

        double pi( ) { return (*m_method_pi_d)(); }

        void print_pi( ) { return (*m_method_print_pi_v)(); }

        ::DBus::signal_proxy<void,std::string,std::string,double,double,double >& signal_calculation() { return *m_signal_calculation; }

        uint64_t factorial( uint8_t n ) { return (*m_method_factorial_ty)( n); }

        uint64_t fibonacci( uint8_t n ) { return (*m_method_fibonacci_ty)( n); }

        uint64_t thue_morse( uint8_t n ) { return (*m_method_thue_morse_ty)( n); }

        ::DBus::signal_proxy<void,std::string,uint64_t,uint8_t >& signal_computation() { return *m_signal_computation; }


      protected:


        ::DBus::MethodProxy<double,double,double>::pointer m_method_add_ddd;
        ::DBus::MethodProxy<double,double,double>::pointer m_method_sub_ddd;
        ::DBus::MethodProxy<double,double,double>::pointer m_method_mul_ddd;
        ::DBus::MethodProxy<double,double,double>::pointer m_method_div_ddd;
        ::DBus::MethodProxy<double>::pointer m_method_pi_d;
        ::DBus::MethodProxy<void>::pointer m_method_print_pi_v;
        ::DBus::signal_proxy<void,std::string,std::string,double,double,double>::pointer m_signal_calculation;

        ::DBus::MethodProxy<uint64_t,uint8_t>::pointer m_method_factorial_ty;
        ::DBus::MethodProxy<uint64_t,uint8_t>::pointer m_method_fibonacci_ty;
        ::DBus::MethodProxy<uint64_t,uint8_t>::pointer m_method_thue_morse_ty;
        ::DBus::signal_proxy<void,std::string,uint64_t,uint8_t>::pointer m_signal_computation;


    };

  }
}

#endif
