// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/
#include "gui.h"

#include "global.h"
#include "codeconv.h"
#include "honmon.h"

#ifdef USE_ICONV
#include <clocale>
#endif
#ifdef ENABLE_NLS
#include <libintl.h>
#endif

#ifdef HAVE_LANGINFO_H
#include <langinfo.h>
#endif

// ********** Global Widgets *******
GtkWidget* mainWindow=NULL;
GtkWidget* mainBox;
GtkWidget* resultText;
GtkWidget* filew;
GtkWidget* wordBox;
GtkWidget* hiddenWordBox;
GtkWidget* resultScroll;
GtkWidget* hpaned;
GtkWidget* dicTitle=NULL;

GtkAccelGroup* accelGroup;
GdkGC *gc_temp;
GdkGC *gc;
GdkGC *gc_color[32];
GdkGC *gc_red;
GdkGC *gc_blue;
GdkGC *gc_green;
GdkGC *gc_inv;
GdkGC *gc_red_inv;
GdkGC *gc_blue_inv;
GdkGC *gc_green_inv;
GdkFont *normalFont,*italicFont,*boldFont,*boldItalicFont,*scriptFont,*isoFont;
GAIJI* currentGaiji;

int colorTable[][3]={
  {0xffff,0xffff,0xffff},
  {0xffff,0xffff,0x0000},
  {0x0000,0xffff,0xffff},
  {0x0000,0xffff,0x0000},
  {0x8000,0x8000,0x8000},
  {0x4000,0x4000,0x4000},
  {0x8000,0x8000,0x0000},
  {0xffff,0x0000,0xffff},
  {0x0000,0x8000,0x8000},
  {0xffff,0x0000,0x0000},
  {0x0000,0x8000,0x0000},
  {0x8000,0x0000,0x8000},
  {0x8000,0x0000,0x0000},
  {0x0000,0x0000,0xffff},
  {0x0000,0x0000,0x8000},
  {0x0000,0x0000,0x0000},
};




#include "buildwin.h"
#include "callback.h"


void Resize(GtkWidget *widget, GdkEventConfigure *event){
  gtk_window_set_default_size(GTK_WINDOW(mainWindow),
			      event->width,event->height);
}

void MainRealize(){
  int w=preference.GetIntValue("/ebdic/preference/geometry/w");
  int h=preference.GetIntValue("/ebdic/preference/geometry/h");
  if (w>0 && h>0) gtk_window_set_default_size(GTK_WINDOW(mainWindow),w,h);
}

void MainMap(){
  int x=preference.GetIntValue("/ebdic/preference/geometry/x");
  int y=preference.GetIntValue("/ebdic/preference/geometry/y");
  if (x>0 && y>0) gtk_window_reposition(GTK_WINDOW(mainWindow),x,y);
}

void PanedMap(){
  /*
  int w=preference.GetIntValue("/ebdic/preference/geometry/hit-window-width");
  fprintf(stderr,"w=%d\n",w);
  if (w>0) gtk_paned_set_position(GTK_PANED(hpaned),w);
  gtk_widget_queue_resize(GTK_WIDGET(hpaned));
  */
}


static bool CreateMainWindow(void){
  // ********** Create Main Window ************
  mainWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect (GTK_OBJECT (mainWindow), "destroy",
                      GTK_SIGNAL_FUNC (winDestroy), NULL);
  gtk_signal_connect (GTK_OBJECT (mainWindow), "map",
                      GTK_SIGNAL_FUNC (MainMap), NULL);
  gtk_signal_connect (GTK_OBJECT (mainWindow), "realize",
                      GTK_SIGNAL_FUNC (MainRealize), NULL);
  gtk_container_border_width (GTK_CONTAINER (mainWindow), 3);
  //  gtk_widget_set_usize( GTK_WIDGET (mainWindow), 780, 550);
  gtk_window_set_title( GTK_WINDOW (mainWindow), _("EbDic"));
  gtk_widget_show (mainWindow);
  accelGroup=gtk_accel_group_new();
  CreateInvisibleButtons();
  gtk_accel_group_attach(accelGroup,GTK_OBJECT(mainWindow));
  GtkWidget* toolbar=CreateToolBar(mainWindow);

  hiddenWordBox=gtk_entry_new_with_max_length(100);

  //  gtk_timeout_add(500,SelectionPolling,NULL);

  gtk_widget_set_events(wordBox,GDK_ALL_EVENTS_MASK);

  // ********** Create Result Box **********
  //    ** Create Result Word List **

  resultScroll=gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (resultScroll),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);
  //  gtk_widget_set_usize(resultScroll,100,400);

  //    ** Create Result Text **

  resultText=gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (resultText),
				  GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);

  //  resultText=gtk_hbox_new (FALSE,0);
  //  gtk_widget_set_usize(resultText,390,400);

  //  *** Create Result Window Pair
  hpaned=gtk_hpaned_new();
  gtk_paned_add1 (GTK_PANED(hpaned),resultScroll);
  gtk_widget_show (resultScroll);
  gtk_paned_add2 (GTK_PANED(hpaned),resultText);
  gtk_widget_show (resultText);

  gtk_signal_connect (GTK_OBJECT (hpaned), "map",
                      GTK_SIGNAL_FUNC (PanedMap), NULL);


  // ******** Create Main Window ***********

  mainBox = gtk_vbox_new(false, 0);
  gtk_box_pack_start(GTK_BOX(mainBox), toolbar, false, false, 1);
  gtk_widget_show(toolbar);
  //  gtk_box_pack_start(GTK_BOX(mainBox), wordBox, false,false,1);
  //  gtk_widget_show(wordBox);
  //  gtk_box_pack_start(GTK_BOX(mainBox), hiddenWordBox, false,false,1);
  //  gtk_widget_show(hiddenWordBox);
  gtk_box_pack_start(GTK_BOX(mainBox), hpaned, true, true,1);
  gtk_widget_show (hpaned);

  gtk_container_add(GTK_CONTAINER(mainWindow), mainBox);
  gtk_widget_show(mainBox);
  gtk_widget_grab_focus(wordBox);
  //  gtk_widget_grab_default(wordBox);

  /*
  bool r=false;
  if (defaultConfigFile!=NULL) r=ReadConf(defaultConfigFile);
  if (r==false && getenv("EBDICCONF")!=NULL){ 
    r=ReadConf(getenv("EBDICCONF"));
  };
  if (r==false && getenv("HOME")!=NULL){ 
    r=ReadConf((string(getenv("HOME"))+"/.ebdic").c_str());
  };
  if (r==false) r=ReadConf(PKGDATADIR "/ebdic.conf");
  */

  gc=gdk_gc_new(mainWindow->window);
  gc_temp=gc;
  gc_inv=gdk_gc_new(mainWindow->window);
  gdk_gc_set_foreground(gc,&mainWindow->style->black);
  gdk_gc_set_background(gc,&mainWindow->style->bg[GTK_STATE_NORMAL]);
  gdk_gc_set_foreground(gc_inv,&mainWindow->style->bg[GTK_STATE_NORMAL]);
  gdk_gc_set_background(gc_inv,&mainWindow->style->black);

  for(int i=0;i<32;i++) gc_color[i]=gdk_gc_new(mainWindow->window);
  for(int i=0;i<16;i++){
    GdkColor col1;
    col1.red=colorTable[i][0];
    col1.green=colorTable[i][1];
    col1.blue=colorTable[i][2];
    gdk_color_alloc(gtk_widget_get_colormap(mainWindow),&col1);
    gdk_gc_set_foreground(gc_color[i],&col1);
    gdk_gc_set_background(gc_color[i],
			  &mainWindow->style->bg[GTK_STATE_NORMAL]);
    gdk_gc_set_function (gc_color[i],GDK_COPY);

    gdk_gc_set_background(gc_color[31-i],&col1);
    gdk_gc_set_foreground(gc_color[31-i],
			  &mainWindow->style->bg[GTK_STATE_NORMAL]);
    gdk_gc_set_function (gc_color[31-i],GDK_COPY);
  }
  for(int i=28;i<32;i++){
    gdk_gc_set_foreground(gc_color[i],&mainWindow->style->black);
  }

  gc_red=gdk_gc_new(mainWindow->window);
  gc_red_inv=gdk_gc_new(mainWindow->window);
  GdkColor col1;
  col1.red=0xffff;
  col1.blue=0;
  col1.green=0;
  gdk_color_alloc(gtk_widget_get_colormap(mainWindow),&col1);
  gdk_gc_set_foreground(gc_red,&col1);
  gdk_gc_set_background(gc_red,&mainWindow->style->bg[GTK_STATE_NORMAL]);
  gdk_gc_set_foreground(gc_red_inv,&mainWindow->style->bg[GTK_STATE_NORMAL]);
  gdk_gc_set_background(gc_red_inv,&col1);

  gc_blue=gdk_gc_new(mainWindow->window);
  gc_blue_inv=gdk_gc_new(mainWindow->window);
  col1.red=0;
  col1.blue=0xffff;
  col1.green=0;
  gdk_color_alloc(gtk_widget_get_colormap(mainWindow),
		  &col1);
  gdk_gc_set_foreground(gc_blue,&col1);
  gdk_gc_set_background(gc_blue,&mainWindow->style->bg[GTK_STATE_NORMAL]);
  gdk_gc_set_foreground(gc_blue_inv,&mainWindow->style->bg[GTK_STATE_NORMAL]);
  gdk_gc_set_background(gc_blue_inv,&col1);

  gc_green=gdk_gc_new(mainWindow->window);
  gc_green_inv=gdk_gc_new(mainWindow->window);
  col1.red=0;
  col1.blue=0;
  col1.green=0xffff;
  gdk_color_alloc(gtk_widget_get_colormap(mainWindow),&col1);
  gdk_gc_set_foreground(gc_green,&col1);
  gdk_gc_set_background(gc_green,&mainWindow->style->bg[GTK_STATE_NORMAL]);
  gdk_gc_set_foreground(gc_green_inv,&mainWindow->style->bg[GTK_STATE_NORMAL]);
  gdk_gc_set_background(gc_green_inv,&col1);

#if 0
  normalFont=gdk_fontset_load("-misc-variable-medium-r-normal--17-*-iso10646-1,-*-courier-medium-r-normal--17-*,-*-fixed-medium-r-normal--16-*,*");
  boldFont=italicFont=boldItalicFont=gdk_fontset_load("-misc-variable-medium-r-normal--17-120-100-100-p-101-iso10646-1,-*-courier-medium-r-normal--17-*,-*-fixed-medium-r-normal--16-*,*");
  scriptFont=gdk_fontset_load("-misc-biwidth-medium-r-normal--13-180-75-75-c-80-iso10646-1,-*--13-*,*");
  
  setlocale(LC_ALL,"en_US.ISO8859-1");
  isoFont=gdk_fontset_load("-misc-fixed-medium-r-normal--14-*-iso8859-1");
  setlocale(LC_ALL,"");
#endif
#if 0
  normalFont=gdk_fontset_load("-*-courier-medium-r-normal--17-*,-*-fixed-medium-r-normal--16-*,*");
  boldFont=gdk_fontset_load("-*-courier-bold-r-normal--17-*,-*-*-bold-r-normal--16-*,-*-fixed-medium-r-normal--16-*,*");
  italicFont=gdk_fontset_load("-*-courier-medium-o-normal--17-*,-*-*-medium-i-normal--16-*,-*-fixed-medium-r-normal--16-*,*");
  boldItalicFont=gdk_fontset_load("-*-courier-bold-o-normal--17-*,-*-*-bold-i-normal--16-*,-*-fixed-medium-r-normal--16-*,*");
  scriptFont=gdk_fontset_load("-*-courier-medium-r-normal--8-*,-*-fixed-medium-*--8-*,*");
  setlocale(LC_ALL,"en_US.ISO8859-1");
  isoFont=gdk_fontset_load("-misc-fixed-medium-r-normal--14-*-iso8859-1");
  setlocale(LC_ALL,"");
#endif
#if 0
  normalFont=gdk_fontset_load("-misc-variable-medium-r-normal--17-*-iso10646-1,-*-courier-medium-r-normal--17-*,-*-fixed-medium-r-normal--16-*,*");
  boldFont=gdk_fontset_load("-*-courier-bold-r-normal--17-*,-*-*-bold-r-normal--16-*,-misc-variable-medium-r-normal--17-*-iso10646-1,-*-fixed-medium-r-normal--16-*,*");
  italicFont=gdk_fontset_load("-*-courier-medium-o-normal--17-*,-*-*-medium-i-normal--16-*,-misc-variable-medium-r-normal--17-*-iso10646-1,-*-fixed-medium-r-normal--16-*,*");
  boldItalicFont=gdk_fontset_load("-*-courier-bold-o-normal--17-*,-*-*-bold-i-normal--16-*,-misc-variable-medium-r-normal--17-*-iso10646-1,-*-fixed-medium-r-normal--16-*,*");
  scriptFont=gdk_fontset_load("-misc-biwidth-medium-r-normal--13-*-iso10646-1,-*-courier-medium-r-normal--8-*,-*-fixed-medium-*--8-*,*");
  setlocale(LC_ALL,"en_US.ISO8859-1");
  isoFont=gdk_fontset_load("-misc-fixed-medium-r-normal--14-*-iso8859-1");
  setlocale(LC_ALL,"");
#endif
#if 0
  normalFont=gdk_fontset_load("-misc-variable-medium-r-normal--17-*-iso10646-1,-*-courier-medium-r-normal--17-*,-*-fixed-medium-r-normal--16-*,*");
  boldFont=normalFont;
  italicFont=normalFont;
  boldItalicFont=
  scriptFont=gdk_fontset_load("-*-fixed-medium-*--8-*-iso8859-*,-*-courier-medium-r-normal--8-*,-misc-biwidth-medium-r-normal--13-*-iso10646-1,*");
  setlocale(LC_ALL,"en_US.ISO8859-1");
  isoFont=gdk_fontset_load("-misc-fixed-medium-r-normal--14-*-iso8859-1");
  setlocale(LC_ALL,"");
#endif

  normalFont=gdk_fontset_load
    (preference.GetStringValue("/ebdic/fontset/normal").c_str());
  boldFont=gdk_fontset_load
    (preference.GetStringValue("/ebdic/fontset/bold").c_str());
  italicFont=gdk_fontset_load
    (preference.GetStringValue("/ebdic/fontset/italic").c_str());
  boldItalicFont=gdk_fontset_load
    (preference.GetStringValue("/ebdic/fontset/bold-italic").c_str());
  scriptFont=gdk_fontset_load
    (preference.GetStringValue("/ebdic/fontset/script").c_str());
  setlocale(LC_ALL,"en_US.ISO8859-1");
  isoFont=gdk_fontset_load
    (preference.GetStringValue("/ebdic/fontset/iso8859-1").c_str());
  setlocale(LC_ALL,"");


  gtk_signal_connect(GTK_OBJECT(wordBox), "expose_event",
		     GTK_SIGNAL_FUNC(Refresh),NULL);

  gtk_signal_connect(GTK_OBJECT(resultText), "expose_event",
		     GTK_SIGNAL_FUNC(Refresh),NULL);

  gtk_signal_connect(GTK_OBJECT(mainWindow),"configure_event",
		     GTK_SIGNAL_FUNC(Resize),mainWindow);
  return true;
}


int main(int argc, char **argv){
  // Debug::Level(Debug::INDEX_DECODE | Debug::HONMON_CONTROL | 
  //                Debug::VERBOSE);

  unsetenv("OUTPUT_CHARSET");

#ifdef DEBUG
  //  Debug::Level(DEBUG & ~Debug::LOW_LEVEL_FILE & ~Debug::FILE_CACHE & 
  //	       ~Debug::INDEX_DECODE & ~Debug::NDTP & ~Debug::CODE);
  Debug::Level(DEBUG);
  Debug::DebugOut(Debug::TEMP,"DEBUG LEVEL = %d\n",DEBUG);
#else
  Debug::Level(0);
#endif
  gtk_set_locale();
#ifdef ENABLE_NLS
  textdomain(PACKAGE);
#endif

  CODECONV::Initialize();

  fprintf(stderr,PACKAGE "-" VERSION "\n");
  fprintf(stderr,_("Copyright (C) 1998-2001 Takashi NEMOTO\n"));

  gtk_init (&argc, &argv);
  //  gdk_rgb_init();
  currentGaiji=NULL;
  char* defaultConfigFile=NULL;
  if (argc>1) {
    defaultConfigFile=argv[1];
  }

  if (!preference.Read(defaultConfigFile)) preference.Reset();


  CreateMainWindow();
  PreferenceChanged();

  gtk_main();
  return 0;

}
