// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#ifndef __gaiji_h__
#define __gaiji_h__

#include "def.h"
#include "bfile.h"
#include <map>

class NdtpIO;

class GaijiChar {
  int width;
  int height;
  int size;
  byte* bitmap;

  void copy(const GaijiChar& g);
public:
  GaijiChar(int w,int h,const byte* bmp);
  GaijiChar(const GaijiChar&);
  const GaijiChar& operator=(const GaijiChar&);
  int Width() const { return width; };
  int Height() const { return height; };
  int Size() const { return size; };
  const byte* Bitmap() const { return bitmap; };
};

class GAIJI {
  static byte rTbl[256];
  static bool rTblInitialized;
  std::map<int, GaijiChar*> gaijiMap;
  void ReadFile(BlockIO* pf,int startBlock);
  void ReadNdtp(NdtpIO* pf,int size);
 public:
  GAIJI(const char* fileName,const char* fileName2=NULL);
  GAIJI(BlockIO* pf,int size);
  GAIJI(BlockIO* pf,int startBlock,int startBlock2);
  virtual ~GAIJI();
  GaijiChar* Gaiji(int code);
};

#endif

