// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include "def.h"
#include "bfile.h"

int dump(const unsigned char *buf,int length,int flag,int offset) {
  int x=0;
  int buf2[16];
  int adrs=0;
  buf+=offset;
  do {
    if (x==0) fprintf(stdout,"%04d ",adrs);
    fprintf(stdout,"%02X",*buf);
    if ((x & 1)==1) putchar(' ');
    buf2[x]=*(buf++);
    adrs++;
    x++;
    if (x>15) {
      x=0;
      for(int i=0;i<16;i++) {
	unsigned char ch=buf2[i];
	if (ch<0x20 || ch>126) ch='.';
	putchar(ch);
      }
      putchar(' ');
      for(int i=0;i<16;i++) {
	if (flag==1) {
	  unsigned char ch=buf2[i];
	  if (ch=='@') { 
	    ch='@'; 
	  } else if (ch>=0xf0) {
	    ch='0'+(ch&15);
	  } else if (ch>=0xd0) {
	    ch-=0xc0;
	    ch=((ch & 0x70) >> 1)+(ch&15)+0x41;
	  } else if (ch>=0xc0) {
	    ch-=0xc0;
	    ch=(ch&15)+0x40;
	  } else if (ch<' ') {
	    ch='.';
	  };
	  putchar(ch);
	} else if (buf2[i]<32 || buf2[i]>127) {
	  fprintf(stdout,".");
	} else if (flag==0 || (flag==2 && buf2[i-1]<0x20)) {
	  putchar(buf2[i]);
	} else if (flag==2 || flag==3) {
	  if ((i & 1)==0 && 
	      buf2[i]>0x20 && buf2[i]<127 && buf2[i+1]>0x20 && buf2[i+1]<127){
	    putchar(buf2[i]|0x80);
	    putchar(buf2[i+1]|0x80);
	    i++;
	  } else {
	    putchar('.');
	  }
	}
      };
      fprintf(stdout,"\n");
    };
  } while (adrs<length);
  return 1;
}
  
int main(int argc,char **argv){
  int asc=3;
  char *file="honmon.zl";
  char *ARG0=argv[0];
  byte buf[2049];
  int offset;
  long size;

#ifdef DEBUG
  Debug::Level(DEBUG);
  Debug::DebugOut(Debug::TEMP,"DEBUG LEVEL = %d\n",DEBUG);
#else
  Debug::Level(0);
#endif

  while(argc>1 && argv[1][0]=='-') {
    fprintf(stderr,"ARGC=%d \n",argc);
    if (argc>=5 && strcmp(argv[1],"-b")==0){
      size=atol(argv[2]);
      fprintf(stderr,"BIN MODE size=%ld\n",size);
      argv+=3; argc-=3; asc=-1;
    } 
    if (argc>=3 && strcmp(argv[1],"-a")==0){
      argv++; argc--; asc=0;
    } else if (argc>=3 && strcmp(argv[1],"-x")==0){
      argv++; argc--; asc=1;
    } else if (argc>=3 && strcmp(argv[1],"-k")==0){
      argv++; argc--; asc=2;
    } else if (argc>=3 && strcmp(argv[1],"-f")==0) {
      file=argv[2];
      argv+=2; argc-=2;
    } else {
      argv++;
      argc--;
    }
  }
  if (argc<2 || argc>3) {
    printf("usage: %s [-a|-x|-k|-b <offset> <size>] [-f <file name>] block [offset]\n",ARG0);
    exit(1);
  }
  int block=strtol(argv[1],NULL,0);
  if (argc==3) {
    offset=strtol(argv[2],NULL,0);
  } else {
    offset=0;
  }
  BlockIO* pf=OpenDict(file);
  //  pf->Seek(TAG(block,0));

  if (!pf->ReadBlock(block,buf)){
    fprintf(stderr,"Read Error\n");
  };
  delete pf;
  if (asc>=0){
    dump(buf,cBlockSize-offset,asc,offset);
  } else {
    for(int i=0;i<size;i++){
      putchar(buf[i]);
      fflush(stdout);
    }
  }
};
