/*
 * Copyright (c) 2008-2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimcanon.h 653 2009-02-28 20:35:27Z takahiko $
 */

#ifndef __DKIM_CANON_H__
#define __DKIM_CANON_H__

#include <stdbool.h>
#include "dkim.h"
#include "dkimpolicy.h"

typedef struct DkimCanon DkimCanon;

extern DkimCanon *DkimCanon_new(const DkimPolicy *policy, dkim_canonalg_t headeralg,
                                dkim_canonalg_t bodyalg, dkim_stat_t *dstat);
extern void DkimCanon_free(DkimCanon *self);
extern void DkimCanon_reset(DkimCanon *self);
extern dkim_stat_t DkimCanon_header(DkimCanon *self, const char *headerf, const char *headerv,
                                    bool crlf, const unsigned char **canonbuf, size_t *canonsize);
extern dkim_stat_t DkimCanon_signheader(DkimCanon *self, const char *headerf, const char *headerv,
                                        const char *b_tag_value_head, const char *b_tag_value_tail,
                                        const unsigned char **canonbuf, size_t *canonsize);
extern dkim_stat_t DkimCanon_body(DkimCanon *self, const unsigned char *bodyp, size_t bodylen,
                                  const unsigned char **canonbuf, size_t *canonsize);
extern dkim_stat_t DkimCanon_bodyfin(DkimCanon *self, const unsigned char **canonbuf,
                                     size_t *canonsize);

#endif /* __DKIM_CANON_H__ */
