/*
 * Copyright (c) 2008-2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimspec.h 650 2009-02-28 20:29:48Z takahiko $
 */
// DKIM の仕様 (RFC4871) で定められている定数の宣言

#ifndef __DKIMSPEC_H__
#define __DKIMSPEC_H__

// FROM ヘッダのフィールド名
#define	FROMHEADER		"From"

// SENDER ヘッダのフィールド名
// #define  SENDERHEADER        "Sender"

// DKIM 署名ヘッダのフィールド名
#define	DKIM_SIGNHEADER		"DKIM-Signature"

// DKIM の公開鍵やポリシーレコードを DNS から探索する際に使用する名前空間
#define DKIM_DNS_NAMESPACE	"_domainkey"

// DKIM のポリシーレコードを DNS から探索する際に使用するセレクタ
#define DKIM_DNS_ADSP_SELECTOR	"_adsp"

// DKIM 公開鍵レコードのバージョン文字列
#define DKIM1_VERSION_TAG	"DKIM1"

// sig-l-tag, sig-t-tag, sig-x-tag の各タグ値の最大長
#define DKIM_SIG_L_TAG_LEN	76
#define DKIM_SIG_T_TAG_LEN	12
#define DKIM_SIG_X_TAG_LEN	12

// IIJ 仕様
// 公開鍵レコードを調べる際に何レコードまでトライするか. DoS 対策.
#define DKIM_PUBKEY_CANDIDATE_MAX	10

#endif /* __DKIMSPEC_H__ */
