/*
 * Copyright (c) 2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimpolicy.c 766 2009-03-22 08:16:29Z takahiko $
 */

#include "rcsid.h"
RCSID("$Id: dkimpolicy.c 766 2009-03-22 08:16:29Z takahiko $");

#include <assert.h>
#include <stdbool.h>
#include <stdio.h>
#include <syslog.h>
#include "strarray.h"
#include "dkim.h"
#include "dkimlogger.h"
#include "dkimpolicy.h"

void
DkimPolicy_init(DkimPolicy *self)
{
    self->sendmail813 = false;
    self->author_priority = NULL;
    self->logger = syslog;
}   // end function : DkimPolicy_init

void
DkimPolicy_cleanup(DkimPolicy *self)
{
    if (NULL != self->author_priority) {
        StrArray_free(self->author_priority);
    }   // end if
}   // end function : DkimPolicy_cleanup

void
DkimPolicy_setLogger(DkimPolicy *self, void (*logger) (int priority, const char *message, ...))
{
    self->logger = logger;
}   // end function : DkimPolicy_setLogger

void
DkimPolicy_setSendmail813(DkimPolicy *self, bool flag)
// TODO: もっといい名前つけたい
{
    self->sendmail813 = flag;
}   // end function : DkimPolicy_setSendmail813

dkim_stat_t
DkimPolicy_setAuthorPriority(DkimPolicy *self, const char *record, const char *delim)
{
    assert(NULL != self);

    if (NULL == record) {
        DkimLogConfigError(self, "empty value specified for author extraction priority");
        return DSTAT_CFGERR_EMPTY_VALUE;
    }   // end if

    if (NULL != self->author_priority) {
        // 既に設定されている場合は削除
        StrArray_free(self->author_priority);
    }   // end if
    self->author_priority = StrArray_split(record, delim, true);
    if (NULL == self->author_priority) {
        DkimLogNoResource(self);
        return DSTAT_SYSERR_NORESOURCE;
    }   // end if
    return DSTAT_OK;
}   // end function : DkimPolicy_setAuthorPriority
