/* ChannelList.c generated by valac, the Vala compiler
 * generated from ChannelList.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <dbus/dbus.h>


#define DVB_TYPE_ID_BUS_CHANNEL_LIST (dvb_id_bus_channel_list_get_type ())
#define DVB_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelList))
#define DVB_IS_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST))
#define DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelListIface))

typedef struct _DVBIDBusChannelList DVBIDBusChannelList;
typedef struct _DVBIDBusChannelListIface DVBIDBusChannelListIface;

#define DVB_TYPE_CHANNEL_INFO (dvb_channel_info_get_type ())
typedef struct _DVBChannelInfo DVBChannelInfo;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;
typedef struct _DVBChannelListPrivate DVBChannelListPrivate;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_IO_TYPE_CHANNEL_LIST_READER (dvb_io_channel_list_reader_get_type ())
#define DVB_IO_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReader))
#define DVB_IO_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderClass))
#define DVB_IO_IS_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER))
#define DVB_IO_IS_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_CHANNEL_LIST_READER))
#define DVB_IO_CHANNEL_LIST_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderClass))

typedef struct _DVBioChannelListReader DVBioChannelListReader;
typedef struct _DVBioChannelListReaderClass DVBioChannelListReaderClass;
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBChannelInfo {
	guint id;
	char* name;
	gboolean is_radio;
};

struct _DVBIDBusChannelListIface {
	GTypeInterface parent_iface;
	guint* (*GetChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	guint* (*GetRadioChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	guint* (*GetTVChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	gboolean (*GetChannelName) (DVBIDBusChannelList* self, guint channel_id, char** channel_name, GError** error);
	gboolean (*GetChannelNetwork) (DVBIDBusChannelList* self, guint channel_id, char** network, GError** error);
	gboolean (*IsRadioChannel) (DVBIDBusChannelList* self, guint channel_id, gboolean* radio, GError** error);
	gboolean (*GetChannelURL) (DVBIDBusChannelList* self, guint channel_id, char** url, GError** error);
	DVBChannelInfo* (*GetChannelInfos) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	gboolean (*GetChannelsOfGroup) (DVBIDBusChannelList* self, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error);
	gboolean (*AddChannelToGroup) (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
	gboolean (*RemoveChannelFromGroup) (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
};

struct _DVBChannelList {
	GObject parent_instance;
	DVBChannelListPrivate * priv;
	GeeHashMap* channels;
};

struct _DVBChannelListClass {
	GObjectClass parent_class;
};

struct _DVBChannelListPrivate {
	GFile* _channels_file;
	guint _GroupId;
	GStaticRecMutex __lock_channels;
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*get_parent_group) (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint* group_id, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const char* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer dvb_channel_list_parent_class = NULL;
static GeeIterableIface* dvb_channel_list_gee_iterable_parent_iface = NULL;
static DVBIDBusChannelListIface* dvb_channel_list_dvb_id_bus_channel_list_parent_iface = NULL;

GType dvb_channel_info_get_type (void);
DVBChannelInfo* dvb_channel_info_dup (const DVBChannelInfo* self);
void dvb_channel_info_free (DVBChannelInfo* self);
void dvb_channel_info_copy (const DVBChannelInfo* self, DVBChannelInfo* dest);
void dvb_channel_info_destroy (DVBChannelInfo* self);
GType dvb_id_bus_channel_list_get_type (void);
GType dvb_channel_list_get_type (void);
GType dvb_channel_get_type (void);
#define DVB_CHANNEL_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL_LIST, DVBChannelListPrivate))
enum  {
	DVB_CHANNEL_LIST_DUMMY_PROPERTY,
	DVB_CHANNEL_LIST_CHANNELS_FILE,
	DVB_CHANNEL_LIST_GROUP_ID,
	DVB_CHANNEL_LIST_SIZE,
	DVB_CHANNEL_LIST_ELEMENT_TYPE
};
DVBChannelList* dvb_channel_list_new (GFile* channels);
DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
guint dvb_channel_get_Sid (DVBChannel* self);
void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel);
void dvb_channel_list_remove (DVBChannelList* self, guint sid);
gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid);
void dvb_channel_list_clear (DVBChannelList* self);
static GeeIterator* dvb_channel_list_real_iterator (GeeIterable* base);
GType dvb_adapter_type_get_type (void);
DVBioChannelListReader* dvb_io_channel_list_reader_new (DVBChannelList* channels, DVBAdapterType type);
DVBioChannelListReader* dvb_io_channel_list_reader_construct (GType object_type, DVBChannelList* channels, DVBAdapterType type);
GType dvb_io_channel_list_reader_get_type (void);
void dvb_io_channel_list_reader_read_into (DVBioChannelListReader* self, GError** error);
void dvb_channel_list_load (DVBChannelList* self, DVBAdapterType type, GError** error);
gint dvb_channel_list_get_size (DVBChannelList* self);
static guint* dvb_channel_list_real_GetChannels (DVBIDBusChannelList* base, int* result_length1, GError** error);
guint dvb_channel_get_VideoPID (DVBChannel* self);
static guint* dvb_channel_list_real_GetRadioChannels (DVBIDBusChannelList* base, int* result_length1, GError** error);
gboolean dvb_channel_is_radio (DVBChannel* self);
static guint* dvb_channel_list_real_GetTVChannels (DVBIDBusChannelList* base, int* result_length1, GError** error);
const char* dvb_channel_get_Name (DVBChannel* self);
static gboolean dvb_channel_list_real_GetChannelName (DVBIDBusChannelList* base, guint channel_id, char** channel_name, GError** error);
const char* dvb_channel_get_Network (DVBChannel* self);
static gboolean dvb_channel_list_real_GetChannelNetwork (DVBIDBusChannelList* base, guint channel_id, char** network, GError** error);
static gboolean dvb_channel_list_real_IsRadioChannel (DVBIDBusChannelList* base, guint channel_id, gboolean* radio, GError** error);
char* dvb_channel_get_URL (DVBChannel* self);
static gboolean dvb_channel_list_real_GetChannelURL (DVBIDBusChannelList* base, guint channel_id, char** url, GError** error);
static void _vala_DVBChannelInfo_array_free (DVBChannelInfo* array, gint array_length);
static DVBChannelInfo* dvb_channel_list_real_GetChannelInfos (DVBIDBusChannelList* base, int* result_length1, GError** error);
GType dvb_device_group_get_type (void);
GQuark dvb_database_sql_error_quark (void);
GType dvb_device_get_type (void);
GType dvb_channel_group_get_type (void);
GType dvb_database_config_store_get_type (void);
DVBdatabaseConfigStore* dvb_factory_get_config_store (void);
GeeList* dvb_database_config_store_get_channels_of_group (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
guint dvb_channel_list_get_GroupId (DVBChannelList* self);
static gboolean dvb_channel_list_real_GetChannelsOfGroup (DVBIDBusChannelList* base, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error);
gboolean dvb_database_config_store_add_channel_to_group (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
static gboolean dvb_channel_list_real_AddChannelToGroup (DVBIDBusChannelList* base, guint channel_id, gint channel_group_id, GError** error);
gboolean dvb_database_config_store_remove_channel_from_group (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
static gboolean dvb_channel_list_real_RemoveChannelFromGroup (DVBIDBusChannelList* base, guint channel_id, gint channel_group_id, GError** error);
GFile* dvb_channel_list_get_channels_file (DVBChannelList* self);
static void dvb_channel_list_set_channels_file (DVBChannelList* self, GFile* value);
void dvb_channel_list_set_GroupId (DVBChannelList* self, guint value);
static GObject * dvb_channel_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void dvb_channel_list_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_channel_list_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_channel_list_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_channel_list_introspect (DVBChannelList* self, DBusConnection* connection, DBusMessage* message);
static void dvb_channel_list_finalize (GObject* obj);
static void dvb_channel_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_channel_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_channel_list_dbus_path_vtable = {_dvb_channel_list_dbus_unregister, dvb_channel_list_dbus_message};
static const _DBusObjectVTable _dvb_channel_list_dbus_vtable = {dvb_channel_list_dbus_register_object};


DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels) {
	DVBChannelList * self;
	self = (DVBChannelList*) g_object_new (object_type, "channels-file", channels, NULL);
	return self;
}


DVBChannelList* dvb_channel_list_new (GFile* channels) {
	return dvb_channel_list_construct (DVB_TYPE_CHANNEL_LIST, channels);
}


DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid) {
	DVBChannel* result = NULL;
	GError * _inner_error_;
	DVBChannel* val;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	val = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			if (gee_map_contains ((GeeMap*) self->channels, GUINT_TO_POINTER (sid))) {
				DVBChannel* _tmp0_;
				val = (_tmp0_ = (DVBChannel*) gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (sid)), _g_object_unref0 (val), _tmp0_);
			}
		}
		__finally33:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (val);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = val;
	return result;
}


void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			gee_abstract_map_set ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (dvb_channel_get_Sid (channel)), channel);
		}
		__finally34:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_channel_list_remove (DVBChannelList* self, guint sid) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			gee_map_remove ((GeeMap*) self->channels, GUINT_TO_POINTER (sid), NULL);
		}
		__finally35:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			val = gee_map_contains ((GeeMap*) self->channels, GUINT_TO_POINTER (sid));
		}
		__finally36:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	return result;
}


void dvb_channel_list_clear (DVBChannelList* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			gee_abstract_map_clear ((GeeAbstractMap*) self->channels);
		}
		__finally37:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static GeeIterator* dvb_channel_list_real_iterator (GeeIterable* base) {
	DVBChannelList * self;
	GeeIterator* result = NULL;
	GeeCollection* _tmp0_;
	GeeIterator* _tmp1_;
	self = (DVBChannelList*) base;
	result = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_values ((GeeMap*) self->channels))), _g_object_unref0 (_tmp0_), _tmp1_);
	return result;
}


void dvb_channel_list_load (DVBChannelList* self, DVBAdapterType type, GError** error) {
	GError * _inner_error_;
	DVBioChannelListReader* reader;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	reader = dvb_io_channel_list_reader_new (self, type);
	dvb_io_channel_list_reader_read_into (reader, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (reader);
		return;
	}
	_g_object_unref0 (reader);
}


static guint* dvb_channel_list_real_GetChannels (DVBIDBusChannelList* base, int* result_length1, GError** error) {
	DVBChannelList * self;
	guint* result = NULL;
	GError * _inner_error_;
	guint* _tmp1_;
	gint _ids_size_;
	gint ids_length1;
	gint _tmp0_;
	guint* ids;
	gint i;
	guint* _tmp4_;
	self = (DVBChannelList*) base;
	_inner_error_ = NULL;
	ids = (_tmp1_ = g_new0 (guint, _tmp0_ = dvb_channel_list_get_size (self)), ids_length1 = _tmp0_, _ids_size_ = ids_length1, _tmp1_);
	i = 0;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			{
				GeeSet* _tmp2_;
				GeeIterator* _tmp3_;
				GeeIterator* _id_it;
				_id_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_map_get_keys ((GeeMap*) self->channels))), _g_object_unref0 (_tmp2_), _tmp3_);
				while (TRUE) {
					guint id;
					if (!gee_iterator_next (_id_it)) {
						break;
					}
					id = GPOINTER_TO_UINT (gee_iterator_get (_id_it));
					ids[i] = id;
					i++;
				}
				_g_object_unref0 (_id_it);
			}
		}
		__finally38:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = (_tmp4_ = ids, *result_length1 = ids_length1, _tmp4_);
	return result;
	ids = (g_free (ids), NULL);
}


static guint* dvb_channel_list_real_GetRadioChannels (DVBIDBusChannelList* base, int* result_length1, GError** error) {
	DVBChannelList * self;
	guint* result = NULL;
	GError * _inner_error_;
	GSList* radio_channels;
	guint* _tmp3_;
	gint _ids_size_;
	gint ids_length1;
	gint _tmp2_;
	guint* ids;
	guint* _tmp5_;
	self = (DVBChannelList*) base;
	_inner_error_ = NULL;
	radio_channels = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			{
				GeeSet* _tmp0_;
				GeeIterator* _tmp1_;
				GeeIterator* _id_it;
				_id_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys ((GeeMap*) self->channels))), _g_object_unref0 (_tmp0_), _tmp1_);
				while (TRUE) {
					guint id;
					DVBChannel* chan;
					if (!gee_iterator_next (_id_it)) {
						break;
					}
					id = GPOINTER_TO_UINT (gee_iterator_get (_id_it));
					chan = (DVBChannel*) gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (id));
					if (dvb_channel_get_VideoPID (chan) == 0) {
						radio_channels = g_slist_prepend (radio_channels, GUINT_TO_POINTER (id));
					}
					_g_object_unref0 (chan);
				}
				_g_object_unref0 (_id_it);
			}
		}
		__finally39:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_slist_free0 (radio_channels);
				return NULL;
			} else {
				_g_slist_free0 (radio_channels);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	radio_channels = g_slist_reverse (radio_channels);
	ids = (_tmp3_ = g_new0 (guint, _tmp2_ = g_slist_length (radio_channels)), ids_length1 = _tmp2_, _ids_size_ = ids_length1, _tmp3_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < g_slist_length (radio_channels))) {
					break;
				}
				ids[i] = GPOINTER_TO_UINT (g_slist_nth_data (radio_channels, (guint) i));
			}
		}
	}
	result = (_tmp5_ = ids, *result_length1 = ids_length1, _tmp5_);
	_g_slist_free0 (radio_channels);
	return result;
	_g_slist_free0 (radio_channels);
	ids = (g_free (ids), NULL);
}


static guint* dvb_channel_list_real_GetTVChannels (DVBIDBusChannelList* base, int* result_length1, GError** error) {
	DVBChannelList * self;
	guint* result = NULL;
	GError * _inner_error_;
	GSList* video_channels;
	guint* _tmp3_;
	gint _ids_size_;
	gint ids_length1;
	gint _tmp2_;
	guint* ids;
	guint* _tmp5_;
	self = (DVBChannelList*) base;
	_inner_error_ = NULL;
	video_channels = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			{
				GeeSet* _tmp0_;
				GeeIterator* _tmp1_;
				GeeIterator* _id_it;
				_id_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys ((GeeMap*) self->channels))), _g_object_unref0 (_tmp0_), _tmp1_);
				while (TRUE) {
					guint id;
					DVBChannel* chan;
					if (!gee_iterator_next (_id_it)) {
						break;
					}
					id = GPOINTER_TO_UINT (gee_iterator_get (_id_it));
					chan = (DVBChannel*) gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (id));
					if (!dvb_channel_is_radio (chan)) {
						video_channels = g_slist_prepend (video_channels, GUINT_TO_POINTER (id));
					}
					_g_object_unref0 (chan);
				}
				_g_object_unref0 (_id_it);
			}
		}
		__finally40:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_slist_free0 (video_channels);
				return NULL;
			} else {
				_g_slist_free0 (video_channels);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	video_channels = g_slist_reverse (video_channels);
	ids = (_tmp3_ = g_new0 (guint, _tmp2_ = g_slist_length (video_channels)), ids_length1 = _tmp2_, _ids_size_ = ids_length1, _tmp3_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < g_slist_length (video_channels))) {
					break;
				}
				ids[i] = GPOINTER_TO_UINT (g_slist_nth_data (video_channels, (guint) i));
			}
		}
	}
	result = (_tmp5_ = ids, *result_length1 = ids_length1, _tmp5_);
	_g_slist_free0 (video_channels);
	return result;
	_g_slist_free0 (video_channels);
	ids = (g_free (ids), NULL);
}


static gboolean dvb_channel_list_real_GetChannelName (DVBIDBusChannelList* base, guint channel_id, char** channel_name, GError** error) {
	DVBChannelList * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean ret;
	char* val;
	char* _tmp4_;
	self = (DVBChannelList*) base;
	if (channel_name != NULL) {
		*channel_name = NULL;
	}
	_inner_error_ = NULL;
	ret = FALSE;
	val = g_strdup ("");
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			if (gee_map_contains ((GeeMap*) self->channels, GUINT_TO_POINTER (channel_id))) {
				DVBChannel* _tmp0_;
				char* _tmp1_;
				char* name;
				const char* _tmp2_;
				char* _tmp3_;
				name = (_tmp1_ = g_strdup (dvb_channel_get_Name (_tmp0_ = (DVBChannel*) gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (channel_id)))), _g_object_unref0 (_tmp0_), _tmp1_);
				_tmp2_ = NULL;
				if (name == NULL) {
					_tmp2_ = "";
				} else {
					_tmp2_ = name;
				}
				val = (_tmp3_ = g_strdup (_tmp2_), _g_free0 (val), _tmp3_);
				ret = TRUE;
				_g_free0 (name);
			}
		}
		__finally41:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (val);
				return FALSE;
			} else {
				_g_free0 (val);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	*channel_name = (_tmp4_ = g_strdup (val), _g_free0 (*channel_name), _tmp4_);
	result = ret;
	_g_free0 (val);
	return result;
}


static gboolean dvb_channel_list_real_GetChannelNetwork (DVBIDBusChannelList* base, guint channel_id, char** network, GError** error) {
	DVBChannelList * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	char* val;
	gboolean ret;
	char* _tmp4_;
	self = (DVBChannelList*) base;
	if (network != NULL) {
		*network = NULL;
	}
	_inner_error_ = NULL;
	val = g_strdup ("");
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			if (gee_map_contains ((GeeMap*) self->channels, GUINT_TO_POINTER (channel_id))) {
				DVBChannel* _tmp0_;
				char* _tmp1_;
				char* tmp;
				const char* _tmp2_;
				char* _tmp3_;
				tmp = (_tmp1_ = g_strdup (dvb_channel_get_Network (_tmp0_ = (DVBChannel*) gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (channel_id)))), _g_object_unref0 (_tmp0_), _tmp1_);
				_tmp2_ = NULL;
				if (tmp == NULL) {
					_tmp2_ = "";
				} else {
					_tmp2_ = tmp;
				}
				val = (_tmp3_ = g_strdup (_tmp2_), _g_free0 (val), _tmp3_);
				ret = TRUE;
				_g_free0 (tmp);
			}
		}
		__finally42:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (val);
				return FALSE;
			} else {
				_g_free0 (val);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	*network = (_tmp4_ = g_strdup (val), _g_free0 (*network), _tmp4_);
	result = ret;
	_g_free0 (val);
	return result;
}


static gboolean dvb_channel_list_real_IsRadioChannel (DVBIDBusChannelList* base, guint channel_id, gboolean* radio, GError** error) {
	DVBChannelList * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val;
	gboolean ret;
	self = (DVBChannelList*) base;
	_inner_error_ = NULL;
	val = FALSE;
	ret = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			if (gee_map_contains ((GeeMap*) self->channels, GUINT_TO_POINTER (channel_id))) {
				DVBChannel* _tmp0_;
				val = dvb_channel_is_radio (_tmp0_ = (DVBChannel*) gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (channel_id)));
				_g_object_unref0 (_tmp0_);
				ret = TRUE;
			}
		}
		__finally43:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	*radio = val;
	result = ret;
	return result;
}


static gboolean dvb_channel_list_real_GetChannelURL (DVBIDBusChannelList* base, guint channel_id, char** url, GError** error) {
	DVBChannelList * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	DVBChannel* channel;
	self = (DVBChannelList*) base;
	if (url != NULL) {
		*url = NULL;
	}
	_inner_error_ = NULL;
	channel = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			if (gee_map_contains ((GeeMap*) self->channels, GUINT_TO_POINTER (channel_id))) {
				DVBChannel* _tmp0_;
				channel = (_tmp0_ = (DVBChannel*) gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (channel_id)), _g_object_unref0 (channel), _tmp0_);
			}
		}
		__finally44:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (channel);
				return FALSE;
			} else {
				_g_object_unref0 (channel);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (channel == NULL) {
		char* _tmp1_;
		*url = (_tmp1_ = g_strdup (""), _g_free0 (*url), _tmp1_);
		result = FALSE;
		_g_object_unref0 (channel);
		return result;
	} else {
		char* _tmp2_;
		*url = (_tmp2_ = dvb_channel_get_URL (channel), _g_free0 (*url), _tmp2_);
		result = TRUE;
		_g_object_unref0 (channel);
		return result;
	}
	_g_object_unref0 (channel);
}


static void _vala_DVBChannelInfo_array_free (DVBChannelInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_channel_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DVBChannelInfo* dvb_channel_list_real_GetChannelInfos (DVBIDBusChannelList* base, int* result_length1, GError** error) {
	DVBChannelList * self;
	DVBChannelInfo* result = NULL;
	GError * _inner_error_;
	DVBChannelInfo* _tmp1_;
	gint _channels_size_;
	gint channels_length1;
	gint _tmp0_;
	DVBChannelInfo* channels;
	gint i;
	DVBChannelInfo* _tmp7_;
	self = (DVBChannelList*) base;
	_inner_error_ = NULL;
	channels = (_tmp1_ = g_new0 (DVBChannelInfo, _tmp0_ = gee_map_get_size ((GeeMap*) self->channels)), channels_length1 = _tmp0_, _channels_size_ = channels_length1, _tmp1_);
	i = 0;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			{
				GeeSet* _tmp2_;
				GeeIterator* _tmp3_;
				GeeIterator* _id_it;
				_id_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_map_get_keys ((GeeMap*) self->channels))), _g_object_unref0 (_tmp2_), _tmp3_);
				while (TRUE) {
					guint id;
					DVBChannel* channel;
					DVBChannelInfo chan_info = {0};
					char* _tmp4_;
					DVBChannelInfo _tmp6_;
					DVBChannelInfo _tmp5_ = {0};
					if (!gee_iterator_next (_id_it)) {
						break;
					}
					id = GPOINTER_TO_UINT (gee_iterator_get (_id_it));
					channel = (DVBChannel*) gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (id));
					memset (&chan_info, 0, sizeof (DVBChannelInfo));
					chan_info.id = id;
					chan_info.name = (_tmp4_ = g_strdup (dvb_channel_get_Name (channel)), _g_free0 (chan_info.name), _tmp4_);
					chan_info.is_radio = dvb_channel_is_radio (channel);
					channels[i] = (_tmp6_ = (dvb_channel_info_copy (&chan_info, &_tmp5_), _tmp5_), dvb_channel_info_destroy (&channels[i]), _tmp6_);
					i++;
					_g_object_unref0 (channel);
					dvb_channel_info_destroy (&chan_info);
				}
				_g_object_unref0 (_id_it);
			}
		}
		__finally45:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				channels = (_vala_DVBChannelInfo_array_free (channels, channels_length1), NULL);
				return NULL;
			} else {
				channels = (_vala_DVBChannelInfo_array_free (channels, channels_length1), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = (_tmp7_ = channels, *result_length1 = channels_length1, _tmp7_);
	return result;
	channels = (_vala_DVBChannelInfo_array_free (channels, channels_length1), NULL);
}


static gboolean dvb_channel_list_real_GetChannelsOfGroup (DVBIDBusChannelList* base, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error) {
	DVBChannelList * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	DVBdatabaseConfigStore* config;
	GeeList* channels;
	guint* _tmp3_;
	gint _tmp2_;
	self = (DVBChannelList*) base;
	if (channel_ids != NULL) {
		*channel_ids = NULL;
	}
	_inner_error_ = NULL;
	config = dvb_factory_get_config_store ();
	channels = NULL;
	{
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		_tmp0_ = dvb_database_config_store_get_channels_of_group (config, self->priv->_GroupId, channel_group_id, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch46_dvb_database_sql_error;
			}
			_g_object_unref0 (config);
			_g_object_unref0 (channels);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		channels = (_tmp1_ = _tmp0_, _g_object_unref0 (channels), _tmp1_);
	}
	goto __finally46;
	__catch46_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("ChannelList.vala:275: %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (config);
			_g_object_unref0 (channels);
			return result;
		}
	}
	__finally46:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (config);
			_g_object_unref0 (channels);
			return FALSE;
		} else {
			_g_object_unref0 (config);
			_g_object_unref0 (channels);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	*channel_ids = (_tmp3_ = g_new0 (guint, _tmp2_ = gee_collection_get_size ((GeeCollection*) channels)), *channel_ids = (g_free (*channel_ids), NULL), *channel_ids_length1 = _tmp2_, _tmp3_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < (*channel_ids_length1))) {
					break;
				}
				(*channel_ids)[i] = GPOINTER_TO_UINT (gee_list_get (channels, i));
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (config);
	_g_object_unref0 (channels);
	return result;
}


static gboolean dvb_channel_list_real_AddChannelToGroup (DVBIDBusChannelList* base, guint channel_id, gint channel_group_id, GError** error) {
	DVBChannelList * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	DVBdatabaseConfigStore* config;
	DVBChannel* chan;
	gboolean ret = FALSE;
	self = (DVBChannelList*) base;
	_inner_error_ = NULL;
	config = dvb_factory_get_config_store ();
	chan = dvb_channel_list_get_channel (self, channel_id);
	if (chan == NULL) {
		result = FALSE;
		_g_object_unref0 (config);
		_g_object_unref0 (chan);
		return result;
	}
	{
		gboolean _tmp0_;
		_tmp0_ = dvb_database_config_store_add_channel_to_group (config, chan, channel_group_id, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch47_dvb_database_sql_error;
			}
			_g_object_unref0 (config);
			_g_object_unref0 (chan);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		ret = _tmp0_;
	}
	goto __finally47;
	__catch47_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("ChannelList.vala:304: %s", e->message);
			ret = FALSE;
			_g_error_free0 (e);
		}
	}
	__finally47:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (config);
			_g_object_unref0 (chan);
			return FALSE;
		} else {
			_g_object_unref0 (config);
			_g_object_unref0 (chan);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (config);
	_g_object_unref0 (chan);
	return result;
}


static gboolean dvb_channel_list_real_RemoveChannelFromGroup (DVBIDBusChannelList* base, guint channel_id, gint channel_group_id, GError** error) {
	DVBChannelList * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	DVBdatabaseConfigStore* config;
	DVBChannel* chan;
	gboolean ret = FALSE;
	self = (DVBChannelList*) base;
	_inner_error_ = NULL;
	config = dvb_factory_get_config_store ();
	chan = dvb_channel_list_get_channel (self, channel_id);
	if (chan == NULL) {
		result = FALSE;
		_g_object_unref0 (config);
		_g_object_unref0 (chan);
		return result;
	}
	{
		gboolean _tmp0_;
		_tmp0_ = dvb_database_config_store_remove_channel_from_group (config, chan, channel_group_id, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch48_dvb_database_sql_error;
			}
			_g_object_unref0 (config);
			_g_object_unref0 (chan);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		ret = _tmp0_;
	}
	goto __finally48;
	__catch48_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("ChannelList.vala:327: %s", e->message);
			ret = FALSE;
			_g_error_free0 (e);
		}
	}
	__finally48:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (config);
			_g_object_unref0 (chan);
			return FALSE;
		} else {
			_g_object_unref0 (config);
			_g_object_unref0 (chan);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (config);
	_g_object_unref0 (chan);
	return result;
}


GFile* dvb_channel_list_get_channels_file (DVBChannelList* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_channels_file;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_channel_list_set_channels_file (DVBChannelList* self, GFile* value) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_channels_file = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_channels_file), _tmp0_);
	g_object_notify ((GObject *) self, "channels-file");
}


guint dvb_channel_list_get_GroupId (DVBChannelList* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_GroupId;
	return result;
}


void dvb_channel_list_set_GroupId (DVBChannelList* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_GroupId = value;
	g_object_notify ((GObject *) self, "GroupId");
}


gint dvb_channel_list_get_size (DVBChannelList* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = gee_map_get_size ((GeeMap*) self->channels);
	return result;
}


static GType dvb_channel_list_real_get_element_type (GeeIterable* base) {
	GType result;
	DVBChannelList* self;
	self = (DVBChannelList*) base;
	result = DVB_TYPE_CHANNEL;
	return result;
}


static GObject * dvb_channel_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBChannelList * self;
	parent_class = G_OBJECT_CLASS (dvb_channel_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_CHANNEL_LIST (obj);
	{
		GeeHashMap* _tmp0_;
		self->channels = (_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->channels), _tmp0_);
	}
	return obj;
}


void _dvb_channel_list_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_channel_list_introspect (DVBChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.ChannelList\">\n  <method name=\"GetChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetRadioChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTVChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_name\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelNetwork\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"network\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"IsRadioChannel\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"radio\" type=\"b\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelURL\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"url\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelInfos\">\n    <arg name=\"result\" type=\"a(usb)\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelsOfGroup\">\n    <arg name=\"channel_group_id\" type=\"i\" direction=\"in\"/>\n    <arg name=\"channel_ids\" type=\"au\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddChannelToGroup\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_group_id\" type=\"i\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"RemoveChannelFromGroup\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_group_id\" type=\"i\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"Changed\">\n    <arg name=\"channel_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_channel_list_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_channel_list_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dvb_id_bus_channel_list_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_channel_list_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_channel_list_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dvb_id_bus_channel_list_dbus_register_object (connection, path, object);
}


static void dvb_channel_list_class_init (DVBChannelListClass * klass) {
	dvb_channel_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelListPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_channel_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_channel_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_channel_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_CHANNELS_FILE, g_param_spec_object ("channels-file", "channels-file", "channels-file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_GROUP_ID, g_param_spec_uint ("GroupId", "GroupId", "GroupId", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_ELEMENT_TYPE, "element-type");
	g_type_set_qdata (DVB_TYPE_CHANNEL_LIST, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_channel_list_dbus_vtable));
}


static void dvb_channel_list_gee_iterable_interface_init (GeeIterableIface * iface) {
	dvb_channel_list_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = dvb_channel_list_real_iterator;
	iface->get_element_type = dvb_channel_list_real_get_element_type;
}


static void dvb_channel_list_dvb_id_bus_channel_list_interface_init (DVBIDBusChannelListIface * iface) {
	dvb_channel_list_dvb_id_bus_channel_list_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetChannels = dvb_channel_list_real_GetChannels;
	iface->GetRadioChannels = dvb_channel_list_real_GetRadioChannels;
	iface->GetTVChannels = dvb_channel_list_real_GetTVChannels;
	iface->GetChannelName = dvb_channel_list_real_GetChannelName;
	iface->GetChannelNetwork = dvb_channel_list_real_GetChannelNetwork;
	iface->IsRadioChannel = dvb_channel_list_real_IsRadioChannel;
	iface->GetChannelURL = dvb_channel_list_real_GetChannelURL;
	iface->GetChannelInfos = dvb_channel_list_real_GetChannelInfos;
	iface->GetChannelsOfGroup = dvb_channel_list_real_GetChannelsOfGroup;
	iface->AddChannelToGroup = dvb_channel_list_real_AddChannelToGroup;
	iface->RemoveChannelFromGroup = dvb_channel_list_real_RemoveChannelFromGroup;
}


static void dvb_channel_list_instance_init (DVBChannelList * self) {
	self->priv = DVB_CHANNEL_LIST_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_channels);
}


static void dvb_channel_list_finalize (GObject* obj) {
	DVBChannelList * self;
	self = DVB_CHANNEL_LIST (obj);
	_g_object_unref0 (self->priv->_channels_file);
	g_static_rec_mutex_free (&self->priv->__lock_channels);
	_g_object_unref0 (self->channels);
	G_OBJECT_CLASS (dvb_channel_list_parent_class)->finalize (obj);
}


GType dvb_channel_list_get_type (void) {
	static volatile gsize dvb_channel_list_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_channel_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannelList), 0, (GInstanceInitFunc) dvb_channel_list_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) dvb_channel_list_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo dvb_id_bus_channel_list_info = { (GInterfaceInitFunc) dvb_channel_list_dvb_id_bus_channel_list_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_channel_list_type_id;
		dvb_channel_list_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannelList", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_channel_list_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (dvb_channel_list_type_id, DVB_TYPE_ID_BUS_CHANNEL_LIST, &dvb_id_bus_channel_list_info);
		g_once_init_leave (&dvb_channel_list_type_id__volatile, dvb_channel_list_type_id);
	}
	return dvb_channel_list_type_id__volatile;
}


static void dvb_channel_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannelList * self;
	self = DVB_CHANNEL_LIST (object);
	switch (property_id) {
		case DVB_CHANNEL_LIST_CHANNELS_FILE:
		g_value_set_object (value, dvb_channel_list_get_channels_file (self));
		break;
		case DVB_CHANNEL_LIST_GROUP_ID:
		g_value_set_uint (value, dvb_channel_list_get_GroupId (self));
		break;
		case DVB_CHANNEL_LIST_SIZE:
		g_value_set_int (value, dvb_channel_list_get_size (self));
		break;
		case DVB_CHANNEL_LIST_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannelList * self;
	self = DVB_CHANNEL_LIST (object);
	switch (property_id) {
		case DVB_CHANNEL_LIST_CHANNELS_FILE:
		dvb_channel_list_set_channels_file (self, g_value_get_object (value));
		break;
		case DVB_CHANNEL_LIST_GROUP_ID:
		dvb_channel_list_set_GroupId (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




