// DOM1 test suite. Generated by gen_tests.sh from W3C DOM1 core test suite.
// See below for original file copyrights.

var builder = { contentType: "text/xml" };

var _xml_file_contents = {
staff:
'<?xml version="1.0"?><?TEST-STYLE PIDATA?>\n'+
'<!DOCTYPE staff SYSTEM "staff.dtd" [\n'+
'   <!ENTITY ent1 "es">\n'+
'   <!ENTITY ent2 "1900 Dallas Road">\n'+
'   <!ENTITY ent3 "Texas">\n'+
'   <!ENTITY ent4 "<entElement domestic=\'Yes\'>Element data</entElement><?PItarget PIdata?>">\n'+
'   <!ENTITY ent5 PUBLIC "entityURI" "entityFile" NDATA notation1>\n'+
'   <!ENTITY ent1 "This entity should be discarded">\n'+
'   <!NOTATION notation1 PUBLIC "notation1File">\n'+
'   <!NOTATION notation2 SYSTEM "notation2File">\n'+
']>\n'+
'<!-- This is comment number 1.-->\n'+
'<staff>\n'+
' <employee>\n'+
'  <employeeId>EMP0001</employeeId>\n'+
'  <name>Margaret Martin</name>\n'+
'  <position>Accountant</position>           \n'+
'  <salary>56,000</salary>\n'+
'  <gender>Female</gender>\n'+
'  <address domestic="Yes">1230 North Ave. Dallas, Texas 98551</address>\n'+
' </employee>\n'+
' <employee>\n'+
'  <employeeId>EMP0002</employeeId>\n'+
'  <name>Martha Raynolds<![CDATA[This is a CDATASection with EntityReference number 2 &ent2;]]>\n'+
'<![CDATA[This is an adjacent CDATASection with a reference to a tab &tab;]]></name>\n'+
'  <position>Secretary</position>\n'+
'  <salary>35,000</salary>\n'+
'  <gender>Female</gender>\n'+
'  <address domestic="Yes" street="Yes">&ent2; Dallas, &ent3;\n'+
' 98554</address>\n'+
' </employee>\n'+
' <employee>\n'+
'  <employeeId>EMP0003</employeeId>\n'+
'  <name>Roger\n'+
' Jones</name>\n'+
'  <position>Department Manager</position>\n'+
'  <salary>100,000</salary>\n'+
'  <gender>&ent4;</gender>\n'+
'  <address domestic="Yes" street="No">PO Box 27 Irving, texas 98553</address>\n'+
' </employee>\n'+
' <employee>\n'+
'  <employeeId>EMP0004</employeeId>\n'+
'  <name>Jeny Oconnor</name>\n'+
'  <position>Personnel Director</position>\n'+
'  <salary>95,000</salary>\n'+
'  <gender>Female</gender>\n'+
'  <address domestic="Yes" street="Y&ent1;">27 South Road. Dallas, Texas 98556</address>\n'+
' </employee>\n'+
' <employee>\n'+
'  <employeeId>EMP0005</employeeId>\n'+
'  <name>Robert Myers</name>\n'+
'  <position>Computer Specialist</position>\n'+
'  <salary>90,000</salary>\n'+
'  <gender>male</gender>\n'+
'  <address street="Yes">1821 Nordic. Road, Irving Texas 98558</address>\n'+
' </employee>\n'+
' </staff>\n'+
'',
hc_staff:
'<?xml version="1.0"?><?TEST-STYLE PIDATA?>\n'+
'<!DOCTYPE html\n'+
'   PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"\n'+
'   "xhtml1-strict.dtd" [\n'+
'   <!ENTITY alpha "&#945;">\n'+
'   <!ENTITY beta "&#946;">\n'+
'   <!ENTITY gamma "&#947;">\n'+
'   <!ENTITY delta "&#948;">\n'+
'   <!ENTITY epsilon "&#949;">\n'+
'   <!ENTITY alpha "&#950;">\n'+
'   <!NOTATION notation1 PUBLIC "notation1File">\n'+
'   <!NOTATION notation2 SYSTEM "notation2File">\n'+
'   <!ATTLIST acronym dir CDATA "ltr">\n'+
']>\n'+
'<!-- This is comment number 1.-->\n'+
'<html xmlns=\'http://www.w3.org/1999/xhtml\'><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/><title>hc_staff</title><script type="text/javascript" src="svgunit.js"/><script charset="UTF-8" type="text/javascript" src="svgtest.js"/><script type=\'text/javascript\'>function loadComplete() { startTest(); }</script></head><body onload="parent.loadComplete()">\n'+
' <p>\n'+
'  <em>EMP0001</em>\n'+
'  <strong>Margaret Martin</strong>\n'+
'  <code>Accountant</code>           \n'+
'  <sup>56,000</sup>\n'+
'  <var>Female</var>\n'+
'  <acronym title="Yes">1230 North Ave. Dallas, Texas 98551</acronym>\n'+
' </p>\n'+
' <p>\n'+
'  <em>EMP0002</em>\n'+
'  <strong>Martha RaynoldsThis is a CDATASection with EntityReference number 2 &amp;ent2;\n'+
'This is an adjacent CDATASection with a reference to a tab &amp;tab;</strong>\n'+
'  <code>Secretary</code>\n'+
'  <sup>35,000</sup>\n'+
'  <var>Female</var>\n'+
'  <acronym title="Yes" class="Yes">&beta; Dallas, &gamma;\n'+
' 98554</acronym>\n'+
' </p>\n'+
' <p>\n'+
'  <em>EMP0003</em>\n'+
'  <strong>Roger\n'+
' Jones</strong>\n'+
'  <code>Department Manager</code>\n'+
'  <sup>100,000</sup>\n'+
'  <var>&delta;</var>\n'+
'  <acronym title="Yes" class="No">PO Box 27 Irving, texas 98553</acronym>\n'+
' </p>\n'+
' <p>\n'+
'  <em>EMP0004</em>\n'+
'  <strong>Jeny Oconnor</strong>\n'+
'  <code>Personnel Director</code>\n'+
'  <sup>95,000</sup>\n'+
'  <var>Female</var>\n'+
'  <acronym title="Yes" class="Y&alpha;">27 South Road. Dallas, Texas 98556</acronym>\n'+
' </p>\n'+
' <p>\n'+
'  <em>EMP0005</em>\n'+
'  <strong>Robert Myers</strong>\n'+
'  <code>Computer Specialist</code>\n'+
'  <sup>90,000</sup>\n'+
'  <var>male</var>\n'+
'  <acronym title="Yes">1821 Nordic. Road, Irving Texas 98558</acronym>\n'+
' </p>\n'+
'</body></html>\n'+
'',
hc_nodtdstaff:
'<html xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/><title>hc_nodtdstaff</title></head><body onload="parent.loadComplete()">\n'+
' <p>\n'+
'  <em>EMP0001</em>\n'+
'  <strong>Margaret Martin</strong>\n'+
'  <code>Accountant</code>           \n'+
'  <sup>56,000</sup>\n'+
'  <var>Female</var>\n'+
'  <acronym title="Yes">1230 North Ave. Dallas, Texas 98551</acronym>\n'+
' </p>\n'+
'</body></html>\n'+
''};

function equalsAutoCase(dummy, x, y) {
  return x === y;
}

// This is only for some assertTrue calls that span multiple lines and
// can't be converted by gen_tests.sh script.
function assertTrue(name, cond) {
  ASSERT(STRICT_EQ(true, cond), name);
}

// We only tests XML, so case-sensitive.
function toLowerArray(arr) {
  return arr;
}

function load(dummy1, dummy2, name) {
  var doc = new DOMDocument();
  doc.loadXML(_xml_file_contents[name]);
  return doc;
}

function DOM_COLLECTION_EQ(expected, list) {
  var eq_length = EQ(expected.length, list.length);
  if (eq_length != null)
    return eq_length;
  for (var i = 0; i < expected.length; i++) {
    var matches = 0;
    for (var j = 0; j < list.length; j++) {
      if (expected[i] == list[j])
        matches++;
    }
    if (matches == 0)
      return _Message("DOM_COLLECTION_EQ[" + i + "]", expected[i], "Not Found");
    if (matches > 1)
      return _Message("DOM_COLLECTION_EQ[" + i + "]", expected[i],
                      "Found multiple");
  }
  return null;
}

function DOM_LIST_EQ(expected, list) {
  var eq_length = EQ(expected.length, list.length);
  if (eq_length != null)
    return eq_length;
  for (var i = 0; i < expected.length; i++) {
    var eq_value = EQ(expected[i], list[i]);
    if (eq_value != null)
      return eq_value;
  }
  return null;
}

function DOM_SAME(expected, node) {
  if (expected == node)
    return null;
  var eq = EQ(expected.nodeType, node.nodeType);
  if (eq != null)
    return eq;
  return EQ(expected.nodeValue, node.nodeValue);
}


/*
This ECMAScript source file was generated by test-to-ecmascript.xsl
and gen_tests.sh,
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

/**
*
    Attr nodes may be associated with Element nodes contained within a DocumentFragment.
  Create a new DocumentFragment and add a newly created Element node(with one attribute).
  Once the element is added, its attribute should be available as an attribute associated
  with an Element within a DocumentFragment.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-35CB04B5
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68F082
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-B63ED1A3
*/
TEST("attrcreatedocumentfragment", function() {
   var success;
    var doc;
      var docFragment;
      var newOne;
      var domesticNode;
      var domesticAttr;
      var attrs;
      var attrName;
      var appendedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      docFragment = doc.createDocumentFragment();
      newOne = doc.createElement("newElement");
      newOne.setAttribute("newdomestic","Yes");
      appendedChild = docFragment.appendChild(newOne);
      domesticNode = docFragment.firstChild;

      domesticAttr = domesticNode.attributes;

      attrs = domesticAttr.item(0);
      attrName = attrs.name;

      ASSERT(STRICT_EQ("newdomestic",attrName),"attrCreateDocumentFragmentAssert");

});



/**
*
    The "setValue()" method for an attribute creates a
  Text node with the unparsed content of the string.
  Retrieve the attribute named "street" from the last
  child of of the fourth employee and assign the "Y&ent1;"
  string to its value attribute.  This value is not yet
  parsed and therefore should still be the same upon
  retrieval. This test uses the "getNamedItem(name)" method
  from the NamedNodeMap interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-221662474
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2002Apr/0057.html
*/
TEST("attrcreatetextnode", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var streetAttr;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      addressList = doc.getElementsByTagName("address");
      testNode = addressList.item(3);
      attributes = testNode.attributes;

      streetAttr = attributes.getNamedItem("street");
      streetAttr.value = "Y&ent1;";

      value = streetAttr.value;

      ASSERT(STRICT_EQ("Y&ent1;",value),"value");
       value = streetAttr.nodeValue;

      ASSERT(STRICT_EQ("Y&ent1;",value),"nodeValue");

});



/**
*
    The "setNodeValue()" method for an attribute creates a
  Text node with the unparsed content of the string.
  Retrieve the attribute named "street" from the last
  child of of the fourth employee and assign the "Y&ent1;"
  string to its value attribute.  This value is not yet
  parsed and therefore should still be the same upon
  retrieval. This test uses the "getNamedItem(name)" method
  from the NamedNodeMap interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2002Apr/0057.html
*/
TEST("attrcreatetextnode2", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var streetAttr;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      addressList = doc.getElementsByTagName("address");
      testNode = addressList.item(3);
      attributes = testNode.attributes;

      streetAttr = attributes.getNamedItem("street");
      streetAttr.nodeValue = "Y&ent1;";

      value = streetAttr.value;

      ASSERT(STRICT_EQ("Y&ent1;",value),"value");
       value = streetAttr.nodeValue;

      ASSERT(STRICT_EQ("Y&ent1;",value),"nodeValue");

});



/**
*
    If an Attr is explicitly assigned any value, then that value is the attributes effective value.
  Retrieve the attribute named "domestic" from the last child of of the first employee
  and examine its nodeValue attribute.  This test uses the "getNamedItem(name)" method
  from the NamedNodeMap interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1074577549
*/
TEST("attreffectivevalue", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var domesticAttr;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      addressList = doc.getElementsByTagName("address");
      testNode = addressList.item(0);
      attributes = testNode.attributes;

      domesticAttr = attributes.getNamedItem("domestic");
      value = domesticAttr.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"attrEffectiveValueAssert");

});



/**
*
    The "getValue()" method will return the value of the
  attribute as a string.  The general entity references
  are replaced with their values.
  Retrieve the attribute named "street" from the last
  child of of the fourth employee and examine the string
  returned by the "getValue()" method.  The value should
  be set to "Yes" after the EntityReference is
  replaced with its value.  This test uses the
  "getNamedItem(name)" method from the NamedNodeMap
  interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-221662474
*/
TEST("attrentityreplacement", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var streetAttr;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      addressList = doc.getElementsByTagName("address");
      testNode = addressList.item(3);
      attributes = testNode.attributes;

      streetAttr = attributes.getNamedItem("street");
      value = streetAttr.value;

      ASSERT(STRICT_EQ("Yes",value),"streetYes");

});



/**
*
    The getNodeName() method of an Attribute node.
  Retrieve the attribute named street from the last
  child of of the second employee and examine its
  NodeName.  This test uses the getNamedItem(name) method from the NamedNodeMap
  interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1112119403
*/
TEST("attrname", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var streetAttr;
      var name;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      addressList = doc.getElementsByTagName("address");
      testNode = addressList.item(1);
      attributes = testNode.attributes;

      streetAttr = attributes.getNamedItem("street");
      name = streetAttr.nodeName;

      ASSERT(STRICT_EQ("street",name),"nodeName");
       name = streetAttr.name;

      ASSERT(STRICT_EQ("street",name),"name");

});



/**
*
The "getNextSibling()" method for an Attr node should return null.
Retrieve the attribute named "domestic" from the last child of of the
first employee and examine its NextSibling node.  This test uses the
"getNamedItem(name)" method from the NamedNodeMap interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6AC54C2F
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
*/
TEST("attrnextsiblingnull", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var domesticAttr;
      var s;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      addressList = doc.getElementsByTagName("address");
      testNode = addressList.item(0);
      attributes = testNode.attributes;

      domesticAttr = attributes.getNamedItem("domestic");
      s = domesticAttr.nextSibling;

      ASSERT(NULL(s),"attrNextSiblingNullAssert");

});



/**
*
The "getParentNode()" method for an Attr node should return null.  Retrieve
the attribute named "domestic" from the last child of the first employee
and examine its parentNode attribute.  This test also uses the "getNamedItem(name)"
method from the NamedNodeMap interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1060184317
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
*/
TEST("attrparentnodenull", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var domesticAttr;
      var s;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      addressList = doc.getElementsByTagName("address");
      testNode = addressList.item(0);
      attributes = testNode.attributes;

      domesticAttr = attributes.getNamedItem("domestic");
      s = domesticAttr.parentNode;

      ASSERT(NULL(s),"attrParentNodeNullAssert");

});



/**
*
The "getPreviousSibling()" method for an Attr node should return null.
Retrieve the attribute named "domestic" from the last child of of the
first employee and examine its PreviousSibling node.  This test uses the
"getNamedItem(name)" method from the NamedNodeMap interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-640FB3C8
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
*/
TEST("attrprevioussiblingnull", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var domesticAttr;
      var s;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      addressList = doc.getElementsByTagName("address");
      testNode = addressList.item(0);
      attributes = testNode.attributes;

      domesticAttr = attributes.getNamedItem("domestic");
      s = domesticAttr.previousSibling;

      ASSERT(NULL(s),"attrPreviousSiblingNullAssert");

});



/**
*
    The "getSpecified()" method for an Attr node should
  be set to true if the attribute was explicitly given
  a value.
  Retrieve the attribute named "domestic" from the last
  child of of the first employee and examine the value
  returned by the "getSpecified()" method.  This test uses
  the "getNamedItem(name)" method from the NamedNodeMap
  interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-862529273
*/
TEST("attrspecifiedvalue", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var domesticAttr;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      addressList = doc.getElementsByTagName("address");
      testNode = addressList.item(0);
      attributes = testNode.attributes;

      domesticAttr = attributes.getNamedItem("domestic");
      state = domesticAttr.specified;

      ASSERT(STRICT_EQ(true,state),"domesticSpecified");

});



/**
*
    The "getSpecified()" method for an Attr node should return true if the
  value of the attribute is changed.
  Retrieve the attribute named "street" from the last
  child of of the THIRD employee and change its
  value to "Yes"(which is the default DTD value).  This
  should cause the "getSpecified()" method to be true.
  This test uses the "setAttribute(name,value)" method
  from the Element interface and the "getNamedItem(name)"
  method from the NamedNodeMap interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-862529273
*/
TEST("attrspecifiedvaluechanged", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var streetAttr;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      addressList = doc.getElementsByTagName("address");
      testNode = addressList.item(2);
      testNode.setAttribute("street","Yes");
      attributes = testNode.attributes;

      streetAttr = attributes.getNamedItem("street");
      state = streetAttr.specified;

      ASSERT(STRICT_EQ(true,state),"streetSpecified");

});



/**
*
Retrieve the last CDATASection node located inside the
second child of the second employee and examine its
content.  Since the CDATASection interface inherits
from the CharacterData interface(via the Text node),
the "getData()" method can be used to access the
CDATA content.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
*/
TEST("cdatasectiongetdata", function() {
   var success;
    var doc;
      var nameList;
      var child;
      var lastChild;
      var data;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      nameList = doc.getElementsByTagName("name");
      child = nameList.item(1);
      lastChild = child.lastChild;

      nodeType = lastChild.nodeType;

      ASSERT(STRICT_EQ(4,nodeType),"isCDATA");
       data = lastChild.data;

      ASSERT(STRICT_EQ("This is an adjacent CDATASection with a reference to a tab &tab;",data),"data");

});



/**
*
Adjacent CDATASection nodes cannot be merged together by
use of the "normalize()" method from the Element interface.
Retrieve second child of the second employee and invoke
the "normalize()" method.  The Element under contains
two CDATASection nodes that should not be merged together
by the "normalize()" method.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-162CF083
*/
TEST("cdatasectionnormalize", function() {
   var success;
    var doc;
      var nameList;
      var lChild;
      var childNodes;
      var cdataN;
      var data;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      nameList = doc.getElementsByTagName("name");
      lChild = nameList.item(1);
      lChild.normalize();
      childNodes = lChild.childNodes;

      cdataN = childNodes.item(1);
      ASSERT(NOT_NULL(cdataN),"firstCDATASection");
data = cdataN.data;

      ASSERT(STRICT_EQ("This is a CDATASection with EntityReference number 2 &ent2;",data),"data1");
       cdataN = childNodes.item(2);
      ASSERT(NOT_NULL(cdataN),"secondCDATASection");
data = cdataN.data;

      ASSERT(STRICT_EQ("This is an adjacent CDATASection with a reference to a tab &tab;",data),"data2");

});



/**
*
    The "appendData(arg)" method appends a string to the end
   of the character data of the node.

   Retrieve the character data from the second child
   of the first employee.  The appendData(arg) method is
   called with arg=", Esquire".  The method should append
   the specified data to the already existing character
   data.  The new value return by the "getLength()" method
   should be 24.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-32791A2F
*/
TEST("characterdataappenddata", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childValue;
      var childLength;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.appendData(", Esquire");
      childValue = child.data;

      childLength = childValue.length;
      ASSERT(STRICT_EQ(24,childLength),"characterdataAppendDataAssert");

});



/**
*
    On successful invocation of the "appendData(arg)"
   method the "getData()" method provides access to the
   concatentation of data and the specified string.

   Retrieve the character data from the second child
   of the first employee.  The appendData(arg) method is
   called with arg=", Esquire".  The method should append
   the specified data to the already existing character
   data.  The new value return by the "getData()" method
   should be "Margaret Martin, Esquire".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-32791A2F
*/
TEST("characterdataappenddatagetdata", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.appendData(", Esquire");
      childData = child.data;

      ASSERT(STRICT_EQ("Margaret Martin, Esquire",childData),"characterdataAppendDataGetDataAssert");

});



/**
*
The "deleteData(offset,count)" method removes a range of
characters from the node.  Delete data at the beginning
of the character data.

Retrieve the character data from the last child of the
first employee.  The "deleteData(offset,count)"
method is then called with offset=0 and count=16.
The method should delete the characters from position
0 thru position 16.  The new value of the character data
should be "Dallas, Texas 98551".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
*/
TEST("characterdatadeletedatabegining", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.deleteData(0,16);
      childData = child.data;

      ASSERT(STRICT_EQ("Dallas, Texas 98551",childData),"characterdataDeleteDataBeginingAssert");

});



/**
*
    The "deleteData(offset,count)" method removes a range of
   characters from the node.  Delete data at the end
   of the character data.

   Retrieve the character data from the last child of the
   first employee.  The "deleteData(offset,count)"
   method is then called with offset=30 and count=5.
   The method should delete the characters from position
   30 thru position 35.  The new value of the character data
   should be "1230 North Ave. Dallas, Texas".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
*/
TEST("characterdatadeletedataend", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.deleteData(30,5);
      childData = child.data;

      ASSERT(STRICT_EQ("1230 North Ave. Dallas, Texas ",childData),"characterdataDeleteDataEndAssert");

});



/**
*
    If the sum of the offset and count used in the
   "deleteData(offset,count) method is greater than the
   length of the character data then all the characters
   from the offset to the end of the data are deleted.

   Retrieve the character data from the last child of the
   first employee.  The "deleteData(offset,count)"
   method is then called with offset=4 and count=50.
   The method should delete the characters from position 4
   to the end of the data since the offset+count(50+4)
   is greater than the length of the character data(35).
   The new value of the character data should be "1230".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
*/
TEST("characterdatadeletedataexceedslength", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.deleteData(4,50);
      childData = child.data;

      ASSERT(STRICT_EQ("1230",childData),"characterdataDeleteDataExceedsLengthAssert");

});



/**
*
    On successful invocation of the "deleteData(offset,count)"
   method, the "getData()" and "getLength()" methods reflect
   the changes.

   Retrieve the character data from the last child of the
   first employee.  The "deleteData(offset,count)"
   method is then called with offset=30 and count=5.
   The method should delete the characters from position
   30 thru position 35.  The new value of the character data
   should be "1230 North Ave. Dallas, Texas" which is
   returned by the "getData()" method and "getLength()"
   method should return 30".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7D61178C
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
*/
TEST("characterdatadeletedatagetlengthanddata", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;
      var childLength;
      var result = new Array();


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.deleteData(30,5);
      childData = child.data;

      ASSERT(STRICT_EQ("1230 North Ave. Dallas, Texas ",childData),"data");
       childLength = child.length;

      ASSERT(STRICT_EQ(30,childLength),"length");

});



/**
*
    The "deleteData(offset,count)" method removes a range of
   characters from the node.  Delete data in the middle
   of the character data.

   Retrieve the character data from the last child of the
   first employee.  The "deleteData(offset,count)"
   method is then called with offset=16 and count=8.
   The method should delete the characters from position
   16 thru position 24.  The new value of the character data
   should be "1230 North Ave. Texas 98551".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
*/
TEST("characterdatadeletedatamiddle", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.deleteData(16,8);
      childData = child.data;

      ASSERT(STRICT_EQ("1230 North Ave. Texas 98551",childData),"characterdataDeleteDataMiddleAssert");

});



/**
*

    The "getData()" method retrieves the character data

  currently stored in the node.

  Retrieve the character data from the second child

  of the first employee and invoke the "getData()"

  method.  The method returns the character data

  string.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
*/
TEST("characterdatagetdata", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      childData = child.data;

      ASSERT(STRICT_EQ("Margaret Martin",childData),"characterdataGetDataAssert");

});



/**
*
    The "getLength()" method returns the number of characters
  stored in this nodes data.
  Retrieve the character data from the second
  child of the first employee and examine the
  value returned by the getLength() method.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7D61178C
*/
TEST("characterdatagetlength", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childValue;
      var childLength;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      childValue = child.data;

      childLength = childValue.length;
      ASSERT(STRICT_EQ(15,childLength),"characterdataGetLengthAssert");

});



/**
*
    The "deleteData(offset,count)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is greater that the number of characters in the string.

   Retrieve the character data of the last child of the
   first employee and invoke its "deleteData(offset,count)"
   method with offset=40 and count=3.  It should raise the
   desired exception since the offset is greater than the
   number of characters in the string.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-7C603781')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("characterdataindexsizeerrdeletedataoffsetgreater", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            child.deleteData(40,3);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INDEX_SIZE_ERR");
	}

});



/**
*
    The "deleteData(offset,count)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is negative.

   Retrieve the character data of the last child of the
   first employee and invoke its "deleteData(offset,count)"
   method with offset=-5 and count=3.  It should raise the
   desired exception since the offset is negative.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-7C603781')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
*/
TEST("characterdataindexsizeerrdeletedataoffsetnegative", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            child.deleteData(-5,3);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throws_INDEX_SIZE_ERR");
	}

});



/**
*
    The "insertData(offset,arg)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is greater than the number of characters in the string.

   Retrieve the character data of the last child of the
   first employee and invoke its insertData"(offset,arg)"
   method with offset=40 and arg="ABC".  It should raise
   the desired exception since the offset is greater than
   the number of characters in the string.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-7C603781')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("characterdataindexsizeerrinsertdataoffsetgreater", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            child.insertData(40,"ABC");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INDEX_SIZE_ERR");
	}

});



/**
*
    The "insertData(offset,arg)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is negative.

   Retrieve the character data of the last child of the
   first employee and invoke its insertData"(offset,arg)"
   method with offset=-5 and arg="ABC".  It should raise
   the desired exception since the offset is negative.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-E5CBA7FB')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
*/
TEST("characterdataindexsizeerrinsertdataoffsetnegative", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            child.insertData(-5,"ABC");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throws_INDEX_SIZE_ERR");
	}

});



/**
*
    The "replaceData(offset,count,arg)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is greater than the length of the string.

   Retrieve the character data of the last child of the
   first employee and invoke its
   "replaceData(offset,count,arg) method with offset=40
   and count=3 and arg="ABC".  It should raise the
   desired exception since the offset is greater than the
   length of the string.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-7C603781')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("characterdataindexsizeerrreplacedataoffsetgreater", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            child.replaceData(40,3,"ABC");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INDEX_SIZE_ERR");
	}

});



/**
*
    The "replaceData(offset,count,arg)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is negative.

   Retrieve the character data of the last child of the
   first employee and invoke its
   "replaceData(offset,count,arg) method with offset=-5
   and count=3 and arg="ABC".  It should raise the
   desired exception since the offset is negative.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-E5CBA7FB')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
*/
TEST("characterdataindexsizeerrreplacedataoffsetnegative", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            child.replaceData(-5,3,"ABC");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throws_INDEX_SIZE_ERR");
	}

});



/**
*
    The "substringData(offset,count)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is negative.

   Retrieve the character data of the last child of the
   first employee and invoke its "substringData(offset,count)
   method with offset=-5 and count=3.  It should raise the
   desired exception since the offset is negative.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6531BCCF
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-6531BCCF')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
*/
TEST("characterdataindexsizeerrsubstringnegativeoffset", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var badString;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            badString = child.substringData(-5,3);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throws_INDEX_SIZE_ERR");
	}

});



/**
*
    The "substringData(offset,count)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is greater than the number of characters in the string.

   Retrieve the character data of the last child of the
   first employee and invoke its "substringData(offset,count)
   method with offset=40 and count=3.  It should raise the
   desired exception since the offsets value is greater
   than the length.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6531BCCF
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-6531BCCF')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("characterdataindexsizeerrsubstringoffsetgreater", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var badString;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            badString = child.substringData(40,3);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INDEX_SIZE_ERR");
	}

});



/**
*
The "insertData(offset,arg)" method will insert a string
at the specified character offset.  Insert the data at
the beginning of the character data.

Retrieve the character data from the second child of
the first employee.  The "insertData(offset,arg)"
method is then called with offset=0 and arg="Mss.".
The method should insert the string "Mss." at position 0.
The new value of the character data should be
"Mss. Margaret Martin".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3EDB695F
*/
TEST("characterdatainsertdatabeginning", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.insertData(0,"Mss. ");
      childData = child.data;

      ASSERT(STRICT_EQ("Mss. Margaret Martin",childData),"characterdataInsertDataBeginningAssert");

});



/**
*
    The "insertData(offset,arg)" method will insert a string
   at the specified character offset.  Insert the data at
   the end of the character data.

   Retrieve the character data from the second child of
   the first employee.  The "insertData(offset,arg)"
   method is then called with offset=15 and arg=", Esquire".
   The method should insert the string ", Esquire" at
   position 15.  The new value of the character data should
   be "Margaret Martin, Esquire".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3EDB695F
*/
TEST("characterdatainsertdataend", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.insertData(15,", Esquire");
      childData = child.data;

      ASSERT(STRICT_EQ("Margaret Martin, Esquire",childData),"characterdataInsertDataEndAssert");

});



/**
*
    The "insertData(offset,arg)" method will insert a string
   at the specified character offset.  Insert the data in
   the middle of the character data.

   Retrieve the character data from the second child of
   the first employee.  The "insertData(offset,arg)"
   method is then called with offset=9 and arg="Ann".
   The method should insert the string "Ann" at position 9.
   The new value of the character data should be
   "Margaret Ann Martin".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3EDB695F
*/
TEST("characterdatainsertdatamiddle", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.insertData(9,"Ann ");
      childData = child.data;

      ASSERT(STRICT_EQ("Margaret Ann Martin",childData),"characterdataInsertDataMiddleAssert");

});



/**
*
The "replaceData(offset,count,arg)" method replaces the
characters starting at the specified offset with the
specified string.  Test for replacement in the
middle of the data.

Retrieve the character data from the last child of the
first employee.  The "replaceData(offset,count,arg)"
method is then called with offset=5 and count=5 and
arg="South".  The method should replace characters five
thru 9 of the character data with "South".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
*/
TEST("characterdatareplacedatabegining", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.replaceData(0,4,"2500");
      childData = child.data;

      ASSERT(STRICT_EQ("2500 North Ave. Dallas, Texas 98551",childData),"characterdataReplaceDataBeginingAssert");

});



/**
*
    The "replaceData(offset,count,arg)" method replaces the
   characters starting at the specified offset with the
   specified string.  Test for replacement at the
   end of the data.

   Retrieve the character data from the last child of the
   first employee.  The "replaceData(offset,count,arg)"
   method is then called with offset=30 and count=5 and
   arg="98665".  The method should replace characters 30
   thru 34 of the character data with "98665".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
*/
TEST("characterdatareplacedataend", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.replaceData(30,5,"98665");
      childData = child.data;

      ASSERT(STRICT_EQ("1230 North Ave. Dallas, Texas 98665",childData),"characterdataReplaceDataEndAssert");

});



/**
*
    The "replaceData(offset,count,arg)" method replaces the
   characters starting at the specified offset with the
   specified string.  Test the situation where the length
   of the arg string is greater than the specified offset.

   Retrieve the character data from the last child of the
   first employee.  The "replaceData(offset,count,arg)"
   method is then called with offset=0 and count=4 and
   arg="260030".  The method should replace characters one
   thru four with "260030".  Note that the length of the
   specified string is greater that the specified offset.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
*/
TEST("characterdatareplacedataexceedslengthofarg", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.replaceData(0,4,"260030");
      childData = child.data;

      ASSERT(STRICT_EQ("260030 North Ave. Dallas, Texas 98551",childData),"characterdataReplaceDataExceedsLengthOfArgAssert");

});



/**
*
    If the sum of the offset and count exceeds the length then
   all the characters to the end of the data are replaced.

   Retrieve the character data from the last child of the
   first employee.  The "replaceData(offset,count,arg)"
   method is then called with offset=0 and count=50 and
   arg="2600".  The method should replace all the characters
   with "2600". This is because the sum of the offset and
   count exceeds the length of the character data.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
*/
TEST("characterdatareplacedataexceedslengthofdata", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.replaceData(0,50,"2600");
      childData = child.data;

      ASSERT(STRICT_EQ("2600",childData),"characterdataReplaceDataExceedsLengthOfDataAssert");

});



/**
*
    The "replaceData(offset,count,arg)" method replaces the
   characters starting at the specified offset with the
   specified string.  Test for replacement in the
   middle of the data.

   Retrieve the character data from the last child of the
   first employee.  The "replaceData(offset,count,arg)"
   method is then called with offset=5 and count=5 and
   arg="South".  The method should replace characters five
   thru 9 of the character data with "South".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
*/
TEST("characterdatareplacedatamiddle", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.replaceData(5,5,"South");
      childData = child.data;

      ASSERT(STRICT_EQ("1230 South Ave. Dallas, Texas 98551",childData),"characterdataReplaceDataMiddleAssert");

});



/**
*
  The "setNodeValue()" method changes the character data
  currently stored in the node.
  Retrieve the character data from the second child
  of the first employee and invoke the "setNodeValue()"
  method, call "getData()" and compare.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
*/
TEST("characterdatasetnodevalue", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;
      var childValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.nodeValue = "Marilyn Martin";

      childData = child.data;

      ASSERT(STRICT_EQ("Marilyn Martin",childData),"data");
       childValue = child.nodeValue;

      ASSERT(STRICT_EQ("Marilyn Martin",childValue),"value");

});



/**
*
    If the sum of the "offset" and "count" exceeds the
   "length" then the "substringData(offset,count)" method
   returns all the characters to the end of the data.

   Retrieve the character data from the second child
   of the first employee and access part of the data
   by using the substringData(offset,count) method
   with offset=9 and count=10.  The method should return
   the substring "Martin" since offset+count > length
   (19 > 15).

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6531BCCF
*/
TEST("characterdatasubstringexceedsvalue", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var substring;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      substring = child.substringData(9,10);
      ASSERT(STRICT_EQ("Martin",substring),"characterdataSubStringExceedsValueAssert");

});



/**
*
    The "substringData(offset,count)" method returns the
   specified string.

   Retrieve the character data from the second child
   of the first employee and access part of the data
   by using the substringData(offset,count) method.  The
   method should return the specified substring starting
   at position "offset" and extract "count" characters.
   The method should return the string "Margaret".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6531BCCF
*/
TEST("characterdatasubstringvalue", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var substring;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      substring = child.substringData(0,8);
      ASSERT(STRICT_EQ("Margaret",substring),"characterdataSubStringValueAssert");

});



/**
*
    A comment is all the characters between the starting
  '<!--' and ending '-->'
  Retrieve the nodes of the DOM document.  Search for a
  comment node and the content is its value.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1334481328
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
*/
TEST("commentgetcomment", function() {
   var success;
    var doc;
      var elementList;
      var child;
      var childName;
      var childValue;
      var commentCount = 0;
      var childType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.childNodes;

      for(var indexid2258656 = 0;indexid2258656 < elementList.length; indexid2258656++) {
      child = elementList.item(indexid2258656);
      childType = child.nodeType;


	if(
	(8 == childType)
	) {
	childName = child.nodeName;

      ASSERT(STRICT_EQ("#comment",childName),"nodeName");
       childValue = child.nodeValue;

      ASSERT(STRICT_EQ(" This is comment number 1.",childValue),"nodeValue");
       commentCount = commentCount + 1;

	}
	
	}
   ASSERT(STRICT_EQ(1,commentCount),"commentCount");

});



/**
*
    The "createAttribute(name)" method creates an Attribute
   node of the given name.

   Retrieve the entire DOM document and invoke its
   "createAttribute(name)" method.  It should create a
   new Attribute node with the given name. The name, value
   and type of the newly created object are retrieved and
   output.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1084891198
*/
TEST("documentcreateattribute", function() {
   var success;
    var doc;
      var newAttrNode;
      var attrValue;
      var attrName;
      var attrType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newAttrNode = doc.createAttribute("district");
      attrValue = newAttrNode.nodeValue;

      ASSERT(STRICT_EQ("",attrValue),"value");
       attrName = newAttrNode.nodeName;

      ASSERT(STRICT_EQ("district",attrName),"name");
       attrType = newAttrNode.nodeType;

      ASSERT(STRICT_EQ(2,attrType),"type");

});



/**
*
    The "createCDATASection(data)" method creates a new
   CDATASection node whose value is the specified string.
   Retrieve the entire DOM document and invoke its
   "createCDATASection(data)" method.  It should create a
   new CDATASection node whose "data" is the specified
   string.  The content, name and type are retrieved and
   output.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D26C0AF8
*/
TEST("documentcreatecdatasection", function() {
   var success;
    var doc;
      var newCDATASectionNode;
      var newCDATASectionValue;
      var newCDATASectionName;
      var newCDATASectionType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newCDATASectionNode = doc.createCDATASection("This is a new CDATASection node");
      newCDATASectionValue = newCDATASectionNode.nodeValue;

      ASSERT(STRICT_EQ("This is a new CDATASection node",newCDATASectionValue),"nodeValue");
       newCDATASectionName = newCDATASectionNode.nodeName;

      ASSERT(STRICT_EQ("#cdata-section",newCDATASectionName),"nodeName");
       newCDATASectionType = newCDATASectionNode.nodeType;

      ASSERT(STRICT_EQ(4,newCDATASectionType),"nodeType");

});



/**
*
    The "createComment(data)" method creates a new Comment
   node given the specified string.
   Retrieve the entire DOM document and invoke its
   "createComment(data)" method.  It should create a new
   Comment node whose "data" is the specified string.
   The content, name and type are retrieved and output.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1334481328
*/
TEST("documentcreatecomment", function() {
   var success;
    var doc;
      var newCommentNode;
      var newCommentValue;
      var newCommentName;
      var newCommentType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newCommentNode = doc.createComment("This is a new Comment node");
      newCommentValue = newCommentNode.nodeValue;

      ASSERT(STRICT_EQ("This is a new Comment node",newCommentValue),"value");
       newCommentName = newCommentNode.nodeName;

      ASSERT(STRICT_EQ("#comment",newCommentName),"name");
       newCommentType = newCommentNode.nodeType;

      ASSERT(STRICT_EQ(8,newCommentType),"type");

});



/**
*
    The "createDocumentFragment()" method creates an empty
   DocumentFragment object.
   Retrieve the entire DOM document and invoke its
   "createDocumentFragment()" method.  The content, name,
   type and value of the newly created object are output.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-35CB04B5
*/
TEST("documentcreatedocumentfragment", function() {
   var success;
    var doc;
      var newDocFragment;
      var children;
      var length;
      var newDocFragmentName;
      var newDocFragmentType;
      var newDocFragmentValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newDocFragment = doc.createDocumentFragment();
      children = newDocFragment.childNodes;

      length = children.length;

      ASSERT(STRICT_EQ(0,length),"length");
       newDocFragmentName = newDocFragment.nodeName;

      ASSERT(STRICT_EQ("#document-fragment",newDocFragmentName),"name");
       newDocFragmentType = newDocFragment.nodeType;

      ASSERT(STRICT_EQ(11,newDocFragmentType),"type");
       newDocFragmentValue = newDocFragment.nodeValue;

      ASSERT(NULL(newDocFragmentValue),"value");

});



/**
*
    The "createElement(tagName)" method creates an Element
   of the type specified.
   Retrieve the entire DOM document and invoke its
   "createElement(tagName)" method with tagName="address".
   The method should create an instance of an Element node
   whose tagName is "address".  The NodeName, NodeType
   and NodeValue are returned.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547
*/
TEST("documentcreateelement", function() {
   var success;
    var doc;
      var newElement;
      var newElementName;
      var newElementType;
      var newElementValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newElement = doc.createElement("address");
      newElementName = newElement.nodeName;

      ASSERT(STRICT_EQ("address",newElementName),"name");
       newElementType = newElement.nodeType;

      ASSERT(STRICT_EQ(1,newElementType),"type");
       newElementValue = newElement.nodeValue;

      ASSERT(NULL(newElementValue),"valueInitiallyNull");

});



/**
*
    The tagName parameter in the "createElement(tagName)"
   method is case-sensitive for XML documents.
   Retrieve the entire DOM document and invoke its
   "createElement(tagName)" method twice.  Once for tagName
   equal to "address" and once for tagName equal to "ADDRESS"
   Each call should create a distinct Element node.  The
   newly created Elements are then assigned attributes
   that are retrieved.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547
*/
TEST("documentcreateelementcasesensitive", function() {
   var success;
    var doc;
      var newElement1;
      var newElement2;
      var attribute1;
      var attribute2;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newElement1 = doc.createElement("ADDRESS");
      newElement2 = doc.createElement("address");
      newElement1.setAttribute("district","Fort Worth");
      newElement2.setAttribute("county","Dallas");
      attribute1 = newElement1.getAttribute("district");
      attribute2 = newElement2.getAttribute("county");
      ASSERT(STRICT_EQ("Fort Worth",attribute1),"attrib1");
       ASSERT(STRICT_EQ("Dallas",attribute2),"attrib2");

});



/**
*
    The "createProcessingInstruction(target,data)" method
   creates a new ProcessingInstruction node with the
   specified name and data string.

   Retrieve the entire DOM document and invoke its
   "createProcessingInstruction(target,data)" method.
   It should create a new PI node with the specified target
   and data.  The target, data and type are retrieved and
   output.

* @author NIST
* @author Mary Brady
* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2001Apr/0020.html
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-135944439
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("documentcreateprocessinginstruction", function() {
   var success;
    var doc;
      var newPINode;
      var piValue;
      var piName;
      var piType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newPINode = doc.createProcessingInstruction("TESTPI","This is a new PI node");
      ASSERT(NOT_NULL(newPINode),"createdPINotNull");
piName = newPINode.nodeName;

      ASSERT(STRICT_EQ("TESTPI",piName),"name");
       piValue = newPINode.nodeValue;

      ASSERT(STRICT_EQ("This is a new PI node",piValue),"value");
       piType = newPINode.nodeType;

      ASSERT(STRICT_EQ(7,piType),"type");

});



/**
*
    The "createTextNode(data)" method creates a Text node
   given the specfied string.
   Retrieve the entire DOM document and invoke its
   "createTextNode(data)" method.  It should create a
   new Text node whose "data" is the specified string.
   The NodeName and NodeType are also checked.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1975348127
*/
TEST("documentcreatetextnode", function() {
   var success;
    var doc;
      var newTextNode;
      var newTextName;
      var newTextValue;
      var newTextType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newTextNode = doc.createTextNode("This is a new Text node");
      newTextValue = newTextNode.nodeValue;

      ASSERT(STRICT_EQ("This is a new Text node",newTextValue),"value");
       newTextName = newTextNode.nodeName;

      ASSERT(STRICT_EQ("#text",newTextName),"name");
       newTextType = newTextNode.nodeType;

      ASSERT(STRICT_EQ(3,newTextType),"type");

});



/**
*
    The "getDoctype()" method returns null for XML documents
   without a document type declaration.
   Retrieve the XML document without a DTD and invoke the
   "getDoctype()" method.  It should return null.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-B63ED1A31
*/
TEST("documentgetdoctypenodtd", function() {
   var success;
    var doc;
      var docType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_nodtdstaff");
      docType = doc.doctype;

      ASSERT(NULL(docType),"documentGetDocTypeNoDTDAssert");

});



/**
*
    The "getElementsByTagName(tagName)" method returns a
   NodeList of all the Elements with a given tagName.

   Retrieve the entire DOM document and invoke its
   "getElementsByTagName(tagName)" method with tagName
   equal to "name".  The method should return a NodeList
   that contains 5 elements.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-A6C9094
*/
TEST("documentgetelementsbytagnamelength", function() {
   var success;
    var doc;
      var nameList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      nameList = doc.getElementsByTagName("name");
      ASSERT(STRICT_EQ(5,nameList.length),"documentGetElementsByTagNameLengthAssert");

});



/**
*
    The "getElementsByTagName(tagName)" method returns a
   NodeList of all the Elements with a given tagName
   in a pre-order traversal of the tree.

   Retrieve the entire DOM document and invoke its
   "getElementsByTagName(tagName)" method with tagName
   equal to "name".  The method should return a NodeList
   that contains 5 elements.  The FOURTH item in the
   list is retrieved and output.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-A6C9094
*/
TEST("documentgetelementsbytagnamevalue", function() {
   var success;
    var doc;
      var nameList;
      var nameNode;
      var firstChild;
      var childValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      nameList = doc.getElementsByTagName("name");
      nameNode = nameList.item(3);
      firstChild = nameNode.firstChild;

      childValue = firstChild.nodeValue;

      ASSERT(STRICT_EQ("Jeny Oconnor",childValue),"documentGetElementsByTagNameValueAssert");

});



/**
*
    The "getImplementation()" method returns the
   DOMImplementation object that handles this document.
   Retrieve the entire DOM document and invoke its
   "getImplementation()" method.  It should return a
   DOMImplementation whose "hasFeature("XML","1.0")
   method returns the boolean value "true".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1B793EBA
*/
TEST("documentgetimplementation", function() {
   var success;
    var doc;
      var docImpl;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      docImpl = doc.implementation;
state = docImpl.hasFeature("XML","1.0");
ASSERT(STRICT_EQ(true,state),"documentGetImplementationAssert");

});



/**
*
    The "getDocumentElement()" method provides direct access
   to the child node that is the root element of the document.
   Retrieve the entire DOM document and invoke its
   "getDocumentElement()" method.  It should return an
   Element node whose NodeName is "staff" (or "svg").

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-87CD092
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=251
*/
TEST("documentgetrootnode", function() {
   var success;
    var doc;
      var root;
      var rootName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      root = doc.documentElement;

      rootName = root.nodeName;


	if(
	
	(builder.contentType == "image/svg+xml")

	) {
	ASSERT(STRICT_EQ("svg",rootName),"svgRootNode");

	}
	
		else {
			ASSERT(STRICT_EQ("staff",rootName),"documentGetRootNodeAssert");

		}
	
});



/**
*
    The "createAttribute(tagName)" method raises an
   INVALID_CHARACTER_ERR DOMException if the specified
   tagName contains an invalid character.

   Retrieve the entire DOM document and invoke its
   "createAttribute(tagName)" method with the tagName equal
   to the string "invalid^Name".  Due to the invalid
   character the desired EXCEPTION should be raised.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1084891198
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-1084891198')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1084891198
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("documentinvalidcharacterexceptioncreateattribute", function() {
   var success;
    var doc;
      var createdAttr;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");

	{
		success = false;
		try {
            createdAttr = doc.createAttribute("invalid^Name");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 5);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INVALID_CHARACTER_ERR");
	}

});



/**
*
    The "createElement(tagName)" method raises an
   INVALID_CHARACTER_ERR DOMException if the specified
   tagName contains an invalid character.

   Retrieve the entire DOM document and invoke its
   "createElement(tagName)" method with the tagName equal
   to the string "invalid^Name".  Due to the invalid
   character the desired EXCEPTION should be raised.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-2141741547')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("documentinvalidcharacterexceptioncreateelement", function() {
   var success;
    var doc;
      var badElement;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");

	{
		success = false;
		try {
            badElement = doc.createElement("invalid^Name");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 5);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INVALID_CHARACTER_ERR");
	}

});



/**
*
    The "createProcessingInstruction(target,data) method
   raises an INVALID_CHARACTER_ERR DOMException if the
   specified tagName contains an invalid character.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-135944439
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-135944439')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("documentinvalidcharacterexceptioncreatepi", function() {
   var success;
    var doc;
      var badPI;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");

	if(
	
	(builder.contentType == "text/html")

	) {
	
	{
		success = false;
		try {
            badPI = doc.createProcessingInstruction("foo","data");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 9);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_SUPPORTED_ERR");
	}

	}
	
		else {
			
	{
		success = false;
		try {
            badPI = doc.createProcessingInstruction("invalid^Name","data");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 5);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INVALID_CHARACTER_ERR");
	}

		}
	
});



/**
*
Creating a processing instruction with an empty target should cause an INVALID_CHARACTER_ERR.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-135944439
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-135944439')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=525
*/
TEST("documentinvalidcharacterexceptioncreatepi1", function() {
   var success;
    var doc;
      var badPI;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");

	if(
	
	(builder.contentType == "text/html")

	) {
	
	{
		success = false;
		try {
            badPI = doc.createProcessingInstruction("foo","data");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 9);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_SUPPORTED_ERR");
	}

	}
	
		else {
			
	{
		success = false;
		try {
            badPI = doc.createProcessingInstruction("","data");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 5);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INVALID_CHARACTER_ERR");
	}

		}
	
});



/**
*
hasFeature("XML", "") should return true for implementations that can read staff files.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-5CED94D7
* @see http://www.w3.org/2000/11/DOM-Level-2-errata#core-14
*/
TEST("domimplementationfeaturenoversion", function() {
   var success;
    var doc;
      var domImpl;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      domImpl = doc.implementation;
state = domImpl.hasFeature("XML","");
ASSERT(STRICT_EQ(true,state),"hasXMLEmpty");

});



/**
*
hasFeature("XML", null) should return true for implementations that can read staff documents.

* @author NIST
* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-5CED94D7
* @see http://www.w3.org/2000/11/DOM-Level-2-errata#core-14
*/
TEST("domimplementationfeaturenull", function() {
   var success;
    var doc;
      var domImpl;
      var state;
      var nullVersion = null;


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      domImpl = doc.implementation;
state = domImpl.hasFeature("XML",nullVersion);
ASSERT(STRICT_EQ(true,state),"hasXMLnull");

});



/**
*
hasFeature("xml", "1.0") should return true for implementations that can read staff documents.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-5CED94D7
*/
TEST("domimplementationfeaturexml", function() {
   var success;
    var doc;
      var domImpl;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      domImpl = doc.implementation;
state = domImpl.hasFeature("xml","1.0");
ASSERT(STRICT_EQ(true,state),"hasXML1");

});



/**
*
    The "setAttribute(name,value)" method adds a new attribute
   to the Element

   Retrieve the last child of the last employee, then
   add an attribute to it by invoking the
   "setAttribute(name,value)" method.  It should create
   a "name" attribute with an assigned value equal to
   "value".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68F082
*/
TEST("elementaddnewattribute", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(4);
      testEmployee.setAttribute("district","dallas");
      attrValue = testEmployee.getAttribute("district");
      ASSERT(STRICT_EQ("dallas",attrValue),"elementAddNewAttributeAssert");

});



/**
*
    Elements may have attributes associated with them.

   Retrieve the first attribute from the last child of
   the first employee and invoke the "getSpecified()"
   method.  This test is only intended to show that
   Elements can actually have attributes.  This test uses
   the "getNamedItem(name)" method from the NamedNodeMap
   interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
*/
TEST("elementassociatedattribute", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var domesticAttr;
      var specified;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(0);
      attributes = testEmployee.attributes;

      domesticAttr = attributes.getNamedItem("domestic");
      specified = domesticAttr.specified;

      ASSERT(STRICT_EQ(true,specified),"domesticSpecified");

});



/**
*
    The "setAttribute(name,value)" method adds a new attribute
   to the Element.  If the "name" is already present, then
   its value should be changed to the new one that is in
   the "value" parameter.

   Retrieve the last child of the fourth employee, then add
   an attribute to it by invoking the
   "setAttribute(name,value)" method.  Since the name of the
   used attribute("street") is already present in this
   element, then its value should be changed to the new one
   of the "value" parameter.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68F082
*/
TEST("elementchangeattributevalue", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(3);
      testEmployee.setAttribute("street","Neither");
      attrValue = testEmployee.getAttribute("street");
      ASSERT(STRICT_EQ("Neither",attrValue),"elementChangeAttributeValueAssert");

});



/**
*
    The "setAttributeNode(newAttr)" method adds a new
   attribute to the Element.

   Retrieve first address element and add
   a new attribute node to it by invoking its
   "setAttributeNode(newAttr)" method.  This test makes use
   of the "createAttribute(name)" method from the Document
   interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154
*/
TEST("elementcreatenewattribute", function() {
   var success;
    var doc;
      var elementList;
      var testAddress;
      var newAttribute;
      var oldAttr;
      var districtAttr;
      var attrVal;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddress = elementList.item(0);
      newAttribute = doc.createAttribute("district");
      oldAttr = testAddress.setAttributeNode(newAttribute);
      ASSERT(NULL(oldAttr),"old_attr_doesnt_exist");
    districtAttr = testAddress.getAttributeNode("district");
      ASSERT(NOT_NULL(districtAttr),"new_district_accessible");
attrVal = testAddress.getAttribute("district");
      ASSERT(STRICT_EQ("",attrVal),"attr_value");

});



/**
*
    The "getAttributeNode(name)" method retrieves an
   attribute node by name.

   Retrieve the attribute "domestic" from the last child
   of the first employee.  Since the method returns an
   Attr object, the "name" can be examined to ensure the
   proper attribute was retrieved.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-217A91B8
*/
TEST("elementgetattributenode", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var domesticAttr;
      var name;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(0);
      domesticAttr = testEmployee.getAttributeNode("domestic");
      name = domesticAttr.nodeName;

      ASSERT(STRICT_EQ("domestic",name),"elementGetAttributeNodeAssert");

});



/**
*
    The "getAttributeNode(name)" method retrieves an
   attribute node by name.  It should return null if the
   "name" attribute does not exist.

   Retrieve the last child of the first employee and attempt
   to retrieve a non-existing attribute.  The method should
   return "null".  The non-existing attribute to be used
   is "invalidAttribute".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-217A91B8
*/
TEST("elementgetattributenodenull", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var domesticAttr;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(0);
      domesticAttr = testEmployee.getAttributeNode("invalidAttribute");
      ASSERT(NULL(domesticAttr),"elementGetAttributeNodeNullAssert");

});



/**
*
    The "getAttribute(name)" method returns an empty
   string if no value was assigned to an attribute and
   no default value was given in the DTD file.

   Retrieve the last child of the last employee, then
   invoke "getAttribute(name)" method, where "name" is an
   attribute without a specified or DTD default value.
   The "getAttribute(name)" method should return the empty
   string.  This method makes use of the
   "createAttribute(newAttr)" method from the Document
   interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-666EE0F9
*/
TEST("elementgetelementempty", function() {
   var success;
    var doc;
      var newAttribute;
      var elementList;
      var testEmployee;
      var domesticAttr;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newAttribute = doc.createAttribute("district");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(3);
      domesticAttr = testEmployee.setAttributeNode(newAttribute);
      attrValue = testEmployee.getAttribute("district");
      ASSERT(STRICT_EQ("",attrValue),"elementGetElementEmptyAssert");

});



/**
*
The "getElementsByTagName(name)" method returns a list
of all descendant Elements with the given tag name.
Test for an empty list.

Create a NodeList of all the descendant elements
using the string "noMatch" as the tagName.
The method should return a NodeList whose length is
"0" since there are not any descendant elements
that match the given tag name.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1938918D
*/
TEST("elementgetelementsbytagname", function() {
   var success;
    var doc;
      var elementList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      ASSERT(STRICT_EQ(5,elementList.length),"elementGetElementsByTagNameAssert");

});



/**
*
Element.getElementsByTagName("employee") should return a NodeList whose length is
"5" in the order the children were encountered.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1938918D
*/
TEST("elementgetelementsbytagnameaccessnodelist", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var child;
      var childName;
      var childValue;
      var childType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      testEmployee = elementList.item(3);
      child = testEmployee.firstChild;

      childType = child.nodeType;


	if(
	(3 == childType)
	) {
	child = child.nextSibling;


	}
	childName = child.nodeName;

      ASSERT(STRICT_EQ("employeeId",childName),"nodename");
       child = child.firstChild;

      childValue = child.nodeValue;

      ASSERT(STRICT_EQ("EMP0004",childValue),"emp0004");

});



/**
*
The "getElementsByTagName(name)" method returns a list
of all descendant Elements with the given tag name.

Create a NodeList of all the descendant elements
using the string "employee" as the tagName.
The method should return a NodeList whose length is
"5".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1938918D
*/
TEST("elementgetelementsbytagnamenomatch", function() {
   var success;
    var doc;
      var elementList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("noMatch");
      ASSERT(STRICT_EQ(0,elementList.length),"elementGetElementsByTagNameNoMatchNoMatchAssert");

});



/**
*
The "getElementsByTagName(name)" method may use the
special value "*" to match all tags in the element
tree.

Create a NodeList of all the descendant elements
of the last employee by using the special value "*".
The method should return all the descendant children(6)
in the order the children were encountered.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1938918D
*/
TEST("elementgetelementsbytagnamespecialvalue", function() {
   var success;
    var doc;
      var elementList;
      var lastEmployee;
      var lastempList;
      var child;
      var childName;
      var result = new Array();

      expectedResult = new Array();
      expectedResult[0] = "employeeId";
      expectedResult[1] = "name";
      expectedResult[2] = "position";
      expectedResult[3] = "salary";
      expectedResult[4] = "gender";
      expectedResult[5] = "address";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      lastEmployee = elementList.item(4);
      lastempList = lastEmployee.getElementsByTagName("*");
      for(var indexid2258684 = 0;indexid2258684 < lastempList.length; indexid2258684++) {
      child = lastempList.item(indexid2258684);
      childName = child.nodeName;

      result[result.length] = childName;

	}
   ASSERT(DOM_LIST_EQ(expectedResult,result),"tagNames");

});



/**
*

    The "getTagName()" method returns the

   tagName of an element.



   Invoke the "getTagName()" method one the

   root node. The value returned should be "staff".


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-104682815
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=251
*/
TEST("elementgettagname", function() {
   var success;
    var doc;
      var root;
      var tagname;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      root = doc.documentElement;

      tagname = root.tagName;


	if(
	
	(builder.contentType == "image/svg+xml")

	) {
	ASSERT(STRICT_EQ("svg",tagname),"svgTagName");

	}
	
		else {
			ASSERT(STRICT_EQ("staff",tagname),"elementGetTagNameAssert");

		}
	
});



/**
*
    The "setAttributeNode(newAttr)" method raises an
   "INUSE_ATTRIBUTE_ERR DOMException if the "newAttr"
   is already an attribute of another element.

   Retrieve the last child of the second employee and append
   a newly created element.  The "createAttribute(name)"
   and "setAttributeNode(newAttr)" methods are invoked
   to create and add a new attribute to the newly created
   Element.  The "setAttributeNode(newAttr)" method is
   once again called to add the new attribute causing an
   exception to be raised since the attribute is already
   an attribute of another element.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-887236154')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INUSE_ATTRIBUTE_ERR'])
*/
TEST("elementinuseattributeerr", function() {
   var success;
    var doc;
      var newAttribute;
      var addressElementList;
      var testAddress;
      var newElement;
      var appendedChild;
      var setAttr1;
      var setAttr2;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      addressElementList = doc.getElementsByTagName("address");
      testAddress = addressElementList.item(1);
      newElement = doc.createElement("newElement");
      appendedChild = testAddress.appendChild(newElement);
      newAttribute = doc.createAttribute("newAttribute");
      setAttr1 = newElement.setAttributeNode(newAttribute);

	{
		success = false;
		try {
            setAttr2 = testAddress.setAttributeNode(newAttribute);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 10);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INUSE_ATTRIBUTE_ERR");
	}

});



/**
*

    The "setAttribute(name,value)" method raises an

   "INVALID_CHARACTER_ERR DOMException if the specified

   name contains an invalid character.



   Retrieve the last child of the first employee and

   call its "setAttribute(name,value)" method with

   "name" containing an invalid character.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68F082
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-F68F082')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("elementinvalidcharacterexception", function() {
   var success;
    var doc;
      var elementList;
      var testAddress;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddress = elementList.item(0);

	{
		success = false;
		try {
            testAddress.setAttribute("invalid^Name","value");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 5);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INVALID_CHARACTER_ERR");
	}

});



/**
*
    The "normalize()" method puts all the nodes in the full
   depth of the sub-tree underneath this element into a
   "normal" form.

   Retrieve the third employee and access its second child.
   This child contains a block of text that is spread
   across multiple lines.  The content of the "name" child
   should be parsed and treated as a single Text node.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-162CF083
*/
TEST("elementnormalize", function() {
   var success;
    var doc;
      var root;
      var elementList;
      var testName;
      var firstChild;
      var childValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      root = doc.documentElement;

      root.normalize();
      elementList = root.getElementsByTagName("name");
      testName = elementList.item(2);
      firstChild = testName.firstChild;

      childValue = firstChild.nodeValue;

      ASSERT(STRICT_EQ("Roger\n Jones",childValue),"elementNormalizeAssert");

});



/**
*
    The "removeAttributeNode(oldAttr)" method raises a
   NOT_FOUND_ERR DOMException if the "oldAttr" attribute
   is not an attribute of the element.

   Retrieve the last employee and attempt to remove
   a non existing attribute node.  This should cause the
   intended exception to be raised.  This test makes use
   of the "createAttribute(name)" method from the Document
   interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D589198
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-D589198')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("elementnotfounderr", function() {
   var success;
    var doc;
      var oldAttribute;
      var addressElementList;
      var testAddress;
      var attrAddress;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      addressElementList = doc.getElementsByTagName("address");
      testAddress = addressElementList.item(4);
      oldAttribute = doc.createAttribute("oldAttribute");

	{
		success = false;
		try {
            attrAddress = testAddress.removeAttributeNode(oldAttribute);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 8);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_FOUND_ERR");
	}

});



/**
*
    The "removeAttributeNode(oldAttr)" method removes the
   specified attribute.

   Retrieve the last child of the third employee, add a
   new "district" node to it and then try to remove it.
   To verify that the node was removed use the
   "getNamedItem(name)" method from the NamedNodeMap
   interface.  It also uses the "getAttributes()" method
   from the Node interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D589198
*/
TEST("elementremoveattributeaftercreate", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var newAttribute;
      var attributes;
      var districtAttr;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(2);
      newAttribute = doc.createAttribute("district");
      districtAttr = testEmployee.setAttributeNode(newAttribute);
      districtAttr = testEmployee.removeAttributeNode(newAttribute);
      attributes = testEmployee.attributes;

      districtAttr = attributes.getNamedItem("district");
      ASSERT(NULL(districtAttr),"elementRemoveAttributeAfterCreateAssert");

});



/**
*
    The "removeAttributeNode(oldAttr)" method returns the
   node that was removed.

   Retrieve the last child of the third employee and
   remove its "street" Attr node.  The method should
   return the old attribute node.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D589198
*/
TEST("elementremoveattributenode", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var streetAttr;
      var removedAttr;
      var removedValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(2);
      streetAttr = testEmployee.getAttributeNode("street");
      removedAttr = testEmployee.removeAttributeNode(streetAttr);
      removedValue = removedAttr.value;

      ASSERT(STRICT_EQ("No",removedValue),"elementRemoveAttributeNodeAssert");

});



/**
*
This test calls setAttributeNode to replace an attribute with itself.
Since the node is not an attribute of another Element, it would
be inappropriate to throw an INUSE_ATTRIBUTE_ERR.

This test was derived from elementinuserattributeerr which
inadvertanly made this test.

* @author Curt Arnold
* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154
*/
TEST("elementreplaceattributewithself", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var streetAttr;
      var replacedAttr;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(2);
      streetAttr = testEmployee.getAttributeNode("street");
      replacedAttr = testEmployee.setAttributeNode(streetAttr);
      ASSERT(DOM_SAME(streetAttr,replacedAttr),"replacedAttr");

});



/**
*
    The "setAttributeNode(newAttr)" method adds a new
   attribute to the Element.  If the "newAttr" Attr node is
   already present in this element, it should replace the
   existing one.

   Retrieve the last child of the third employee and add a
   new attribute node by invoking the "setAttributeNode(new
   Attr)" method.  The new attribute node to be added is
   "street", which is already present in this element.  The
   method should replace the existing Attr node with the
   new one.  This test uses the "createAttribute(name)"
   method from the Document interface.

* @author NIST
* @author Mary Brady
*/
TEST("elementreplaceexistingattribute", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var newAttribute;
      var name;
      var setAttr;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(2);
      newAttribute = doc.createAttribute("street");
      setAttr = testEmployee.setAttributeNode(newAttribute);
      name = testEmployee.getAttribute("street");
      ASSERT(STRICT_EQ("",name),"elementReplaceExistingAttributeAssert");

});



/**
*
If the "setAttributeNode(newAttr)" method replaces an
existing Attr node with the same name, then it should
return the previously existing Attr node.

Retrieve the last child of the third employee and add a
new attribute node.  The new attribute node is "street",
which is already present in this Element.  The method
should return the existing Attr node(old "street" Attr).
This test uses the "createAttribute(name)" method
from the Document interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154
*/
TEST("elementreplaceexistingattributegevalue", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var newAttribute;
      var streetAttr;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(2);
      newAttribute = doc.createAttribute("street");
      streetAttr = testEmployee.setAttributeNode(newAttribute);
      value = streetAttr.value;

      ASSERT(STRICT_EQ("No",value),"streetNo");

});



/**
*
    The "getAttribute(name)" method returns an attribute
   value by name.

   Retrieve the second address element, then
   invoke the 'getAttribute("street")' method.  This should
   return the value of the attribute("No").

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-666EE0F9
*/
TEST("elementretrieveattrvalue", function() {
   var success;
    var doc;
      var elementList;
      var testAddress;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddress = elementList.item(2);
      attrValue = testAddress.getAttribute("street");
      ASSERT(STRICT_EQ("No",attrValue),"attrValue");

});



/**
*
    The "getElementsByTagName()" method returns a NodeList
   of all descendant elements with a given tagName.

   Invoke the "getElementsByTagName()" method and create
   a NodeList of "position" elements.  Retrieve the second
   "position" element in the list and return the NodeName.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-104682815
*/
TEST("elementretrievetagname", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var name;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("position");
      testEmployee = elementList.item(1);
      name = testEmployee.nodeName;

      ASSERT(STRICT_EQ("position",name),"nodename");
       name = testEmployee.tagName;

      ASSERT(STRICT_EQ("position",name),"tagname");

});



/**
*
    The "setAttributeNode(newAttr)" method returns the
   null value if no previously existing Attr node with the
   same name was replaced.

   Retrieve the last child of the third employee and add a
   new attribute to it.  The new attribute node added is
   "district", which is not part of this Element.  The
   method should return the null value.
   This test uses the "createAttribute(name)"
   method from the Document interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154
*/
TEST("elementsetattributenodenull", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var newAttribute;
      var districtAttr;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(2);
      newAttribute = doc.createAttribute("district");
      districtAttr = testEmployee.setAttributeNode(newAttribute);
      ASSERT(NULL(districtAttr),"elementSetAttributeNodeNullAssert");

});



/**
*

    The "setAttributeNode(newAttr)" method raises an

   "WRONG_DOCUMENT_ERR DOMException if the "newAttr"

   was created from a different document than the one that

   created this document.



   Retrieve the last employee and attempt to set a new

   attribute node for its "employee" element.  The new

   attribute was created from a document other than the

   one that created this element, therefore a

   WRONG_DOCUMENT_ERR DOMException should be raised.

   This test uses the "createAttribute(newAttr)" method

   from the Document interface.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='WRONG_DOCUMENT_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-887236154')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='WRONG_DOCUMENT_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("elementwrongdocumenterr", function() {
   var success;
    var doc1;
      var doc2;
      var newAttribute;
      var addressElementList;
      var testAddress;
      var attrAddress;

      var doc1Ref = null;
      if (typeof(this.doc1) != 'undefined') {
        doc1Ref = this.doc1;
      }
      doc1 = load(doc1Ref, "doc1", "staff");

      var doc2Ref = null;
      if (typeof(this.doc2) != 'undefined') {
        doc2Ref = this.doc2;
      }
      doc2 = load(doc2Ref, "doc2", "staff");
      newAttribute = doc2.createAttribute("newAttribute");
      addressElementList = doc1.getElementsByTagName("address");
      testAddress = addressElementList.item(4);

	{
		success = false;
		try {
            attrAddress = testAddress.setAttributeNode(newAttribute);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 4);
		}
		ASSERT(STRICT_EQ(true,success),"throw_WRONG_DOCUMENT_ERR");
	}

});



/**
*
Appends a text node to an attribute and checks if the value of
the attribute is changed.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
*/
TEST("hc_attrappendchild1", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var lastChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = doc.createTextNode("terday");
      retval = titleAttr.appendChild(textNode);
      value = titleAttr.value;

      ASSERT(STRICT_EQ("Yesterday",value),"attrValue");
       value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("Yesterday",value),"attrNodeValue");
       value = retval.nodeValue;

      ASSERT(STRICT_EQ("terday",value),"retvalValue");
       lastChild = titleAttr.lastChild;

      value = lastChild.nodeValue;

      ASSERT(STRICT_EQ("terday",value),"lastChildValue");

});



/**
*
Attempts to append an element to the child nodes of an attribute.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
*/
TEST("hc_attrappendchild2", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var newChild;
      var retval;
      var lastChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      newChild = doc.createElement("terday");

	{
		success = false;
		try {
            retval = titleAttr.appendChild(newChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
Appends a document fragment to an attribute and checks if the value of
the attribute is changed.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
*/
TEST("hc_attrappendchild3", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var terNode;
      var dayNode;
      var retval;
      var lastChild;
      var docFrag;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      terNode = doc.createTextNode("ter");
      dayNode = doc.createTextNode("day");
      docFrag = doc.createDocumentFragment();
      retval = docFrag.appendChild(terNode);
      retval = docFrag.appendChild(dayNode);
      retval = titleAttr.appendChild(docFrag);
      value = titleAttr.value;

      ASSERT(STRICT_EQ("Yesterday",value),"attrValue");
       value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("Yesterday",value),"attrNodeValue");
       value = retval.nodeValue;

      ASSERT(NULL(value),"retvalValue");
    lastChild = titleAttr.lastChild;

      value = lastChild.nodeValue;

      ASSERT(STRICT_EQ("day",value),"lastChildValue");

});



/**
*
Attempt to append a CDATASection to an attribute which should result
in a HIERARCHY_REQUEST_ERR.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
*/
TEST("hc_attrappendchild4", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var lastChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");

	if(
	
	(builder.contentType == "text/html")

	) {
	
	{
		success = false;
		try {
            textNode = doc.createCDATASection("terday");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 9);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_SUPPORTED_ERR");
	}

	}
	
		else {
			textNode = doc.createCDATASection("terday");

	{
		success = false;
		try {
            retval = titleAttr.appendChild(textNode);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

		}
	
});



/**
*
Attempt to append a node from another document to an attribute which should result
in a WRONG_DOCUMENT_ERR.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
*/
TEST("hc_attrappendchild5", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var lastChild;
      var otherDoc;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");

      var otherDocRef = null;
      if (typeof(this.otherDoc) != 'undefined') {
        otherDocRef = this.otherDoc;
      }
      otherDoc = load(otherDocRef, "otherDoc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = otherDoc.createTextNode("terday");

	{
		success = false;
		try {
            retval = titleAttr.appendChild(textNode);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 4);
		}
		ASSERT(STRICT_EQ(true,success),"throw_WRONG_DOCUMENT_ERR");
	}

});



/**
*
Creates an new attribute node and appends a text node.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
*/
TEST("hc_attrappendchild6", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var lastChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      titleAttr = doc.createAttribute("title");
      textNode = doc.createTextNode("Yesterday");
      retval = titleAttr.appendChild(textNode);
      value = titleAttr.value;

      ASSERT(STRICT_EQ("Yesterday",value),"attrValue");
       value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("Yesterday",value),"attrNodeValue");
       value = retval.nodeValue;

      ASSERT(STRICT_EQ("Yesterday",value),"retvalValue");
       lastChild = titleAttr.lastChild;

      value = lastChild.nodeValue;

      ASSERT(STRICT_EQ("Yesterday",value),"lastChildValue");

});



/**
*
Checks that Node.childNodes for an attribute node contains
the expected text node.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1451460987
*/
TEST("hc_attrchildnodes1", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var childNodes;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      childNodes = titleAttr.childNodes;

      ASSERT(STRICT_EQ(1,childNodes.length),"childNodesSize");
textNode = childNodes.item(0);
      value = textNode.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"child1IsYes");
       textNode = childNodes.item(1);
      ASSERT(NULL(textNode),"secondItemIsNull");

});



/**
*
Checks Node.childNodes for an attribute with multiple child nodes.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1451460987
*/
TEST("hc_attrchildnodes2", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var childNodes;
      var retval;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      childNodes = titleAttr.childNodes;

      textNode = doc.createTextNode("terday");
      retval = titleAttr.appendChild(textNode);
      ASSERT(STRICT_EQ(2,childNodes.length),"childNodesSize");
textNode = childNodes.item(0);
      value = textNode.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"child1IsYes");
       textNode = childNodes.item(1);
      value = textNode.nodeValue;

      ASSERT(STRICT_EQ("terday",value),"child2IsTerday");
       textNode = childNodes.item(2);
      ASSERT(NULL(textNode),"thirdItemIsNull");

});



/**
*
Appends a text node to an attribute and clones the node.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4
*/
TEST("hc_attrclonenode1", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var lastChild;
      var clonedTitle;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = doc.createTextNode("terday");
      retval = titleAttr.appendChild(textNode);
      clonedTitle = titleAttr.cloneNode(false);
      textNode.nodeValue = "text_node_not_cloned";

      value = clonedTitle.value;

      ASSERT(STRICT_EQ("Yesterday",value),"attrValue");
       value = clonedTitle.nodeValue;

      ASSERT(STRICT_EQ("Yesterday",value),"attrNodeValue");
       lastChild = clonedTitle.lastChild;

      value = lastChild.nodeValue;

      ASSERT(STRICT_EQ("terday",value),"lastChildValue");

});



/**
*
  Create a new DocumentFragment and add a newly created Element node(with one attribute).
  Once the element is added, its attribute should be available as an attribute associated
  with an Element within a DocumentFragment.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-35CB04B5
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68F082
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-B63ED1A3
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=236
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2003Jun/0011.html
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=184
*/
TEST("hc_attrcreatedocumentfragment", function() {
   var success;
    var doc;
      var docFragment;
      var newOne;
      var domesticNode;
      var attributes;
      var attribute;
      var attrName;
      var appendedChild;
      var langAttrCount = 0;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      docFragment = doc.createDocumentFragment();
      newOne = doc.createElement("html");
      newOne.setAttribute("lang","EN");
      appendedChild = docFragment.appendChild(newOne);
      domesticNode = docFragment.firstChild;

      attributes = domesticNode.attributes;

      for(var indexid2258715 = 0;indexid2258715 < attributes.length; indexid2258715++) {
      attribute = attributes.item(indexid2258715);
      attrName = attribute.nodeName;


	if(
	equalsAutoCase("attribute", "lang", attrName)
	) {
	langAttrCount += 1;

	}
	
	}
   ASSERT(STRICT_EQ(1,langAttrCount),"hasLangAttr");

});



/**
*
    The "setValue()" method for an attribute creates a
  Text node with the unparsed content of the string.
  Retrieve the attribute named "class" from the last
  child of of the fourth employee and assign the "Y&ent1;"
  string to its value attribute.  This value is not yet
  parsed and therefore should still be the same upon
  retrieval. This test uses the "getNamedItem(name)" method
  from the NamedNodeMap interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-221662474
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2002Apr/0057.html
*/
TEST("hc_attrcreatetextnode", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var streetAttr;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      addressList = doc.getElementsByTagName("acronym");
      testNode = addressList.item(3);
      attributes = testNode.attributes;

      streetAttr = attributes.getNamedItem("class");
      streetAttr.value = "Y&ent1;";

      value = streetAttr.value;

      ASSERT(STRICT_EQ("Y&ent1;",value),"value");
       value = streetAttr.nodeValue;

      ASSERT(STRICT_EQ("Y&ent1;",value),"nodeValue");

});



/**
*
    The "setNodeValue()" method for an attribute creates a
  Text node with the unparsed content of the string.
  Retrieve the attribute named "class" from the last
  child of of the fourth employee and assign the "Y&ent1;"
  string to its value attribute.  This value is not yet
  parsed and therefore should still be the same upon
  retrieval. This test uses the "getNamedItem(name)" method
  from the NamedNodeMap interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2002Apr/0057.html
*/
TEST("hc_attrcreatetextnode2", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var streetAttr;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      addressList = doc.getElementsByTagName("acronym");
      testNode = addressList.item(3);
      attributes = testNode.attributes;

      streetAttr = attributes.getNamedItem("class");
      streetAttr.nodeValue = "Y&ent1;";

      value = streetAttr.value;

      ASSERT(STRICT_EQ("Y&ent1;",value),"value");
       value = streetAttr.nodeValue;

      ASSERT(STRICT_EQ("Y&ent1;",value),"nodeValue");

});



/**
*
    If an Attr is explicitly assigned any value, then that value is the attributes effective value.
  Retrieve the attribute named "domestic" from the last child of of the first employee
  and examine its nodeValue attribute.  This test uses the "getNamedItem(name)" method
  from the NamedNodeMap interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1074577549
*/
TEST("hc_attreffectivevalue", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var domesticAttr;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      addressList = doc.getElementsByTagName("acronym");
      testNode = addressList.item(0);
      attributes = testNode.attributes;

      domesticAttr = attributes.getNamedItem("title");
      value = domesticAttr.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"attrEffectiveValueAssert");

});



/**
*
Checks that Node.firstChild for an attribute node contains
the expected text node.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-169727388
*/
TEST("hc_attrfirstchild", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var otherChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = titleAttr.firstChild;

      ASSERT(NOT_NULL(textNode),"textNodeNotNull");
value = textNode.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"child1IsYes");
       otherChild = textNode.nextSibling;

      ASSERT(NULL(otherChild),"nextSiblingIsNull");
    otherChild = textNode.previousSibling;

      ASSERT(NULL(otherChild),"previousSiblingIsNull");

});



/**
*
Checks the value of an attribute that contains entity references.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-221662474
*/
TEST("hc_attrgetvalue1", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var lastChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("class");
      value = titleAttr.value;

      ASSERT(STRICT_EQ("Yα",value),"attrValue1");

});



/**
*
Checks that Node.hasChildNodes() is true for an attribute with content.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-810594187
*/
TEST("hc_attrhaschildnodes", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var hasChildNodes;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      hasChildNodes = titleAttr.hasChildNodes();
      ASSERT(STRICT_EQ(true,hasChildNodes),"hasChildrenIsTrue");

});



/**
*
Appends a text node to an attribute and checks if the value of
the attribute is changed.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("hc_attrinsertbefore1", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var firstChild;
      var lastChild;
      var refChild = null;


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = doc.createTextNode("terday");
      retval = titleAttr.insertBefore(textNode,refChild);
      value = titleAttr.value;

      ASSERT(STRICT_EQ("Yesterday",value),"attrValue");
       value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("Yesterday",value),"attrNodeValue");
       value = retval.nodeValue;

      ASSERT(STRICT_EQ("terday",value),"retvalValue");
       firstChild = titleAttr.firstChild;

      value = firstChild.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"firstChildValue");
       lastChild = titleAttr.lastChild;

      value = lastChild.nodeValue;

      ASSERT(STRICT_EQ("terday",value),"lastChildValue");

});



/**
*
Prepends a text node to an attribute and checks if the value of
the attribute is changed.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("hc_attrinsertbefore2", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var lastChild;
      var firstChild;
      var refChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = doc.createTextNode("terday");
      refChild = titleAttr.firstChild;

      retval = titleAttr.insertBefore(textNode,refChild);
      value = titleAttr.value;

      ASSERT(STRICT_EQ("terdayYes",value),"attrValue");
       value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("terdayYes",value),"attrNodeValue");
       value = retval.nodeValue;

      ASSERT(STRICT_EQ("terday",value),"retvalValue");
       firstChild = titleAttr.firstChild;

      value = firstChild.nodeValue;

      ASSERT(STRICT_EQ("terday",value),"firstChildValue");
       lastChild = titleAttr.lastChild;

      value = lastChild.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"lastChildValue");

});



/**
*
Appends a document fragment to an attribute and checks if the value of
the attribute is changed.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("hc_attrinsertbefore3", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var terNode;
      var dayNode;
      var docFrag;
      var retval;
      var firstChild;
      var lastChild;
      var refChild = null;


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      terNode = doc.createTextNode("ter");
      dayNode = doc.createTextNode("day");
      docFrag = doc.createDocumentFragment();
      retval = docFrag.appendChild(terNode);
      retval = docFrag.appendChild(dayNode);
      retval = titleAttr.insertBefore(docFrag,refChild);
      value = titleAttr.value;

      ASSERT(STRICT_EQ("Yesterday",value),"attrValue");
       value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("Yesterday",value),"attrNodeValue");
       value = retval.nodeValue;

      ASSERT(NULL(value),"retvalValue");
    firstChild = titleAttr.firstChild;

      value = firstChild.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"firstChildValue");
       lastChild = titleAttr.lastChild;

      value = lastChild.nodeValue;

      ASSERT(STRICT_EQ("day",value),"lastChildValue");

});



/**
*
Prepends a document fragment to an attribute and checks if the value of
the attribute is changed.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("hc_attrinsertbefore4", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var terNode;
      var dayNode;
      var docFrag;
      var retval;
      var firstChild;
      var lastChild;
      var refChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      terNode = doc.createTextNode("ter");
      dayNode = doc.createTextNode("day");
      docFrag = doc.createDocumentFragment();
      retval = docFrag.appendChild(terNode);
      retval = docFrag.appendChild(dayNode);
      refChild = titleAttr.firstChild;

      retval = titleAttr.insertBefore(docFrag,refChild);
      value = titleAttr.value;

      ASSERT(STRICT_EQ("terdayYes",value),"attrValue");
       value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("terdayYes",value),"attrNodeValue");
       value = retval.nodeValue;

      ASSERT(NULL(value),"retvalValue");
    firstChild = titleAttr.firstChild;

      value = firstChild.nodeValue;

      ASSERT(STRICT_EQ("ter",value),"firstChildValue");
       lastChild = titleAttr.lastChild;

      value = lastChild.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"lastChildValue");

});



/**
*
Attempt to append a CDATASection to an attribute which should result
in a HIERARCHY_REQUEST_ERR.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("hc_attrinsertbefore5", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var refChild = null;


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");

	if(
	
	(builder.contentType == "text/html")

	) {
	
	{
		success = false;
		try {
            textNode = doc.createCDATASection("terday");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 9);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_SUPPORTED_ERR");
	}

	}
	
		else {
			textNode = doc.createCDATASection("terday");

	{
		success = false;
		try {
            retval = titleAttr.insertBefore(textNode,refChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

		}
	
});



/**
*
Attempt to append a text node from another document to an attribute which should result
in a WRONG_DOCUMENT_ERR.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("hc_attrinsertbefore6", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var refChild = null;

      var otherDoc;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");

      var otherDocRef = null;
      if (typeof(this.otherDoc) != 'undefined') {
        otherDocRef = this.otherDoc;
      }
      otherDoc = load(otherDocRef, "otherDoc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = otherDoc.createTextNode("terday");

	{
		success = false;
		try {
            retval = titleAttr.insertBefore(textNode,refChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 4);
		}
		ASSERT(STRICT_EQ(true,success),"throw_WRONG_DOCUMENT_ERR");
	}

});



/**
*
Appends a document fragment containing a CDATASection to an attribute.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("hc_attrinsertbefore7", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var terNode;
      var dayNode;
      var docFrag;
      var retval;
      var firstChild;
      var lastChild;
      var refChild = null;


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      terNode = doc.createTextNode("ter");

	if(
	
	(builder.contentType == "text/html")

	) {
	
	{
		success = false;
		try {
            dayNode = doc.createCDATASection("day");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 9);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_SUPPORTED_ERR");
	}

	}
	
		else {
			dayNode = doc.createCDATASection("day");
      docFrag = doc.createDocumentFragment();
      retval = docFrag.appendChild(terNode);
      retval = docFrag.appendChild(dayNode);

	{
		success = false;
		try {
            retval = titleAttr.insertBefore(docFrag,refChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

		}
	
});



/**
*
Checks that Node.lastChild for an attribute node contains
the expected text node.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-61AD09FB
*/
TEST("hc_attrlastchild", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var otherChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = titleAttr.firstChild;

      ASSERT(NOT_NULL(textNode),"textNodeNotNull");
value = textNode.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"child1IsYes");
       otherChild = textNode.nextSibling;

      ASSERT(NULL(otherChild),"nextSiblingIsNull");
    otherChild = textNode.previousSibling;

      ASSERT(NULL(otherChild),"previousSiblingIsNull");

});



/**
*
  Retrieve the attribute named class from the last
  child of of the second "p" element and examine its
  NodeName.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1112119403
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=236
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2003Jun/0011.html
*/
TEST("hc_attrname", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var streetAttr;
      var strong1;
      var strong2;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      addressList = doc.getElementsByTagName("acronym");
      testNode = addressList.item(1);
      attributes = testNode.attributes;

      streetAttr = attributes.getNamedItem("class");
      strong1 = streetAttr.nodeName;

      strong2 = streetAttr.name;

      ASSERT(STRICT_EQ("class",strong1), "nodeName");
       ASSERT(STRICT_EQ("class",strong2), "name");

});



/**
*
The "getNextSibling()" method for an Attr node should return null.
Retrieve the attribute named "domestic" from the last child of of the
first employee and examine its NextSibling node.  This test uses the
"getNamedItem(name)" method from the NamedNodeMap interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6AC54C2F
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
*/
TEST("hc_attrnextsiblingnull", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var domesticAttr;
      var s;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      addressList = doc.getElementsByTagName("acronym");
      testNode = addressList.item(0);
      attributes = testNode.attributes;

      domesticAttr = attributes.getNamedItem("title");
      s = domesticAttr.nextSibling;

      ASSERT(NULL(s),"attrNextSiblingNullAssert");

});



/**
*
Appends a text node to an attribute, normalizes the attribute
and checks for a single child node.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-162CF083
*/
TEST("hc_attrnormalize", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var firstChild;
      var secondChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = doc.createTextNode("terday");
      retval = titleAttr.appendChild(textNode);
      textNode = doc.createTextNode("");
      retval = titleAttr.appendChild(textNode);
      testNode.normalize();
      value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("Yesterday",value),"attrNodeValue");
       firstChild = titleAttr.firstChild;

      value = firstChild.nodeValue;

      ASSERT(STRICT_EQ("Yesterday",value),"firstChildValue");
       secondChild = firstChild.nextSibling;

      ASSERT(NULL(secondChild),"secondChildIsNull");

});



/**
*
The "getParentNode()" method for an Attr node should return null.  Retrieve
the attribute named "domestic" from the last child of the first employee
and examine its parentNode attribute.  This test also uses the "getNamedItem(name)"
method from the NamedNodeMap interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1060184317
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
*/
TEST("hc_attrparentnodenull", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var domesticAttr;
      var s;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      addressList = doc.getElementsByTagName("acronym");
      testNode = addressList.item(0);
      attributes = testNode.attributes;

      domesticAttr = attributes.getNamedItem("title");
      s = domesticAttr.parentNode;

      ASSERT(NULL(s),"attrParentNodeNullAssert");

});



/**
*
The "getPreviousSibling()" method for an Attr node should return null.
Retrieve the attribute named "domestic" from the last child of of the
first employee and examine its PreviousSibling node.  This test uses the
"getNamedItem(name)" method from the NamedNodeMap interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-640FB3C8
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
*/
TEST("hc_attrprevioussiblingnull", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var domesticAttr;
      var s;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      addressList = doc.getElementsByTagName("acronym");
      testNode = addressList.item(0);
      attributes = testNode.attributes;

      domesticAttr = attributes.getNamedItem("title");
      s = domesticAttr.previousSibling;

      ASSERT(NULL(s),"attrPreviousSiblingNullAssert");

});



/**
*
Removes the child node of an attribute and checks that the value is empty.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066
*/
TEST("hc_attrremovechild1", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var firstChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = titleAttr.firstChild;

      ASSERT(NOT_NULL(textNode),"attrChildNotNull");
retval = titleAttr.removeChild(textNode);
      value = titleAttr.value;

      ASSERT(STRICT_EQ("",value),"attrValue");
       value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("",value),"attrNodeValue");
       value = retval.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"retvalValue");
       firstChild = titleAttr.firstChild;

      ASSERT(NULL(firstChild),"firstChildNull");

});



/**
*
Attempts to remove a freshly created text node which should result in a NOT_FOUND_ERR exception.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066
*/
TEST("hc_attrremovechild2", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = doc.createTextNode("Yesterday");

	{
		success = false;
		try {
            retval = titleAttr.removeChild(textNode);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 8);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_FOUND_ERR");
	}

});



/**
*
Replaces a text node of an attribute and checks if the value of
the attribute is changed.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
*/
TEST("hc_attrreplacechild1", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var firstChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = doc.createTextNode("terday");
      firstChild = titleAttr.firstChild;

      ASSERT(NOT_NULL(firstChild),"attrChildNotNull");
retval = titleAttr.replaceChild(textNode,firstChild);
      value = titleAttr.value;

      ASSERT(STRICT_EQ("terday",value),"attrValue");
       value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("terday",value),"attrNodeValue");
       value = retval.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"retvalValue");
       firstChild = titleAttr.firstChild;

      value = firstChild.nodeValue;

      ASSERT(STRICT_EQ("terday",value),"firstChildValue");

});



/**
*
Replaces a text node of an attribute with a document fragment and checks if the value of
the attribute is changed.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
*/
TEST("hc_attrreplacechild2", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var terNode;
      var dayNode;
      var docFrag;
      var retval;
      var firstChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      terNode = doc.createTextNode("ter");
      dayNode = doc.createTextNode("day");
      docFrag = doc.createDocumentFragment();
      retval = docFrag.appendChild(terNode);
      retval = docFrag.appendChild(dayNode);
      firstChild = titleAttr.firstChild;

      ASSERT(NOT_NULL(firstChild),"attrChildNotNull");
retval = titleAttr.replaceChild(docFrag,firstChild);
      value = titleAttr.value;

      ASSERT(STRICT_EQ("terday",value),"attrValue");
       value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("terday",value),"attrNodeValue");
       value = retval.nodeValue;

      ASSERT(STRICT_EQ("Yes",value),"retvalValue");
       firstChild = titleAttr.firstChild;

      value = firstChild.nodeValue;

      ASSERT(STRICT_EQ("ter",value),"firstChildValue");

});



/**
*
Sets Attr.value on an attribute that only has a simple value.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-221662474
*/
TEST("hc_attrsetvalue1", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var retval;
      var firstChild;
      var otherChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      firstChild = titleAttr.firstChild;

      ASSERT(NOT_NULL(firstChild),"attrChildNotNull");
titleAttr.value = "Tomorrow";

      firstChild.nodeValue = "impl reused node";

      value = titleAttr.value;

      ASSERT(STRICT_EQ("Tomorrow",value),"attrValue");
       value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("Tomorrow",value),"attrNodeValue");
       firstChild = titleAttr.lastChild;

      value = firstChild.nodeValue;

      ASSERT(STRICT_EQ("Tomorrow",value),"firstChildValue");
       otherChild = firstChild.nextSibling;

      ASSERT(NULL(otherChild),"nextSiblingIsNull");

});



/**
*
Sets Attr.value on an attribute that should contain multiple child nodes.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-221662474
*/
TEST("hc_attrsetvalue2", function() {
   var success;
    var doc;
      var acronymList;
      var testNode;
      var attributes;
      var titleAttr;
      var value;
      var textNode;
      var retval;
      var firstChild;
      var otherChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      acronymList = doc.getElementsByTagName("acronym");
      testNode = acronymList.item(3);
      attributes = testNode.attributes;

      titleAttr = attributes.getNamedItem("title");
      textNode = doc.createTextNode("terday");
      retval = titleAttr.appendChild(textNode);
      firstChild = titleAttr.firstChild;

      ASSERT(NOT_NULL(firstChild),"attrChildNotNull");
titleAttr.value = "Tomorrow";

      firstChild.nodeValue = "impl reused node";

      value = titleAttr.value;

      ASSERT(STRICT_EQ("Tomorrow",value),"attrValue");
       value = titleAttr.nodeValue;

      ASSERT(STRICT_EQ("Tomorrow",value),"attrNodeValue");
       firstChild = titleAttr.lastChild;

      value = firstChild.nodeValue;

      ASSERT(STRICT_EQ("Tomorrow",value),"firstChildValue");
       otherChild = firstChild.nextSibling;

      ASSERT(NULL(otherChild),"nextSiblingIsNull");

});



/**
*
    The "getSpecified()" method for an Attr node should
  be set to true if the attribute was explicitly given
  a value.
  Retrieve the attribute named "domestic" from the last
  child of of the first employee and examine the value
  returned by the "getSpecified()" method.  This test uses
  the "getNamedItem(name)" method from the NamedNodeMap
  interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-862529273
*/
TEST("hc_attrspecifiedvalue", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var domesticAttr;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      addressList = doc.getElementsByTagName("acronym");
      testNode = addressList.item(0);
      attributes = testNode.attributes;

      domesticAttr = attributes.getNamedItem("title");
      state = domesticAttr.specified;

      ASSERT(STRICT_EQ(true,state),"acronymTitleSpecified");

});



/**
*
    The "getSpecified()" method for an Attr node should return true if the
  value of the attribute is changed.
  Retrieve the attribute named "class" from the last
  child of of the THIRD employee and change its
  value to "Yes"(which is the default DTD value).  This
  should cause the "getSpecified()" method to be true.
  This test uses the "setAttribute(name,value)" method
  from the Element interface and the "getNamedItem(name)"
  method from the NamedNodeMap interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-862529273
*/
TEST("hc_attrspecifiedvaluechanged", function() {
   var success;
    var doc;
      var addressList;
      var testNode;
      var attributes;
      var streetAttr;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      addressList = doc.getElementsByTagName("acronym");
      testNode = addressList.item(2);
      testNode.setAttribute("class","Yα");
      attributes = testNode.attributes;

      streetAttr = attributes.getNamedItem("class");
      state = streetAttr.specified;

      ASSERT(STRICT_EQ(true,state),"acronymClassSpecified");

});



/**
*
    The "appendData(arg)" method appends a string to the end
   of the character data of the node.

   Retrieve the character data from the second child
   of the first employee.  The appendData(arg) method is
   called with arg=", Esquire".  The method should append
   the specified data to the already existing character
   data.  The new value return by the "getLength()" method
   should be 24.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-32791A2F
*/
TEST("hc_characterdataappenddata", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childValue;
      var childLength;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.appendData(", Esquire");
      childValue = child.data;

      childLength = childValue.length;
      ASSERT(STRICT_EQ(24,childLength),"characterdataAppendDataAssert");

});



/**
*
    On successful invocation of the "appendData(arg)"
   method the "getData()" method provides access to the
   concatentation of data and the specified string.

   Retrieve the character data from the second child
   of the first employee.  The appendData(arg) method is
   called with arg=", Esquire".  The method should append
   the specified data to the already existing character
   data.  The new value return by the "getData()" method
   should be "Margaret Martin, Esquire".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-32791A2F
*/
TEST("hc_characterdataappenddatagetdata", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.appendData(", Esquire");
      childData = child.data;

      ASSERT(STRICT_EQ("Margaret Martin, Esquire",childData),"characterdataAppendDataGetDataAssert");

});



/**
*
The "deleteData(offset,count)" method removes a range of
characters from the node.  Delete data at the beginning
of the character data.

Retrieve the character data from the last child of the
first employee.  The "deleteData(offset,count)"
method is then called with offset=0 and count=16.
The method should delete the characters from position
0 thru position 16.  The new value of the character data
should be "Dallas, Texas 98551".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
*/
TEST("hc_characterdatadeletedatabegining", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.deleteData(0,16);
      childData = child.data;

      ASSERT(STRICT_EQ("Dallas, Texas 98551",childData),"data");

});



/**
*
    The "deleteData(offset,count)" method removes a range of
   characters from the node.  Delete data at the end
   of the character data.

   Retrieve the character data from the last child of the
   first employee.  The "deleteData(offset,count)"
   method is then called with offset=30 and count=5.
   The method should delete the characters from position
   30 thru position 35.  The new value of the character data
   should be "1230 North Ave. Dallas, Texas".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
*/
TEST("hc_characterdatadeletedataend", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.deleteData(30,5);
      childData = child.data;

      ASSERT(STRICT_EQ("1230 North Ave. Dallas, Texas ",childData),"characterdataDeleteDataEndAssert");

});



/**
*
    If the sum of the offset and count used in the
   "deleteData(offset,count) method is greater than the
   length of the character data then all the characters
   from the offset to the end of the data are deleted.

   Retrieve the character data from the last child of the
   first employee.  The "deleteData(offset,count)"
   method is then called with offset=4 and count=50.
   The method should delete the characters from position 4
   to the end of the data since the offset+count(50+4)
   is greater than the length of the character data(35).
   The new value of the character data should be "1230".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
*/
TEST("hc_characterdatadeletedataexceedslength", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.deleteData(4,50);
      childData = child.data;

      ASSERT(STRICT_EQ("1230",childData),"characterdataDeleteDataExceedsLengthAssert");

});



/**
*
    On successful invocation of the "deleteData(offset,count)"
   method, the "getData()" and "getLength()" methods reflect
   the changes.

   Retrieve the character data from the last child of the
   first employee.  The "deleteData(offset,count)"
   method is then called with offset=30 and count=5.
   The method should delete the characters from position
   30 thru position 35.  The new value of the character data
   should be "1230 North Ave. Dallas, Texas" which is
   returned by the "getData()" method and "getLength()"
   method should return 30".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7D61178C
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
*/
TEST("hc_characterdatadeletedatagetlengthanddata", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;
      var childLength;
      var result = new Array();


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.deleteData(30,5);
      childData = child.data;

      ASSERT(STRICT_EQ("1230 North Ave. Dallas, Texas ",childData),"data");
       childLength = child.length;

      ASSERT(STRICT_EQ(30,childLength),"length");

});



/**
*
    The "deleteData(offset,count)" method removes a range of
   characters from the node.  Delete data in the middle
   of the character data.

   Retrieve the character data from the last child of the
   first employee.  The "deleteData(offset,count)"
   method is then called with offset=16 and count=8.
   The method should delete the characters from position
   16 thru position 24.  The new value of the character data
   should be "1230 North Ave. Texas 98551".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
*/
TEST("hc_characterdatadeletedatamiddle", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.deleteData(16,8);
      childData = child.data;

      ASSERT(STRICT_EQ("1230 North Ave. Texas 98551",childData),"characterdataDeleteDataMiddleAssert");

});



/**
*

    The "getData()" method retrieves the character data

  currently stored in the node.

  Retrieve the character data from the second child

  of the first employee and invoke the "getData()"

  method.  The method returns the character data

  string.


* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
*/
TEST("hc_characterdatagetdata", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      childData = child.data;

      ASSERT(STRICT_EQ("Margaret Martin",childData),"characterdataGetDataAssert");

});



/**
*
    The "getLength()" method returns the number of characters
  stored in this nodes data.
  Retrieve the character data from the second
  child of the first employee and examine the
  value returned by the getLength() method.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7D61178C
*/
TEST("hc_characterdatagetlength", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childValue;
      var childLength;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      childValue = child.data;

      childLength = childValue.length;
      ASSERT(STRICT_EQ(15,childLength),"characterdataGetLengthAssert");

});



/**
*
    The "deleteData(offset,count)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is greater that the number of characters in the string.

   Retrieve the character data of the last child of the
   first employee and invoke its "deleteData(offset,count)"
   method with offset=40 and count=3.  It should raise the
   desired exception since the offset is greater than the
   number of characters in the string.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-7C603781')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_characterdataindexsizeerrdeletedataoffsetgreater", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            child.deleteData(40,3);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INDEX_SIZE_ERR");
	}

});



/**
*
    The "deleteData(offset,count)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is negative.

   Retrieve the character data of the last child of the
   first employee and invoke its "deleteData(offset,count)"
   method with offset=-5 and count=3.  It should raise the
   desired exception since the offset is negative.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-7C603781')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
*/
TEST("hc_characterdataindexsizeerrdeletedataoffsetnegative", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            child.deleteData(-5,3);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throws_INDEX_SIZE_ERR");
	}

});



/**
*
    The "insertData(offset,arg)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is greater than the number of characters in the string.

   Retrieve the character data of the last child of the
   first employee and invoke its insertData"(offset,arg)"
   method with offset=40 and arg="ABC".  It should raise
   the desired exception since the offset is greater than
   the number of characters in the string.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-7C603781')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_characterdataindexsizeerrinsertdataoffsetgreater", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            child.deleteData(40,3);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INDEX_SIZE_ERR");
	}

});



/**
*
    The "insertData(offset,arg)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is negative.

   Retrieve the character data of the last child of the
   first employee and invoke its insertData"(offset,arg)"
   method with offset=-5 and arg="ABC".  It should raise
   the desired exception since the offset is negative.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-E5CBA7FB')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
*/
TEST("hc_characterdataindexsizeerrinsertdataoffsetnegative", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            child.replaceData(-5,3,"ABC");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throws_INDEX_SIZE_ERR");
	}

});



/**
*
    The "replaceData(offset,count,arg)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is greater than the length of the string.

   Retrieve the character data of the last child of the
   first employee and invoke its
   "replaceData(offset,count,arg) method with offset=40
   and count=3 and arg="ABC".  It should raise the
   desired exception since the offset is greater than the
   length of the string.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-7C603781
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-7C603781')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=242
*/
TEST("hc_characterdataindexsizeerrreplacedataoffsetgreater", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            child.deleteData(40,3);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INDEX_SIZE_ERR");
	}

});



/**
*
    The "replaceData(offset,count,arg)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is negative.

   Retrieve the character data of the last child of the
   first employee and invoke its
   "replaceData(offset,count,arg) method with offset=-5
   and count=3 and arg="ABC".  It should raise the
   desired exception since the offset is negative.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-E5CBA7FB')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
*/
TEST("hc_characterdataindexsizeerrreplacedataoffsetnegative", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            child.replaceData(-5,3,"ABC");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throws_INDEX_SIZE_ERR");
	}

});



/**
*
    The "substringData(offset,count)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is negative.

   Retrieve the character data of the last child of the
   first employee and invoke its "substringData(offset,count)
   method with offset=-5 and count=3.  It should raise the
   desired exception since the offset is negative.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6531BCCF
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-6531BCCF')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
*/
TEST("hc_characterdataindexsizeerrsubstringnegativeoffset", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var badString;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            badString = child.substringData(-5,3);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throws_INDEX_SIZE_ERR");
	}

});



/**
*
    The "substringData(offset,count)" method raises an
   INDEX_SIZE_ERR DOMException if the specified offset
   is greater than the number of characters in the string.

   Retrieve the character data of the last child of the
   first employee and invoke its "substringData(offset,count)
   method with offset=40 and count=3.  It should raise the
   desired exception since the offsets value is greater
   than the length.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6531BCCF
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-6531BCCF')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_characterdataindexsizeerrsubstringoffsetgreater", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var badString;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;


	{
		success = false;
		try {
            badString = child.substringData(40,3);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INDEX_SIZE_ERR");
	}

});



/**
*
The "insertData(offset,arg)" method will insert a string
at the specified character offset.  Insert the data at
the beginning of the character data.

Retrieve the character data from the second child of
the first employee.  The "insertData(offset,arg)"
method is then called with offset=0 and arg="Mss.".
The method should insert the string "Mss." at position 0.
The new value of the character data should be
"Mss. Margaret Martin".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3EDB695F
*/
TEST("hc_characterdatainsertdatabeginning", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.insertData(0,"Mss. ");
      childData = child.data;

      ASSERT(STRICT_EQ("Mss. Margaret Martin",childData),"characterdataInsertDataBeginningAssert");

});



/**
*
    The "insertData(offset,arg)" method will insert a string
   at the specified character offset.  Insert the data at
   the end of the character data.

   Retrieve the character data from the second child of
   the first employee.  The "insertData(offset,arg)"
   method is then called with offset=15 and arg=", Esquire".
   The method should insert the string ", Esquire" at
   position 15.  The new value of the character data should
   be "Margaret Martin, Esquire".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3EDB695F
*/
TEST("hc_characterdatainsertdataend", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.insertData(15,", Esquire");
      childData = child.data;

      ASSERT(STRICT_EQ("Margaret Martin, Esquire",childData),"characterdataInsertDataEndAssert");

});



/**
*
    The "insertData(offset,arg)" method will insert a string
   at the specified character offset.  Insert the data in
   the middle of the character data.

   Retrieve the character data from the second child of
   the first employee.  The "insertData(offset,arg)"
   method is then called with offset=9 and arg="Ann".
   The method should insert the string "Ann" at position 9.
   The new value of the character data should be
   "Margaret Ann Martin".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3EDB695F
*/
TEST("hc_characterdatainsertdatamiddle", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.insertData(9,"Ann ");
      childData = child.data;

      ASSERT(STRICT_EQ("Margaret Ann Martin",childData),"characterdataInsertDataMiddleAssert");

});



/**
*
The "replaceData(offset,count,arg)" method replaces the
characters starting at the specified offset with the
specified string.  Test for replacement in the
middle of the data.

Retrieve the character data from the last child of the
first employee.  The "replaceData(offset,count,arg)"
method is then called with offset=5 and count=5 and
arg="South".  The method should replace characters five
thru 9 of the character data with "South".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
*/
TEST("hc_characterdatareplacedatabegining", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.replaceData(0,4,"2500");
      childData = child.data;

      ASSERT(STRICT_EQ("2500 North Ave. Dallas, Texas 98551",childData),"characterdataReplaceDataBeginingAssert");

});



/**
*
    The "replaceData(offset,count,arg)" method replaces the
   characters starting at the specified offset with the
   specified string.  Test for replacement at the
   end of the data.

   Retrieve the character data from the last child of the
   first employee.  The "replaceData(offset,count,arg)"
   method is then called with offset=30 and count=5 and
   arg="98665".  The method should replace characters 30
   thru 34 of the character data with "98665".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
*/
TEST("hc_characterdatareplacedataend", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.replaceData(30,5,"98665");
      childData = child.data;

      ASSERT(STRICT_EQ("1230 North Ave. Dallas, Texas 98665",childData),"characterdataReplaceDataEndAssert");

});



/**
*
    The "replaceData(offset,count,arg)" method replaces the
   characters starting at the specified offset with the
   specified string.  Test the situation where the length
   of the arg string is greater than the specified offset.

   Retrieve the character data from the last child of the
   first employee.  The "replaceData(offset,count,arg)"
   method is then called with offset=0 and count=4 and
   arg="260030".  The method should replace characters one
   thru four with "260030".  Note that the length of the
   specified string is greater that the specified offset.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
*/
TEST("hc_characterdatareplacedataexceedslengthofarg", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.replaceData(0,4,"260030");
      childData = child.data;

      ASSERT(STRICT_EQ("260030 North Ave. Dallas, Texas 98551",childData),"characterdataReplaceDataExceedsLengthOfArgAssert");

});



/**
*
    If the sum of the offset and count exceeds the length then
   all the characters to the end of the data are replaced.

   Retrieve the character data from the last child of the
   first employee.  The "replaceData(offset,count,arg)"
   method is then called with offset=0 and count=50 and
   arg="2600".  The method should replace all the characters
   with "2600". This is because the sum of the offset and
   count exceeds the length of the character data.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
*/
TEST("hc_characterdatareplacedataexceedslengthofdata", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.replaceData(0,50,"2600");
      childData = child.data;

      ASSERT(STRICT_EQ("2600",childData),"characterdataReplaceDataExceedsLengthOfDataAssert");

});



/**
*
    The "replaceData(offset,count,arg)" method replaces the
   characters starting at the specified offset with the
   specified string.  Test for replacement in the
   middle of the data.

   Retrieve the character data from the last child of the
   first employee.  The "replaceData(offset,count,arg)"
   method is then called with offset=5 and count=5 and
   arg="South".  The method should replace characters five
   thru 9 of the character data with "South".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-E5CBA7FB
*/
TEST("hc_characterdatareplacedatamiddle", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.replaceData(5,5,"South");
      childData = child.data;

      ASSERT(STRICT_EQ("1230 South Ave. Dallas, Texas 98551",childData),"characterdataReplaceDataMiddleAssert");

});



/**
*
  The "setNodeValue()" method changes the character data
  currently stored in the node.
  Retrieve the character data from the second child
  of the first employee and invoke the "setNodeValue()"
  method, call "getData()" and compare.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-72AB8359
*/
TEST("hc_characterdatasetnodevalue", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var childData;
      var childValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      child.nodeValue = "Marilyn Martin";

      childData = child.data;

      ASSERT(STRICT_EQ("Marilyn Martin",childData),"data");
       childValue = child.nodeValue;

      ASSERT(STRICT_EQ("Marilyn Martin",childValue),"value");

});



/**
*
    If the sum of the "offset" and "count" exceeds the
   "length" then the "substringData(offset,count)" method
   returns all the characters to the end of the data.

   Retrieve the character data from the second child
   of the first employee and access part of the data
   by using the substringData(offset,count) method
   with offset=9 and count=10.  The method should return
   the substring "Martin" since offset+count > length
   (19 > 15).

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6531BCCF
*/
TEST("hc_characterdatasubstringexceedsvalue", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var substring;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      substring = child.substringData(9,10);
      ASSERT(STRICT_EQ("Martin",substring),"characterdataSubStringExceedsValueAssert");

});



/**
*
    The "substringData(offset,count)" method returns the
   specified string.

   Retrieve the character data from the second child
   of the first employee and access part of the data
   by using the substringData(offset,count) method.  The
   method should return the specified substring starting
   at position "offset" and extract "count" characters.
   The method should return the string "Margaret".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6531BCCF
*/
TEST("hc_characterdatasubstringvalue", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var child;
      var substring;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(0);
      child = nameNode.firstChild;

      substring = child.substringData(0,8);
      ASSERT(STRICT_EQ("Margaret",substring),"characterdataSubStringValueAssert");

});



/**
*
    A comment is all the characters between the starting
  '<!--' and ending '-->'
  Retrieve the nodes of the DOM document.  Search for a
  comment node and the content is its value.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1334481328
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=509
*/
TEST("hc_commentgetcomment", function() {
   var success;
    var doc;
      var elementList;
      var child;
      var childName;
      var childValue;
      var commentCount = 0;
      var childType;
      var attributes;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.childNodes;

      for(var indexid2258674 = 0;indexid2258674 < elementList.length; indexid2258674++) {
      child = elementList.item(indexid2258674);
      childType = child.nodeType;


	if(
	(8 == childType)
	) {
	childName = child.nodeName;

      ASSERT(STRICT_EQ("#comment",childName),"nodeName");
       childValue = child.nodeValue;

      ASSERT(STRICT_EQ(" This is comment number 1.",childValue),"nodeValue");
       attributes = child.attributes;

      ASSERT(NULL(attributes),"attributes");
    commentCount += 1;

	}
	
	}
   	assertTrue("atMostOneComment",

	(commentCount < 2)
);

});



/**
*
   Retrieve the entire DOM document and invoke its
   "createAttribute(name)" method.  It should create a
   new Attribute node with the given name. The name, value
   and type of the newly created object are retrieved and
   output.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1084891198
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=236
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2003Jun/0011.html
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=243
*/
TEST("hc_documentcreateattribute", function() {
   var success;
    var doc;
      var newAttrNode;
      var attrValue;
      var attrName;
      var attrType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newAttrNode = doc.createAttribute("title");
      attrValue = newAttrNode.nodeValue;

      ASSERT(STRICT_EQ("",attrValue),"value");
       attrName = newAttrNode.nodeName;

      ASSERT(STRICT_EQ("title",attrName), "name");
       attrType = newAttrNode.nodeType;

      ASSERT(STRICT_EQ(2,attrType),"type");

});



/**
*
    The "createComment(data)" method creates a new Comment
   node given the specified string.
   Retrieve the entire DOM document and invoke its
   "createComment(data)" method.  It should create a new
   Comment node whose "data" is the specified string.
   The content, name and type are retrieved and output.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1334481328
*/
TEST("hc_documentcreatecomment", function() {
   var success;
    var doc;
      var newCommentNode;
      var newCommentValue;
      var newCommentName;
      var newCommentType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newCommentNode = doc.createComment("This is a new Comment node");
      newCommentValue = newCommentNode.nodeValue;

      ASSERT(STRICT_EQ("This is a new Comment node",newCommentValue),"value");
       newCommentName = newCommentNode.nodeName;

      ASSERT(STRICT_EQ("#comment",newCommentName),"strong");
       newCommentType = newCommentNode.nodeType;

      ASSERT(STRICT_EQ(8,newCommentType),"type");

});



/**
*
    The "createDocumentFragment()" method creates an empty
   DocumentFragment object.
   Retrieve the entire DOM document and invoke its
   "createDocumentFragment()" method.  The content, name,
   type and value of the newly created object are output.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-35CB04B5
*/
TEST("hc_documentcreatedocumentfragment", function() {
   var success;
    var doc;
      var newDocFragment;
      var children;
      var length;
      var newDocFragmentName;
      var newDocFragmentType;
      var newDocFragmentValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newDocFragment = doc.createDocumentFragment();
      children = newDocFragment.childNodes;

      length = children.length;

      ASSERT(STRICT_EQ(0,length),"length");
       newDocFragmentName = newDocFragment.nodeName;

      ASSERT(STRICT_EQ("#document-fragment",newDocFragmentName),"strong");
       newDocFragmentType = newDocFragment.nodeType;

      ASSERT(STRICT_EQ(11,newDocFragmentType),"type");
       newDocFragmentValue = newDocFragment.nodeValue;

      ASSERT(NULL(newDocFragmentValue),"value");

});



/**
*
    The "createElement(tagName)" method creates an Element
   of the type specified.
   Retrieve the entire DOM document and invoke its
   "createElement(tagName)" method with tagName="acronym".
   The method should create an instance of an Element node
   whose tagName is "acronym".  The NodeName, NodeType
   and NodeValue are returned.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547
*/
TEST("hc_documentcreateelement", function() {
   var success;
    var doc;
      var newElement;
      var newElementName;
      var newElementType;
      var newElementValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newElement = doc.createElement("acronym");
      newElementName = newElement.nodeName;

      ASSERT(STRICT_EQ("acronym",newElementName), "strong");
       newElementType = newElement.nodeType;

      ASSERT(STRICT_EQ(1,newElementType),"type");
       newElementValue = newElement.nodeValue;

      ASSERT(NULL(newElementValue),"valueInitiallyNull");

});



/**
*
    The tagName parameter in the "createElement(tagName)"
   method is case-sensitive for XML documents.
   Retrieve the entire DOM document and invoke its
   "createElement(tagName)" method twice.  Once for tagName
   equal to "acronym" and once for tagName equal to "ACRONYM"
   Each call should create a distinct Element node.  The
   newly created Elements are then assigned attributes
   that are retrieved.

   Modified on 27 June 2003 to avoid setting an invalid style
   values and checked the node names to see if they matched expectations.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=243
*/
TEST("hc_documentcreateelementcasesensitive", function() {
   var success;
    var doc;
      var newElement1;
      var newElement2;
      var attribute1;
      var attribute2;
      var nodeName1;
      var nodeName2;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newElement1 = doc.createElement("ACRONYM");
      newElement2 = doc.createElement("acronym");
      newElement1.setAttribute("lang","EN");
      newElement2.setAttribute("title","Dallas");
      attribute1 = newElement1.getAttribute("lang");
      attribute2 = newElement2.getAttribute("title");
      ASSERT(STRICT_EQ("EN",attribute1),"attrib1");
       ASSERT(STRICT_EQ("Dallas",attribute2),"attrib2");
       nodeName1 = newElement1.nodeName;

      nodeName2 = newElement2.nodeName;

      ASSERT(STRICT_EQ("ACRONYM",nodeName1), "nodeName1");
       ASSERT(STRICT_EQ("acronym",nodeName2), "nodeName2");

});



/**
*
    The "createTextNode(data)" method creates a Text node
   given the specfied string.
   Retrieve the entire DOM document and invoke its
   "createTextNode(data)" method.  It should create a
   new Text node whose "data" is the specified string.
   The NodeName and NodeType are also checked.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1975348127
*/
TEST("hc_documentcreatetextnode", function() {
   var success;
    var doc;
      var newTextNode;
      var newTextName;
      var newTextValue;
      var newTextType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newTextNode = doc.createTextNode("This is a new Text node");
      newTextValue = newTextNode.nodeValue;

      ASSERT(STRICT_EQ("This is a new Text node",newTextValue),"value");
       newTextName = newTextNode.nodeName;

      ASSERT(STRICT_EQ("#text",newTextName),"strong");
       newTextType = newTextNode.nodeType;

      ASSERT(STRICT_EQ(3,newTextType),"type");

});



/**
*
    The "getElementsByTagName(tagName)" method returns a
   NodeList of all the Elements with a given tagName.

   Retrieve the entire DOM document and invoke its
   "getElementsByTagName(tagName)" method with tagName
   equal to "strong".  The method should return a NodeList
   that contains 5 elements.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-A6C9094
*/
TEST("hc_documentgetelementsbytagnamelength", function() {
   var success;
    var doc;
      var nameList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      nameList = doc.getElementsByTagName("strong");
      ASSERT(STRICT_EQ(5,nameList.length),"documentGetElementsByTagNameLengthAssert");

});



/**
*
   Retrieve the entire DOM document and invoke its
   "getElementsByTagName(tagName)" method with tagName
   equal to "*".  The method should return a NodeList
   that contains all the elements of the document.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-A6C9094
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=251
*/
TEST("hc_documentgetelementsbytagnametotallength", function() {
   var success;
    var doc;
      var nameList;
      expectedNames = new Array();
      expectedNames[0] = "html";
      expectedNames[1] = "head";
      expectedNames[2] = "meta";
      expectedNames[3] = "title";
      expectedNames[4] = "script";
      expectedNames[5] = "script";
      expectedNames[6] = "script";
      expectedNames[7] = "body";
      expectedNames[8] = "p";
      expectedNames[9] = "em";
      expectedNames[10] = "strong";
      expectedNames[11] = "code";
      expectedNames[12] = "sup";
      expectedNames[13] = "var";
      expectedNames[14] = "acronym";
      expectedNames[15] = "p";
      expectedNames[16] = "em";
      expectedNames[17] = "strong";
      expectedNames[18] = "code";
      expectedNames[19] = "sup";
      expectedNames[20] = "var";
      expectedNames[21] = "acronym";
      expectedNames[22] = "p";
      expectedNames[23] = "em";
      expectedNames[24] = "strong";
      expectedNames[25] = "code";
      expectedNames[26] = "sup";
      expectedNames[27] = "var";
      expectedNames[28] = "acronym";
      expectedNames[29] = "p";
      expectedNames[30] = "em";
      expectedNames[31] = "strong";
      expectedNames[32] = "code";
      expectedNames[33] = "sup";
      expectedNames[34] = "var";
      expectedNames[35] = "acronym";
      expectedNames[36] = "p";
      expectedNames[37] = "em";
      expectedNames[38] = "strong";
      expectedNames[39] = "code";
      expectedNames[40] = "sup";
      expectedNames[41] = "var";
      expectedNames[42] = "acronym";

      svgExpectedNames = new Array();
      svgExpectedNames[0] = "svg";
      svgExpectedNames[1] = "rect";
      svgExpectedNames[2] = "script";
      svgExpectedNames[3] = "head";
      svgExpectedNames[4] = "meta";
      svgExpectedNames[5] = "title";
      svgExpectedNames[6] = "body";
      svgExpectedNames[7] = "p";
      svgExpectedNames[8] = "em";
      svgExpectedNames[9] = "strong";
      svgExpectedNames[10] = "code";
      svgExpectedNames[11] = "sup";
      svgExpectedNames[12] = "var";
      svgExpectedNames[13] = "acronym";
      svgExpectedNames[14] = "p";
      svgExpectedNames[15] = "em";
      svgExpectedNames[16] = "strong";
      svgExpectedNames[17] = "code";
      svgExpectedNames[18] = "sup";
      svgExpectedNames[19] = "var";
      svgExpectedNames[20] = "acronym";
      svgExpectedNames[21] = "p";
      svgExpectedNames[22] = "em";
      svgExpectedNames[23] = "strong";
      svgExpectedNames[24] = "code";
      svgExpectedNames[25] = "sup";
      svgExpectedNames[26] = "var";
      svgExpectedNames[27] = "acronym";
      svgExpectedNames[28] = "p";
      svgExpectedNames[29] = "em";
      svgExpectedNames[30] = "strong";
      svgExpectedNames[31] = "code";
      svgExpectedNames[32] = "sup";
      svgExpectedNames[33] = "var";
      svgExpectedNames[34] = "acronym";
      svgExpectedNames[35] = "p";
      svgExpectedNames[36] = "em";
      svgExpectedNames[37] = "strong";
      svgExpectedNames[38] = "code";
      svgExpectedNames[39] = "sup";
      svgExpectedNames[40] = "var";
      svgExpectedNames[41] = "acronym";

      var actualNames = new Array();

      var thisElement;
      var thisTag;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      nameList = doc.getElementsByTagName("*");
      for(var indexid2258927 = 0;indexid2258927 < nameList.length; indexid2258927++) {
      thisElement = nameList.item(indexid2258927);
      thisTag = thisElement.tagName;

      actualNames[actualNames.length] = thisTag;

	}

	if(
	
	(builder.contentType == "image/svg+xml")

	) {
	ASSERT(DOM_LIST_EQ(svgExpectedNames,actualNames), "svgTagNames");

	}
	
		else {
			ASSERT(DOM_LIST_EQ(expectedNames,actualNames), "tagNames");

		}
	
});



/**
*
    The "getElementsByTagName(tagName)" method returns a
   NodeList of all the Elements with a given tagName
   in a pre-order traversal of the tree.

   Retrieve the entire DOM document and invoke its
   "getElementsByTagName(tagName)" method with tagName
   equal to "strong".  The method should return a NodeList
   that contains 5 elements.  The FOURTH item in the
   list is retrieved and output.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-A6C9094
*/
TEST("hc_documentgetelementsbytagnamevalue", function() {
   var success;
    var doc;
      var nameList;
      var nameNode;
      var firstChild;
      var childValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      nameList = doc.getElementsByTagName("strong");
      nameNode = nameList.item(3);
      firstChild = nameNode.firstChild;

      childValue = firstChild.nodeValue;

      ASSERT(STRICT_EQ("Jeny Oconnor",childValue),"documentGetElementsByTagNameValueAssert");

});



/**
*
   Retrieve the entire DOM document and invoke its
   "getImplementation()" method.  If contentType="text/html",
   DOMImplementation.hasFeature("HTML","1.0") should be true.
   Otherwise, DOMImplementation.hasFeature("XML", "1.0")
   should be true.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1B793EBA
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=245
*/
TEST("hc_documentgetimplementation", function() {
   var success;
    var doc;
      var docImpl;
      var xmlstate;
      var htmlstate;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      docImpl = doc.implementation;
xmlstate = docImpl.hasFeature("XML","1.0");
htmlstate = docImpl.hasFeature("HTML","1.0");

	if(
	
	(builder.contentType == "text/html")

	) {
	ASSERT(STRICT_EQ(true,htmlstate),"supports_HTML_1.0");

	}
	
		else {
			ASSERT(STRICT_EQ(true,xmlstate),"supports_XML_1.0");

		}
	
});



/**
*
  Load a document and invoke its
   "getDocumentElement()" method.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-87CD092
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=251
*/
TEST("hc_documentgetrootnode", function() {
   var success;
    var doc;
      var root;
      var rootName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      root = doc.documentElement;

      rootName = root.nodeName;


	if(
	
	(builder.contentType == "image/svg+xml")

	) {
	ASSERT(STRICT_EQ("svg",rootName),"svgTagName");

	}
	
		else {
			ASSERT(STRICT_EQ("html",rootName), "docElemName");

		}
	
});



/**
*
    The "createAttribute(tagName)" method raises an
   INVALID_CHARACTER_ERR DOMException if the specified
   tagName contains an invalid character.

   Retrieve the entire DOM document and invoke its
   "createAttribute(tagName)" method with the tagName equal
   to the string "invalid^Name".  Due to the invalid
   character the desired EXCEPTION should be raised.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1084891198
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-1084891198')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1084891198
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_documentinvalidcharacterexceptioncreateattribute", function() {
   var success;
    var doc;
      var createdAttr;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");

	{
		success = false;
		try {
            createdAttr = doc.createAttribute("invalid^Name");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 5);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INVALID_CHARACTER_ERR");
	}

});



/**
*
Creating an attribute with an empty name should cause an INVALID_CHARACTER_ERR.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1084891198
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-1084891198')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1084891198
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=525
*/
TEST("hc_documentinvalidcharacterexceptioncreateattribute1", function() {
   var success;
    var doc;
      var createdAttr;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");

	{
		success = false;
		try {
            createdAttr = doc.createAttribute("");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 5);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INVALID_CHARACTER_ERR");
	}

});



/**
*
    The "createElement(tagName)" method raises an
   INVALID_CHARACTER_ERR DOMException if the specified
   tagName contains an invalid character.

   Retrieve the entire DOM document and invoke its
   "createElement(tagName)" method with the tagName equal
   to the string "invalid^Name".  Due to the invalid
   character the desired EXCEPTION should be raised.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-2141741547')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_documentinvalidcharacterexceptioncreateelement", function() {
   var success;
    var doc;
      var badElement;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");

	{
		success = false;
		try {
            badElement = doc.createElement("invalid^Name");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 5);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INVALID_CHARACTER_ERR");
	}

});



/**
*
Creating an element with an empty name should cause an INVALID_CHARACTER_ERR.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-2141741547')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-2141741547
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=525
*/
TEST("hc_documentinvalidcharacterexceptioncreateelement1", function() {
   var success;
    var doc;
      var badElement;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");

	{
		success = false;
		try {
            badElement = doc.createElement("");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 5);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INVALID_CHARACTER_ERR");
	}

});



/**
*
   Load a document and invoke its
   "getImplementation()" method.  This should create a
   DOMImplementation object whose "hasFeature(feature,
   version)" method is invoked with version equal to "".
   If the version is not specified, supporting any version
   feature will cause the method to return "true".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-5CED94D7
* @see http://www.w3.org/2000/11/DOM-Level-2-errata#core-14
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=245
*/
TEST("hc_domimplementationfeaturenoversion", function() {
   var success;
    var doc;
      var domImpl;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      domImpl = doc.implementation;

	if(
	
	(builder.contentType == "text/html")

	) {
	state = domImpl.hasFeature("HTML","");

	}
	
		else {
			state = domImpl.hasFeature("XML","");

		}
	ASSERT(STRICT_EQ(true,state),"hasFeatureBlank");

});



/**
*
   Load a document and invoke its
   "getImplementation()" method.  This should create a
   DOMImplementation object whose "hasFeature(feature,
   version)" method is invoked with version equal to null.
   If the version is not specified, supporting any version
   feature will cause the method to return "true".

* @author Curt Arnold
* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-5CED94D7
* @see http://www.w3.org/2000/11/DOM-Level-2-errata#core-14
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=245
*/
TEST("hc_domimplementationfeaturenull", function() {
   var success;
    var doc;
      var domImpl;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      domImpl = doc.implementation;

	if(
	
	(builder.contentType == "text/html")

	) {
	state = domImpl.hasFeature("HTML",null);
ASSERT(STRICT_EQ(true,state),"supports_HTML_null");

	}
	
		else {
			state = domImpl.hasFeature("XML",null);
ASSERT(STRICT_EQ(true,state),"supports_XML_null");

		}
	
});



/**
*
   Retrieve the entire DOM document and invoke its
   "getImplementation()" method.  This should create a
   DOMImplementation object whose "hasFeature(feature,
   version)" method is invoked with "feature" equal to "html" or "xml".
   The method should return a boolean "true".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-5CED94D7
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=245
*/
TEST("hc_domimplementationfeaturexml", function() {
   var success;
    var doc;
      var domImpl;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      domImpl = doc.implementation;

	if(
	
	(builder.contentType == "text/html")

	) {
	state = domImpl.hasFeature("html","1.0");
ASSERT(STRICT_EQ(true,state),"supports_html_1.0");

	}
	
		else {
			state = domImpl.hasFeature("xml","1.0");
ASSERT(STRICT_EQ(true,state),"supports_xml_1.0");

		}
	
});



/**
*
    The "setAttribute(name,value)" method adds a new attribute
   to the Element

   Retrieve the last child of the last employee, then
   add an attribute to it by invoking the
   "setAttribute(name,value)" method.  It should create
   a "strong" attribute with an assigned value equal to
   "value".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68F082
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=243
*/
TEST("hc_elementaddnewattribute", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(4);
      testEmployee.setAttribute("lang","EN-us");
      attrValue = testEmployee.getAttribute("lang");
      ASSERT(STRICT_EQ("EN-us",attrValue),"attrValue");

});



/**
*
   Retrieve the first attribute from the last child of
   the first employee and invoke the "getSpecified()"
   method.  This test is only intended to show that
   Elements can actually have attributes.  This test uses
   the "getNamedItem(name)" method from the NamedNodeMap
   interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
*/
TEST("hc_elementassociatedattribute", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var domesticAttr;
      var specified;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(0);
      attributes = testEmployee.attributes;

      domesticAttr = attributes.getNamedItem("title");
      specified = domesticAttr.specified;

      ASSERT(STRICT_EQ(true,specified),"acronymTitleSpecified");

});



/**
*
    The "setAttribute(name,value)" method adds a new attribute
   to the Element.  If the "strong" is already present, then
   its value should be changed to the new one that is in
   the "value" parameter.

   Retrieve the last child of the fourth employee, then add
   an attribute to it by invoking the
   "setAttribute(name,value)" method.  Since the name of the
   used attribute("class") is already present in this
   element, then its value should be changed to the new one
   of the "value" parameter.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68F082
*/
TEST("hc_elementchangeattributevalue", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(3);
      testEmployee.setAttribute("class","Neither");
      attrValue = testEmployee.getAttribute("class");
      ASSERT(STRICT_EQ("Neither",attrValue),"elementChangeAttributeValueAssert");

});



/**
*
    The "setAttributeNode(newAttr)" method adds a new
   attribute to the Element.

   Retrieve first address element and add
   a new attribute node to it by invoking its
   "setAttributeNode(newAttr)" method.  This test makes use
   of the "createAttribute(name)" method from the Document
   interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=243
*/
TEST("hc_elementcreatenewattribute", function() {
   var success;
    var doc;
      var elementList;
      var testAddress;
      var newAttribute;
      var oldAttr;
      var districtAttr;
      var attrVal;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddress = elementList.item(0);
      newAttribute = doc.createAttribute("lang");
      oldAttr = testAddress.setAttributeNode(newAttribute);
      ASSERT(NULL(oldAttr),"old_attr_doesnt_exist");
    districtAttr = testAddress.getAttributeNode("lang");
      ASSERT(NOT_NULL(districtAttr),"new_district_accessible");
attrVal = testAddress.getAttribute("lang");
      ASSERT(STRICT_EQ("",attrVal),"attr_value");

});



/**
*
   Retrieve the attribute "title" from the last child
   of the first "p" element and check its node name.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-217A91B8
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=236
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2003Jun/0011.html
*/
TEST("hc_elementgetattributenode", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var domesticAttr;
      var nodeName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(0);
      domesticAttr = testEmployee.getAttributeNode("title");
      nodeName = domesticAttr.nodeName;

      ASSERT(STRICT_EQ("title",nodeName), "nodeName");

});



/**
*
    The "getAttributeNode(name)" method retrieves an
   attribute node by name.  It should return null if the
   "strong" attribute does not exist.

   Retrieve the last child of the first employee and attempt
   to retrieve a non-existing attribute.  The method should
   return "null".  The non-existing attribute to be used
   is "invalidAttribute".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-217A91B8
*/
TEST("hc_elementgetattributenodenull", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var domesticAttr;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(0);
      domesticAttr = testEmployee.getAttributeNode("invalidAttribute");
      ASSERT(NULL(domesticAttr),"elementGetAttributeNodeNullAssert");

});



/**
*
    The "getAttribute(name)" method returns an empty
   string if no value was assigned to an attribute and
   no default value was given in the DTD file.

   Retrieve the last child of the last employee, then
   invoke "getAttribute(name)" method, where "strong" is an
   attribute without a specified or DTD default value.
   The "getAttribute(name)" method should return the empty
   string.  This method makes use of the
   "createAttribute(newAttr)" method from the Document
   interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-666EE0F9
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=243
*/
TEST("hc_elementgetelementempty", function() {
   var success;
    var doc;
      var newAttribute;
      var elementList;
      var testEmployee;
      var domesticAttr;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newAttribute = doc.createAttribute("lang");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(3);
      domesticAttr = testEmployee.setAttributeNode(newAttribute);
      attrValue = testEmployee.getAttribute("lang");
      ASSERT(STRICT_EQ("",attrValue),"elementGetElementEmptyAssert");

});



/**
*
The "getElementsByTagName(name)" method returns a list
of all descendant Elements with the given tag name.
Test for an empty list.

Create a NodeList of all the descendant elements
using the string "noMatch" as the tagName.
The method should return a NodeList whose length is
"0" since there are not any descendant elements
that match the given tag name.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1938918D
*/
TEST("hc_elementgetelementsbytagname", function() {
   var success;
    var doc;
      var elementList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      ASSERT(STRICT_EQ(5,elementList.length),"elementGetElementsByTagNameAssert");

});



/**
*
The "getElementsByTagName(name)" method returns a list
of all descendant Elements in the order the children
were encountered in a pre order traversal of the element
tree.

Create a NodeList of all the descendant elements
using the string "p" as the tagName.
The method should return a NodeList whose length is
"5" in the order the children were encountered.
Access the FOURTH element in the NodeList.  The FOURTH
element, the first or second should be an "em" node with
the content "EMP0004".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1938918D
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_elementgetelementsbytagnameaccessnodelist", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var firstC;
      var childName;
      var nodeType;
      var employeeIDNode;
      var employeeID;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      testEmployee = elementList.item(3);
      firstC = testEmployee.firstChild;

      nodeType = firstC.nodeType;


    while(
	(3 == nodeType)
	) {
	firstC = firstC.nextSibling;

      nodeType = firstC.nodeType;


	}
childName = firstC.nodeName;

      ASSERT(STRICT_EQ("em",childName), "childName");
       employeeIDNode = firstC.firstChild;

      employeeID = employeeIDNode.nodeValue;

      ASSERT(STRICT_EQ("EMP0004",employeeID),"employeeID");

});



/**
*
The "getElementsByTagName(name)" method returns a list
of all descendant Elements with the given tag name.

Create a NodeList of all the descendant elements
using the string "employee" as the tagName.
The method should return a NodeList whose length is
"5".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1938918D
*/
TEST("hc_elementgetelementsbytagnamenomatch", function() {
   var success;
    var doc;
      var elementList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("noMatch");
      ASSERT(STRICT_EQ(0,elementList.length),"elementGetElementsByTagNameNoMatchNoMatchAssert");

});



/**
*
The "getElementsByTagName(name)" method may use the
special value "*" to match all tags in the element
tree.

Create a NodeList of all the descendant elements
of the last employee by using the special value "*".
The method should return all the descendant children(6)
in the order the children were encountered.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1938918D
*/
TEST("hc_elementgetelementsbytagnamespecialvalue", function() {
   var success;
    var doc;
      var elementList;
      var lastEmployee;
      var lastempList;
      var child;
      var childName;
      var result = new Array();

      expectedResult = new Array();
      expectedResult[0] = "em";
      expectedResult[1] = "strong";
      expectedResult[2] = "code";
      expectedResult[3] = "sup";
      expectedResult[4] = "var";
      expectedResult[5] = "acronym";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      lastEmployee = elementList.item(4);
      lastempList = lastEmployee.getElementsByTagName("*");
      for(var indexid2258680 = 0;indexid2258680 < lastempList.length; indexid2258680++) {
      child = lastempList.item(indexid2258680);
      childName = child.nodeName;

      result[result.length] = childName;

	}
   ASSERT(DOM_LIST_EQ(expectedResult,result), "tagNames");

});



/**
*
   Invoke the "getTagName()" method one the
   root node. The value returned should be "html" or "svg".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-104682815
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=251
*/
TEST("hc_elementgettagname", function() {
   var success;
    var doc;
      var root;
      var tagname;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      root = doc.documentElement;

      tagname = root.tagName;


	if(
	
	(builder.contentType == "image/svg+xml")

	) {
	ASSERT(STRICT_EQ("svg",tagname),"svgTagname");

	}
	
		else {
			ASSERT(STRICT_EQ("html",tagname), "tagname");

		}
	
});



/**
*
    The "setAttributeNode(newAttr)" method raises an
   "INUSE_ATTRIBUTE_ERR DOMException if the "newAttr"
   is already an attribute of another element.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-887236154')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=244
*/
TEST("hc_elementinuseattributeerr", function() {
   var success;
    var doc;
      var newAttribute;
      var addressElementList;
      var testAddress;
      var newElement;
      var attrAddress;
      var appendedChild;
      var setAttr1;
      var setAttr2;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      addressElementList = doc.getElementsByTagName("body");
      testAddress = addressElementList.item(0);
      newElement = doc.createElement("p");
      appendedChild = testAddress.appendChild(newElement);
      newAttribute = doc.createAttribute("title");
      setAttr1 = newElement.setAttributeNode(newAttribute);

	{
		success = false;
		try {
            setAttr2 = testAddress.setAttributeNode(newAttribute);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 10);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INUSE_ATTRIBUTE_ERR");
	}

});



/**
*
    The "setAttribute(name,value)" method raises an
   "INVALID_CHARACTER_ERR DOMException if the specified
   name contains an invalid character.

   Retrieve the last child of the first employee and
   call its "setAttribute(name,value)" method with
   "strong" containing an invalid character.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68F082
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-F68F082')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_elementinvalidcharacterexception", function() {
   var success;
    var doc;
      var elementList;
      var testAddress;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddress = elementList.item(0);

	{
		success = false;
		try {
            testAddress.setAttribute("invalid^Name","value");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 5);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INVALID_CHARACTER_ERR");
	}

});



/**
*
Calling Element.setAttribute with an empty name will cause an INVALID_CHARACTER_ERR.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68F082
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-F68F082')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INVALID_CHARACTER_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=525
*/
TEST("hc_elementinvalidcharacterexception1", function() {
   var success;
    var doc;
      var elementList;
      var testAddress;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddress = elementList.item(0);

	{
		success = false;
		try {
            testAddress.setAttribute("","value");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 5);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INVALID_CHARACTER_ERR");
	}

});



/**
*
Append a couple of text nodes to the first sup element, normalize the
document element and check that the element has been normalized.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-162CF083
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=546
*/
TEST("hc_elementnormalize", function() {
   var success;
    var doc;
      var root;
      var elementList;
      var testName;
      var firstChild;
      var childValue;
      var textNode;
      var retNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("sup");
      testName = elementList.item(0);
      textNode = doc.createTextNode("");
      retNode = testName.appendChild(textNode);
      textNode = doc.createTextNode(",000");
      retNode = testName.appendChild(textNode);
      root = doc.documentElement;

      root.normalize();
      elementList = doc.getElementsByTagName("sup");
      testName = elementList.item(0);
      firstChild = testName.firstChild;

      childValue = firstChild.nodeValue;

      ASSERT(STRICT_EQ("56,000,000",childValue),"elementNormalizeAssert");

});



/**
*
Add an empty text node to an existing attribute node, normalize the containing element
and check that the attribute node has eliminated the empty text.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-162CF083
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=482
*/
TEST("hc_elementnormalize2", function() {
   var success;
    var doc;
      var root;
      var elementList;
      var element;
      var firstChild;
      var secondChild;
      var childValue;
      var emptyText;
      var attrNode;
      var retval;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      root = doc.documentElement;

      emptyText = doc.createTextNode("");
      elementList = root.getElementsByTagName("acronym");
      element = elementList.item(0);
      attrNode = element.getAttributeNode("title");
      retval = attrNode.appendChild(emptyText);
      element.normalize();
      attrNode = element.getAttributeNode("title");
      firstChild = attrNode.firstChild;

      childValue = firstChild.nodeValue;

      ASSERT(STRICT_EQ("Yes",childValue),"firstChild");
       secondChild = firstChild.nextSibling;

      ASSERT(NULL(secondChild),"secondChildNull");

});



/**
*
    The "removeAttributeNode(oldAttr)" method raises a
   NOT_FOUND_ERR DOMException if the "oldAttr" attribute
   is not an attribute of the element.

   Retrieve the last employee and attempt to remove
   a non existing attribute node.  This should cause the
   intended exception to be raised.  This test makes use
   of the "createAttribute(name)" method from the Document
   interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D589198
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-D589198')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_elementnotfounderr", function() {
   var success;
    var doc;
      var oldAttribute;
      var addressElementList;
      var testAddress;
      var attrAddress;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      addressElementList = doc.getElementsByTagName("acronym");
      testAddress = addressElementList.item(4);
      oldAttribute = doc.createAttribute("title");

	{
		success = false;
		try {
            attrAddress = testAddress.removeAttributeNode(oldAttribute);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 8);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_FOUND_ERR");
	}

});



/**
*
    The "removeAttribute(name)" removes an attribute by name.
   If the attribute has a default value, it is immediately
   replaced.  However, there is no default values in the HTML
   compatible tests, so its value is "".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6D6AC0F9
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2002Mar/0002.html
*/
TEST("hc_elementremoveattribute", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(3);
      testEmployee.removeAttribute("class");
      attrValue = testEmployee.getAttribute("class");
      ASSERT(STRICT_EQ("",attrValue),"attrValue");

});



/**
*
    The "removeAttributeNode(oldAttr)" method removes the
   specified attribute.

   Retrieve the last child of the third employee, add a
   new "lang" attribute to it and then try to remove it.
   To verify that the node was removed use the
   "getNamedItem(name)" method from the NamedNodeMap
   interface.  It also uses the "getAttributes()" method
   from the Node interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D589198
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=243
*/
TEST("hc_elementremoveattributeaftercreate", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var newAttribute;
      var attributes;
      var districtAttr;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(2);
      newAttribute = doc.createAttribute("lang");
      districtAttr = testEmployee.setAttributeNode(newAttribute);
      districtAttr = testEmployee.removeAttributeNode(newAttribute);
      attributes = testEmployee.attributes;

      districtAttr = attributes.getNamedItem("lang");
      ASSERT(NULL(districtAttr),"removed_item_null");

});



/**
*
    The "removeAttributeNode(oldAttr)" method returns the
   node that was removed.

   Retrieve the last child of the third employee and
   remove its "class" Attr node.  The method should
   return the old attribute node.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D589198
*/
TEST("hc_elementremoveattributenode", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var streetAttr;
      var removedAttr;
      var removedValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(2);
      streetAttr = testEmployee.getAttributeNode("class");
      removedAttr = testEmployee.removeAttributeNode(streetAttr);
      ASSERT(NOT_NULL(removedAttr),"removedAttrNotNull");
removedValue = removedAttr.value;

      ASSERT(STRICT_EQ("No",removedValue),"elementRemoveAttributeNodeAssert");

});



/**
*
This test calls setAttributeNode to replace an attribute with itself.
Since the node is not an attribute of another Element, it would
be inappropriate to throw an INUSE_ATTRIBUTE_ERR.

This test was derived from elementinuserattributeerr which
inadvertanly made this test.

* @author Curt Arnold
* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154
*/
TEST("hc_elementreplaceattributewithself", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var streetAttr;
      var replacedAttr;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(2);
      streetAttr = testEmployee.getAttributeNode("class");
      replacedAttr = testEmployee.setAttributeNode(streetAttr);
      ASSERT(DOM_SAME(streetAttr,replacedAttr),"replacedAttr");

});



/**
*
    The "setAttributeNode(newAttr)" method adds a new
   attribute to the Element.  If the "newAttr" Attr node is
   already present in this element, it should replace the
   existing one.

   Retrieve the last child of the third employee and add a
   new attribute node by invoking the "setAttributeNode(new
   Attr)" method.  The new attribute node to be added is
   "class", which is already present in this element.  The
   method should replace the existing Attr node with the
   new one.  This test uses the "createAttribute(name)"
   method from the Document interface.

* @author Curt Arnold
*/
TEST("hc_elementreplaceexistingattribute", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var newAttribute;
      var strong;
      var setAttr;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(2);
      newAttribute = doc.createAttribute("class");
      setAttr = testEmployee.setAttributeNode(newAttribute);
      strong = testEmployee.getAttribute("class");
      ASSERT(STRICT_EQ("",strong),"replacedValue");

});



/**
*
If the "setAttributeNode(newAttr)" method replaces an
existing Attr node with the same name, then it should
return the previously existing Attr node.

Retrieve the last child of the third employee and add a
new attribute node.  The new attribute node is "class",
which is already present in this Element.  The method
should return the existing Attr node(old "class" Attr).
This test uses the "createAttribute(name)" method
from the Document interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154
*/
TEST("hc_elementreplaceexistingattributegevalue", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var newAttribute;
      var streetAttr;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(2);
      newAttribute = doc.createAttribute("class");
      streetAttr = testEmployee.setAttributeNode(newAttribute);
      ASSERT(NOT_NULL(streetAttr),"previousAttrNotNull");
value = streetAttr.value;

      ASSERT(STRICT_EQ("No",value),"previousAttrValue");

});



/**
*
    The "getAttribute(name)" method returns an attribute
   value by name.

   Retrieve the second address element, then
   invoke the 'getAttribute("class")' method.  This should
   return the value of the attribute("No").

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-666EE0F9
*/
TEST("hc_elementretrieveattrvalue", function() {
   var success;
    var doc;
      var elementList;
      var testAddress;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddress = elementList.item(2);
      attrValue = testAddress.getAttribute("class");
      ASSERT(STRICT_EQ("No",attrValue),"attrValue");

});



/**
*
    The "getElementsByTagName()" method returns a NodeList
   of all descendant elements with a given tagName.

   Invoke the "getElementsByTagName()" method and create
   a NodeList of "code" elements.  Retrieve the second
   "code" element in the list and return the NodeName.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-104682815
*/
TEST("hc_elementretrievetagname", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var strong;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("code");
      testEmployee = elementList.item(1);
      strong = testEmployee.nodeName;

      ASSERT(STRICT_EQ("code",strong), "nodename");
       strong = testEmployee.tagName;

      ASSERT(STRICT_EQ("code",strong), "tagname");

});



/**
*
    The "setAttributeNode(newAttr)" method returns the
   null value if no previously existing Attr node with the
   same name was replaced.

   Retrieve the last child of the third employee and add a
   new attribute to it.  The new attribute node added is
   "lang", which is not part of this Element.  The
   method should return the null value.
   This test uses the "createAttribute(name)"
   method from the Document interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=243
*/
TEST("hc_elementsetattributenodenull", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var newAttribute;
      var districtAttr;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(2);
      newAttribute = doc.createAttribute("lang");
      districtAttr = testEmployee.setAttributeNode(newAttribute);
      ASSERT(NULL(districtAttr),"elementSetAttributeNodeNullAssert");

});



/**
*
    The "setAttributeNode(newAttr)" method raises an
   "WRONG_DOCUMENT_ERR DOMException if the "newAttr"
   was created from a different document than the one that
   created this document.

   Retrieve the last employee and attempt to set a new
   attribute node for its "employee" element.  The new
   attribute was created from a document other than the
   one that created this element, therefore a
   WRONG_DOCUMENT_ERR DOMException should be raised.

   This test uses the "createAttribute(newAttr)" method
   from the Document interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='WRONG_DOCUMENT_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-887236154')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='WRONG_DOCUMENT_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_elementwrongdocumenterr", function() {
   var success;
    var doc1;
      var doc2;
      var newAttribute;
      var addressElementList;
      var testAddress;
      var attrAddress;

      var doc1Ref = null;
      if (typeof(this.doc1) != 'undefined') {
        doc1Ref = this.doc1;
      }
      doc1 = load(doc1Ref, "doc1", "hc_staff");

      var doc2Ref = null;
      if (typeof(this.doc2) != 'undefined') {
        doc2Ref = this.doc2;
      }
      doc2 = load(doc2Ref, "doc2", "hc_staff");
      newAttribute = doc2.createAttribute("newAttribute");
      addressElementList = doc1.getElementsByTagName("acronym");
      testAddress = addressElementList.item(4);

	{
		success = false;
		try {
            attrAddress = testAddress.setAttributeNode(newAttribute);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 4);
		}
		ASSERT(STRICT_EQ(true,success),"throw_WRONG_DOCUMENT_ERR");
	}

});



/**
*
   Retrieve the second "p" element and create a NamedNodeMap
   listing of the attributes of the last child.  Once the
   list is created an invocation of the "getNamedItem(name)"
   method is done with name="title".  This should result
   in the title Attr node being returned.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1074577549
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=236
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2003Jun/0011.html
*/
TEST("hc_namednodemapgetnameditem", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var domesticAttr;
      var attrName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(1);
      attributes = testEmployee.attributes;

      domesticAttr = attributes.getNamedItem("title");
      attrName = domesticAttr.nodeName;

      ASSERT(STRICT_EQ("title",attrName), "nodeName");

});



/**
*
The "setNamedItem(arg)" method raises a
INUSE_ATTRIBUTE_ERR DOMException if "arg" is an
Attr that is already in an attribute of another Element.

Create a NamedNodeMap object from the attributes of the
last child of the third employee and attempt to add
an attribute that is already being used by the first
employee.  This should raise the desired exception.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1025163788
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-1025163788')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_namednodemapinuseattributeerr", function() {
   var success;
    var doc;
      var elementList;
      var firstNode;
      var testNode;
      var attributes;
      var domesticAttr;
      var setAttr;
      var setNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      firstNode = elementList.item(0);
      domesticAttr = doc.createAttribute("title");
      domesticAttr.value = "Yα";

      setAttr = firstNode.setAttributeNode(domesticAttr);
      elementList = doc.getElementsByTagName("acronym");
      testNode = elementList.item(2);
      attributes = testNode.attributes;


	{
		success = false;
		try {
            setNode = attributes.setNamedItem(domesticAttr);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 10);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INUSE_ATTRIBUTE_ERR");
	}

});



/**
*
    The "removeNamedItem(name)" method raises a
   NOT_FOUND_ERR DOMException if there is not a node
   named "strong" in the map.

   Create a NamedNodeMap object from the attributes of the
   last child of the third employee and attempt to remove
   the "lang" attribute.  There is not a node named
   "lang" in the list and therefore the desired
   exception should be raised.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D58B193
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-D58B193')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=243
*/
TEST("hc_namednodemapnotfounderr", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var removedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(2);
      attributes = testEmployee.attributes;


	{
		success = false;
		try {
            removedNode = attributes.removeNamedItem("lang");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 8);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_FOUND_ERR");
	}

});



/**
*
    The "removeNamedItem(name)" method removes a node
   specified by name.

   Retrieve the third employee and create a NamedNodeMap
   object of the attributes of the last child.  Once the
   list is created invoke the "removeNamedItem(name)"
   method with name="class".  This should result
   in the removal of the specified attribute.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D58B193
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2002Mar/0002.html
*/
TEST("hc_namednodemapremovenameditem", function() {
   var success;
    var doc;
      var elementList;
      var newAttribute;
      var testAddress;
      var attributes;
      var streetAttr;
      var specified;
      var removedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddress = elementList.item(2);
      attributes = testAddress.attributes;

      removedNode = attributes.removeNamedItem("class");
      streetAttr = attributes.getNamedItem("class");
      ASSERT(NULL(streetAttr),"isnull");

});



/**
*
   Retrieve the second p element and create a NamedNodeMap
   listing of the attributes of the last child.  Once the
   list is created an invocation of the "getNamedItem(name)"
   method is done with name="class".  This should result
   in the method returning an Attr node.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1074577549
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1112119403
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=236
*/
TEST("hc_namednodemapreturnattrnode", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var streetAttr;
      var attrName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(1);
      attributes = testEmployee.attributes;

      streetAttr = attributes.getNamedItem("class");
      ASSERT(EQ(2,streetAttr.nodeType),"typeAssert");
attrName = streetAttr.nodeName;

      ASSERT(STRICT_EQ("class",attrName), "nodeName");
       attrName = streetAttr.name;

      ASSERT(STRICT_EQ("class",attrName), "name");

});



/**
*
    The "getNamedItem(name)" method returns null of the
   specified name did not identify any node in the map.

   Retrieve the second employee and create a NamedNodeMap
   listing of the attributes of the last child.  Once the
   list is created an invocation of the "getNamedItem(name)"
   method is done with name="lang".  This name does not
   match any names in the list therefore the method should
   return null.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1074577549
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=243
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_namednodemapreturnnull", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var districtNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testEmployee = elementList.item(1);
      attributes = testEmployee.attributes;

      districtNode = attributes.getNamedItem("lang");
      ASSERT(NULL(districtNode),"langAttrNull");

});



/**
*
   Retrieve the second "p" element and create a NamedNodeMap
   object from the attributes of the last child by
   invoking the "getAttributes()" method.  Once the
   list is created an invocation of the "setNamedItem(arg)"
   method is done with arg=newAttr, where newAttr is a
   new Attr Node previously created.  The "setNamedItem(arg)"
   method should add then new node to the NamedNodeItem
   object by using its "nodeName" attribute("lang').
   This node is then retrieved using the "getNamedItem(name)"
   method.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1025163788
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=236
* @see http://lists.w3.org/Archives/Public/www-dom-ts/2003Jun/0011.html
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=243
*/
TEST("hc_namednodemapsetnameditem", function() {
   var success;
    var doc;
      var elementList;
      var newAttribute;
      var testAddress;
      var attributes;
      var districtNode;
      var attrName;
      var setNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddress = elementList.item(1);
      newAttribute = doc.createAttribute("lang");
      attributes = testAddress.attributes;

      setNode = attributes.setNamedItem(newAttribute);
      districtNode = attributes.getNamedItem("lang");
      attrName = districtNode.nodeName;

      ASSERT(STRICT_EQ("lang",attrName), "nodeName");

});



/**
*
    If the "setNamedItem(arg)" method replaces an already
   existing node with the same name then the already
   existing node is returned.

   Retrieve the third employee and create a NamedNodeMap
   object from the attributes of the last child by
   invoking the "getAttributes()" method.  Once the
   list is created an invocation of the "setNamedItem(arg)"
   method is done with arg=newAttr, where newAttr is a
   new Attr Node previously created and whose node name
   already exists in the map.  The "setNamedItem(arg)"
   method should replace the already existing node with
   the new one and return the existing node.
   This test uses the "createAttribute(name)" method from
   the document interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1025163788
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
*/
TEST("hc_namednodemapsetnameditemreturnvalue", function() {
   var success;
    var doc;
      var elementList;
      var newAttribute;
      var testAddress;
      var attributes;
      var newNode;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddress = elementList.item(2);
      newAttribute = doc.createAttribute("class");
      attributes = testAddress.attributes;

      newNode = attributes.setNamedItem(newAttribute);
      ASSERT(NOT_NULL(newNode),"previousAttrNotNull");
attrValue = newNode.nodeValue;

      ASSERT(STRICT_EQ("No",attrValue),"previousAttrValue");

});



/**
*
    If the node to be added by the "setNamedItem(arg)" method
   already exists in the NamedNodeMap, it is replaced by
   the new one.

   Retrieve the second employee and create a NamedNodeMap
   object from the attributes of the last child by
   invoking the "getAttributes()" method.  Once the
   list is created an invocation of the "setNamedItem(arg)"
   method is done with arg=newAttr, where newAttr is a
   new Attr Node previously created and whose node name
   already exists in the map.  The "setNamedItem(arg)"
   method should replace the already existing node with
   the new one.
   This node is then retrieved using the "getNamedItem(name)"
   method.  This test uses the "createAttribute(name)"
   method from the document interface

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1025163788
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
*/
TEST("hc_namednodemapsetnameditemthatexists", function() {
   var success;
    var doc;
      var elementList;
      var newAttribute;
      var testAddress;
      var attributes;
      var districtNode;
      var attrValue;
      var setNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddress = elementList.item(1);
      newAttribute = doc.createAttribute("class");
      attributes = testAddress.attributes;

      setNode = attributes.setNamedItem(newAttribute);
      districtNode = attributes.getNamedItem("class");
      attrValue = districtNode.nodeValue;

      ASSERT(STRICT_EQ("",attrValue),"namednodemapSetNamedItemThatExistsAssert");

});



/**
*
    If the "setNamedItem(arg)" method does not replace an
   existing node with the same name then it returns null.

   Retrieve the third employee and create a NamedNodeMap
   object from the attributes of the last child.
   Once the list is created the "setNamedItem(arg)" method
   is invoked with arg=newAttr, where newAttr is a
   newly created Attr Node and whose node name
   already exists in the map.  The "setNamedItem(arg)"
   method should add the new node and return null.
   This test uses the "createAttribute(name)" method from
   the document interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1025163788
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=243
*/
TEST("hc_namednodemapsetnameditemwithnewvalue", function() {
   var success;
    var doc;
      var elementList;
      var newAttribute;
      var testAddress;
      var attributes;
      var newNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddress = elementList.item(2);
      newAttribute = doc.createAttribute("lang");
      attributes = testAddress.attributes;

      newNode = attributes.setNamedItem(newAttribute);
      ASSERT(NULL(newNode),"prevValueNull");

});



/**
*
    The "setNamedItem(arg)" method raises a
   WRONG_DOCUMENT_ERR DOMException if "arg" was created
   from a different document than the one that created
   the NamedNodeMap.

   Create a NamedNodeMap object from the attributes of the
   last child of the third employee and attempt to add
   another Attr node to it that was created from a
   different DOM document.  This should raise the desired
   exception.  This method uses the "createAttribute(name)"
   method from the Document interface.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='WRONG_DOCUMENT_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1025163788
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-1025163788')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='WRONG_DOCUMENT_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_namednodemapwrongdocumenterr", function() {
   var success;
    var doc1;
      var doc2;
      var elementList;
      var testAddress;
      var attributes;
      var newAttribute;
      var strong;
      var setNode;

      var doc1Ref = null;
      if (typeof(this.doc1) != 'undefined') {
        doc1Ref = this.doc1;
      }
      doc1 = load(doc1Ref, "doc1", "hc_staff");

      var doc2Ref = null;
      if (typeof(this.doc2) != 'undefined') {
        doc2Ref = this.doc2;
      }
      doc2 = load(doc2Ref, "doc2", "hc_staff");
      elementList = doc1.getElementsByTagName("acronym");
      testAddress = elementList.item(2);
      newAttribute = doc2.createAttribute("newAttribute");
      attributes = testAddress.attributes;


	{
		success = false;
		try {
            setNode = attributes.setNamedItem(newAttribute);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 4);
		}
		ASSERT(STRICT_EQ(true,success),"throw_WRONG_DOCUMENT_ERR");
	}

});



/**
*
    Retrieve the second "p" and append a "br" Element
    node to the list of children.   The last node in the list
    is then retrieved and its NodeName examined.   The
    "getNodeName()" method should return "br".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodeappendchild", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var createdNode;
      var lchild;
      var childName;
      var appendedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      createdNode = doc.createElement("br");
      appendedChild = employeeNode.appendChild(createdNode);
      lchild = employeeNode.lastChild;

      childName = lchild.nodeName;

      ASSERT(STRICT_EQ("br",childName), "nodeName");

});



/**
*
    If the "newChild" is already in the tree, it is first
    removed before the new one is appended.

    Retrieve the "em" second employee and
    append the first child to the end of the list.   After
    the "appendChild(newChild)" method is invoked the first
    child should be the one that was second and the last
    child should be the one that was first.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodeappendchildchildexists", function() {
   var success;
    var doc;
      var elementList;
      var childList;
      var childNode;
      var newChild;
      var memberNode;
      var memberName;
      var refreshedActual = new Array();

      var actual = new Array();

      var nodeType;
      expected = new Array();
      expected[0] = "strong";
      expected[1] = "code";
      expected[2] = "sup";
      expected[3] = "var";
      expected[4] = "acronym";
      expected[5] = "em";

      var appendedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      childNode = elementList.item(1);
      childList = childNode.getElementsByTagName("*");
      newChild = childList.item(0);
      appendedChild = childNode.appendChild(newChild);
      for(var indexid2258731 = 0;indexid2258731 < childList.length; indexid2258731++) {
      memberNode = childList.item(indexid2258731);
      memberName = memberNode.nodeName;

      actual[actual.length] = memberName;

	}
   ASSERT(DOM_LIST_EQ(expected,actual), "liveByTagName");
       childList = childNode.childNodes;

      for(var indexid2258874 = 0;indexid2258874 < childList.length; indexid2258874++) {
      memberNode = childList.item(indexid2258874);
      nodeType = memberNode.nodeType;


	if(
	(1 == nodeType)
	) {
	memberName = memberNode.nodeName;

      refreshedActual[refreshedActual.length] = memberName;

	}
	
	}
   ASSERT(DOM_LIST_EQ(expected,refreshedActual), "refreshedChildNodes");

});



/**
*
    If the "newChild" is a DocumentFragment object then
    all its content is added to the child list of this node.

    Create and populate a new DocumentFragment object and
    append it to the second employee.   After the
    "appendChild(newChild)" method is invoked retrieve the
    new nodes at the end of the list, they should be the
    two Element nodes from the DocumentFragment.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodeappendchilddocfragment", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var newdocFragment;
      var newChild1;
      var newChild2;
      var child;
      var childName;
      var result = new Array();

      var appendedChild;
      var nodeType;
      expected = new Array();
      expected[0] = "em";
      expected[1] = "strong";
      expected[2] = "code";
      expected[3] = "sup";
      expected[4] = "var";
      expected[5] = "acronym";
      expected[6] = "br";
      expected[7] = "b";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      newdocFragment = doc.createDocumentFragment();
      newChild1 = doc.createElement("br");
      newChild2 = doc.createElement("b");
      appendedChild = newdocFragment.appendChild(newChild1);
      appendedChild = newdocFragment.appendChild(newChild2);
      appendedChild = employeeNode.appendChild(newdocFragment);
      for(var indexid2258773 = 0;indexid2258773 < childList.length; indexid2258773++) {
      child = childList.item(indexid2258773);
      nodeType = child.nodeType;


	if(
	(1 == nodeType)
	) {
	childName = child.nodeName;

      result[result.length] = childName;

	}
	
	}
   ASSERT(DOM_LIST_EQ(expected,result), "nodeNames");

});



/**
*
    The "appendChild(newChild)" method returns the node
    added.

    Append a newly created node to the child list of the
    second employee and check the NodeName returned.   The
    "getNodeName()" method should return "br".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodeappendchildgetnodename", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var newChild;
      var appendNode;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      newChild = doc.createElement("br");
      appendNode = employeeNode.appendChild(newChild);
      childName = appendNode.nodeName;

      ASSERT(STRICT_EQ("br",childName), "nodeName");

});



/**
*
    The "appendChild(newChild)" method raises a
    HIERARCHY_REQUEST_ERR DOMException if this node is of
    a type that does not allow children of the type "newChild"
    to be inserted.

    Retrieve the root node and attempt to append a newly
    created Attr node.   An Element node cannot have children
    of the "Attr" type, therefore the desired exception
    should be raised.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-184E7107')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_nodeappendchildinvalidnodetype", function() {
   var success;
    var doc;
      var rootNode;
      var newChild;
      var appendedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      rootNode = doc.documentElement;

      newChild = doc.createAttribute("newAttribute");

	{
		success = false;
		try {
            appendedChild = rootNode.appendChild(newChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
    The "appendChild(newChild)" method raises a
    WRONG_DOCUMENT_ERR DOMException if the "newChild" was
    created from a different document than the one that
    created this node.

    Retrieve the second employee and attempt to append
    a node created from a different document.   An attempt
    to make such a replacement should raise the desired
    exception.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-184E7107')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodeappendchildnewchilddiffdocument", function() {
   var success;
    var doc1;
      var doc2;
      var newChild;
      var elementList;
      var elementNode;
      var appendedChild;

      var doc1Ref = null;
      if (typeof(this.doc1) != 'undefined') {
        doc1Ref = this.doc1;
      }
      doc1 = load(doc1Ref, "doc1", "hc_staff");

      var doc2Ref = null;
      if (typeof(this.doc2) != 'undefined') {
        doc2Ref = this.doc2;
      }
      doc2 = load(doc2Ref, "doc2", "hc_staff");
      newChild = doc1.createElement("br");
      elementList = doc2.getElementsByTagName("p");
      elementNode = elementList.item(1);

	{
		success = false;
		try {
            appendedChild = elementNode.appendChild(newChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 4);
		}
		ASSERT(STRICT_EQ(true,success),"throw_WRONG_DOCUMENT_ERR");
	}

});



/**
*
    The "appendChild(newChild)" method raises a
    HIERARCHY_REQUEST_ERR DOMException if the node to
    append is one of this node's ancestors.

    Retrieve the second employee and attempt to append
    an ancestor node(root node) to it.
    An attempt to make such an addition should raise the
    desired exception.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-184E7107')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
*/
TEST("hc_nodeappendchildnodeancestor", function() {
   var success;
    var doc;
      var newChild;
      var elementList;
      var employeeNode;
      var childList;
      var oldChild;
      var appendedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newChild = doc.documentElement;

      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);

	{
		success = false;
		try {
            appendedChild = employeeNode.appendChild(newChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
The "getAttributes()" method invoked on an Attribute
Node returns null.

Retrieve the first attribute from the last child of the
first employee and invoke the "getAttributes()" method
on the Attribute Node.  It should return null.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
*/
TEST("hc_nodeattributenodeattribute", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var addrAttr;
      var attrNode;
      var attrList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddr = elementList.item(0);
      addrAttr = testAddr.attributes;

      attrNode = addrAttr.item(0);
      attrList = attrNode.attributes;

      ASSERT(NULL(attrList),"nodeAttributeNodeAttributeAssert1");

});



/**
*
    Retrieve the Attribute named "title" from the last
    child of the first p element and check the string returned
    by the "getNodeName()" method.   It should be equal to
    "title".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=236
*/
TEST("hc_nodeattributenodename", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var addrAttr;
      var attrName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddr = elementList.item(0);
      addrAttr = testAddr.getAttributeNode("title");
      attrName = addrAttr.nodeName;

      ASSERT(STRICT_EQ("title",attrName), "nodeName");

});



/**
*

    The "getNodeType()" method for an Attribute Node

    returns the constant value 2.



    Retrieve the first attribute from the last child of

    the first employee and invoke the "getNodeType()"

    method.   The method should return 2.


* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
*/
TEST("hc_nodeattributenodetype", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var addrAttr;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddr = elementList.item(0);
      addrAttr = testAddr.getAttributeNode("title");
      nodeType = addrAttr.nodeType;

      ASSERT(STRICT_EQ(2,nodeType),"nodeAttrNodeTypeAssert1");

});



/**
*

    The string returned by the "getNodeValue()" method for an
    Attribute Node is the value of the Attribute.

    Retrieve the Attribute named "title" from the last
    child of the first "p" and check the string returned
    by the "getNodeValue()" method.   It should be equal to
    "Yes".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
*/
TEST("hc_nodeattributenodevalue", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var addrAttr;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddr = elementList.item(0);
      addrAttr = testAddr.getAttributeNode("title");
      attrValue = addrAttr.nodeValue;

      ASSERT(STRICT_EQ("Yes",attrValue),"nodeValue");

});



/**
*

    The "getChildNodes()" method returns a NodeList
    that contains all children of this node.

    Retrieve the second employee and check the NodeList
    returned by the "getChildNodes()" method.   The
    length of the list should be 13.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1451460987
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodechildnodes", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childNode;
      var childNodes;
      var nodeType;
      var childName;
      var actual = new Array();

      expected = new Array();
      expected[0] = "em";
      expected[1] = "strong";
      expected[2] = "code";
      expected[3] = "sup";
      expected[4] = "var";
      expected[5] = "acronym";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childNodes = employeeNode.childNodes;

      for(var indexid2258684 = 0;indexid2258684 < childNodes.length; indexid2258684++) {
      childNode = childNodes.item(indexid2258684);
      nodeType = childNode.nodeType;

      childName = childNode.nodeName;


	if(
	(1 == nodeType)
	) {
	actual[actual.length] = childName;

	}
	
		else {
			ASSERT(STRICT_EQ(3,nodeType),"textNodeType");

		}
	
	}
   ASSERT(DOM_LIST_EQ(expected,actual), "elementNames");

});



/**
*
    The NodeList returned by the "getChildNodes()" method
    is live.   Changes on the node's children are immediately
    reflected on the nodes returned in the NodeList.

    Create a NodeList of the children of the second employee
    and then add a newly created element that was created
    by the "createElement()" method(Document Interface) to
    the second employee by using the "appendChild()" method.
    The length of the NodeList should reflect this new
    addition to the child list.   It should return the value 14.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1451460987
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodechildnodesappendchild", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var createdNode;
      var childNode;
      var childName;
      var childType;
      var textNode;
      var actual = new Array();

      expected = new Array();
      expected[0] = "em";
      expected[1] = "strong";
      expected[2] = "code";
      expected[3] = "sup";
      expected[4] = "var";
      expected[5] = "acronym";
      expected[6] = "br";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      createdNode = doc.createElement("br");
      employeeNode = employeeNode.appendChild(createdNode);
      for(var indexid2258731 = 0;indexid2258731 < childList.length; indexid2258731++) {
      childNode = childList.item(indexid2258731);
      childName = childNode.nodeName;

      childType = childNode.nodeType;


	if(
	(1 == childType)
	) {
	actual[actual.length] = childName;

	}
	
		else {
			ASSERT(STRICT_EQ(3,childType),"textNodeType");

		}
	
	}
   ASSERT(DOM_LIST_EQ(expected,actual), "childElements");

});



/**
*
    The "getChildNodes()" method returns a NodeList
    that contains all children of this node.   If there
    are not any children, this is a NodeList that does not
    contain any nodes.

    Retrieve the character data of the second "em" node and
    invoke the "getChildNodes()" method.   The
    NodeList returned should not have any nodes.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1451460987
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodechildnodesempty", function() {
   var success;
    var doc;
      var elementList;
      var childList;
      var employeeNode;
      var textNode;
      var length;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("em");
      employeeNode = elementList.item(1);
      textNode = employeeNode.firstChild;

      childList = textNode.childNodes;

      length = childList.length;

      ASSERT(STRICT_EQ(0,length),"length_zero");

});



/**
*
    The "cloneNode(deep)" method does not copy text unless it
    is deep cloned.(Test for deep=false)

    Retrieve the fourth child of the second employee and
    the "cloneNode(deep)" method with deep=false.   The
    duplicate node returned by the method should not copy
    any text data contained in this node.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4
*/
TEST("hc_nodeclonefalsenocopytext", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var childNode;
      var clonedNode;
      var lastChildNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      childNode = childList.item(3);
      clonedNode = childNode.cloneNode(false);
      lastChildNode = clonedNode.lastChild;

      ASSERT(NULL(lastChildNode),"nodeCloneFalseNoCopyTextAssert1");

});



/**
*
    The duplicate node returned by the "cloneNode(deep)"
    method does not have a ParentNode.

    Retrieve the second employee and invoke the
    "cloneNode(deep)" method with deep=false.   The
    duplicate node returned should return null when the
    "getParentNode()" is invoked.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4
*/
TEST("hc_nodeclonegetparentnull", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var clonedNode;
      var parentNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      clonedNode = employeeNode.cloneNode(false);
      parentNode = clonedNode.parentNode;

      ASSERT(NULL(parentNode),"nodeCloneGetParentNullAssert1");

});



/**
*
    The "cloneNode(deep)" method returns a copy of the node
    only if deep=false.

    Retrieve the second employee and invoke the
    "cloneNode(deep)" method with deep=false.   The
    method should only clone this node.   The NodeName and
    length of the NodeList are checked.   The "getNodeName()"
    method should return "employee" and the "getLength()"
    method should return 0.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4
*/
TEST("hc_nodeclonenodefalse", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var clonedNode;
      var cloneName;
      var cloneChildren;
      var length;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      clonedNode = employeeNode.cloneNode(false);
      cloneName = clonedNode.nodeName;

      ASSERT(STRICT_EQ("p",cloneName), "strong");
       cloneChildren = clonedNode.childNodes;

      length = cloneChildren.length;

      ASSERT(STRICT_EQ(0,length),"length");

});



/**
*
    The "cloneNode(deep)" method returns a copy of the node
    and the subtree under it if deep=true.

    Retrieve the second employee and invoke the
    "cloneNode(deep)" method with deep=true.   The
    method should clone this node and the subtree under it.
    The NodeName of each child in the returned node is
    checked to insure the entire subtree under the second
    employee was cloned.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodeclonenodetrue", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var clonedNode;
      var clonedList;
      var clonedChild;
      var clonedChildName;
      var origList;
      var origChild;
      var origChildName;
      var result = new Array();

      var expected = new Array();


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      origList = employeeNode.childNodes;

      for(var indexid2258685 = 0;indexid2258685 < origList.length; indexid2258685++) {
      origChild = origList.item(indexid2258685);
      origChildName = origChild.nodeName;

      expected[expected.length] = origChildName;

	}
   clonedNode = employeeNode.cloneNode(true);
      clonedList = clonedNode.childNodes;

      for(var indexid2258722 = 0;indexid2258722 < clonedList.length; indexid2258722++) {
      clonedChild = clonedList.item(indexid2258722);
      clonedChildName = clonedChild.nodeName;

      result[result.length] = clonedChildName;

	}
   ASSERT(DOM_LIST_EQ(expected,result),"clone");

});



/**
*
    The "cloneNode(deep)" method does not copy text unless it
    is deep cloned.(Test for deep=true)

    Retrieve the eighth child of the second employee and
    the "cloneNode(deep)" method with deep=true.   The
    duplicate node returned by the method should copy
    any text data contained in this node.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodeclonetruecopytext", function() {
   var success;
    var doc;
      var elementList;
      var childNode;
      var clonedNode;
      var lastChildNode;
      var childValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("sup");
      childNode = elementList.item(1);
      clonedNode = childNode.cloneNode(true);
      lastChildNode = clonedNode.lastChild;

      childValue = lastChildNode.nodeValue;

      ASSERT(STRICT_EQ("35,000",childValue),"cloneContainsText");

});



/**
*
    The "getAttributes()" method invoked on a Comment
    Node returns null.

    Find any comment that is an immediate child of the root
    and assert that Node.attributes is null.  Then create
    a new comment node (in case they had been omitted) and
    make the assertion.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1728279322
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=248
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=263
*/
TEST("hc_nodecommentnodeattributes", function() {
   var success;
    var doc;
      var commentNode;
      var nodeList;
      var attrList;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      nodeList = doc.childNodes;

      for(var indexid2258625 = 0;indexid2258625 < nodeList.length; indexid2258625++) {
      commentNode = nodeList.item(indexid2258625);
      nodeType = commentNode.nodeType;


	if(
	(8 == nodeType)
	) {
	attrList = commentNode.attributes;

      ASSERT(NULL(attrList),"existingCommentAttributesNull");

	}
	
	}
   commentNode = doc.createComment("This is a comment");
      attrList = commentNode.attributes;

      ASSERT(NULL(attrList),"createdCommentAttributesNull");

});



/**
*
    The string returned by the "getNodeName()" method for a
    Comment Node is "#comment".

    Retrieve the Comment node in the XML file
    and check the string returned by the "getNodeName()"
    method.   It should be equal to "#comment".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1728279322
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=248
*/
TEST("hc_nodecommentnodename", function() {
   var success;
    var doc;
      var elementList;
      var commentNode;
      var nodeType;
      var commentName;
      var commentNodeName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.childNodes;

      for(var indexid2258626 = 0;indexid2258626 < elementList.length; indexid2258626++) {
      commentNode = elementList.item(indexid2258626);
      nodeType = commentNode.nodeType;


	if(
	(8 == nodeType)
	) {
	commentNodeName = commentNode.nodeName;

      ASSERT(STRICT_EQ("#comment",commentNodeName),"existingNodeName");

	}
	
	}
   commentNode = doc.createComment("This is a comment");
      commentNodeName = commentNode.nodeName;

      ASSERT(STRICT_EQ("#comment",commentNodeName),"createdNodeName");

});



/**
*
    The "getNodeType()" method for a Comment Node
    returns the constant value 8.

    Retrieve the nodes from the document and check for
    a comment node and invoke the "getNodeType()" method.   This should
    return 8.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1728279322
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=248
*/
TEST("hc_nodecommentnodetype", function() {
   var success;
    var doc;
      var testList;
      var commentNode;
      var commentNodeName;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      testList = doc.childNodes;

      for(var indexid2258619 = 0;indexid2258619 < testList.length; indexid2258619++) {
      commentNode = testList.item(indexid2258619);
      commentNodeName = commentNode.nodeName;


	if(
	("#comment" == commentNodeName)
	) {
	nodeType = commentNode.nodeType;

      ASSERT(STRICT_EQ(8,nodeType),"existingCommentNodeType");

	}
	
	}
   commentNode = doc.createComment("This is a comment");
      nodeType = commentNode.nodeType;

      ASSERT(STRICT_EQ(8,nodeType),"createdCommentNodeType");

});



/**
*
    The string returned by the "getNodeValue()" method for a
    Comment Node is the content of the comment.

    Retrieve the comment in the XML file and
    check the string returned by the "getNodeValue()" method.
    It should be equal to "This is comment number 1".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1728279322
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=248
*/
TEST("hc_nodecommentnodevalue", function() {
   var success;
    var doc;
      var elementList;
      var commentNode;
      var commentName;
      var commentValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.childNodes;

      for(var indexid2258620 = 0;indexid2258620 < elementList.length; indexid2258620++) {
      commentNode = elementList.item(indexid2258620);
      commentName = commentNode.nodeName;


	if(
	("#comment" == commentName)
	) {
	commentValue = commentNode.nodeValue;

      ASSERT(STRICT_EQ(" This is comment number 1.",commentValue),"value");

	}
	
	}
   commentNode = doc.createComment(" This is a comment");
      commentValue = commentNode.nodeValue;

      ASSERT(STRICT_EQ(" This is a comment",commentValue),"createdCommentNodeValue");

});



/**
*
    The string returned by the "getNodeName()" method for a
    DocumentFragment Node is "#document-frament".

    Retrieve the DOM document and invoke the
    "createDocumentFragment()" method and check the string
    returned by the "getNodeName()" method.   It should be
    equal to "#document-fragment".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-B63ED1A3
*/
TEST("hc_nodedocumentfragmentnodename", function() {
   var success;
    var doc;
      var docFragment;
      var documentFragmentName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      docFragment = doc.createDocumentFragment();
      documentFragmentName = docFragment.nodeName;

      ASSERT(STRICT_EQ("#document-fragment",documentFragmentName),"nodeDocumentFragmentNodeNameAssert1");

});



/**
*
    The "getNodeType()" method for a DocumentFragment Node
    returns the constant value 11.

    Invoke the "createDocumentFragment()" method and
    examine the NodeType of the document fragment
    returned by the "getNodeType()" method.   The method
    should return 11.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-B63ED1A3
*/
TEST("hc_nodedocumentfragmentnodetype", function() {
   var success;
    var doc;
      var documentFragmentNode;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      documentFragmentNode = doc.createDocumentFragment();
      nodeType = documentFragmentNode.nodeType;

      ASSERT(STRICT_EQ(11,nodeType),"nodeDocumentFragmentNodeTypeAssert1");

});



/**
*
    The string returned by the "getNodeValue()" method for a
    DocumentFragment Node is null.

    Retrieve the DOM document and invoke the
    "createDocumentFragment()" method and check the string
    returned by the "getNodeValue()" method.   It should be
    equal to null.

* @author Curt Arnold
* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-B63ED1A3
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
*/
TEST("hc_nodedocumentfragmentnodevalue", function() {
   var success;
    var doc;
      var docFragment;
      var attrList;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      docFragment = doc.createDocumentFragment();
      attrList = docFragment.attributes;

      ASSERT(NULL(attrList),"attributesNull");
    value = docFragment.nodeValue;

      ASSERT(NULL(value),"initiallyNull");

});



/**
*
The "getAttributes()" method invoked on a Document
Node returns null.

Retrieve the DOM Document and invoke the
"getAttributes()" method on the Document Node.
It should return null.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#i-Document
*/
TEST("hc_nodedocumentnodeattribute", function() {
   var success;
    var doc;
      var attrList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      attrList = doc.attributes;

      ASSERT(NULL(attrList),"doc_attributes_is_null");

});



/**
*
    The string returned by the "getNodeName()" method for a
    Document Node is "#document".

    Retrieve the DOM document and check the string returned
    by the "getNodeName()" method.   It should be equal to
    "#document".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#i-Document
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
*/
TEST("hc_nodedocumentnodename", function() {
   var success;
    var doc;
      var documentName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      documentName = doc.nodeName;

      ASSERT(STRICT_EQ("#document",documentName),"documentNodeName");

});



/**
*
The "getNodeType()" method for a Document Node
returns the constant value 9.

Retrieve the document and invoke the "getNodeType()"
method.   The method should return 9.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#i-Document
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
*/
TEST("hc_nodedocumentnodetype", function() {
   var success;
    var doc;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      nodeType = doc.nodeType;

      ASSERT(STRICT_EQ(9,nodeType),"nodeDocumentNodeTypeAssert1");

});



/**
*
    The string returned by the "getNodeValue()" method for a
    Document Node is null.

    Retrieve the DOM Document and check the string returned
    by the "getNodeValue()" method.   It should be equal to
    null.


* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#i-Document
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
*/
TEST("hc_nodedocumentnodevalue", function() {
   var success;
    var doc;
      var documentValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      documentValue = doc.nodeValue;

      ASSERT(NULL(documentValue),"documentNodeValue");

});



/**
*
    Retrieve the first Element Node(Root Node) of the
    DOM object and check the string returned by the
    "getNodeName()" method.   It should be equal to its
    tagName.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=251
*/
TEST("hc_nodeelementnodename", function() {
   var success;
    var doc;
      var elementNode;
      var elementName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementNode = doc.documentElement;

      elementName = elementNode.nodeName;


	if(
	
	(builder.contentType == "image/svg+xml")

	) {
	ASSERT(STRICT_EQ("svg",elementName),"svgNodeName");

	}
	
		else {
			ASSERT(STRICT_EQ("html",elementName), "nodeName");

		}
	
});



/**
*
    The "getNodeType()" method for an Element Node
    returns the constant value 1.

    Retrieve the root node and invoke the "getNodeType()"
    method.   The method should return 1.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
*/
TEST("hc_nodeelementnodetype", function() {
   var success;
    var doc;
      var rootNode;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      rootNode = doc.documentElement;

      nodeType = rootNode.nodeType;

      ASSERT(STRICT_EQ(1,nodeType),"nodeElementNodeTypeAssert1");

});



/**
*
    The string returned by the "getNodeValue()" method for an
    Element Node is null.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
*/
TEST("hc_nodeelementnodevalue", function() {
   var success;
    var doc;
      var elementNode;
      var elementValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementNode = doc.documentElement;

      elementValue = elementNode.nodeValue;

      ASSERT(NULL(elementValue),"elementNodeValue");

});



/**
*
    The "getFirstChild()" method returns the first child
    of this node.

    Retrieve the second employee and invoke the
    "getFirstChild()" method.   The NodeName returned
    should be "#text" or "EM".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-169727388
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodegetfirstchild", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var fchildNode;
      var childName;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      fchildNode = employeeNode.firstChild;

      childName = fchildNode.nodeName;


	if(
	("#text" == childName)
	) {
	ASSERT(STRICT_EQ("#text",childName),"firstChild_w_whitespace");

	}
	
		else {
			ASSERT(STRICT_EQ("em",childName), "firstChild_wo_whitespace");

		}
	
});



/**
*
    If there is not a first child then the "getFirstChild()"
    method returns null.

    Retrieve the text of the first "em" element and invoke the "getFirstChild()" method.   It
    should return null.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-169727388
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodegetfirstchildnull", function() {
   var success;
    var doc;
      var emList;
      var emNode;
      var emText;
      var nullChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      emList = doc.getElementsByTagName("em");
      emNode = emList.item(0);
      emText = emNode.firstChild;

      nullChild = emText.firstChild;

      ASSERT(NULL(nullChild),"nullChild");

});



/**
*
    The "getLastChild()" method returns the last child
    of this node.

    Retrieve the second employee and invoke the
    "getLastChild()" method.   The NodeName returned
    should be "#text".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-61AD09FB
*/
TEST("hc_nodegetlastchild", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var lchildNode;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      lchildNode = employeeNode.lastChild;

      childName = lchildNode.nodeName;

      // ASSERT(STRICT_EQ("#text",childName),"whitespace");
      ASSERT(STRICT_EQ("acronym",childName),"whitespace removed");

});



/**
*

    If there is not a last child then the "getLastChild()"
    method returns null.

  Retrieve the text of the first "em" element and invoke the "getFirstChild()" method.   It
    should return null.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-61AD09FB
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodegetlastchildnull", function() {
   var success;
    var doc;
      var emList;
      var emNode;
      var emText;
      var nullChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      emList = doc.getElementsByTagName("em");
      emNode = emList.item(0);
      emText = emNode.firstChild;

      nullChild = emText.lastChild;

      ASSERT(NULL(nullChild),"nullChild");

});



/**
*
    The "getNextSibling()" method returns the node immediately
    following this node.

    Retrieve the first child of the second employee and
    invoke the "getNextSibling()" method.   It should return
    a node with the NodeName of "#text".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6AC54C2F
*/
TEST("hc_nodegetnextsibling", function() {
   var success;
    var doc;
      var elementList;
      var emNode;
      var nsNode;
      var nsName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("em");
      emNode = elementList.item(1);
      nsNode = emNode.nextSibling;

      nsName = nsNode.nodeName;

      // ASSERT(STRICT_EQ("#text",nsName),"whitespace");
      ASSERT(STRICT_EQ("strong",nsName),"whitespace removed");

});



/**
*

    If there is not a node immediately following this node the

    "getNextSibling()" method returns null.



    Retrieve the first child of the second employee and

    invoke the "getNextSibling()" method.   It should

    be set to null.


* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6AC54C2F
*/
TEST("hc_nodegetnextsiblingnull", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var lcNode;
      var nsNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      lcNode = employeeNode.lastChild;

      nsNode = lcNode.nextSibling;

      ASSERT(NULL(nsNode),"nodeGetNextSiblingNullAssert1");

});



/**
*
Evaluate Node.ownerDocument on the second "p" element.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#node-ownerDoc
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=251
*/
TEST("hc_nodegetownerdocument", function() {
   var success;
    var doc;
      var elementList;
      var docNode;
      var ownerDocument;
      var docElement;
      var elementName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      docNode = elementList.item(1);
      ownerDocument = docNode.ownerDocument;

      docElement = ownerDocument.documentElement;

      elementName = docElement.nodeName;


	if(
	
	(builder.contentType == "image/svg+xml")

	) {
	ASSERT(STRICT_EQ("svg",elementName),"svgNodeName");

	}
	
		else {
			ASSERT(STRICT_EQ("html",elementName), "ownerDocElemTagName");

		}
	
});



/**
*

    The "getOwnerDocument()" method returns null if the target

    node itself is a document.



    Invoke the "getOwnerDocument()" method on the master

    document.   The Document returned should be null.


* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#node-ownerDoc
*/
TEST("hc_nodegetownerdocumentnull", function() {
   var success;
    var doc;
      var ownerDocument;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      ownerDocument = doc.ownerDocument;

      ASSERT(NULL(ownerDocument),"nodeGetOwnerDocumentNullAssert1");

});



/**
*
    The "getPreviousSibling()" method returns the node
    immediately preceding this node.

    Retrieve the second child of the second employee and
    invoke the "getPreviousSibling()" method.   It should
    return a node with a NodeName of "#text".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-640FB3C8
*/
TEST("hc_nodegetprevioussibling", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var psNode;
      var psName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(1);
      psNode = nameNode.previousSibling;

      psName = psNode.nodeName;

      // ASSERT(STRICT_EQ("#text",psName),"whitespace");
      ASSERT(STRICT_EQ("em",psName),"whitespace removed");

});



/**
*

    If there is not a node immediately preceding this node the

    "getPreviousSibling()" method returns null.



    Retrieve the first child of the second employee and

    invoke the "getPreviousSibling()" method.   It should

    be set to null.


* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-640FB3C8
*/
TEST("hc_nodegetprevioussiblingnull", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var fcNode;
      var psNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(2);
      fcNode = employeeNode.firstChild;

      psNode = fcNode.previousSibling;

      ASSERT(NULL(psNode),"nodeGetPreviousSiblingNullAssert1");

});



/**
*
    The "hasChildNodes()" method returns true if the node
    has children.

    Retrieve the root node("staff") and invoke the
    "hasChildNodes()" method.   It should return the boolean
    value "true".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-810594187
*/
TEST("hc_nodehaschildnodes", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      state = employeeNode.hasChildNodes();
      ASSERT(STRICT_EQ(true,state),"nodeHasChildAssert1");

});



/**
*
    The "hasChildNodes()" method returns false if the node
    does not have any children.

    Retrieve the text of the first "em" element and invoke the "hasChildNodes()" method.   It
    should return false.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1451460987
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-810594187
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodehaschildnodesfalse", function() {
   var success;
    var doc;
      var emList;
      var emNode;
      var emText;
      var hasChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      emList = doc.getElementsByTagName("em");
      emNode = emList.item(0);
      emText = emNode.firstChild;

      hasChild = emText.hasChildNodes();
      ASSERT(STRICT_EQ(false,hasChild),"hasChild");

});



/**
*
    The "insertBefore(newChild,refChild)" method inserts the
    node "newChild" before the node "refChild".

    Insert a newly created Element node before the second
    sup element in the document and check the "newChild"
    and "refChild" after insertion for correct placement.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=261
*/
TEST("hc_nodeinsertbefore", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var refChild;
      var newChild;
      var child;
      var childName;
      var insertedNode;
      var actual = new Array();

      expected = new Array();
      expected[0] = "em";
      expected[1] = "strong";
      expected[2] = "code";
      expected[3] = "br";
      expected[4] = "sup";
      expected[5] = "var";
      expected[6] = "acronym";

      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("sup");
      refChild = elementList.item(2);
      employeeNode = refChild.parentNode;

      childList = employeeNode.childNodes;

      newChild = doc.createElement("br");
      insertedNode = employeeNode.insertBefore(newChild,refChild);
      for(var indexid2258748 = 0;indexid2258748 < childList.length; indexid2258748++) {
      child = childList.item(indexid2258748);
      nodeType = child.nodeType;


	if(
	(1 == nodeType)
	) {
	childName = child.nodeName;

      actual[actual.length] = childName;

	}
	
	}
   ASSERT(DOM_LIST_EQ(expected,actual), "nodeNames");

});



/**
*
    If the "newChild" is a DocumentFragment object then all
    its children are inserted in the same order before the
    the "refChild".

    Create a DocumentFragment object and populate it with
    two Element nodes.   Retrieve the second employee and
    insert the newly created DocumentFragment before its
    fourth child.   The second employee should now have two
    extra children("newChild1" and "newChild2") at
    positions fourth and fifth respectively.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodeinsertbeforedocfragment", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var refChild;
      var newdocFragment;
      var newChild1;
      var newChild2;
      var child;
      var childName;
      var appendedChild;
      var insertedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      refChild = childList.item(3);
      newdocFragment = doc.createDocumentFragment();
      newChild1 = doc.createElement("br");
      newChild2 = doc.createElement("b");
      appendedChild = newdocFragment.appendChild(newChild1);
      appendedChild = newdocFragment.appendChild(newChild2);
      insertedNode = employeeNode.insertBefore(newdocFragment,refChild);
      child = childList.item(3);
      childName = child.nodeName;

      ASSERT(STRICT_EQ("br",childName), "childName3");
       child = childList.item(4);
      childName = child.nodeName;

      ASSERT(STRICT_EQ("b",childName), "childName4");

});



/**
*
    The "insertBefore(newChild,refChild)" method raises a
    HIERARCHY_REQUEST_ERR DOMException if this node is of
    a type that does not allow children of the type "newChild"
    to be inserted.

    Retrieve the root node and attempt to insert a newly
    created Attr node.   An Element node cannot have children
    of the "Attr" type, therefore the desired exception
    should be raised.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-952280727')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=406
*/
TEST("hc_nodeinsertbeforeinvalidnodetype", function() {
   var success;
    var doc;
      var rootNode;
      var newChild;
      var elementList;
      var refChild;
      var insertedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newChild = doc.createAttribute("title");
      elementList = doc.getElementsByTagName("p");
      refChild = elementList.item(1);
      rootNode = refChild.parentNode;


	{
		success = false;
		try {
            insertedNode = rootNode.insertBefore(newChild,refChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
    The "insertBefore(newChild,refChild)" method raises a
    WRONG_DOCUMENT_ERR DOMException if the "newChild" was
    created from a different document than the one that
    created this node.

    Retrieve the second employee and attempt to insert a new
    child that was created from a different document than the
    one that created the second employee.   An attempt to
    insert such a child should raise the desired exception.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='WRONG_DOCUMENT_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-952280727')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='WRONG_DOCUMENT_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodeinsertbeforenewchilddiffdocument", function() {
   var success;
    var doc1;
      var doc2;
      var refChild;
      var newChild;
      var elementList;
      var elementNode;
      var insertedNode;

      var doc1Ref = null;
      if (typeof(this.doc1) != 'undefined') {
        doc1Ref = this.doc1;
      }
      doc1 = load(doc1Ref, "doc1", "hc_staff");

      var doc2Ref = null;
      if (typeof(this.doc2) != 'undefined') {
        doc2Ref = this.doc2;
      }
      doc2 = load(doc2Ref, "doc2", "hc_staff");
      newChild = doc1.createElement("br");
      elementList = doc2.getElementsByTagName("p");
      elementNode = elementList.item(1);
      refChild = elementNode.firstChild;


	{
		success = false;
		try {
            insertedNode = elementNode.insertBefore(newChild,refChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 4);
		}
		ASSERT(STRICT_EQ(true,success),"throw_WRONG_DOCUMENT_ERR");
	}

});



/**
*
    If the "newChild" is already in the tree, the
    "insertBefore(newChild,refChild)" method must first
    remove it before the insertion takes place.

    Insert a node Element ("em") that is already
    present in the tree.   The existing node should be
    removed first and the new one inserted.   The node is
    inserted at a different position in the tree to assure
    that it was indeed inserted.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodeinsertbeforenewchildexists", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var refChild;
      var newChild;
      var child;
      var childName;
      var insertedNode;
      expected = new Array();
      expected[0] = "strong";
      expected[1] = "code";
      expected[2] = "sup";
      expected[3] = "var";
      expected[4] = "em";
      expected[5] = "acronym";

      var result = new Array();

      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.getElementsByTagName("*");
      refChild = childList.item(5);
      newChild = childList.item(0);
      insertedNode = employeeNode.insertBefore(newChild,refChild);
      for(var indexid2258746 = 0;indexid2258746 < childList.length; indexid2258746++) {
      child = childList.item(indexid2258746);
      nodeType = child.nodeType;


	if(
	(1 == nodeType)
	) {
	childName = child.nodeName;

      result[result.length] = childName;

	}
	
	}
   ASSERT(DOM_LIST_EQ(expected,result), "childNames");

});



/**
*
    The "insertBefore(newChild,refChild)" method raises a
    HIERARCHY_REQUEST_ERR DOMException if the node to be
    inserted is one of this nodes ancestors.

    Retrieve the second employee and attempt to insert a
    node that is one of its ancestors(root node).   An
    attempt to insert such a node should raise the
    desired exception.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-952280727')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("hc_nodeinsertbeforenodeancestor", function() {
   var success;
    var doc;
      var newChild;
      var elementList;
      var employeeNode;
      var childList;
      var refChild;
      var insertedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newChild = doc.documentElement;

      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      refChild = childList.item(0);

	{
		success = false;
		try {
            insertedNode = employeeNode.insertBefore(newChild,refChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
    The "insertBefore(newChild,refchild)" method returns
    the node being inserted.

    Insert an Element node before the fourth
    child of the second employee and check the node
    returned from the "insertBefore(newChild,refChild)"
    method.   The node returned should be "newChild".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodeinsertbeforenodename", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var refChild;
      var newChild;
      var insertedNode;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      refChild = childList.item(3);
      newChild = doc.createElement("br");
      insertedNode = employeeNode.insertBefore(newChild,refChild);
      childName = insertedNode.nodeName;

      ASSERT(STRICT_EQ("br",childName), "nodeName");

});



/**
*
    The "insertBefore(newChild,refChild)" method raises a
    NOT_FOUND_ERR DOMException if the reference child is
    not a child of this node.

    Retrieve the second employee and attempt to insert a
    new node before a reference node that is not a child
    of this node.   An attempt to insert before a non child
    node should raise the desired exception.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-952280727')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_nodeinsertbeforerefchildnonexistent", function() {
   var success;
    var doc;
      var refChild;
      var newChild;
      var elementList;
      var elementNode;
      var insertedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newChild = doc.createElement("br");
      refChild = doc.createElement("b");
      elementList = doc.getElementsByTagName("p");
      elementNode = elementList.item(1);

	{
		success = false;
		try {
            insertedNode = elementNode.insertBefore(newChild,refChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 8);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_FOUND_ERR");
	}

});



/**
*
    If the "refChild" is null then the
    "insertBefore(newChild,refChild)" method inserts the
    node "newChild" at the end of the list of children.

    Retrieve the second employee and invoke the
    "insertBefore(newChild,refChild)" method with
    refChild=null.   Since "refChild" is null the "newChild"
    should be added to the end of the list.   The last item
    in the list is checked after insertion.   The last Element
    node of the list should be "newChild".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodeinsertbeforerefchildnull", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var refChild = null;

      var newChild;
      var child;
      var childName;
      var insertedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      newChild = doc.createElement("br");
      insertedNode = employeeNode.insertBefore(newChild,refChild);
      child = employeeNode.lastChild;

      childName = child.nodeName;

      ASSERT(STRICT_EQ("br",childName), "nodeName");

});



/**
*
   Create a list of all the children elements of the third
   employee and access its first child by using an index
   of 0.  This should result in the whitspace before "em" being
   selected (em when ignoring whitespace).
   Further we evaluate its content(by using
   the "getNodeName()" method) to ensure the proper
   element was accessed.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-844377136
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodelistindexequalzero", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var child;
      var childName;
      var length;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      length = employeeList.length;

      child = employeeList.item(0);
      childName = child.nodeName;


	if(
	(13 == length)
	) {
	ASSERT(STRICT_EQ("#text",childName),"childName_w_whitespace");

	}
	
		else {
			ASSERT(STRICT_EQ("em",childName), "childName_wo_whitespace");

		}
	
});



/**
*
    The "getLength()" method returns the number of nodes
   in the list.

   Create a list of all the children elements of the third
   employee and invoke the "getLength()" method.
   It should contain the value 13.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-203510337
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodelistindexgetlength", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var length;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      length = employeeList.length;


	if(
	(6 == length)
	) {
	ASSERT(STRICT_EQ(6,length),"length_wo_space");

	}
	
		else {
			ASSERT(STRICT_EQ(13,length),"length_w_space");

		}
	
});



/**
*
    The "getLength()" method returns the number of nodes
   in the list.(Test for EMPTY list)

   Create a list of all the children of the Text node
   inside the first child of the third employee and
   invoke the "getLength()" method.   It should contain
   the value 0.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-203510337
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodelistindexgetlengthofemptylist", function() {
   var success;
    var doc;
      var emList;
      var emNode;
      var textNode;
      var textList;
      var length;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      emList = doc.getElementsByTagName("em");
      emNode = emList.item(2);
      textNode = emNode.firstChild;

      textList = textNode.childNodes;

      length = textList.length;

      ASSERT(STRICT_EQ(0,length),"length");

});



/**
*
    The items in the list are accessible via an integral
   index starting from zero.
   (Index not equal 0)

   Create a list of all the children elements of the third
   employee and access its fourth child by using an index
   of 3 and calling getNodeName() which should return
   "strong" (no whitespace)  or "#text" (with whitespace).

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-844377136
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodelistindexnotzero", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var child;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      child = employeeList.item(3);
      childName = child.nodeName;


	if(
	("#text" == childName)
	) {
	ASSERT(STRICT_EQ("#text",childName),"childName_space");

	}
	
		else {
			ASSERT(STRICT_EQ("sup",childName), "childName_strong");

		}
	
});



/**
*
   Create a list of all the children elements of the third
   employee and access its first child by invoking the
   "item(index)" method with an index=0.  This should
   result in node with a nodeName of "#text" or "em".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-844377136
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodelistreturnfirstitem", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var child;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      child = employeeList.item(0);
      childName = child.nodeName;


	if(
	("#text" == childName)
	) {
	ASSERT(STRICT_EQ("#text",childName),"nodeName_w_space");

	}
	
		else {
			ASSERT(STRICT_EQ("em",childName), "nodeName_wo_space");

		}
	
});



/**
*
   Create a list of all the children elements of the third
   employee and access its last child by invoking the
   "item(index)" method with an index=length-1.  This should
   result in node with nodeName="#text" or acronym.
* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-844377136
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodelistreturnlastitem", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var child;
      var childName;
      var index;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      index = employeeList.length;

      index -= 1;
child = employeeList.item(index);
      childName = child.nodeName;


	if(
	(12 == index)
	) {
	ASSERT(STRICT_EQ("#text",childName),"lastNodeName_w_whitespace");

	}
	
		else {
			ASSERT(STRICT_EQ("acronym",childName), "lastNodeName");
       ASSERT(STRICT_EQ(5,index),"index");

		}
	
});



/**
*
    The range of valid child node indices is 0 thru length -1

   Create a list of all the children elements of the third
   employee and traverse the list from index=0 thru
   length -1.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-203510337
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-844377136
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodelisttraverselist", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var child;
      var childName;
      var nodeType;
      var result = new Array();

      expected = new Array();
      expected[0] = "em";
      expected[1] = "strong";
      expected[2] = "code";
      expected[3] = "sup";
      expected[4] = "var";
      expected[5] = "acronym";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      for(var indexid2258695 = 0;indexid2258695 < employeeList.length; indexid2258695++) {
      child = employeeList.item(indexid2258695);
      nodeType = child.nodeType;

      childName = child.nodeName;


	if(
	(1 == nodeType)
	) {
	result[result.length] = childName;

	}
	
		else {
			ASSERT(STRICT_EQ(3,nodeType),"textNodeType");
       ASSERT(STRICT_EQ("#text",childName),"textNodeName");

		}
	
	}
   ASSERT(DOM_LIST_EQ(expected,result), "nodeNames");

});



/**
*
    The "getParentNode()" method returns the parent
    of this node.

    Retrieve the second employee and invoke the
    "getParentNode()" method on this node.   It should
    be set to "body".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1060184317
*/
TEST("hc_nodeparentnode", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var parentNode;
      var parentName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      parentNode = employeeNode.parentNode;

      parentName = parentNode.nodeName;

      ASSERT(STRICT_EQ("body",parentName), "parentNodeName");

});



/**
*
    The "getParentNode()" method invoked on a node that has
    just been created and not yet added to the tree is null.

    Create a new "employee" Element node using the
    "createElement(name)" method from the Document interface.
    Since this new node has not yet been added to the tree,
    the "getParentNode()" method will return null.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1060184317
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodeparentnodenull", function() {
   var success;
    var doc;
      var createdNode;
      var parentNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      createdNode = doc.createElement("br");
      parentNode = createdNode.parentNode;

      ASSERT(NULL(parentNode),"parentNode");

});



/**
*
    The "removeChild(oldChild)" method removes the child node
    indicated by "oldChild" from the list of children and
    returns it.

    Remove the first employee by invoking the
    "removeChild(oldChild)" method an checking the
    node returned by the "getParentNode()" method.   It
    should be set to null.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_noderemovechild", function() {
   var success;
    var doc;
      var rootNode;
      var childList;
      var childToRemove;
      var removedChild;
      var parentNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      rootNode = doc.documentElement;

      childList = rootNode.childNodes;

      childToRemove = childList.item(1);
      removedChild = rootNode.removeChild(childToRemove);
      parentNode = removedChild.parentNode;

      ASSERT(NULL(parentNode),"parentNodeNull");

});



/**
*
    The "removeChild(oldChild)" method returns
    the node being removed.

    Remove the first child of the second employee
    and check the NodeName returned by the
    "removeChild(oldChild)" method.   The returned node
    should have a NodeName equal to "#text".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_noderemovechildgetnodename", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var oldChild;
      var removedChild;
      var childName;
      var oldName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      oldChild = childList.item(0);
      oldName = oldChild.nodeName;

      removedChild = employeeNode.removeChild(oldChild);
      ASSERT(NOT_NULL(removedChild),"notnull");
childName = removedChild.nodeName;

      ASSERT(STRICT_EQ(oldName,childName),"nodeName");

});



/**
*
    The "removeChild(oldChild)" method removes the node
    indicated by "oldChild".

    Retrieve the second p element and remove its first child.
    After the removal, the second p element should have 5 element
    children and the first child should now be the child
    that used to be at the second position in the list.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_noderemovechildnode", function() {
   var success;
    var doc;
      var elementList;
      var emList;
      var employeeNode;
      var childList;
      var oldChild;
      var child;
      var childName;
      var length;
      var removedChild;
      var removedName;
      var nodeType;
      expected = new Array();
      expected[0] = "strong";
      expected[1] = "code";
      expected[2] = "sup";
      expected[3] = "var";
      expected[4] = "acronym";

      var actual = new Array();


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      emList = employeeNode.getElementsByTagName("em");
      oldChild = emList.item(0);
      removedChild = employeeNode.removeChild(oldChild);
      removedName = removedChild.nodeName;

      ASSERT(STRICT_EQ("em",removedName), "removedName");
       for(var indexid2258869 = 0;indexid2258869 < childList.length; indexid2258869++) {
      child = childList.item(indexid2258869);
      nodeType = child.nodeType;

      childName = child.nodeName;


	if(
	(1 == nodeType)
	) {
	actual[actual.length] = childName;

	}
	
		else {
			ASSERT(STRICT_EQ(3,nodeType),"textNodeType");
       ASSERT(STRICT_EQ("#text",childName),"textNodeName");

		}
	
	}
   ASSERT(DOM_LIST_EQ(expected,actual), "childNames");

});



/**
*
    The "removeChild(oldChild)" method raises a
    NOT_FOUND_ERR DOMException if the old child is
    not a child of this node.

    Retrieve the second employee and attempt to remove a
    node that is not one of its children.   An attempt to
    remove such a node should raise the desired exception.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-1734834066')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_noderemovechildoldchildnonexistent", function() {
   var success;
    var doc;
      var oldChild;
      var elementList;
      var elementNode;
      var removedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      oldChild = doc.createElement("br");
      elementList = doc.getElementsByTagName("p");
      elementNode = elementList.item(1);

	{
		success = false;
		try {
            removedChild = elementNode.removeChild(oldChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 8);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_FOUND_ERR");
	}

});



/**
*
    The "replaceChild(newChild,oldChild)" method replaces
    the node "oldChild" with the node "newChild".

    Replace the first element of the second employee with
    a newly created Element node.   Check the first position
    after the replacement operation is completed.   The new
    Element should be "newChild".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodereplacechild", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var oldChild;
      var newChild;
      var child;
      var childName;
      var replacedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      oldChild = childList.item(0);
      newChild = doc.createElement("br");
      replacedNode = employeeNode.replaceChild(newChild,oldChild);
      child = childList.item(0);
      childName = child.nodeName;

      ASSERT(STRICT_EQ("br",childName), "nodeName");

});



/**
*
    The "replaceChild(newChild,oldChild)" method raises a
    HIERARCHY_REQUEST_ERR DOMException if this node is of
    a type that does not allow children of the type "newChild"
    to be inserted.

    Retrieve the root node and attempt to replace
    one of its children with a newly created Attr node.
    An Element node cannot have children of the "Attr"
    type, therefore the desired exception should be raised.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-785887307')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=406
*/
TEST("hc_nodereplacechildinvalidnodetype", function() {
   var success;
    var doc;
      var rootNode;
      var newChild;
      var elementList;
      var oldChild;
      var replacedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newChild = doc.createAttribute("lang");
      elementList = doc.getElementsByTagName("p");
      oldChild = elementList.item(1);
      rootNode = oldChild.parentNode;


	{
		success = false;
		try {
            replacedChild = rootNode.replaceChild(newChild,oldChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
    The "replaceChild(newChild,oldChild)" method raises a
    WRONG_DOCUMENT_ERR DOMException if the "newChild" was
    created from a different document than the one that
    created this node.

    Retrieve the second employee and attempt to replace one
    of its children with a node created from a different
    document.   An attempt to make such a replacement
    should raise the desired exception.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-785887307')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodereplacechildnewchilddiffdocument", function() {
   var success;
    var doc1;
      var doc2;
      var oldChild;
      var newChild;
      var elementList;
      var elementNode;
      var replacedChild;

      var doc1Ref = null;
      if (typeof(this.doc1) != 'undefined') {
        doc1Ref = this.doc1;
      }
      doc1 = load(doc1Ref, "doc1", "hc_staff");

      var doc2Ref = null;
      if (typeof(this.doc2) != 'undefined') {
        doc2Ref = this.doc2;
      }
      doc2 = load(doc2Ref, "doc2", "hc_staff");
      newChild = doc1.createElement("br");
      elementList = doc2.getElementsByTagName("p");
      elementNode = elementList.item(1);
      oldChild = elementNode.firstChild;


	{
		success = false;
		try {
            replacedChild = elementNode.replaceChild(newChild,oldChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 4);
		}
		ASSERT(STRICT_EQ(true,success),"throw_WRONG_DOCUMENT_ERR");
	}

});



/**
*
    If the "newChild" is already in the tree, it is first
    removed before the new one is added.

    Retrieve the second "p" and replace "acronym" with its "em".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=246
*/
TEST("hc_nodereplacechildnewchildexists", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var oldChild = null;

      var newChild = null;

      var child;
      var childName;
      var childNode;
      var actual = new Array();

      expected = new Array();
      expected[0] = "strong";
      expected[1] = "code";
      expected[2] = "sup";
      expected[3] = "var";
      expected[4] = "em";

      var replacedChild;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.getElementsByTagName("*");
      newChild = childList.item(0);
      oldChild = childList.item(5);
      replacedChild = employeeNode.replaceChild(newChild,oldChild);
      ASSERT(DOM_SAME(oldChild,replacedChild),"return_value_same");
for(var indexid2258862 = 0;indexid2258862 < childList.length; indexid2258862++) {
      childNode = childList.item(indexid2258862);
      childName = childNode.nodeName;

      nodeType = childNode.nodeType;


	if(
	(1 == nodeType)
	) {
	actual[actual.length] = childName;

	}
	
		else {
			ASSERT(STRICT_EQ(3,nodeType),"textNodeType");
       ASSERT(STRICT_EQ("#text",childName),"textNodeName");

		}
	
	}
   ASSERT(DOM_LIST_EQ(expected,actual), "childNames");

});



/**
*
    The "replaceChild(newChild,oldChild)" method raises a
    HIERARCHY_REQUEST_ERR DOMException if the node to put
    in is one of this node's ancestors.

    Retrieve the second employee and attempt to replace
    one of its children with an ancestor node(root node).
    An attempt to make such a replacement should raise the
    desired exception.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-785887307')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
*/
TEST("hc_nodereplacechildnodeancestor", function() {
   var success;
    var doc;
      var newChild;
      var elementList;
      var employeeNode;
      var childList;
      var oldChild;
      var replacedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newChild = doc.documentElement;

      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      oldChild = childList.item(0);

	{
		success = false;
		try {
            replacedNode = employeeNode.replaceChild(newChild,oldChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
    The "replaceChild(newChild,oldChild)" method returns
    the node being replaced.

    Replace the second Element of the second employee with
    a newly created node Element and check the NodeName
    returned by the "replaceChild(newChild,oldChild)"
    method.   The returned node should have a NodeName equal
    to "em".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodereplacechildnodename", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var oldChild;
      var newChild;
      var replacedNode;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("p");
      employeeNode = elementList.item(1);
      childList = employeeNode.getElementsByTagName("em");
      oldChild = childList.item(0);
      newChild = doc.createElement("br");
      replacedNode = employeeNode.replaceChild(newChild,oldChild);
      childName = replacedNode.nodeName;

      ASSERT(STRICT_EQ("em",childName), "replacedNodeName");

});



/**
*
    The "replaceChild(newChild,oldChild)" method raises a
    NOT_FOUND_ERR DOMException if the old child is
    not a child of this node.

    Retrieve the second employee and attempt to replace a
    node that is not one of its children.   An attempt to
    replace such a node should raise the desired exception.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-785887307')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=247
*/
TEST("hc_nodereplacechildoldchildnonexistent", function() {
   var success;
    var doc;
      var oldChild;
      var newChild;
      var elementList;
      var elementNode;
      var replacedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newChild = doc.createElement("br");
      oldChild = doc.createElement("b");
      elementList = doc.getElementsByTagName("p");
      elementNode = elementList.item(1);

	{
		success = false;
		try {
            replacedNode = elementNode.replaceChild(newChild,oldChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 8);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_FOUND_ERR");
	}

});



/**
*
The "getAttributes()" method invoked on a Text
Node returns null.

Retrieve the Text node from the last child of the
first employee and invoke the "getAttributes()" method
on the Text Node.  It should return null.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1312295772
*/
TEST("hc_nodetextnodeattribute", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var textNode;
      var attrList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddr = elementList.item(0);
      textNode = testAddr.firstChild;

      attrList = textNode.attributes;

      ASSERT(NULL(attrList),"text_attributes_is_null");

});



/**
*
    The string returned by the "getNodeName()" method for a
    Text Node is "#text".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
*/
TEST("hc_nodetextnodename", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var textNode;
      var textName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddr = elementList.item(0);
      textNode = testAddr.firstChild;

      textName = textNode.nodeName;

      ASSERT(STRICT_EQ("#text",textName),"textNodeName");

});



/**
*

    The "getNodeType()" method for a Text Node

    returns the constant value 3.



    Retrieve the Text node from the last child of

    the first employee and invoke the "getNodeType()"

    method.   The method should return 3.


* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
*/
TEST("hc_nodetextnodetype", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var textNode;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddr = elementList.item(0);
      textNode = testAddr.firstChild;

      nodeType = textNode.nodeType;

      ASSERT(STRICT_EQ(3,nodeType),"nodeTextNodeTypeAssert1");

});



/**
*
    The string returned by the "getNodeValue()" method for a
    Text Node is the content of the Text node.

    Retrieve the Text node from the last child of the first
    employee and check the string returned by the
    "getNodeValue()" method.   It should be equal to
    "1230 North Ave. Dallas, Texas 98551".

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
*/
TEST("hc_nodetextnodevalue", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var textNode;
      var textValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      testAddr = elementList.item(0);
      textNode = testAddr.firstChild;

      textValue = textNode.nodeValue;

      ASSERT(STRICT_EQ("1230 North Ave. Dallas, Texas 98551",textValue),"textNodeValue");

});



/**
*
An comment is created, setNodeValue is called with a non-null argument, but getNodeValue
should still return null.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1728279322
*/
TEST("hc_nodevalue02", function() {
   var success;
    var doc;
      var newNode;
      var newValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      newNode = doc.createComment("This is a new Comment node");
      newValue = newNode.nodeValue;

      ASSERT(STRICT_EQ("This is a new Comment node",newValue),"initial");
       newNode.nodeValue = "This should have an effect";

      newValue = newNode.nodeValue;

      ASSERT(STRICT_EQ("This should have an effect",newValue),"afterChange");

});



/**
*
    The "splitText(offset)" method raises an
    INDEX_SIZE_ERR DOMException if the specified offset is
    negative.

    Retrieve the textual data from the second child of the
    third employee and invoke the "splitText(offset)" method.
    The desired exception should be raised since the offset
    is a negative number.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-38853C1D
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-38853C1D')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
*/
TEST("hc_textindexsizeerrnegativeoffset", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var textNode;
      var splitNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(2);
      textNode = nameNode.firstChild;


	{
		success = false;
		try {
            splitNode = textNode.splitText(-69);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throws_INDEX_SIZE_ERR");
	}

});



/**
*
    The "splitText(offset)" method raises an
    INDEX_SIZE_ERR DOMException if the specified offset is
    greater than the number of characters in the Text node.

    Retrieve the textual data from the second child of the
    third employee and invoke the "splitText(offset)" method.
    The desired exception should be raised since the offset
    is a greater than the number of characters in the Text
    node.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-38853C1D
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-38853C1D')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("hc_textindexsizeerroffsetoutofbounds", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var textNode;
      var splitNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(2);
      textNode = nameNode.firstChild;


	{
		success = false;
		try {
            splitNode = textNode.splitText(300);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INDEX_SIZE_ERR");
	}

});



/**
*
    Retrieve the textual data from the last child of the
    second employee.   That node is composed of two
    EntityReference nodes and two Text nodes.   After
    the content node is parsed, the "acronym" Element
    should contain four children with each one of the
    EntityReferences containing one child.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1451460987
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-11C98490
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-745549614
*/
TEST("hc_textparseintolistofelements", function() {
   var success;
    var doc;
      var elementList;
      var addressNode;
      var childList;
      var child;
      var value;
      var grandChild;
      var length;
      var result = new Array();

      expectedNormal = new Array();
      expectedNormal[0] = "β";
      expectedNormal[1] = " Dallas, ";
      expectedNormal[2] = "γ";
      expectedNormal[3] = "\n 98554";

      expectedExpanded = new Array();
      expectedExpanded[0] = "β Dallas, γ\n 98554";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      addressNode = elementList.item(1);
      childList = addressNode.childNodes;

      length = childList.length;

      for(var indexid2258715 = 0;indexid2258715 < childList.length; indexid2258715++) {
      child = childList.item(indexid2258715);
      value = child.nodeValue;


	if(
	
	(value == null)

	) {
	grandChild = child.firstChild;

      ASSERT(NOT_NULL(grandChild),"grandChildNotNull");
value = grandChild.nodeValue;

      result[result.length] = value;

	}
	
		else {
			result[result.length] = value;

		}
	
	}

	if(
	(1 == length)
	) {
	ASSERT(DOM_LIST_EQ(expectedExpanded,result),"assertEqCoalescing");

	}
	
		else {
			ASSERT(DOM_LIST_EQ(expectedNormal,result),"assertEqNormal");

		}
	
});



/**
*
    The "splitText(offset)" method returns the new Text node.

    Retrieve the textual data from the last child of the
    first employee and invoke the "splitText(offset)" method.
    The method should return the new Text node.   The offset
    value used for this test is 30.   The "getNodeValue()"
    method is called to check that the new node now contains
    the characters at and after position 30.
    (Starting count at 0)

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-38853C1D
*/
TEST("hc_textsplittextfour", function() {
   var success;
    var doc;
      var elementList;
      var addressNode;
      var textNode;
      var splitNode;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("acronym");
      addressNode = elementList.item(0);
      textNode = addressNode.firstChild;

      splitNode = textNode.splitText(30);
      value = splitNode.nodeValue;

      ASSERT(STRICT_EQ("98551",value),"textSplitTextFourAssert");

});



/**
*
    The "splitText(offset)" method breaks the Text node into
    two Text nodes at the specified offset keeping each node
    as siblings in the tree.

    Retrieve the textual data from the second child of the
    third employee and invoke the "splitText(offset)" method.
    The method splits the Text node into two new sibling
    Text nodes keeping both of them in the tree.   This test
    checks the "nextSibling()" method of the original node
    to ensure that the two nodes are indeed siblings.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-38853C1D
*/
TEST("hc_textsplittextone", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var textNode;
      var splitNode;
      var secondPart;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(2);
      textNode = nameNode.firstChild;

      splitNode = textNode.splitText(7);
      secondPart = textNode.nextSibling;

      value = secondPart.nodeValue;

      ASSERT(STRICT_EQ("Jones",value),"textSplitTextOneAssert");

});



/**
*
    After the "splitText(offset)" method breaks the Text node
    into two Text nodes, the new Text node contains all the
    content at and after the offset point.

    Retrieve the textual data from the second child of the
    third employee and invoke the "splitText(offset)" method.
    The new Text node should contain all the content
    at and after the offset point.   The "getNodeValue()"
    method is called to check that the new node now contains
    the characters at and after position seven.
    (Starting count at 0)

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-38853C1D
*/
TEST("hc_textsplittextthree", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var textNode;
      var splitNode;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(2);
      textNode = nameNode.firstChild;

      splitNode = textNode.splitText(6);
      value = splitNode.nodeValue;

      ASSERT(STRICT_EQ(" Jones",value),"textSplitTextThreeAssert");

});



/**
*
    After the "splitText(offset)" method breaks the Text node
    into two Text nodes, the original node contains all the
    content up to the offset point.

    Retrieve the textual data from the second child of the
    third employee and invoke the "splitText(offset)" method.
    The original Text node should contain all the content
    up to the offset point.   The "getNodeValue()" method
    is called to check that the original node now contains
    the first five characters.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-38853C1D
*/
TEST("hc_textsplittexttwo", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var textNode;
      var splitNode;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(2);
      textNode = nameNode.firstChild;

      splitNode = textNode.splitText(5);
      value = textNode.nodeValue;

      ASSERT(STRICT_EQ("Roger",value),"textSplitTextTwoAssert");

});



/**
*
    If there is not any markup inside an Element or Attr node
    content, then the text is contained in a single object
    implementing the Text interface that is the only child
    of the element.

    Retrieve the textual data from the second child of the
    third employee.   That Text node contains a block of
    multiple text lines without markup, so they should be
    treated as a single Text node.   The "getNodeValue()"
    method should contain the combination of the two lines.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1312295772
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
*/
TEST("hc_textwithnomarkup", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var nodeV;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      elementList = doc.getElementsByTagName("strong");
      nameNode = elementList.item(2);
      nodeV = nameNode.firstChild;

      value = nodeV.nodeValue;

      ASSERT(STRICT_EQ("Roger\n Jones",value),"textWithNoMarkupAssert");

});



/**
*
    The range of valid child node indices is 0 to Length -1.

   Create a NamedNodeMap object from the attributes of the
   last child of the third employee and traverse the
   list from index 0 thru length -1.  All indices should
   be valid.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6D0FB19E
*/
TEST("namednodemapchildnoderange", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var child;
      var length;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(2);
      attributes = testEmployee.attributes;

      length = attributes.length;

      ASSERT(STRICT_EQ(2,length),"length");
       child = attributes.item(0);
      child = attributes.item(1);

});



/**
*
    The "getNamedItem(name)" method retrieves a node
   specified by name.

   Retrieve the second employee and create a NamedNodeMap
   listing of the attributes of the last child.  Once the
   list is created an invocation of the "getNamedItem(name)"
   method is done with name="domestic".  This should result
   in the domestic Attr node being returned.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1074577549
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
*/
TEST("namednodemapgetnameditem", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var domesticAttr;
      var attrName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(1);
      attributes = testEmployee.attributes;

      domesticAttr = attributes.getNamedItem("domestic");
      attrName = domesticAttr.nodeName;

      ASSERT(STRICT_EQ("domestic",attrName),"namednodemapGetNamedItemAssert");

});



/**
*
The "setNamedItem(arg)" method raises a
INUSE_ATTRIBUTE_ERR DOMException if "arg" is an
Attr that is already in an attribute of another Element.

Create a NamedNodeMap object from the attributes of the
last child of the third employee and attempt to add
an attribute that is already being used by the first
employee.  This should raise the desired exception.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1025163788
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-1025163788')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("namednodemapinuseattributeerr", function() {
   var success;
    var doc;
      var elementList;
      var firstNode;
      var testNode;
      var attributes;
      var domesticAttr;
      var setAttr;
      var setNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      firstNode = elementList.item(0);
      domesticAttr = doc.createAttribute("domestic");
      domesticAttr.value = "Yes";

      setAttr = firstNode.setAttributeNode(domesticAttr);
      elementList = doc.getElementsByTagName("address");
      testNode = elementList.item(2);
      attributes = testNode.attributes;


	{
		success = false;
		try {
            setNode = attributes.setNamedItem(domesticAttr);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 10);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INUSE_ATTRIBUTE_ERR");
	}

});



/**
*
    The "removeNamedItem(name)" method raises a
   NOT_FOUND_ERR DOMException if there is not a node
   named "name" in the map.

   Create a NamedNodeMap object from the attributes of the
   last child of the third employee and attempt to remove
   the "district" attribute.  There is not a node named
   "district" in the list and therefore the desired
   exception should be raised.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INUSE_ATTRIBUTE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D58B193
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-D58B193')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INUSE_ATTRIBUTE_ERR'])
*/
TEST("namednodemapnotfounderr", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var removedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(2);
      attributes = testEmployee.attributes;


	{
		success = false;
		try {
            removedNode = attributes.removeNamedItem("district");
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 8);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_FOUND_ERR");
	}

});



/**
*
    The "getLength()" method returns the number of nodes
   in the map.

   Retrieve the second employee and create a NamedNodeMap
   listing of the attributes of the last child.  Once the
   list is created an invocation of the "getLength()"
   method is executed.  The number of nodes should be 2.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6D0FB19E
*/
TEST("namednodemapnumberofnodes", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var length;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(2);
      attributes = testEmployee.attributes;

      length = attributes.length;

      ASSERT(STRICT_EQ(2,length),"length");

});



/**
*
    The "removeNamedItem(name)" method returns the node
   removed from the map.

   Retrieve the third employee and create a NamedNodeMap
   object of the attributes of the last child.  Once the
   list is created invoke the "removeNamedItem(name)"
   method with name="street".  The "removeNamedItem(name)"
   method should remove the existing "street" attribute
   and return it.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D58B193
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
*/
TEST("namednodemapremovenameditemreturnnodevalue", function() {
   var success;
    var doc;
      var elementList;
      var testAddress;
      var attributes;
      var removedNode;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddress = elementList.item(2);
      attributes = testAddress.attributes;

      removedNode = attributes.removeNamedItem("street");
      value = removedNode.nodeValue;

      ASSERT(STRICT_EQ("No",value),"namednodemapRemoveNamedItemReturnNodeValueAssert");

});



/**
*
    The "getNamedItem(name)" method returns a node of any
   type specified by name.

   Retrieve the second employee and create a NamedNodeMap
   listing of the attributes of the last child.  Once the
   list is created an invocation of the "getNamedItem(name)"
   method is done with name="street".  This should result
   in the method returning an Attr node.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1074577549
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1112119403
*/
TEST("namednodemapreturnattrnode", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var streetAttr;
      var attrName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(1);
      attributes = testEmployee.attributes;

      streetAttr = attributes.getNamedItem("street");
      ASSERT(EQ(2,streetAttr.nodeType),"typeAssert");
attrName = streetAttr.nodeName;

      ASSERT(STRICT_EQ("street",attrName),"nodeName");
       attrName = streetAttr.name;

      ASSERT(STRICT_EQ("street",attrName),"attrName");

});



/**
*
    The "item(index)" method returns the indexth item in
   the map(test for first item).

   Retrieve the second employee and create a NamedNodeMap
   listing of the attributes of the last child. Since the
   DOM does not specify an order of these nodes the contents
   of the FIRST node can contain either "domestic" or "street".
   The test should return "true" if the FIRST node is either
   of these values.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
*/
TEST("namednodemapreturnfirstitem", function() {
   var success;
    var doc;
      var elementList;
      var testAddress;
      var attributes;
      var child;
      var name;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddress = elementList.item(1);
      attributes = testAddress.attributes;

      child = attributes.item(0);
      name = child.nodeName;

      	assertTrue("namednodemapReturnFirstItemAssert",

	(("domestic" == name) || ("street" == name))
);

});



/**
*
    The "item(index)" method returns the indexth item in
   the map(test for last item).

   Retrieve the second employee and create a NamedNodeMap
   listing of the attributes of the last child. Since the
   DOM does not specify an order of these nodes the contents
   of the LAST node can contain either "domestic" or "street".
   The test should return "true" if the LAST node is either
   of these values.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
*/
TEST("namednodemapreturnlastitem", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var child;
      var name;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(1);
      attributes = testEmployee.attributes;

      child = attributes.item(1);
      name = child.nodeName;

      	assertTrue("namednodemapReturnLastItemAssert",

	(("domestic" == name) || ("street" == name))
);

});



/**
*
    The "getNamedItem(name)" method returns null of the
   specified name did not identify any node in the map.

   Retrieve the second employee and create a NamedNodeMap
   listing of the attributes of the last child.  Once the
   list is created an invocation of the "getNamedItem(name)"
   method is done with name="district".  This name does not
   match any names in the list therefore the method should
   return null.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1074577549
*/
TEST("namednodemapreturnnull", function() {
   var success;
    var doc;
      var elementList;
      var testEmployee;
      var attributes;
      var districtNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testEmployee = elementList.item(1);
      attributes = testEmployee.attributes;

      districtNode = attributes.getNamedItem("district");
      ASSERT(NULL(districtNode),"namednodemapReturnNullAssert");

});



/**
*
    The "setNamedItem(arg)" method adds a node using its
   nodeName attribute.

   Retrieve the second employee and create a NamedNodeMap
   object from the attributes of the last child by
   invoking the "getAttributes()" method.  Once the
   list is created an invocation of the "setNamedItem(arg)"
   method is done with arg=newAttr, where newAttr is a
   new Attr Node previously created.  The "setNamedItem(arg)"
   method should add then new node to the NamedNodeItem
   object by using its "nodeName" attribute("district').
   This node is then retrieved using the "getNamedItem(name)"
   method.  This test uses the "createAttribute(name)"
   method from the document interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1025163788
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
*/
TEST("namednodemapsetnameditem", function() {
   var success;
    var doc;
      var elementList;
      var newAttribute;
      var testAddress;
      var attributes;
      var districtNode;
      var attrName;
      var setNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddress = elementList.item(1);
      newAttribute = doc.createAttribute("district");
      attributes = testAddress.attributes;

      setNode = attributes.setNamedItem(newAttribute);
      districtNode = attributes.getNamedItem("district");
      attrName = districtNode.nodeName;

      ASSERT(STRICT_EQ("district",attrName),"namednodemapSetNamedItemAssert");

});



/**
*
    If the "setNamedItem(arg)" method replaces an already
   existing node with the same name then the already
   existing node is returned.

   Retrieve the third employee and create a NamedNodeMap
   object from the attributes of the last child by
   invoking the "getAttributes()" method.  Once the
   list is created an invocation of the "setNamedItem(arg)"
   method is done with arg=newAttr, where newAttr is a
   new Attr Node previously created and whose node name
   already exists in the map.  The "setNamedItem(arg)"
   method should replace the already existing node with
   the new one and return the existing node.
   This test uses the "createAttribute(name)" method from
   the document interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1025163788
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
*/
TEST("namednodemapsetnameditemreturnvalue", function() {
   var success;
    var doc;
      var elementList;
      var newAttribute;
      var testAddress;
      var attributes;
      var newNode;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddress = elementList.item(2);
      newAttribute = doc.createAttribute("street");
      attributes = testAddress.attributes;

      newNode = attributes.setNamedItem(newAttribute);
      attrValue = newNode.nodeValue;

      ASSERT(STRICT_EQ("No",attrValue),"returnedNodeValue");

});



/**
*
    If the node to be added by the "setNamedItem(arg)" method
   already exists in the NamedNodeMap, it is replaced by
   the new one.

   Retrieve the second employee and create a NamedNodeMap
   object from the attributes of the last child by
   invoking the "getAttributes()" method.  Once the
   list is created an invocation of the "setNamedItem(arg)"
   method is done with arg=newAttr, where newAttr is a
   new Attr Node previously created and whose node name
   already exists in the map.  The "setNamedItem(arg)"
   method should replace the already existing node with
   the new one.
   This node is then retrieved using the "getNamedItem(name)"
   method.  This test uses the "createAttribute(name)"
   method from the document interface

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1025163788
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
*/
TEST("namednodemapsetnameditemthatexists", function() {
   var success;
    var doc;
      var elementList;
      var newAttribute;
      var testAddress;
      var attributes;
      var districtNode;
      var attrValue;
      var setNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddress = elementList.item(1);
      newAttribute = doc.createAttribute("street");
      attributes = testAddress.attributes;

      setNode = attributes.setNamedItem(newAttribute);
      districtNode = attributes.getNamedItem("street");
      attrValue = districtNode.nodeValue;

      ASSERT(STRICT_EQ("",attrValue),"streetValue");

});



/**
*
    If the "setNamedItem(arg)" method does not replace an
   existing node with the same name then it returns null.

   Retrieve the third employee and create a NamedNodeMap
   object from the attributes of the last child.
   Once the list is created the "setNamedItem(arg)" method
   is invoked with arg=newAttr, where newAttr is a
   newly created Attr Node and whose node name
   already exists in the map.  The "setNamedItem(arg)"
   method should add the new node and return null.
   This test uses the "createAttribute(name)" method from
   the document interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1025163788
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-349467F9
*/
TEST("namednodemapsetnameditemwithnewvalue", function() {
   var success;
    var doc;
      var elementList;
      var newAttribute;
      var testAddress;
      var attributes;
      var newNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddress = elementList.item(2);
      newAttribute = doc.createAttribute("district");
      attributes = testAddress.attributes;

      newNode = attributes.setNamedItem(newAttribute);
      ASSERT(NULL(newNode),"returnedNodeNull");

});



/**
*
    The "setNamedItem(arg)" method raises a
   WRONG_DOCUMENT_ERR DOMException if "arg" was created
   from a different document than the one that created
   the NamedNodeMap.

   Create a NamedNodeMap object from the attributes of the
   last child of the third employee and attempt to add
   another Attr node to it that was created from a
   different DOM document.  This should raise the desired
   exception.  This method uses the "createAttribute(name)"
   method from the Document interface.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='WRONG_DOCUMENT_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1025163788
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-1025163788')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='WRONG_DOCUMENT_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("namednodemapwrongdocumenterr", function() {
   var success;
    var doc1;
      var doc2;
      var elementList;
      var testAddress;
      var attributes;
      var newAttribute;
      var setNode;

      var doc1Ref = null;
      if (typeof(this.doc1) != 'undefined') {
        doc1Ref = this.doc1;
      }
      doc1 = load(doc1Ref, "doc1", "staff");

      var doc2Ref = null;
      if (typeof(this.doc2) != 'undefined') {
        doc2Ref = this.doc2;
      }
      doc2 = load(doc2Ref, "doc2", "staff");
      elementList = doc1.getElementsByTagName("address");
      testAddress = elementList.item(2);
      newAttribute = doc2.createAttribute("newAttribute");
      attributes = testAddress.attributes;


	{
		success = false;
		try {
            setNode = attributes.setNamedItem(newAttribute);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 4);
		}
		ASSERT(STRICT_EQ(true,success),"throw_WRONG_DOCUMENT_ERR");
	}

});



/**
*
    The "appendChild(newChild)" method adds the node
    "newChild" to the end of the list of children of the
    node.

    Retrieve the second employee and append a new Element
    node to the list of children.   The last node in the list
    is then retrieved and its NodeName examined.   The
    "getNodeName()" method should return "newChild".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
*/
TEST("nodeappendchild", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var createdNode;
      var lchild;
      var childName;
      var appendedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      createdNode = doc.createElement("newChild");
      appendedChild = employeeNode.appendChild(createdNode);
      lchild = employeeNode.lastChild;

      childName = lchild.nodeName;

      ASSERT(STRICT_EQ("newChild",childName),"nodeAppendChildAssert1");

});



/**
*
    If the "newChild" is already in the tree, it is first
    removed before the new one is appended.

    Retrieve the first child of the second employee and
    append the first child to the end of the list.   After
    the "appendChild(newChild)" method is invoked the first
    child should be the one that was second and the last
    child should be the one that was first.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
*/
TEST("nodeappendchildchildexists", function() {
   var success;
    var doc;
      var elementList;
      var childNode;
      var newChild;
      var lchild;
      var fchild;
      var lchildName;
      var fchildName;
      var appendedChild;
      var initialName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      childNode = elementList.item(1);
      newChild = childNode.firstChild;

      initialName = newChild.nodeName;

      appendedChild = childNode.appendChild(newChild);
      fchild = childNode.firstChild;

      fchildName = fchild.nodeName;

      lchild = childNode.lastChild;

      lchildName = lchild.nodeName;


	if(
	("employeeId" == initialName)
	) {
	ASSERT(STRICT_EQ("name",fchildName),"assert1_nowhitespace");
       ASSERT(STRICT_EQ("employeeId",lchildName),"assert2_nowhitespace");

	}
	
		else {
			ASSERT(STRICT_EQ("employeeId",fchildName),"assert1");
       ASSERT(STRICT_EQ("#text",lchildName),"assert2");

		}
	
});



/**
*
    Create and populate a new DocumentFragment object and
    append it to the second employee.   After the
    "appendChild(newChild)" method is invoked retrieve the
    new nodes at the end of the list, they should be the
    two Element nodes from the DocumentFragment.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
*/
TEST("nodeappendchilddocfragment", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var newdocFragment;
      var newChild1;
      var newChild2;
      var child;
      var childName;
      var result = new Array();

      var nodeType;
      var appendedChild;
      expected = new Array();
      expected[0] = "employeeId";
      expected[1] = "name";
      expected[2] = "position";
      expected[3] = "salary";
      expected[4] = "gender";
      expected[5] = "address";
      expected[6] = "newChild1";
      expected[7] = "newChild2";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      newdocFragment = doc.createDocumentFragment();
      newChild1 = doc.createElement("newChild1");
      newChild2 = doc.createElement("newChild2");
      appendedChild = newdocFragment.appendChild(newChild1);
      appendedChild = newdocFragment.appendChild(newChild2);
      appendedChild = employeeNode.appendChild(newdocFragment);
      for(var indexid2258770 = 0;indexid2258770 < childList.length; indexid2258770++) {
      child = childList.item(indexid2258770);
      nodeType = child.nodeType;


	if(
	(1 == nodeType)
	) {
	childName = child.nodeName;

      result[result.length] = childName;

	}
	
	}
   ASSERT(DOM_LIST_EQ(expected,result),"elementNames");

});



/**
*
    The "appendChild(newChild)" method returns the node
    added.

    Append a newly created node to the child list of the
    second employee and check the NodeName returned.   The
    "getNodeName()" method should return "newChild".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
*/
TEST("nodeappendchildgetnodename", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var newChild;
      var appendNode;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      newChild = doc.createElement("newChild");
      appendNode = employeeNode.appendChild(newChild);
      childName = appendNode.nodeName;

      ASSERT(STRICT_EQ("newChild",childName),"nodeAppendChildGetNodeNameAssert1");

});



/**
*
    The "appendChild(newChild)" method raises a
    HIERARCHY_REQUEST_ERR DOMException if this node is of
    a type that does not allow children of the type "newChild"
    to be inserted.

    Retrieve the root node and attempt to append a newly
    created Attr node.   An Element node cannot have children
    of the "Attr" type, therefore the desired exception
    should be raised.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-184E7107')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("nodeappendchildinvalidnodetype", function() {
   var success;
    var doc;
      var rootNode;
      var newChild;
      var appendedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      rootNode = doc.documentElement;

      newChild = doc.createAttribute("newAttribute");

	{
		success = false;
		try {
            appendedChild = rootNode.appendChild(newChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
    The "appendChild(newChild)" method raises a
    WRONG_DOCUMENT_ERR DOMException if the "newChild" was
    created from a different document than the one that
    created this node.

    Retrieve the second employee and attempt to append
    a node created from a different document.   An attempt
    to make such a replacement should raise the desired
    exception.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-184E7107')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("nodeappendchildnewchilddiffdocument", function() {
   var success;
    var doc1;
      var doc2;
      var newChild;
      var elementList;
      var elementNode;
      var appendedChild;

      var doc1Ref = null;
      if (typeof(this.doc1) != 'undefined') {
        doc1Ref = this.doc1;
      }
      doc1 = load(doc1Ref, "doc1", "staff");

      var doc2Ref = null;
      if (typeof(this.doc2) != 'undefined') {
        doc2Ref = this.doc2;
      }
      doc2 = load(doc2Ref, "doc2", "staff");
      newChild = doc1.createElement("newChild");
      elementList = doc2.getElementsByTagName("employee");
      elementNode = elementList.item(1);

	{
		success = false;
		try {
            appendedChild = elementNode.appendChild(newChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 4);
		}
		ASSERT(STRICT_EQ(true,success),"throw_WRONG_DOCUMENT_ERR");
	}

});



/**
*
    The "appendChild(newChild)" method raises a
    HIERARCHY_REQUEST_ERR DOMException if the node to
    append is one of this node's ancestors.

    Retrieve the second employee and attempt to append
    an ancestor node(root node) to it.
    An attempt to make such an addition should raise the
    desired exception.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-184E7107')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("nodeappendchildnodeancestor", function() {
   var success;
    var doc;
      var newChild;
      var elementList;
      var employeeNode;
      var appendedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newChild = doc.documentElement;

      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);

	{
		success = false;
		try {
            appendedChild = employeeNode.appendChild(newChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
The "getAttributes()" method invoked on an Attribute
Node returns null.

Retrieve the first attribute from the last child of the
first employee and invoke the "getAttributes()" method
on the Attribute Node.  It should return null.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-637646024
*/
TEST("nodeattributenodeattribute", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var addrAttr;
      var attrNode;
      var attrList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddr = elementList.item(0);
      addrAttr = testAddr.attributes;

      attrNode = addrAttr.item(0);
      attrList = attrNode.attributes;

      ASSERT(NULL(attrList),"nodeAttributeNodeAttributeAssert1");

});



/**
*

    The string returned by the "getNodeName()" method for an

    Attribute Node is the name of the Attribute.



    Retrieve the Attribute named "domestic" from the last

    child of the first employee and check the string returned

    by the "getNodeName()" method.   It should be equal to

    "domestic".


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
*/
TEST("nodeattributenodename", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var addrAttr;
      var attrName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddr = elementList.item(0);
      addrAttr = testAddr.getAttributeNode("domestic");
      attrName = addrAttr.nodeName;

      ASSERT(STRICT_EQ("domestic",attrName),"nodeAttributeNodeNameAssert1");

});



/**
*

    The "getNodeType()" method for an Attribute Node

    returns the constant value 2.



    Retrieve the first attribute from the last child of

    the first employee and invoke the "getNodeType()"

    method.   The method should return 2.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
*/
TEST("nodeattributenodetype", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var addrAttr;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddr = elementList.item(0);
      addrAttr = testAddr.getAttributeNode("domestic");
      nodeType = addrAttr.nodeType;

      ASSERT(STRICT_EQ(2,nodeType),"nodeAttrNodeTypeAssert1");

});



/**
*

    The string returned by the "getNodeValue()" method for an

    Attribute Node is the value of the Attribute.



    Retrieve the Attribute named "domestic" from the last

    child of the first employee and check the string returned

    by the "getNodeValue()" method.   It should be equal to

    "Yes".


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
*/
TEST("nodeattributenodevalue", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var addrAttr;
      var attrValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddr = elementList.item(0);
      addrAttr = testAddr.getAttributeNode("domestic");
      attrValue = addrAttr.nodeValue;

      ASSERT(STRICT_EQ("Yes",attrValue),"nodeAttributeNodeValueAssert1");

});



/**
*
The "getAttributes()" method invoked on a CDATASection
Node returns null.

Retrieve the CDATASection node contained inside the
second child of the second employee and invoke the
"getAttributes()" method on the CDATASection node.
It should return null.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-667469212
*/
TEST("nodecdatasectionnodeattribute", function() {
   var success;
    var doc;
      var elementList;
      var cdataName;
      var cdataNode;
      var attrList;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      cdataName = elementList.item(1);
      cdataNode = cdataName.lastChild;

      nodeType = cdataNode.nodeType;


	if(
	!(4 == nodeType)
	) {
	cdataNode = doc.createCDATASection("");

	}
	attrList = cdataNode.attributes;

      ASSERT(NULL(attrList),"cdataSection");

});



/**
*
    The string returned by the "getNodeName()" method for a
    CDATASection Node is #cdata-section".

    Retrieve the CDATASection node inside the second child
    of the second employee and check the string returned
    by the "getNodeName()" method.   It should be equal to
    "#cdata-section".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-667469212
*/
TEST("nodecdatasectionnodename", function() {
   var success;
    var doc;
      var elementList;
      var cdataName;
      var cdataNode;
      var nodeType;
      var cdataNodeName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      cdataName = elementList.item(1);
      cdataNode = cdataName.lastChild;

      nodeType = cdataNode.nodeType;


	if(
	!(4 == nodeType)
	) {
	cdataNode = doc.createCDATASection("");

	}
	cdataNodeName = cdataNode.nodeName;

      ASSERT(STRICT_EQ("#cdata-section",cdataNodeName),"cdataNodeName");

});



/**
*
    The "getNodeType()" method for a CDATASection Node
    returns the constant value 4.

    Retrieve the CDATASection node contained inside the
    second child of the second employee and invoke the
    "getNodeType()" method.   The method should return 4.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-667469212
*/
TEST("nodecdatasectionnodetype", function() {
   var success;
    var doc;
      var elementList;
      var testName;
      var cdataNode;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      testName = elementList.item(1);
      cdataNode = testName.lastChild;

      nodeType = cdataNode.nodeType;


	if(
	(3 == nodeType)
	) {
	cdataNode = doc.createCDATASection("");
      nodeType = cdataNode.nodeType;


	}
	ASSERT(STRICT_EQ(4,nodeType),"nodeTypeCDATA");

});



/**
*
    The string returned by the "getNodeValue()" method for a
    CDATASection Node is the content of the CDATASection.

    Retrieve the CDATASection node inside the second child
    of the second employee and check the string returned
    by the "getNodeValue()" method.   It should be equal to
    "This is a CDATA Section with EntityReference number 2
    &ent2;".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-667469212
*/
TEST("nodecdatasectionnodevalue", function() {
   var success;
    var doc;
      var elementList;
      var cdataName;
      var childList;
      var child;
      var cdataNodeValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      cdataName = elementList.item(1);
      childList = cdataName.childNodes;

      child = childList.item(1);

	if(
	
	(child == null)

	) {
	child = doc.createCDATASection("This is a CDATASection with EntityReference number 2 &ent2;");

	}
	cdataNodeValue = child.nodeValue;

      ASSERT(STRICT_EQ("This is a CDATASection with EntityReference number 2 &ent2;",cdataNodeValue),"value");

});



/**
*
Collect the element names from Node.childNodes and check against expectations.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1451460987
*/
TEST("nodechildnodes", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childNodes;
      var childNode;
      var childType;
      var childName;
      var elementNames = new Array();

      expectedElementNames = new Array();
      expectedElementNames[0] = "employeeId";
      expectedElementNames[1] = "name";
      expectedElementNames[2] = "position";
      expectedElementNames[3] = "salary";
      expectedElementNames[4] = "gender";
      expectedElementNames[5] = "address";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childNodes = employeeNode.childNodes;

      for(var indexid2258680 = 0;indexid2258680 < childNodes.length; indexid2258680++) {
      childNode = childNodes.item(indexid2258680);
      childType = childNode.nodeType;


	if(
	(1 == childType)
	) {
	childName = childNode.nodeName;

      elementNames[elementNames.length] = childName;

	}
	
	}
   ASSERT(DOM_LIST_EQ(expectedElementNames,elementNames),"elementNames");

});



/**
*
Add an element and check that the previously retrieved childNodes NodeList
is live.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1451460987
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107
*/
TEST("nodechildnodesappendchild", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var createdNode;
      var expectedLength;
      var length;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      expectedLength = childList.length;

      expectedLength += 1;
createdNode = doc.createElement("text3");
      employeeNode = employeeNode.appendChild(createdNode);
      length = childList.length;

      ASSERT(STRICT_EQ(expectedLength,length),"childNodeLength");

});



/**
*
    The "getChildNodes()" method returns a NodeList
    that contains all children of this node.   If there
    are not any children, this is a NodeList that does not
    contain any nodes.

    Retrieve the Text node from the second child of the second
    employee and invoke the "getChildNodes()" method.   The
    NodeList returned should not have any nodes.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1451460987
*/
TEST("nodechildnodesempty", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var secondCNode;
      var textNode;
      var childNodesList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      secondCNode = childList.item(1);
      textNode = secondCNode.firstChild;

      childNodesList = textNode.childNodes;

      ASSERT(STRICT_EQ(0,childNodesList.length),"nodeChildNodesEmptyAssert1");

});



/**
*
    If the cloneNode method is used to clone an
    Element node, all the attributes of the Element are
    copied along with their values.

    Retrieve the last child of the second employee and invoke
    the cloneNode method.   The
    duplicate node returned by the method should copy the
    attributes associated with this node.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
*/
TEST("nodecloneattributescopied", function() {
   var success;
    var doc;
      var elementList;
      var addressNode;
      var clonedNode;
      var attributes;
      var attributeNode;
      var attributeName;
      var result = new Array();

      expectedResult = new Array();
      expectedResult[0] = "domestic";
      expectedResult[1] = "street";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      addressNode = elementList.item(1);
      clonedNode = addressNode.cloneNode(false);
      attributes = clonedNode.attributes;

      for(var indexid2258676 = 0;indexid2258676 < attributes.length; indexid2258676++) {
      attributeNode = attributes.item(indexid2258676);
      attributeName = attributeNode.nodeName;

      result[result.length] = attributeName;

	}
   ASSERT(DOM_COLLECTION_EQ(expectedResult,result),"nodeCloneAttributesCopiedAssert1");

});



/**
*
    The "cloneNode(deep)" method does not copy text unless it
    is deep cloned.(Test for deep=false)

    Retrieve the fourth child of the second employee and
    the "cloneNode(deep)" method with deep=false.   The
    duplicate node returned by the method should not copy
    any text data contained in this node.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4
*/
TEST("nodeclonefalsenocopytext", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var childNode;
      var clonedNode;
      var lastChildNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      childNode = childList.item(3);
      clonedNode = childNode.cloneNode(false);
      lastChildNode = clonedNode.lastChild;

      ASSERT(NULL(lastChildNode),"noTextNodes");

});



/**
*
    The duplicate node returned by the "cloneNode(deep)"
    method does not have a ParentNode.

    Retrieve the second employee and invoke the
    "cloneNode(deep)" method with deep=false.   The
    duplicate node returned should return null when the
    "getParentNode()" is invoked.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4
*/
TEST("nodeclonegetparentnull", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var clonedNode;
      var parentNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      clonedNode = employeeNode.cloneNode(false);
      parentNode = clonedNode.parentNode;

      ASSERT(NULL(parentNode),"nodeCloneGetParentNullAssert1");

});



/**
*
    The "cloneNode(deep)" method returns a copy of the node
    only if deep=false.

    Retrieve the second employee and invoke the
    "cloneNode(deep)" method with deep=false.   The
    method should only clone this node.   The NodeName and
    length of the NodeList are checked.   The "getNodeName()"
    method should return "employee" and the "getLength()"
    method should return 0.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4
*/
TEST("nodeclonenodefalse", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var clonedNode;
      var cloneName;
      var cloneChildren;
      var length;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      clonedNode = employeeNode.cloneNode(false);
      cloneName = clonedNode.nodeName;

      ASSERT(STRICT_EQ("employee",cloneName),"name");
       cloneChildren = clonedNode.childNodes;

      length = cloneChildren.length;

      ASSERT(STRICT_EQ(0,length),"length");

});



/**
*
    The "cloneNode(deep)" method returns a copy of the node
    and the subtree under it if deep=true.

    Retrieve the second employee and invoke the
    "cloneNode(deep)" method with deep=true.   The
    method should clone this node and the subtree under it.
    The NodeName of each child in the returned node is
    checked to insure the entire subtree under the second
    employee was cloned.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4
*/
TEST("nodeclonenodetrue", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var clonedNode;
      var clonedList;
      var clonedChild;
      var clonedChildName;
      var length;
      var result = new Array();

      expectedWhitespace = new Array();
      expectedWhitespace[0] = "#text";
      expectedWhitespace[1] = "employeeId";
      expectedWhitespace[2] = "#text";
      expectedWhitespace[3] = "name";
      expectedWhitespace[4] = "#text";
      expectedWhitespace[5] = "position";
      expectedWhitespace[6] = "#text";
      expectedWhitespace[7] = "salary";
      expectedWhitespace[8] = "#text";
      expectedWhitespace[9] = "gender";
      expectedWhitespace[10] = "#text";
      expectedWhitespace[11] = "address";
      expectedWhitespace[12] = "#text";

      expectedNoWhitespace = new Array();
      expectedNoWhitespace[0] = "employeeId";
      expectedNoWhitespace[1] = "name";
      expectedNoWhitespace[2] = "position";
      expectedNoWhitespace[3] = "salary";
      expectedNoWhitespace[4] = "gender";
      expectedNoWhitespace[5] = "address";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      length = childList.length;

      clonedNode = employeeNode.cloneNode(true);
      clonedList = clonedNode.childNodes;

      for(var indexid2258776 = 0;indexid2258776 < clonedList.length; indexid2258776++) {
      clonedChild = clonedList.item(indexid2258776);
      clonedChildName = clonedChild.nodeName;

      result[result.length] = clonedChildName;

	}

	if(
	(6 == length)
	) {
	ASSERT(DOM_LIST_EQ(expectedNoWhitespace,result),"nowhitespace");

	}
	
		else {
			ASSERT(DOM_LIST_EQ(expectedWhitespace,result),"whitespace");

		}
	
});



/**
*
    Retrieve the second salary and
    the "cloneNode(deep)" method with deep=true.   The
    duplicate node returned by the method should copy
    any text data contained in this node.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-3A0ED0A4
*/
TEST("nodeclonetruecopytext", function() {
   var success;
    var doc;
      var elementList;
      var childList;
      var childNode;
      var clonedNode;
      var lastChildNode;
      var childValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("salary");
      childNode = elementList.item(1);
      clonedNode = childNode.cloneNode(true);
      lastChildNode = clonedNode.lastChild;

      childValue = lastChildNode.nodeValue;

      ASSERT(STRICT_EQ("35,000",childValue),"nodeCloneTrueCopyTextAssert1");

});



/**
*
    The "getAttributes()" method invoked on a Comment
    Node returns null.

    Find any comment that is an immediate child of the root
    and assert that Node.attributes is null.  Then create
    a new comment node (in case they had been omitted) and
    make the assertion.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1728279322
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=248
*/
TEST("nodecommentnodeattributes", function() {
   var success;
    var doc;
      var childList;
      var childNode;
      var attrList;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      childList = doc.childNodes;

      for(var indexid2258624 = 0;indexid2258624 < childList.length; indexid2258624++) {
      childNode = childList.item(indexid2258624);
      nodeType = childNode.nodeType;


	if(
	(8 == nodeType)
	) {
	attrList = childNode.attributes;

      ASSERT(NULL(attrList),"attributesNull");

	}
	
	}
   childNode = doc.createComment("This is a comment");
      attrList = childNode.attributes;

      ASSERT(NULL(attrList),"createdAttributesNull");

});



/**
*
    The string returned by the "getNodeName()" method for a
    Comment Node is "#comment".

    Retrieve the Comment node in the XML file
    and check the string returned by the "getNodeName()"
    method.   It should be equal to "#comment".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1728279322
*/
TEST("nodecommentnodename", function() {
   var success;
    var doc;
      var elementList;
      var commentNode;
      var nodeType;
      var commentNodeName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.childNodes;

      for(var indexid2258614 = 0;indexid2258614 < elementList.length; indexid2258614++) {
      commentNode = elementList.item(indexid2258614);
      nodeType = commentNode.nodeType;


	if(
	(8 == nodeType)
	) {
	commentNodeName = commentNode.nodeName;

      ASSERT(STRICT_EQ("#comment",commentNodeName),"commentNodeName");

	}
	
	}

});



/**
*
    The "getNodeType()" method for a Comment Node
    returns the constant value 8.

    Retrieve the nodes from the document and check for
    a comment node and invoke the "getNodeType()" method.   This should
    return 8.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1728279322
*/
TEST("nodecommentnodetype", function() {
   var success;
    var doc;
      var testList;
      var commentNode;
      var commentNodeName;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      testList = doc.childNodes;

      for(var indexid2258613 = 0;indexid2258613 < testList.length; indexid2258613++) {
      commentNode = testList.item(indexid2258613);
      commentNodeName = commentNode.nodeName;


	if(
	("#comment" == commentNodeName)
	) {
	nodeType = commentNode.nodeType;

      ASSERT(STRICT_EQ(8,nodeType),"nodeCommentNodeTypeAssert1");

	}
	
	}

});



/**
*
    The string returned by the "getNodeValue()" method for a
    Comment Node is the content of the comment.

    Retrieve the comment in the XML file and
    check the string returned by the "getNodeValue()" method.
    It should be equal to "This is comment number 1".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1728279322
*/
TEST("nodecommentnodevalue", function() {
   var success;
    var doc;
      var elementList;
      var commentNode;
      var commentName;
      var commentValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.childNodes;

      for(var indexid2258615 = 0;indexid2258615 < elementList.length; indexid2258615++) {
      commentNode = elementList.item(indexid2258615);
      commentName = commentNode.nodeName;


	if(
	("#comment" == commentName)
	) {
	commentValue = commentNode.nodeValue;

      ASSERT(STRICT_EQ(" This is comment number 1.",commentValue),"value");

	}
	
	}

});



/**
*
    The string returned by the "getNodeName()" method for a
    DocumentFragment Node is "#document-frament".

    Retrieve the DOM document and invoke the
    "createDocumentFragment()" method and check the string
    returned by the "getNodeName()" method.   It should be
    equal to "#document-fragment".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-B63ED1A3
*/
TEST("nodedocumentfragmentnodename", function() {
   var success;
    var doc;
      var docFragment;
      var documentFragmentName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      docFragment = doc.createDocumentFragment();
      documentFragmentName = docFragment.nodeName;

      ASSERT(STRICT_EQ("#document-fragment",documentFragmentName),"nodeDocumentFragmentNodeNameAssert1");

});



/**
*
    The "getNodeType()" method for a DocumentFragment Node
    returns the constant value 11.

    Invoke the "createDocumentFragment()" method and
    examine the NodeType of the document fragment
    returned by the "getNodeType()" method.   The method
    should return 11.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-B63ED1A3
*/
TEST("nodedocumentfragmentnodetype", function() {
   var success;
    var doc;
      var documentFragmentNode;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      documentFragmentNode = doc.createDocumentFragment();
      nodeType = documentFragmentNode.nodeType;

      ASSERT(STRICT_EQ(11,nodeType),"nodeDocumentFragmentNodeTypeAssert1");

});



/**
*
    The string returned by the "getNodeValue()" method for a
    DocumentFragment Node is null.

    Retrieve the DOM document and invoke the
    "createDocumentFragment()" method and check the string
    returned by the "getNodeValue()" method.   It should be
    equal to null.

* @author NIST
* @author Mary Brady
* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-B63ED1A3
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
*/
TEST("nodedocumentfragmentnodevalue", function() {
   var success;
    var doc;
      var docFragment;
      var attrList;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      docFragment = doc.createDocumentFragment();
      attrList = docFragment.attributes;

      ASSERT(NULL(attrList),"attributesNull");
    value = docFragment.nodeValue;

      ASSERT(NULL(value),"initiallyNull");

});



/**
*
The "getAttributes()" method invoked on a Document
Node returns null.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#i-Document
*/
TEST("nodedocumentnodeattribute", function() {
   var success;
    var doc;
      var attrList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      attrList = doc.attributes;

      ASSERT(NULL(attrList),"documentAttributesNull");

});



/**
*
    The string returned by the "getNodeName()" method for a
    Document Node is "#document".

    Retrieve the DOM document and check the string returned
    by the "getNodeName()" method.   It should be equal to
    "#document".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#i-Document
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
*/
TEST("nodedocumentnodename", function() {
   var success;
    var doc;
      var documentName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      documentName = doc.nodeName;

      ASSERT(STRICT_EQ("#document",documentName),"documentNodeName");

});



/**
*
The "getNodeType()" method for a Document Node
returns the constant value 9.

Retrieve the document and invoke the "getNodeType()"
method.   The method should return 9.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#i-Document
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
*/
TEST("nodedocumentnodetype", function() {
   var success;
    var doc;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      nodeType = doc.nodeType;

      ASSERT(STRICT_EQ(9,nodeType),"nodeDocumentNodeTypeAssert1");

});



/**
*
    The string returned by the "getNodeValue()" method for a
    Document Node is null.

    Retrieve the DOM Document and check the string returned
    by the "getNodeValue()" method.   It should be equal to
    null.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#i-Document
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
*/
TEST("nodedocumentnodevalue", function() {
   var success;
    var doc;
      var documentValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      documentValue = doc.nodeValue;

      ASSERT(NULL(documentValue),"documentNodeValueNull");

});



/**
*
    The "getAttributes()" method invoked on an Element
    Node returns a NamedNodeMap containing the attributes
    of this node.

    Retrieve the last child of the third employee and
    invoke the "getAttributes()" method.   It should return
    a NamedNodeMap containing the attributes of the Element
    node.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
*/
TEST("nodeelementnodeattributes", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var addrAttr;
      var attrNode;
      var attrName;
      var attrList = new Array();

      expected = new Array();
      expected[0] = "domestic";
      expected[1] = "street";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddr = elementList.item(2);
      addrAttr = testAddr.attributes;

      for(var indexid2258661 = 0;indexid2258661 < addrAttr.length; indexid2258661++) {
      attrNode = addrAttr.item(indexid2258661);
      attrName = attrNode.nodeName;

      attrList[attrList.length] = attrName;

	}
   ASSERT(DOM_COLLECTION_EQ(expected,attrList),"nodeElementNodeValueAssert1");

});



/**
*

    The string returned by the "getNodeName()" method for an

    Element Node is its tagName.



    Retrieve the first Element Node(Root Node) of the

    DOM object and check the string returned by the

    "getNodeName()" method.   It should be equal to its

    tagName.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=251
*/
TEST("nodeelementnodename", function() {
   var success;
    var doc;
      var elementNode;
      var elementName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementNode = doc.documentElement;

      elementName = elementNode.nodeName;


	if(
	
	(builder.contentType == "image/svg+xml")

	) {
	ASSERT(STRICT_EQ("svg",elementName),"svgNodeName");

	}
	
		else {
			ASSERT(STRICT_EQ("staff",elementName),"nodeElementNodeNameAssert1");

		}
	
});



/**
*
    The "getNodeType()" method for an Element Node
    returns the constant value 1.

    Retrieve the root node and invoke the "getNodeType()"
    method.   The method should return 1.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
*/
TEST("nodeelementnodetype", function() {
   var success;
    var doc;
      var rootNode;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      rootNode = doc.documentElement;

      nodeType = rootNode.nodeType;

      ASSERT(STRICT_EQ(1,nodeType),"nodeElementNodeTypeAssert1");

});



/**
*
    The string returned by the "getNodeValue()" method for an
    Element Node is null.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
*/
TEST("nodeelementnodevalue", function() {
   var success;
    var doc;
      var elementNode;
      var elementValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementNode = doc.documentElement;

      elementValue = elementNode.nodeValue;

      ASSERT(NULL(elementValue),"elementNodeValueNull");

});



/**
*
    The "getFirstChild()" method returns the first child
    of this node.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-169727388
*/
TEST("nodegetfirstchild", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var fchildNode;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      fchildNode = employeeNode.firstChild;

      childName = fchildNode.nodeName;


	if(
	("#text" == childName)
	) {
	fchildNode = fchildNode.nextSibling;

      childName = fchildNode.nodeName;


	}
	ASSERT(STRICT_EQ("employeeId",childName),"nodeName");

});



/**
*

    If there is not a first child then the "getFirstChild()"

    method returns null.



    Retrieve the Text node form the second child of the first

    employee and invoke the "getFirstChild()" method.   It

    should return null.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-169727388
*/
TEST("nodegetfirstchildnull", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var secondChildNode;
      var textNode;
      var noChildNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(0);
      employeeList = employeeNode.childNodes;

      secondChildNode = employeeList.item(1);
      textNode = secondChildNode.firstChild;

      noChildNode = textNode.firstChild;

      ASSERT(NULL(noChildNode),"nodeGetFirstChildNullAssert1");

});



/**
*
    The "getLastChild()" method returns the last child
    of this node.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-61AD09FB
*/
TEST("nodegetlastchild", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var lchildNode;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      lchildNode = employeeNode.lastChild;

      childName = lchildNode.nodeName;


	if(
	("#text" == childName)
	) {
	lchildNode = lchildNode.previousSibling;

      childName = lchildNode.nodeName;


	}
	ASSERT(STRICT_EQ("address",childName),"nodeName");

});



/**
*

    If there is not a last child then the "getLastChild()"

    method returns null.



    Retrieve the Text node from the second child of the first

    employee and invoke the "getLastChild()" method.   It

    should return null.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-61AD09FB
*/
TEST("nodegetlastchildnull", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var secondChildNode;
      var textNode;
      var noChildNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(0);
      employeeList = employeeNode.childNodes;

      secondChildNode = employeeList.item(1);
      textNode = secondChildNode.firstChild;

      noChildNode = textNode.lastChild;

      ASSERT(NULL(noChildNode),"nodeGetLastChildNullAssert1");

});



/**
*
    The "getNextSibling()" method returns the node immediately
    following this node.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6AC54C2F
*/
TEST("nodegetnextsibling", function() {
   var success;
    var doc;
      var elementList;
      var employeeIdNode;
      var nsNode;
      var nsName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employeeId");
      employeeIdNode = elementList.item(1);
      nsNode = employeeIdNode.nextSibling;

      nsName = nsNode.nodeName;


	if(
	("#text" == nsName)
	) {
	nsNode = nsNode.nextSibling;

      nsName = nsNode.nodeName;


	}
	ASSERT(STRICT_EQ("name",nsName),"nodeName");

});



/**
*

    If there is not a node immediately following this node the

    "getNextSibling()" method returns null.



    Retrieve the first child of the second employee and

    invoke the "getNextSibling()" method.   It should

    be set to null.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6AC54C2F
*/
TEST("nodegetnextsiblingnull", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var lcNode;
      var nsNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      lcNode = employeeNode.lastChild;

      nsNode = lcNode.nextSibling;

      ASSERT(NULL(nsNode),"nodeGetNextSiblingNullAssert1");

});



/**
*
    The "getOwnerDocument()" method returns the Document
    object associated with this node.

    Retrieve the second employee and examine Document
    returned by the "getOwnerDocument()" method.   Invoke
    the "getDocumentElement()" on the Document which will
    return an Element that is equal to "staff".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#node-ownerDoc
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=251
*/
TEST("nodegetownerdocument", function() {
   var success;
    var doc;
      var elementList;
      var docNode;
      var ownerDocument;
      var docElement;
      var elementName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      docNode = elementList.item(1);
      ownerDocument = docNode.ownerDocument;

      docElement = ownerDocument.documentElement;

      elementName = docElement.nodeName;


	if(
	
	(builder.contentType == "image/svg+xml")

	) {
	ASSERT(STRICT_EQ("svg",elementName),"svgTagName");

	}
	
		else {
			ASSERT(STRICT_EQ("staff",elementName),"nodeGetOwnerDocumentAssert1");

		}
	
});



/**
*
    The "getOwnerDocument()" method returns null if the target
    node itself is a document.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#node-ownerDoc
*/
TEST("nodegetownerdocumentnull", function() {
   var success;
    var doc;
      var ownerDocument;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      ownerDocument = doc.ownerDocument;

      ASSERT(NULL(ownerDocument),"documentOwnerDocumentNull");

});



/**
*
    The "getPreviousSibling()" method returns the node
    immediately preceding this node.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-640FB3C8
*/
TEST("nodegetprevioussibling", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var psNode;
      var psName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(1);
      psNode = nameNode.previousSibling;

      psName = psNode.nodeName;


	if(
	("#text" == psName)
	) {
	psNode = psNode.previousSibling;

      psName = psNode.nodeName;


	}
	ASSERT(STRICT_EQ("employeeId",psName),"nodeName");

});



/**
*

    If there is not a node immediately preceding this node the

    "getPreviousSibling()" method returns null.



    Retrieve the first child of the second employee and

    invoke the "getPreviousSibling()" method.   It should

    be set to null.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-640FB3C8
*/
TEST("nodegetprevioussiblingnull", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var fcNode;
      var psNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(2);
      fcNode = employeeNode.firstChild;

      psNode = fcNode.previousSibling;

      ASSERT(NULL(psNode),"nodeGetPreviousSiblingNullAssert1");

});



/**
*
    The "hasChildNodes()" method returns true if the node
    has children.

    Retrieve the root node("staff") and invoke the
    "hasChildNodes()" method.   It should return the boolean
    value "true".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-810594187
*/
TEST("nodehaschildnodes", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      state = employeeNode.hasChildNodes();
      ASSERT(STRICT_EQ(true,state),"nodeHasChildAssert1");

});



/**
*
    The "hasChildNodes()" method returns false if the node
    does not have any children.

    Retrieve the Text node inside the first child of the
    second employee and invoke the "hasChildNodes()" method.
    It should return the boolean value "false".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1451460987
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-810594187
*/
TEST("nodehaschildnodesfalse", function() {
   var success;
    var doc;
      var elementList;
      var child;
      var employeeIdList;
      var employeeNode;
      var textNode;
      var state;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      child = elementList.item(1);
      employeeIdList = child.childNodes;

      employeeNode = employeeIdList.item(1);
      textNode = employeeNode.firstChild;

      state = textNode.hasChildNodes();
      ASSERT(STRICT_EQ(false,state),"nodeHasChildFalseAssert1");

});



/**
*
    The "insertBefore(newChild,refChild)" method inserts the
    node "newChild" before the node "refChild".

    Insert a newly created Element node before the eigth
    child of the second employee and check the "newChild"
    and "refChild" after insertion for correct placement.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("nodeinsertbefore", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var refChild;
      var newChild;
      var child;
      var childName;
      var length;
      var insertedNode;
      var actual = new Array();

      expectedWithWhitespace = new Array();
      expectedWithWhitespace[0] = "#text";
      expectedWithWhitespace[1] = "employeeId";
      expectedWithWhitespace[2] = "#text";
      expectedWithWhitespace[3] = "name";
      expectedWithWhitespace[4] = "#text";
      expectedWithWhitespace[5] = "position";
      expectedWithWhitespace[6] = "#text";
      expectedWithWhitespace[7] = "newChild";
      expectedWithWhitespace[8] = "salary";
      expectedWithWhitespace[9] = "#text";
      expectedWithWhitespace[10] = "gender";
      expectedWithWhitespace[11] = "#text";
      expectedWithWhitespace[12] = "address";
      expectedWithWhitespace[13] = "#text";

      expectedWithoutWhitespace = new Array();
      expectedWithoutWhitespace[0] = "employeeId";
      expectedWithoutWhitespace[1] = "name";
      expectedWithoutWhitespace[2] = "position";
      expectedWithoutWhitespace[3] = "newChild";
      expectedWithoutWhitespace[4] = "salary";
      expectedWithoutWhitespace[5] = "gender";
      expectedWithoutWhitespace[6] = "address";

      var expected = new Array();


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      length = childList.length;


	if(
	(6 == length)
	) {
	refChild = childList.item(3);
      expected =  expectedWithoutWhitespace;

	}
	
		else {
			refChild = childList.item(7);
      expected =  expectedWithWhitespace;

		}
	newChild = doc.createElement("newChild");
      insertedNode = employeeNode.insertBefore(newChild,refChild);
      for(var indexid2258846 = 0;indexid2258846 < childList.length; indexid2258846++) {
      child = childList.item(indexid2258846);
      childName = child.nodeName;

      actual[actual.length] = childName;

	}
   ASSERT(DOM_LIST_EQ(expected,actual),"nodeNames");

});



/**
*
    If the "newChild" is a DocumentFragment object then all
    its children are inserted in the same order before the
    the "refChild".

    Create a DocumentFragment object and populate it with
    two Element nodes.   Retrieve the second employee and
    insert the newly created DocumentFragment before its
    fourth child.   The second employee should now have two
    extra children("newChild1" and "newChild2") at
    positions fourth and fifth respectively.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("nodeinsertbeforedocfragment", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var refChild;
      var newdocFragment;
      var newChild1;
      var newChild2;
      var child;
      var childName;
      var appendedChild;
      var insertedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      refChild = childList.item(3);
      newdocFragment = doc.createDocumentFragment();
      newChild1 = doc.createElement("newChild1");
      newChild2 = doc.createElement("newChild2");
      appendedChild = newdocFragment.appendChild(newChild1);
      appendedChild = newdocFragment.appendChild(newChild2);
      insertedNode = employeeNode.insertBefore(newdocFragment,refChild);
      child = childList.item(3);
      childName = child.nodeName;

      ASSERT(STRICT_EQ("newChild1",childName),"childName3");
       child = childList.item(4);
      childName = child.nodeName;

      ASSERT(STRICT_EQ("newChild2",childName),"childName4");

});



/**
*
    The "insertBefore(newChild,refChild)" method raises a
    HIERARCHY_REQUEST_ERR DOMException if this node is of
    a type that does not allow children of the type "newChild"
    to be inserted.

    Retrieve the root node and attempt to insert a newly
    created Attr node.   An Element node cannot have children
    of the "Attr" type, therefore the desired exception
    should be raised.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-952280727')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("nodeinsertbeforeinvalidnodetype", function() {
   var success;
    var doc;
      var rootNode;
      var newChild;
      var elementList;
      var refChild;
      var insertedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      rootNode = doc.documentElement;

      newChild = doc.createAttribute("newAttribute");
      elementList = doc.getElementsByTagName("employee");
      refChild = elementList.item(1);

	{
		success = false;
		try {
            insertedNode = rootNode.insertBefore(newChild,refChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
    The "insertBefore(newChild,refChild)" method raises a
    WRONG_DOCUMENT_ERR DOMException if the "newChild" was
    created from a different document than the one that
    created this node.

    Retrieve the second employee and attempt to insert a new
    child that was created from a different document than the
    one that created the second employee.   An attempt to
    insert such a child should raise the desired exception.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='WRONG_DOCUMENT_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-952280727')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='WRONG_DOCUMENT_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("nodeinsertbeforenewchilddiffdocument", function() {
   var success;
    var doc1;
      var doc2;
      var refChild;
      var newChild;
      var elementList;
      var elementNode;
      var insertedNode;

      var doc1Ref = null;
      if (typeof(this.doc1) != 'undefined') {
        doc1Ref = this.doc1;
      }
      doc1 = load(doc1Ref, "doc1", "staff");

      var doc2Ref = null;
      if (typeof(this.doc2) != 'undefined') {
        doc2Ref = this.doc2;
      }
      doc2 = load(doc2Ref, "doc2", "staff");
      newChild = doc1.createElement("newChild");
      elementList = doc2.getElementsByTagName("employee");
      elementNode = elementList.item(1);
      refChild = elementNode.firstChild;


	{
		success = false;
		try {
            insertedNode = elementNode.insertBefore(newChild,refChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 4);
		}
		ASSERT(STRICT_EQ(true,success),"throw_WRONG_DOCUMENT_ERR");
	}

});



/**
*
    If the "newChild" is already in the tree, the
    "insertBefore(newChild,refChild)" method must first
    remove it before the insertion takes place.

    Insert a node Element ("employeeId") that is already
    present in the tree.   The existing node should be
    removed first and the new one inserted.   The node is
    inserted at a different position in the tree to assure
    that it was indeed inserted.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("nodeinsertbeforenewchildexists", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var refChild;
      var newChild;
      var child;
      var length;
      var childName;
      var insertedNode;
      expectedWhitespace = new Array();
      expectedWhitespace[0] = "#text";
      expectedWhitespace[1] = "#text";
      expectedWhitespace[2] = "name";
      expectedWhitespace[3] = "#text";
      expectedWhitespace[4] = "position";
      expectedWhitespace[5] = "#text";
      expectedWhitespace[6] = "salary";
      expectedWhitespace[7] = "#text";
      expectedWhitespace[8] = "gender";
      expectedWhitespace[9] = "#text";
      expectedWhitespace[10] = "employeeId";
      expectedWhitespace[11] = "address";
      expectedWhitespace[12] = "#text";

      expectedNoWhitespace = new Array();
      expectedNoWhitespace[0] = "name";
      expectedNoWhitespace[1] = "position";
      expectedNoWhitespace[2] = "salary";
      expectedNoWhitespace[3] = "gender";
      expectedNoWhitespace[4] = "employeeId";
      expectedNoWhitespace[5] = "address";

      var expected = new Array();

      var result = new Array();


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      length = childList.length;


	if(
	(6 == length)
	) {
	expected =  expectedNoWhitespace;
refChild = childList.item(5);
      newChild = childList.item(0);

	}
	
		else {
			expected =  expectedWhitespace;
refChild = childList.item(11);
      newChild = childList.item(1);

		}
	insertedNode = employeeNode.insertBefore(newChild,refChild);
      for(var indexid2258859 = 0;indexid2258859 < childList.length; indexid2258859++) {
      child = childList.item(indexid2258859);
      childName = child.nodeName;

      result[result.length] = childName;

	}
   ASSERT(DOM_LIST_EQ(expected,result),"childNames");

});



/**
*
    The "insertBefore(newChild,refChild)" method raises a
    HIERARCHY_REQUEST_ERR DOMException if the node to be
    inserted is one of this nodes ancestors.

    Retrieve the second employee and attempt to insert a
    node that is one of its ancestors(root node).   An
    attempt to insert such a node should raise the
    desired exception.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-952280727')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("nodeinsertbeforenodeancestor", function() {
   var success;
    var doc;
      var newChild;
      var elementList;
      var employeeNode;
      var childList;
      var refChild;
      var insertedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newChild = doc.documentElement;

      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      refChild = childList.item(0);

	{
		success = false;
		try {
            insertedNode = employeeNode.insertBefore(newChild,refChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
    The "insertBefore(newChild,refchild)" method returns
    the node being inserted.

    Insert an Element node before the fourth
    child of the second employee and check the node
    returned from the "insertBefore(newChild,refChild)"
    method.   The node returned should be "newChild".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("nodeinsertbeforenodename", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var refChild;
      var newChild;
      var insertedNode;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      refChild = childList.item(3);
      newChild = doc.createElement("newChild");
      insertedNode = employeeNode.insertBefore(newChild,refChild);
      childName = insertedNode.nodeName;

      ASSERT(STRICT_EQ("newChild",childName),"nodeInsertBeforeNodeNameAssert1");

});



/**
*
    The "insertBefore(newChild,refChild)" method raises a
    NOT_FOUND_ERR DOMException if the reference child is
    not a child of this node.

    Retrieve the second employee and attempt to insert a
    new node before a reference node that is not a child
    of this node.   An attempt to insert before a non child
    node should raise the desired exception.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-952280727')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("nodeinsertbeforerefchildnonexistent", function() {
   var success;
    var doc;
      var refChild;
      var newChild;
      var elementList;
      var elementNode;
      var insertedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newChild = doc.createElement("newChild");
      refChild = doc.createElement("refChild");
      elementList = doc.getElementsByTagName("employee");
      elementNode = elementList.item(1);

	{
		success = false;
		try {
            insertedNode = elementNode.insertBefore(newChild,refChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 8);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_FOUND_ERR");
	}

});



/**
*
    If the "refChild" is null then the
    "insertBefore(newChild,refChild)" method inserts the
    node "newChild" at the end of the list of children.

    Retrieve the second employee and invoke the
    "insertBefore(newChild,refChild)" method with
    refChild=null.   Since "refChild" is null the "newChild"
    should be added to the end of the list.   The last item
    in the list is checked after insertion.   The last Element
    node of the list should be "newChild".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727
*/
TEST("nodeinsertbeforerefchildnull", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var refChild = null;

      var newChild;
      var child;
      var childName;
      var insertedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      newChild = doc.createElement("newChild");
      insertedNode = employeeNode.insertBefore(newChild,refChild);
      child = employeeNode.lastChild;

      childName = child.nodeName;

      ASSERT(STRICT_EQ("newChild",childName),"nodeInsertBeforeRefChildNullAssert1");

});



/**
*
   Create a list of all the children elements of the third
   employee and access its first child by using an index
   of 0.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-844377136
*/
TEST("nodelistindexequalzero", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var child;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      child = employeeList.item(0);
      childName = child.nodeName;


	if(
	!("#text" == childName)
	) {
	ASSERT(STRICT_EQ("employeeId",childName),"childName");

	}
	
});



/**
*
    The "getLength()" method returns the number of nodes
   in the list should be 6 (no whitespace) or 13.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-203510337
*/
TEST("nodelistindexgetlength", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var length;
      var expectedCount = 0;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      length = employeeList.length;

      	assertTrue("lengthIs6or13",

	((6 == length) || (13 == length))
);

});



/**
*
    The "getLength()" method returns the number of nodes
   in the list.(Test for EMPTY list)

   Create a list of all the children of the Text node
   inside the first child of the third employee and
   invoke the "getLength()" method.   It should contain
   the value 0.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-203510337
*/
TEST("nodelistindexgetlengthofemptylist", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var childNode;
      var textNode;
      var textList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      childNode = employeeList.item(1);
      textNode = childNode.firstChild;

      textList = textNode.childNodes;

      ASSERT(STRICT_EQ(0,textList.length),"nodelistIndexGetLengthOfEmptyListAssert");

});



/**
*
   Create a list of all the children elements of the third
   employee and access its fourth child by using an index
   of 3.  This should result in "name" being
   selected.  Further we evaluate its content(by using
   the "getNodeName()" method) to ensure the proper
   element was accessed.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-844377136
*/
TEST("nodelistindexnotzero", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var child;
      var length;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      length = employeeList.length;


	if(
	(6 == length)
	) {
	child = employeeList.item(1);

	}
	
		else {
			child = employeeList.item(3);

		}
	childName = child.nodeName;

      ASSERT(STRICT_EQ("name",childName),"nodeName");

});



/**
*
Get the first child of the third employee using NodeList.item(0)
which will either be a Text node (whitespace) or employeeId element.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-844377136
*/
TEST("nodelistreturnfirstitem", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var child;
      var childName;
      var length;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      child = employeeList.item(0);
      childName = child.nodeName;

      length = employeeList.length;


	if(
	(6 == length)
	) {
	ASSERT(STRICT_EQ("employeeId".toLowerCase(),childName.toLowerCase()),"firstChildNoWhitespace");

	}
	
		else {
			ASSERT(STRICT_EQ("#text".toLowerCase(),childName.toLowerCase()),"firstChildWithWhitespace");

		}
	
});



/**
*
Get this last child of the third employee using NodeList.item(NodeList.length - 1)
and check that it is either a Text element (with whitespace) or an address element.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-844377136
*/
TEST("nodelistreturnlastitem", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var child;
      var childName;
      var length;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      length = employeeList.length;


	if(
	(6 == length)
	) {
	child = employeeList.item(5);
      childName = child.nodeName;

      ASSERT(STRICT_EQ("address",childName),"nodeName1");

	}
	
		else {
			child = employeeList.item(12);
      childName = child.nodeName;

      ASSERT(STRICT_EQ("#text",childName),"nodeName2");

		}
	
});



/**
*
    The range of valid child node indices is 0 thru length -1

   Create a list of all the children elements of the third
   employee and traverse the list from index=0 thru
   length -1.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-203510337
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-844377136
*/
TEST("nodelisttraverselist", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var employeeList;
      var child;
      var childName;
      var result = new Array();

      var length;
      expectedWhitespace = new Array();
      expectedWhitespace[0] = "#text";
      expectedWhitespace[1] = "employeeId";
      expectedWhitespace[2] = "#text";
      expectedWhitespace[3] = "name";
      expectedWhitespace[4] = "#text";
      expectedWhitespace[5] = "position";
      expectedWhitespace[6] = "#text";
      expectedWhitespace[7] = "salary";
      expectedWhitespace[8] = "#text";
      expectedWhitespace[9] = "gender";
      expectedWhitespace[10] = "#text";
      expectedWhitespace[11] = "address";
      expectedWhitespace[12] = "#text";

      expectedNoWhitespace = new Array();
      expectedNoWhitespace[0] = "employeeId";
      expectedNoWhitespace[1] = "name";
      expectedNoWhitespace[2] = "position";
      expectedNoWhitespace[3] = "salary";
      expectedNoWhitespace[4] = "gender";
      expectedNoWhitespace[5] = "address";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(2);
      employeeList = employeeNode.childNodes;

      length = employeeList.length;

      for(var indexid2258756 = 0;indexid2258756 < employeeList.length; indexid2258756++) {
      child = employeeList.item(indexid2258756);
      childName = child.nodeName;

      result[result.length] = childName;

	}

	if(
	(6 == length)
	) {
	ASSERT(DOM_LIST_EQ(expectedNoWhitespace,result),"nowhitespace");

	}
	
		else {
			ASSERT(DOM_LIST_EQ(expectedWhitespace,result),"whitespace");

		}
	
});



/**
*
    The "getParentNode()" method returns the parent
    of this node.

    Retrieve the second employee and invoke the
    "getParentNode()" method on this node.   It should
    be set to "staff".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1060184317
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=251
*/
TEST("nodeparentnode", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var parentNode;
      var parentName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      parentNode = employeeNode.parentNode;

      parentName = parentNode.nodeName;


	if(
	
	(builder.contentType == "image/svg+xml")

	) {
	ASSERT(STRICT_EQ("svg",parentName),"svgTagName");

	}
	
		else {
			ASSERT(STRICT_EQ("staff",parentName),"nodeParentNodeAssert1");

		}
	
});



/**
*
    The "getParentNode()" method invoked on a node that has
    just been created and not yet added to the tree is null.

    Create a new "employee" Element node using the
    "createElement(name)" method from the Document interface.
    Since this new node has not yet been added to the tree,
    the "getParentNode()" method will return null.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1060184317
*/
TEST("nodeparentnodenull", function() {
   var success;
    var doc;
      var createdNode;
      var parentNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      createdNode = doc.createElement("employee");
      parentNode = createdNode.parentNode;

      ASSERT(NULL(parentNode),"parentNode");

});



/**
*

    The "getAttributes()" method invoked on a Processing

    Instruction Node returns null.



    Retrieve the Processing Instruction node and invoke

    the "getAttributes()" method.   It should return null.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
*/
TEST("nodeprocessinginstructionnodeattributes", function() {
   var success;
    var doc;
      var testList;
      var piNode;
      var attrList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      testList = doc.childNodes;

      piNode = testList.item(0);
      attrList = piNode.attributes;

      ASSERT(NULL(attrList),"nodeProcessingInstructionNodeAttrAssert1");

});



/**
*

    The string returned by the "getNodeName()" method for a

    Processing Instruction Node is the target.



    Retrieve the Processing Instruction Node in the XML file

    and check the string returned by the "getNodeName()"

    method.   It should be equal to "XML-STYLE".


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
*/
TEST("nodeprocessinginstructionnodename", function() {
   var success;
    var doc;
      var testList;
      var piNode;
      var piName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      testList = doc.childNodes;

      piNode = testList.item(0);
      piName = piNode.nodeName;

      ASSERT(STRICT_EQ("TEST-STYLE",piName),"nodeProcessingInstructionNodeNameAssert1");

});



/**
*

    The "getNodeType()" method for a Processing Instruction

    node returns the constant value 7.



    Retrieve a NodeList of child elements from the document.

    Retrieve the first child and invoke the "getNodeType()"

    method.   The method should return 7.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
*/
TEST("nodeprocessinginstructionnodetype", function() {
   var success;
    var doc;
      var testList;
      var piNode;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      testList = doc.childNodes;

      piNode = testList.item(0);
      nodeType = piNode.nodeType;

      ASSERT(STRICT_EQ(7,nodeType),"nodeProcessingInstructionNodeTypeAssert1");

});



/**
*
    The string returned by the "getNodeValue()" method for a
    Processing Instruction Node is the content of the
    Processing Instruction(exclude the target).

    Retrieve the Processing Instruction node in the XML file
    and check the string returned by the "getNodeValue()"
    method.   It should be equal to "PIDATA".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
*/
TEST("nodeprocessinginstructionnodevalue", function() {
   var success;
    var doc;
      var testList;
      var piNode;
      var piValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      testList = doc.childNodes;

      piNode = testList.item(0);
      piValue = piNode.nodeValue;

      ASSERT(STRICT_EQ("PIDATA",piValue),"value");

});



/**
*
    Setting the nodeValue should change the value returned by
    nodeValue and ProcessingInstruction.getData.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1004215813
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-837822393
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=181
*/
TEST("nodeprocessinginstructionsetnodevalue", function() {
   var success;
    var doc;
      var testList;
      var piNode;
      var piValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      testList = doc.childNodes;

      piNode = testList.item(0);
      piNode.nodeValue = "Something different";

      piValue = piNode.nodeValue;

      ASSERT(STRICT_EQ("Something different",piValue),"nodeValue");
       piValue = piNode.data;

      ASSERT(STRICT_EQ("Something different",piValue),"data");

});



/**
*
    The "removeChild(oldChild)" method removes the child node
    indicated by "oldChild" from the list of children and
    returns it.

    Remove the first employee by invoking the
    "removeChild(oldChild)" method an checking the
    node returned by the "getParentNode()" method.   It
    should be set to null.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066
*/
TEST("noderemovechild", function() {
   var success;
    var doc;
      var rootNode;
      var childList;
      var childToRemove;
      var removedChild;
      var parentNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      rootNode = doc.documentElement;

      childList = rootNode.childNodes;

      childToRemove = childList.item(1);
      removedChild = rootNode.removeChild(childToRemove);
      parentNode = removedChild.parentNode;

      ASSERT(NULL(parentNode),"nodeRemoveChildAssert1");

});



/**
*
    Remove the first child of the second employee
    and check the NodeName returned by the
    "removeChild(oldChild)" method.   The returned node
    should have a NodeName equal to "#text" or employeeId depending on whitespace.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066
*/
TEST("noderemovechildgetnodename", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var oldChild;
      var removedChild;
      var childName;
      var length;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      length = childList.length;

      oldChild = childList.item(0);
      removedChild = employeeNode.removeChild(oldChild);
      childName = removedChild.nodeName;


	if(
	(6 == length)
	) {
	ASSERT(STRICT_EQ("employeeId",childName),"nowhitespace");

	}
	
		else {
			ASSERT(STRICT_EQ("#text",childName),"whitespace");

		}
	
});



/**
*
    Retrieve the second employee and remove its first child.
    After the removal, the second employee should have five or twelve
    children and the first child should now be the child
    that used to be at the second position in the list.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066
*/
TEST("noderemovechildnode", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var oldChild;
      var child;
      var childName;
      var length;
      var removedChild;
      var removedName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      oldChild = childList.item(0);
      removedChild = employeeNode.removeChild(oldChild);
      removedName = removedChild.nodeName;

      child = childList.item(0);
      childName = child.nodeName;

      length = childList.length;


	if(
	(5 == length)
	) {
	ASSERT(STRICT_EQ("employeeId",removedName),"removedNameNoWhitespace");
       ASSERT(STRICT_EQ("name",childName),"childNameNoWhitespace");

	}
	
		else {
			ASSERT(STRICT_EQ("#text",removedName),"removedName");
       ASSERT(STRICT_EQ("employeeId",childName),"childName");
       ASSERT(STRICT_EQ(12,length),"length");

		}
	
});



/**
*
    The "removeChild(oldChild)" method raises a
    NOT_FOUND_ERR DOMException if the old child is
    not a child of this node.

    Retrieve the second employee and attempt to remove a
    node that is not one of its children.   An attempt to
    remove such a node should raise the desired exception.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-1734834066')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("noderemovechildoldchildnonexistent", function() {
   var success;
    var doc;
      var oldChild;
      var elementList;
      var elementNode;
      var removedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      oldChild = doc.createElement("oldChild");
      elementList = doc.getElementsByTagName("employee");
      elementNode = elementList.item(1);

	{
		success = false;
		try {
            removedChild = elementNode.removeChild(oldChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 8);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_FOUND_ERR");
	}

});



/**
*
    The "replaceChild(newChild,oldChild)" method replaces
    the node "oldChild" with the node "newChild".

    Replace the first element of the second employee with
    a newly created Element node.   Check the first position
    after the replacement operation is completed.   The new
    Element should be "newChild".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
*/
TEST("nodereplacechild", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var oldChild;
      var newChild;
      var child;
      var childName;
      var replacedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      oldChild = childList.item(0);
      newChild = doc.createElement("newChild");
      replacedNode = employeeNode.replaceChild(newChild,oldChild);
      child = childList.item(0);
      childName = child.nodeName;

      ASSERT(STRICT_EQ("newChild",childName),"nodeReplaceChildAssert1");

});



/**
*
    The "replaceChild(newChild,oldChild)" method raises a
    HIERARCHY_REQUEST_ERR DOMException if this node is of
    a type that does not allow children of the type "newChild"
    to be inserted.

    Retrieve the root node and attempt to replace
    one of its children with a newly created Attr node.
    An Element node cannot have children of the "Attr"
    type, therefore the desired exception should be raised.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-785887307')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("nodereplacechildinvalidnodetype", function() {
   var success;
    var doc;
      var rootNode;
      var newChild;
      var elementList;
      var oldChild;
      var replacedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      rootNode = doc.documentElement;

      newChild = doc.createAttribute("newAttribute");
      elementList = doc.getElementsByTagName("employee");
      oldChild = elementList.item(1);

	{
		success = false;
		try {
            replacedChild = rootNode.replaceChild(newChild,oldChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
    The "replaceChild(newChild,oldChild)" method raises a
    WRONG_DOCUMENT_ERR DOMException if the "newChild" was
    created from a different document than the one that
    created this node.

    Retrieve the second employee and attempt to replace one
    of its children with a node created from a different
    document.   An attempt to make such a replacement
    should raise the desired exception.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-785887307')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
*/
TEST("nodereplacechildnewchilddiffdocument", function() {
   var success;
    var doc1;
      var doc2;
      var oldChild;
      var newChild;
      var elementList;
      var elementNode;
      var replacedChild;

      var doc1Ref = null;
      if (typeof(this.doc1) != 'undefined') {
        doc1Ref = this.doc1;
      }
      doc1 = load(doc1Ref, "doc1", "staff");

      var doc2Ref = null;
      if (typeof(this.doc2) != 'undefined') {
        doc2Ref = this.doc2;
      }
      doc2 = load(doc2Ref, "doc2", "staff");
      newChild = doc1.createElement("newChild");
      elementList = doc2.getElementsByTagName("employee");
      elementNode = elementList.item(1);
      oldChild = elementNode.firstChild;


	{
		success = false;
		try {
            replacedChild = elementNode.replaceChild(newChild,oldChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 4);
		}
		ASSERT(STRICT_EQ(true,success),"throw_WRONG_DOCUMENT_ERR");
	}

});



/**
*
    Retrieve the second employee and replace its TWELFTH
    child(address) with its SECOND child(employeeId).   After the
    replacement the second child should now be the one that used
    to be at the third position and the TWELFTH child should be the
    one that used to be at the SECOND position.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
*/
TEST("nodereplacechildnewchildexists", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var oldChild = null;

      var newChild = null;

      var childName;
      var childNode;
      var length;
      var actual = new Array();

      var expected = new Array();

      expectedWithoutWhitespace = new Array();
      expectedWithoutWhitespace[0] = "name";
      expectedWithoutWhitespace[1] = "position";
      expectedWithoutWhitespace[2] = "salary";
      expectedWithoutWhitespace[3] = "gender";
      expectedWithoutWhitespace[4] = "employeeId";

      expectedWithWhitespace = new Array();
      expectedWithWhitespace[0] = "#text";
      expectedWithWhitespace[1] = "#text";
      expectedWithWhitespace[2] = "name";
      expectedWithWhitespace[3] = "#text";
      expectedWithWhitespace[4] = "position";
      expectedWithWhitespace[5] = "#text";
      expectedWithWhitespace[6] = "salary";
      expectedWithWhitespace[7] = "#text";
      expectedWithWhitespace[8] = "gender";
      expectedWithWhitespace[9] = "#text";
      expectedWithWhitespace[10] = "employeeId";
      expectedWithWhitespace[11] = "#text";

      var replacedChild;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      length = childList.length;


	if(
	(13 == length)
	) {
	newChild = childList.item(1);
      oldChild = childList.item(11);
      expected =  expectedWithWhitespace;

	}
	
		else {
			newChild = childList.item(0);
      oldChild = childList.item(5);
      expected =  expectedWithoutWhitespace;

		}
	replacedChild = employeeNode.replaceChild(newChild,oldChild);
      ASSERT(DOM_SAME(oldChild,replacedChild),"return_value_same");
for(var indexid2258967 = 0;indexid2258967 < childList.length; indexid2258967++) {
      childNode = childList.item(indexid2258967);
      childName = childNode.nodeName;

      actual[actual.length] = childName;

	}
   ASSERT(DOM_LIST_EQ(expected,actual),"childNames");

});



/**
*
    The "replaceChild(newChild,oldChild)" method raises a
    HIERARCHY_REQUEST_ERR DOMException if the node to put
    in is one of this node's ancestors.

    Retrieve the second employee and attempt to replace
    one of its children with an ancestor node(root node).
    An attempt to make such a replacement should raise the
    desired exception.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-785887307')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='HIERARCHY_REQUEST_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("nodereplacechildnodeancestor", function() {
   var success;
    var doc;
      var newChild;
      var elementList;
      var employeeNode;
      var childList;
      var oldChild;
      var replacedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newChild = doc.documentElement;

      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      oldChild = childList.item(0);

	{
		success = false;
		try {
            replacedNode = employeeNode.replaceChild(newChild,oldChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 3);
		}
		ASSERT(STRICT_EQ(true,success),"throw_HIERARCHY_REQUEST_ERR");
	}

});



/**
*
    Replace the second Element of the second employee with
    a newly created node Element and check the NodeName
    returned by the "replaceChild(newChild,oldChild)"
    method.   The returned node should have a NodeName equal
    to "employeeId".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
*/
TEST("nodereplacechildnodename", function() {
   var success;
    var doc;
      var elementList;
      var employeeNode;
      var childList;
      var oldChild;
      var newChild;
      var replacedNode;
      var length;
      var childName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.childNodes;

      length = childList.length;

      oldChild = childList.item(1);
      newChild = doc.createElement("newChild");
      replacedNode = employeeNode.replaceChild(newChild,oldChild);
      childName = replacedNode.nodeName;


	if(
	(6 == length)
	) {
	ASSERT(STRICT_EQ("name",childName),"nowhitespace");

	}
	
		else {
			ASSERT(STRICT_EQ("employeeId",childName),"whitespace");

		}
	
});



/**
*
    The "replaceChild(newChild,oldChild)" method raises a
    NOT_FOUND_ERR DOMException if the old child is
    not a child of this node.

    Retrieve the second employee and attempt to replace a
    node that is not one of its children.   An attempt to
    replace such a node should raise the desired exception.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-785887307')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NOT_FOUND_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("nodereplacechildoldchildnonexistent", function() {
   var success;
    var doc;
      var oldChild;
      var newChild;
      var elementList;
      var elementNode;
      var replacedNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newChild = doc.createElement("newChild");
      oldChild = doc.createElement("oldChild");
      elementList = doc.getElementsByTagName("employee");
      elementNode = elementList.item(1);

	{
		success = false;
		try {
            replacedNode = elementNode.replaceChild(newChild,oldChild);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 8);
		}
		ASSERT(STRICT_EQ(true,success),"throw_NOT_FOUND_ERR");
	}

});



/**
*
The "getAttributes()" method invoked on a Text
Node returns null.

Retrieve the Text node from the last child of the
first employee and invoke the "getAttributes()" method
on the Text Node.  It should return null.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-84CF096
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1312295772
*/
TEST("nodetextnodeattribute", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var textNode;
      var attrList;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddr = elementList.item(0);
      textNode = testAddr.firstChild;

      attrList = textNode.attributes;

      ASSERT(NULL(attrList),"nodeTextNodeAttributesAssert1");

});



/**
*

    The string returned by the "getNodeName()" method for a

    Text Node is "#text".



    Retrieve the Text Node from the last child of the

    first employee and check the string returned

    by the "getNodeName()" method.   It should be equal to

    "#text".


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D095
*/
TEST("nodetextnodename", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var textNode;
      var textName;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddr = elementList.item(0);
      textNode = testAddr.firstChild;

      textName = textNode.nodeName;

      ASSERT(STRICT_EQ("#text",textName),"nodeTextNodeNameAssert1");

});



/**
*

    The "getNodeType()" method for a Text Node

    returns the constant value 3.



    Retrieve the Text node from the last child of

    the first employee and invoke the "getNodeType()"

    method.   The method should return 3.


* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-111237558
*/
TEST("nodetextnodetype", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var textNode;
      var nodeType;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddr = elementList.item(0);
      textNode = testAddr.firstChild;

      nodeType = textNode.nodeType;

      ASSERT(STRICT_EQ(3,nodeType),"nodeTextNodeTypeAssert1");

});



/**
*
    The string returned by the "getNodeValue()" method for a
    Text Node is the content of the Text node.

    Retrieve the Text node from the last child of the first
    employee and check the string returned by the
    "getNodeValue()" method.   It should be equal to
    "1230 North Ave. Dallas, Texas 98551".

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
*/
TEST("nodetextnodevalue", function() {
   var success;
    var doc;
      var elementList;
      var testAddr;
      var textNode;
      var textValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      testAddr = elementList.item(0);
      textNode = testAddr.firstChild;

      textValue = textNode.nodeValue;

      ASSERT(STRICT_EQ("1230 North Ave. Dallas, Texas 98551",textValue),"nodeTextNodeValueAssert1");

});



/**
*
An comment is created, setNodeValue is called with a non-null argument, but getNodeValue
should still return null.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1728279322
*/
TEST("nodevalue02", function() {
   var success;
    var doc;
      var newNode;
      var newValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newNode = doc.createComment("This is a new Comment node");
      newValue = newNode.nodeValue;

      ASSERT(STRICT_EQ("This is a new Comment node",newValue),"initial");
       newNode.nodeValue = "This should have an effect";

      newValue = newNode.nodeValue;

      ASSERT(STRICT_EQ("This should have an effect",newValue),"afterChange");

});



/**
*
An processing instruction is created, setNodeValue is called with a non-null argument, but getNodeValue
should still return null.

* @author Curt Arnold
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1004215813
*/
TEST("nodevalue09", function() {
   var success;
    var doc;
      var newNode;
      var newValue;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      newNode = doc.createProcessingInstruction("TARGET","DATA");
      newValue = newNode.nodeValue;

      ASSERT(STRICT_EQ("DATA",newValue),"initial");
       newNode.nodeValue = "This should have an effect";

      newValue = newNode.nodeValue;

      ASSERT(STRICT_EQ("This should have an effect",newValue),"after");

});



/**
*
    The "getData()" method returns the content of the
   processing instruction.  It starts at the first non
   white character following the target and ends at the
   character immediately preceding the "?>".

   Retrieve the ProcessingInstruction node located
   immediately after the prolog.  Create a nodelist of the
   child nodes of this document.  Invoke the "getData()"
   method on the first child in the list. This should
   return the content of the ProcessingInstruction.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-837822393
*/
TEST("processinginstructiongetdata", function() {
   var success;
    var doc;
      var childNodes;
      var piNode;
      var data;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      childNodes = doc.childNodes;

      piNode = childNodes.item(0);
      data = piNode.data;

      ASSERT(STRICT_EQ("PIDATA",data),"processinginstructionGetTargetAssert");

});



/**
*
    The "getTarget()" method returns the target of the
   processing instruction.  It is the first token following
   the markup that begins the processing instruction.

   Retrieve the ProcessingInstruction node located
   immediately after the prolog.  Create a nodelist of the
   child nodes of this document.  Invoke the "getTarget()"
   method on the first child in the list. This should
   return the target of the ProcessingInstruction.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1478689192
*/
TEST("processinginstructiongettarget", function() {
   var success;
    var doc;
      var childNodes;
      var piNode;
      var target;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      childNodes = doc.childNodes;

      piNode = childNodes.item(0);
      target = piNode.target;

      ASSERT(STRICT_EQ("TEST-STYLE",target),"processinginstructionGetTargetAssert");

});



/**
*
    The "splitText(offset)" method raises an
    INDEX_SIZE_ERR DOMException if the specified offset is
    negative.

    Retrieve the textual data from the second child of the
    third employee and invoke the "splitText(offset)" method.
    The desired exception should be raised since the offset
    is a negative number.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-38853C1D
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-38853C1D')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
*/
TEST("textindexsizeerrnegativeoffset", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var textNode;
      var splitNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(2);
      textNode = nameNode.firstChild;


	{
		success = false;
		try {
            splitNode = textNode.splitText(-69);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throws_INDEX_SIZE_ERR");
	}

});



/**
*
    The "splitText(offset)" method raises an
    INDEX_SIZE_ERR DOMException if the specified offset is
    greater than the number of characters in the Text node.

    Retrieve the textual data from the second child of the
    third employee and invoke the "splitText(offset)" method.
    The desired exception should be raised since the offset
    is a greater than the number of characters in the Text
    node.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INDEX_SIZE_ERR'])
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-38853C1D
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-38853C1D')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INDEX_SIZE_ERR'])
* @see http://www.w3.org/Bugs/Public/show_bug.cgi?id=249
*/
TEST("textindexsizeerroffsetoutofbounds", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var textNode;
      var splitNode;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(2);
      textNode = nameNode.firstChild;


	{
		success = false;
		try {
            splitNode = textNode.splitText(300);
        }
		catch(ex) {
      success = (typeof(ex.code) != 'undefined' && ex.code == 1);
		}
		ASSERT(STRICT_EQ(true,success),"throw_INDEX_SIZE_ERR");
	}

});



/**
*
    Retrieve the textual data from the last child of the
    second employee.   That node is composed of two
    EntityReference nodes and two Text nodes.   After
    the content node is parsed, the "address" Element
    should contain four children with each one of the
    EntityReferences containing one child.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1451460987
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-11C98490
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-745549614
*/
TEST("textparseintolistofelements", function() {
   var success;
    var doc;
      var elementList;
      var addressNode;
      var childList;
      var child;
      var length;
      var value;
      var grandChild;
      var result = new Array();

      expectedNormal = new Array();
      expectedNormal[0] = "1900 Dallas Road";
      expectedNormal[1] = " Dallas, ";
      expectedNormal[2] = "Texas";
      expectedNormal[3] = "\n 98554";

      expectedExpanded = new Array();
      expectedExpanded[0] = "1900 Dallas Road Dallas, Texas\n 98554";


      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      addressNode = elementList.item(1);
      childList = addressNode.childNodes;

      length = childList.length;

      for(var indexid2258719 = 0;indexid2258719 < childList.length; indexid2258719++) {
      child = childList.item(indexid2258719);
      value = child.nodeValue;


	if(
	
	(value == null)

	) {
	grandChild = child.firstChild;

      ASSERT(NOT_NULL(grandChild),"grandChildNotNull");
value = grandChild.nodeValue;

      result[result.length] = value;

	}
	
		else {
			result[result.length] = value;

		}
	
	}

	if(
	(4 == length)
	) {
	ASSERT(DOM_LIST_EQ(expectedNormal,result),"assertEqNormal");

	}
	
		else {
			ASSERT(DOM_LIST_EQ(expectedExpanded,result),"assertEqCoalescing");

		}
	
});



/**
*
    The "splitText(offset)" method returns the new Text node.

    Retrieve the textual data from the last child of the
    first employee and invoke the "splitText(offset)" method.
    The method should return the new Text node.   The offset
    value used for this test is 30.   The "getNodeValue()"
    method is called to check that the new node now contains
    the characters at and after position 30.
    (Starting count at 0)

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-38853C1D
*/
TEST("textsplittextfour", function() {
   var success;
    var doc;
      var elementList;
      var addressNode;
      var textNode;
      var splitNode;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("address");
      addressNode = elementList.item(0);
      textNode = addressNode.firstChild;

      splitNode = textNode.splitText(30);
      value = splitNode.nodeValue;

      ASSERT(STRICT_EQ("98551",value),"textSplitTextFourAssert");

});



/**
*
    The "splitText(offset)" method breaks the Text node into
    two Text nodes at the specified offset keeping each node
    as siblings in the tree.

    Retrieve the textual data from the second child of the
    third employee and invoke the "splitText(offset)" method.
    The method splits the Text node into two new sibling
    Text nodes keeping both of them in the tree.   This test
    checks the "nextSibling()" method of the original node
    to ensure that the two nodes are indeed siblings.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-38853C1D
*/
TEST("textsplittextone", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var textNode;
      var splitNode;
      var secondPart;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(2);
      textNode = nameNode.firstChild;

      splitNode = textNode.splitText(7);
      secondPart = textNode.nextSibling;

      value = secondPart.nodeValue;

      ASSERT(STRICT_EQ("Jones",value),"textSplitTextOneAssert");

});



/**
*
    After the "splitText(offset)" method breaks the Text node
    into two Text nodes, the new Text node contains all the
    content at and after the offset point.

    Retrieve the textual data from the second child of the
    third employee and invoke the "splitText(offset)" method.
    The new Text node should contain all the content
    at and after the offset point.   The "getNodeValue()"
    method is called to check that the new node now contains
    the characters at and after position seven.
    (Starting count at 0)

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-38853C1D
*/
TEST("textsplittextthree", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var textNode;
      var splitNode;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(2);
      textNode = nameNode.firstChild;

      splitNode = textNode.splitText(6);
      value = splitNode.nodeValue;

      ASSERT(STRICT_EQ(" Jones",value),"textSplitTextThreeAssert");

});



/**
*
    After the "splitText(offset)" method breaks the Text node
    into two Text nodes, the original node contains all the
    content up to the offset point.

    Retrieve the textual data from the second child of the
    third employee and invoke the "splitText(offset)" method.
    The original Text node should contain all the content
    up to the offset point.   The "getNodeValue()" method
    is called to check that the original node now contains
    the first five characters.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-38853C1D
*/
TEST("textsplittexttwo", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var textNode;
      var splitNode;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(2);
      textNode = nameNode.firstChild;

      splitNode = textNode.splitText(5);
      value = textNode.nodeValue;

      ASSERT(STRICT_EQ("Roger",value),"textSplitTextTwoAssert");

});



/**
*
    If there is not any markup inside an Element or Attr node
    content, then the text is contained in a single object
    implementing the Text interface that is the only child
    of the element.

    Retrieve the textual data from the second child of the
    third employee.   That Text node contains a block of
    multiple text lines without markup, so they should be
    treated as a single Text node.   The "getNodeValue()"
    method should contain the combination of the two lines.

* @author NIST
* @author Mary Brady
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1312295772
* @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-F68D080
*/
TEST("textwithnomarkup", function() {
   var success;
    var doc;
      var elementList;
      var nameNode;
      var nodeV;
      var value;

      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "staff");
      elementList = doc.getElementsByTagName("name");
      nameNode = elementList.item(2);
      nodeV = nameNode.firstChild;

      value = nodeV.nodeValue;

      ASSERT(STRICT_EQ("Roger\n Jones",value),"textNodeValue");

});

RUN_ALL_TESTS();
